/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.zcomponent.ui.wizards.creation;

import com.ibm.teamz.client.ZComponentFactory;
import com.ibm.teamz.internal.zcomponent.ui.nls.Messages;
import com.ibm.teamz.internal.zcomponent.ui.provider.ZDefaultNameProviderFactory;
import com.ibm.teamz.internal.zcomponent.ui.wizards.creation.NewFileFirstPage;
import com.ibm.teamz.zcomponent.ui.Activator;
import com.ibm.teamz.zcomponent.ui.IDefaultNameProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewFileWizard
extends Wizard
implements IWorkbenchWizard {
    private NewFileFirstPage fFirstPage;
    protected IStructuredSelection selection;
    private IWorkbench workbench;
    protected boolean isNameEditable = true;
    protected String nameProviderId;
    protected IDefaultNameProvider nameProvider = null;
    protected String defaultName = "";

    public boolean performCancel() {
        if (this.nameProvider != null) {
            this.nameProvider.creationCanceled(this.fFirstPage.getProjectName(), this.fFirstPage.getContainerName(), this.fFirstPage.getArtifactName());
        }
        return true;
    }

    public boolean performFinish() {
        final IFile[] createdFile = new IFile[1];
        boolean success = false;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    createdFile[0] = ZComponentFactory.createZFile((String)NewFileWizard.this.fFirstPage.getProjectName(), (String)NewFileWizard.this.fFirstPage.getContainerName(), (String)NewFileWizard.this.fFirstPage.getArtifactName(), (Properties)NewFileWizard.this.fFirstPage.getProperties(), (IProgressMonitor)monitor);
                }
                catch (Exception ex) {
                    throw new InvocationTargetException(ex);
                }
            }
        };
        try {
            this.getContainer().run(false, false, op);
            if (this.workbench != null && createdFile[0] != null && createdFile[0].exists()) {
                IWorkbenchWindow window;
                success = true;
                if (this.nameProvider != null) {
                    this.nameProvider.creationCompleted(this.fFirstPage.getProjectName(), this.fFirstPage.getContainerName(), this.fFirstPage.getArtifactName());
                }
                if ((window = this.workbench.getActiveWorkbenchWindow()) != null) {
                    BasicNewResourceWizard.selectAndReveal((IResource)createdFile[0], (IWorkbenchWindow)window);
                    IWorkbenchPage page = window.getActivePage();
                    if (page != null) {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)createdFile[0], (boolean)true);
                    }
                }
            }
        }
        catch (InvocationTargetException ite) {
            String message = ite.getTargetException().getMessage();
            this.openErrorDialog((IStatus)new Status(4, Activator.getUniqueIdentifier(), message));
        }
        catch (Exception ex) {
            String message = ex.getMessage();
            this.openErrorDialog((IStatus)new Status(4, Activator.getUniqueIdentifier(), message));
        }
        if (!success && this.nameProvider != null) {
            this.nameProvider.creationCanceled(this.fFirstPage.getProjectName(), this.fFirstPage.getContainerName(), this.fFirstPage.getArtifactName());
        }
        return true;
    }

    public void addPages() {
        super.addPages();
        this.fFirstPage = new NewFileFirstPage(Messages.BUILDZ_ZFILE_WIZARD_LABEL);
        this.fFirstPage.setTitle(Messages.BUILDZ_ZFILE_WIZARD_LABEL);
        this.fFirstPage.setDescription(Messages.BUILDZ_ZFILE_WIZARD_DESCRIPTION);
        this.addPage((IWizardPage)this.fFirstPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.workbench = workbench;
        this.setWindowTitle(Messages.BUILDZ_ZFILE_WIZARD_NEW_ZFILE_LABEL);
        ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.teamz.zcomponent.ui", (String)"icons/wizban/zfileban_wiz.gif");
        this.setDefaultPageImageDescriptor(desc);
        Map<Object, Object> defaultZFileNameProviders = new Hashtable();
        ZDefaultNameProviderFactory f = ZDefaultNameProviderFactory.newInstance();
        defaultZFileNameProviders = f.getDefaultZFileNameProviders();
        if (defaultZFileNameProviders.size() > 0) {
            Iterator<Object> keySetIterator = defaultZFileNameProviders.keySet().iterator();
            this.nameProviderId = (String)keySetIterator.next();
            this.nameProvider = (IDefaultNameProvider)defaultZFileNameProviders.get(this.nameProviderId);
            this.defaultName = this.nameProvider.getDefaultName();
            this.isNameEditable = this.nameProvider.isFieldEditable();
        }
    }

    private void openErrorDialog(IStatus errorStatus) {
        String errorTitleMessage = Messages.BUILDZ_ZFILE_WIZARD_GENERAL_ERROR;
        final ErrorDialog dialog = new ErrorDialog(null, errorTitleMessage, null, errorStatus, 7);
        dialog.setBlockOnOpen(true);
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    dialog.open();
                }
            });
        } else {
            dialog.open();
        }
    }
}

