/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.zcomponent.ui.wizards.creation;

import com.ibm.team.enterprise.common.client.util.ZComponentUtils;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.SystemDefinitionSelectionDialog;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.teamz.internal.zcomponent.ui.nls.Messages;
import com.ibm.teamz.internal.zcomponent.ui.utils.ZArtifactValidationUtils;
import com.ibm.teamz.internal.zcomponent.ui.wizards.creation.NewFileWizard;
import com.ibm.teamz.internal.zcomponent.ui.wizards.creation.ZComponentIResourceLabelProvider;
import com.ibm.teamz.zcomponent.ui.IDefaultNameProvider;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class NewFileFirstPage
extends WizardPage {
    Text projectNameField;
    Text containerNameField;
    Text artifactNameField;
    Text fLanguageDefinitionField;
    String fLanguageDefinitionUUID;
    private final Listener nameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            boolean valid = NewFileFirstPage.this.validatePage();
            NewFileFirstPage.this.setPageComplete(valid);
        }
    };
    private final Listener projectNameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            boolean valid = NewFileFirstPage.this.validatePage();
            NewFileFirstPage.this.setPageComplete(valid);
        }
    };
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public NewFileFirstPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.team.build.ui.wizard_zfile");
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Composite subGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        subGroup.setLayout((Layout)layout);
        subGroup.setLayoutData((Object)new GridData(768));
        this.createProjectNameGroup(subGroup);
        this.createContainerNameGroup(subGroup);
        this.createArtifactNameGroup(subGroup);
        this.createLanguageDefinitionGroup(subGroup);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        this.setPageComplete(this.validatePage());
    }

    private final void createProjectNameGroup(Composite subGroup) {
        Label projectLabel = new Label(subGroup, 0);
        projectLabel.setText(Messages.BUILDZ_ZFOLDER_WIZARD_PROJECT_LABEL);
        projectLabel.setFont(subGroup.getFont());
        this.projectNameField = new Text(subGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.setFont(subGroup.getFont());
        IStructuredSelection selection = ((NewFileWizard)this.getWizard()).selection;
        if (selection != null && !selection.isEmpty()) {
            IFile file;
            IProject project;
            String projectName;
            Object context = selection.getFirstElement();
            if (context instanceof IProject) {
                IProject project2 = (IProject)context;
                String projectName2 = project2.getName();
                if (ZComponentUtils.isZComponentProject((String)projectName2)) {
                    this.projectNameField.setText(projectName2.trim());
                }
            } else if (context instanceof IFolder) {
                IFolder folder = (IFolder)context;
                IProject project3 = folder.getProject();
                String projectName3 = project3.getName();
                if (ZComponentUtils.isZComponentProject((String)projectName3)) {
                    this.projectNameField.setText(projectName3.trim());
                }
            } else if (context instanceof IFile && ZComponentUtils.isZComponentProject((String)(projectName = (project = (file = (IFile)context).getProject()).getName()))) {
                this.projectNameField.setText(projectName.trim());
            }
        }
        this.projectNameField.addListener(24, this.projectNameModifyListener);
        Button button = new Button(subGroup, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(NewFileFirstPage.this.getShell(), (ILabelProvider)new ZComponentIResourceLabelProvider());
                dialog.setIgnoreCase(false);
                dialog.setTitle(Messages.BUILDZ_PROJECT_SELECTION_LABEL);
                dialog.setMessage(Messages.BUILDZ_PROJECT_SELECTION_DESCRIPTION);
                dialog.setEmptyListMessage(Messages.BUILDZ_PROJECT_SELECTION_EMPTY);
                dialog.setMultipleSelection(false);
                dialog.setElements((Object[])ZComponentUtils.getZComponentProjects());
                dialog.open();
                Object result = dialog.getFirstResult();
                if (result != null) {
                    NewFileFirstPage.this.projectNameField.setText(((IProject)result).getName());
                }
            }
        });
        button.setText(Messages.BUILDZ_SELECTION_BUTTON_LABEL);
    }

    private final void createContainerNameGroup(Composite subGroup) {
        Label containerLabel = new Label(subGroup, 0);
        containerLabel.setText(Messages.BUILDZ_ZFILE_WIZARD_ZFOLDER_LABEL);
        containerLabel.setFont(subGroup.getFont());
        this.containerNameField = new Text(subGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.containerNameField.setLayoutData((Object)data);
        this.containerNameField.setFont(subGroup.getFont());
        IStructuredSelection selection = ((NewFileWizard)this.getWizard()).selection;
        if (selection != null && !selection.isEmpty()) {
            Object context = selection.getFirstElement();
            if (context instanceof IFolder) {
                IFolder folder = (IFolder)context;
                IProject project = folder.getProject();
                String projectName = project.getName();
                if (ZComponentUtils.isZComponentProject((String)projectName) && folder.getParent().getName().equals("zOSsrc")) {
                    this.containerNameField.setText(folder.getName().trim());
                }
            } else if (context instanceof IFile) {
                IFile file = (IFile)context;
                IProject project = file.getProject();
                IContainer container = file.getParent();
                if (container instanceof IFolder) {
                    IFolder folder = (IFolder)container;
                    String projectName = project.getName();
                    if (ZComponentUtils.isZComponentProject((String)projectName) && folder.getParent().getName().equals("zOSsrc")) {
                        this.containerNameField.setText(folder.getName().trim());
                    }
                }
            }
        }
        this.containerNameField.addListener(24, this.nameModifyListener);
        Button button = new Button(subGroup, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(NewFileFirstPage.this.getShell(), (ILabelProvider)new ZComponentIResourceLabelProvider());
                dialog.setIgnoreCase(false);
                dialog.setTitle(Messages.BUILDZ_ZFOLDER_SELECTION_LABEL);
                dialog.setMessage(Messages.BUILDZ_ZFOLDER_SELECTION_DESCRIPTION);
                dialog.setEmptyListMessage(Messages.BUILDZ_ZFOLDER_SELECTION_EMPTY);
                dialog.setMultipleSelection(false);
                dialog.setElements((Object[])ZComponentUtils.getZFolders((String)NewFileFirstPage.this.getProjectName()));
                dialog.open();
                Object result = dialog.getFirstResult();
                if (result != null) {
                    NewFileFirstPage.this.containerNameField.setText(((IResource)result).getName());
                }
            }
        });
        button.setText(Messages.BUILDZ_SELECTION_BUTTON_LABEL);
    }

    private final void createArtifactNameGroup(Composite subGroup) {
        final NewFileWizard wiz = (NewFileWizard)this.getWizard();
        Label artifactLabel = new Label(subGroup, 0);
        artifactLabel.setText(Messages.BUILDZ_ZFILE_WIZARD_ZFILE_NAME_LABEL);
        artifactLabel.setFont(subGroup.getFont());
        this.artifactNameField = new Text(subGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.artifactNameField.setLayoutData((Object)data);
        this.artifactNameField.setFont(subGroup.getFont());
        this.artifactNameField.addListener(24, this.nameModifyListener);
        final ControlDecoration dec = new ControlDecoration((Control)this.artifactNameField, 131072);
        dec.setMarginWidth(2);
        dec.setDescriptionText(wiz.nameProvider != null ? NLS.bind((String)Messages.BUILDZ_ZFILE_WIZARD_ZFILE_NAME_DEFAULT_PROVIDER_USED, (Object)IDefaultNameProvider.class.getSimpleName(), (Object)wiz.nameProviderId) : Messages.BUILDZ_ZFILE_WIZARD_ZFILE_NAME_DEFAULT);
        dec.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        dec.hide();
        this.artifactNameField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (wiz.nameProvider != null) {
                    dec.show();
                }
            }

            public void focusLost(FocusEvent e) {
                dec.hide();
            }
        });
        if (wiz.nameProvider != null) {
            this.artifactNameField.setText(wiz.defaultName);
            this.artifactNameField.setEditable(wiz.isNameEditable);
        }
        Label filler = new Label(subGroup, 0);
        filler.setText("");
    }

    private final void createLanguageDefinitionGroup(Composite subGroup) {
        Label label = new Label(subGroup, 0);
        label.setText(Messages.BUILDZ_ZFILE_WIZARD_LANGUAGE_DEFINITION_LABEL);
        this.fLanguageDefinitionField = new Text(subGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.fLanguageDefinitionField.setLayoutData((Object)data);
        this.fLanguageDefinitionField.setFont(subGroup.getFont());
        this.fLanguageDefinitionField.setEditable(false);
        Button button = new Button(subGroup, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISystemDefinition langDef;
                SystemDefinitionSelectionDialog dialog;
                IProject project = null;
                IShareable share = null;
                ITeamRepository repo = null;
                boolean isProblem = false;
                if (NewFileFirstPage.this.getNameFieldValue(NewFileFirstPage.this.projectNameField) != null) {
                    project = ZComponentUtils.getProject((String)NewFileFirstPage.this.getNameFieldValue(NewFileFirstPage.this.projectNameField));
                    share = (IShareable)project.getAdapter(IShareable.class);
                    if (share == null || !ZComponentUtils.isShared((IProject)project)) {
                        NewFileFirstPage.this.setMessage(Messages.BUILDZ_ZFILE_WIZARD_PROJECT_NOT_SHARED_WARNING, 1);
                        isProblem = true;
                    } else {
                        repo = ZComponentUtils.getTeamRepository((IShareable)share);
                        if (repo == null || !repo.loggedIn()) {
                            NewFileFirstPage.this.setMessage(Messages.BUILDZ_ZFILE_WIZARD_NOT_LOGGED_IN_TO_REPOSITORY_WARNING, 1);
                            isProblem = true;
                        }
                    }
                }
                if (!isProblem && (dialog = new SystemDefinitionSelectionDialog(NewFileFirstPage.this.getShell(), repo, IZosLanguageDefinition.ITEM_TYPE)).open() == 0 && (langDef = dialog.getSelectedSystemDefinition()) != null) {
                    NewFileFirstPage.this.fLanguageDefinitionUUID = langDef.getItemId().getUuidValue();
                    NewFileFirstPage.this.fLanguageDefinitionField.setText(langDef.getName());
                }
            }
        });
        button.setText(Messages.BUILDZ_SELECTION_BUTTON_LABEL);
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        return this.getNameFieldValue(this.projectNameField);
    }

    public String getContainerName() {
        return this.getNameFieldValue(this.containerNameField);
    }

    public String getArtifactName() {
        return this.getNameFieldValue(this.artifactNameField);
    }

    private String getNameFieldValue(Text field) {
        if (field == null) {
            return "";
        }
        return field.getText().trim();
    }

    protected boolean validatePage() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String projectFieldContents = this.getNameFieldValue(this.projectNameField);
        String containerFieldContents = this.getNameFieldValue(this.containerNameField);
        String artifactFieldContents = this.getNameFieldValue(this.artifactNameField);
        if (projectFieldContents.equals("")) {
            this.setErrorMessage(Messages.BUILDZ_ZFOLDER_WIZARD_PROJECT_EMPTY);
            return false;
        }
        IProject project = ZComponentUtils.getProject((String)this.getProjectName());
        if (!project.exists()) {
            this.setErrorMessage(Messages.BUILDZ_ZFOLDER_WIZARD_PROJECT_DOES_NOT_EXIST);
            return false;
        }
        if (containerFieldContents.equals("")) {
            this.setErrorMessage(Messages.BUILDZ_ZFILE_WIZARD_ZFOLDER_EMPTY);
            return false;
        }
        IFolder container = ZComponentUtils.getContainer((String)this.getProjectName(), (String)this.getContainerName());
        if (!container.exists()) {
            this.setErrorMessage(Messages.BUILDZ_ZFILE_WIZARD_ZFOLDER_DOES_NOT_EXIST);
            return false;
        }
        IFolder handle = this.getProjectHandle().getFolder("zOSsrc").getFolder(this.getContainerName());
        IStatus nameStatus = ZArtifactValidationUtils.validateZFile(artifactFieldContents, handle, null);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        nameStatus = workspace.validateName(artifactFieldContents, 1);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.artifactNameField.setFocus();
        }
    }

    public Properties getProperties() {
        Properties props = new Properties();
        if (this.fLanguageDefinitionUUID != null) {
            props.put("team.enterprise.language.definition", this.fLanguageDefinitionUUID);
        }
        return props;
    }
}

