/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.zcomponent.ui.utils;

import com.ibm.team.enterprise.common.client.util.ZComponentUtils;
import com.ibm.team.enterprise.common.common.IEnterpriseConfiguration;
import com.ibm.team.enterprise.internal.common.client.EnterpriseConfigurationCache;
import com.ibm.team.enterprise.systemdefinition.client.util.DataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.api.MappingValidation;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IMetadataProperties;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.teamz.internal.zcomponent.ui.nls.Messages;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ZArtifactValidationUtils {
    private static Map<IFolder, IEnterpriseConfiguration> configurationMap = new HashMap<IFolder, IEnterpriseConfiguration>();

    private static String removeExtension(String name) {
        String rc = name;
        int idx = rc.lastIndexOf(46);
        if (idx > -1) {
            rc = rc.substring(0, idx);
        }
        return rc;
    }

    private static IStatus errorStatus(String message) {
        return new Status(4, "com.ibm.teamz.zcomponent.ui", message);
    }

    public static IStatus validateZFile(String proposedZFileName, IFolder containingFolder, IFile currentFile) {
        if (proposedZFileName.isEmpty()) {
            return ZArtifactValidationUtils.errorStatus(Messages.BUILDZ_ZFILE_WIZARD_ZFILE_NAME_EMPTY);
        }
        if (proposedZFileName.indexOf(32) > -1) {
            return ZArtifactValidationUtils.errorStatus(Messages.INVALID_CHARACTER_SPACE_IN_ZFILE_NAME);
        }
        IEnterpriseConfiguration configuration = null;
        if (configurationMap.containsKey(containingFolder)) {
            configuration = configurationMap.get(containingFolder);
        } else {
            configuration = ZArtifactValidationUtils.getConfiguration(containingFolder);
            if (configuration != null) {
                configurationMap.put(containingFolder, configuration);
            }
        }
        MappingValidation mv = new MappingValidation(configuration);
        if (mv.isValidMemberName(ZArtifactValidationUtils.removeExtension(proposedZFileName)) != 0) {
            return ZArtifactValidationUtils.errorStatus(NLS.bind((String)Messages.INVALID_ZFILE_NAME, (Object)mv.getMemberErrorMessage(mv.isValidMemberName(ZArtifactValidationUtils.removeExtension(proposedZFileName)))));
        }
        try {
            if (containingFolder != null && containingFolder.exists()) {
                IFile fileHandle = containingFolder.getFile(proposedZFileName);
                if (fileHandle != null && fileHandle.exists()) {
                    return ZArtifactValidationUtils.errorStatus(Messages.BUILDZ_ZFILE_WIZARD_ZFILE_ALREADY_EXISTS);
                }
                IResource[] files = containingFolder.members(1);
                String proposedNoExtension = ZArtifactValidationUtils.removeExtension(proposedZFileName);
                int i = 0;
                while (i < files.length) {
                    if (currentFile == null || !files[i].equals((Object)currentFile)) {
                        String fileNameNoExtension = ZArtifactValidationUtils.removeExtension(files[i].getName());
                        if (files[i].getName().equalsIgnoreCase(proposedZFileName)) {
                            return ZArtifactValidationUtils.errorStatus(Messages.BUILDZ_ZFILE_WIZARD_ZFILE_NAME_DIFFERENT_CASE_ALREADY_EXISTS);
                        }
                        if (ZArtifactValidationUtils.removeExtension(fileNameNoExtension).equalsIgnoreCase(proposedNoExtension)) {
                            return ZArtifactValidationUtils.errorStatus(Messages.BUILDZ_ZFILE_WIZARD_ZFILE_NAME_DIFFERENT_EXTN_ALREADY_EXISTS);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (CoreException ce) {
            return new Status(4, "com.ibm.teamz.zcomponent.ui", new String(), (Throwable)ce);
        }
        return Status.OK_STATUS;
    }

    private static IEnterpriseConfiguration getConfiguration(IFolder containingFolder) {
        IEnterpriseConfiguration configuration;
        IDataSetDefinition dsdef;
        ITeamRepository repository;
        block8: {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile resource = root.getFileForLocation(containingFolder.getLocation());
            IShareable shareable = (IShareable)resource.getAdapter(IShareable.class);
            repository = ZComponentUtils.getTeamRepository((IShareable)shareable);
            IMetadataProperties metadata = null;
            try {
                metadata = shareable.getMetadataProperties((IProgressMonitor)new NullProgressMonitor());
            }
            catch (FileSystemException e) {
                return null;
            }
            catch (NullPointerException e) {
                return null;
            }
            Map properties = metadata.getCurrentProperties();
            String uuid = (String)properties.get("team.enterprise.resource.definition");
            if (uuid == null) {
                return null;
            }
            dsdef = null;
            configuration = null;
            try {
                dsdef = DataSetDefinition.fetch((ITeamRepository)repository, (String)uuid);
                if (dsdef != null) break block8;
                return null;
            }
            catch (TeamRepositoryException e) {
                return null;
            }
        }
        configuration = EnterpriseConfigurationCache.getInstance().fetch(repository, dsdef.getProjectArea());
        if (configuration == null) {
            return null;
        }
        return configuration;
    }
}

