/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.zcomponent.ui.provider;

import com.ibm.teamz.zcomponent.ui.IDefaultNameProvider;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class ZDefaultNameProviderFactory {
    private static ZDefaultNameProviderFactory INSTANCE;
    private static final String EXTENSION_POINT = "com.ibm.enterprise.zfile.default.name.provider";
    private static final String EXTENSION_ID_ATTR = "id";
    private static final String EXTENSION_CLASS_ATTR = "class";
    private static final String EXTENSION_TYPE_ATTR = "type";
    private static final String EXTENSION_TYPE_ATTR_ZFILE = "zfile";
    private final Map<String, IDefaultNameProvider> defaultZFileNameProviders = new Hashtable<String, IDefaultNameProvider>();
    public static Log logger;

    static {
        logger = LogFactory.getLog(ZDefaultNameProviderFactory.class);
    }

    public static final ZDefaultNameProviderFactory newInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ZDefaultNameProviderFactory();
            INSTANCE.init();
        }
        return INSTANCE;
    }

    public void init() {
        this.defaultZFileNameProviders.clear();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_POINT);
        IConfigurationElement[] members = extensionPoint.getConfigurationElements();
        int m = 0;
        while (m < members.length) {
            IConfigurationElement member = members[m];
            String id = member.getAttribute(EXTENSION_ID_ATTR);
            String type = member.getAttribute(EXTENSION_TYPE_ATTR);
            if (type.equalsIgnoreCase(EXTENSION_TYPE_ATTR_ZFILE)) {
                try {
                    IDefaultNameProvider provider = this.createDefaultNameProvider(member);
                    this.defaultZFileNameProviders.put(id, provider);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            ++m;
        }
        logger.debug((Object)"End initializing");
    }

    private IDefaultNameProvider createDefaultNameProvider(IConfigurationElement element) throws ClassNotFoundException {
        try {
            Object obj = element.createExecutableExtension(EXTENSION_CLASS_ATTR);
            if (obj instanceof IDefaultNameProvider) {
                return (IDefaultNameProvider)obj;
            }
            throw new ClassNotFoundException(NLS.bind((String)"Class not found for: ", (Object)obj.getClass().getName()));
        }
        catch (CoreException e) {
            logger.debug((Object)("Error in createDefaultNameProvider: " + e.getLocalizedMessage()));
            throw new ClassNotFoundException(e.getLocalizedMessage(), e);
        }
    }

    public Map<String, IDefaultNameProvider> getDefaultZFileNameProviders() {
        return this.defaultZFileNameProviders;
    }

    public IDefaultNameProvider getdefaultZFileNameProvider(String scannerId) {
        return this.defaultZFileNameProviders.get(scannerId);
    }

    public List<IDefaultNameProvider> getAlldefaultZFileNameProviders() {
        ArrayList<IDefaultNameProvider> list = new ArrayList<IDefaultNameProvider>();
        list.addAll(this.defaultZFileNameProviders.values());
        return list;
    }
}

