/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.zcomponent.ui.property.pages;

import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosTranslator;
import com.ibm.team.enterprise.systemdefinition.common.util.ItemHandleAwareHashSet;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.teamz.internal.zcomponent.ui.property.pages.FileMetadataPropertiesComposite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class USSFolderMetadataPropertiesComposite
extends FileMetadataPropertiesComposite {
    public USSFolderMetadataPropertiesComposite(Composite parent, IResource resource) {
        super(parent, resource);
        this.setDefinitionsFilter(new LanguageDefinitionsWithAntFilter());
        this.setDefinitionsFetchingProperties(new String[]{ISystemDefinition.NAME_PROPERTY, ISystemDefinition.DESCRIPTION_PROPERTY, ISystemDefinition.PROJECT_AREA_PROPERTY, ILanguageDefinition.TRANSLATORS_PROPERTY});
    }

    protected void createContents(Class<? extends IPlatformObject> platform) {
        super.createContents(platform);
        this.loadButton.setVisible(false);
        Object layoutData = this.loadButton.getLayoutData();
        if (layoutData instanceof GridData) {
            ((GridData)layoutData).exclude = true;
        }
    }

    private class LanguageDefinitionsWithAntFilter
    extends ViewerFilter {
        private LanguageDefinitionsWithAntFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            final boolean[] result = new boolean[1];
            final ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)USSFolderMetadataPropertiesComposite.this.fTeamRepository.getClientLibrary(ISystemDefinitionModelClient.class);
            if (element instanceof ILanguageDefinition) {
                ILanguageDefinition langDef = (ILanguageDefinition)element;
                if (langDef.getTranslators().size() > 0) {
                    final ItemHandleAwareHashSet trToCheck = new ItemHandleAwareHashSet();
                    for (ITranslatorEntry entry : langDef.getTranslators()) {
                        if (!entry.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.translator")) continue;
                        trToCheck.add((Object)IZosTranslator.ITEM_TYPE.createItemHandle(UUID.valueOf((String)entry.getValue()), null));
                    }
                    if (!trToCheck.isEmpty()) {
                        UIUpdaterJob job = new UIUpdaterJob(""){
                            List<ISystemDefinition> translators;
                            {
                                super($anonymous0);
                                this.translators = null;
                            }

                            public IStatus runInBackground(IProgressMonitor monitor) {
                                try {
                                    this.translators = client.fetchSystemDefinitions(new ArrayList(trToCheck), Arrays.asList(IZosTranslator.CALL_METHOD_PROPERTY), monitor);
                                }
                                catch (TeamRepositoryException e) {
                                    e.printStackTrace();
                                }
                                return super.runInBackground(monitor);
                            }

                            public IStatus runInUI(IProgressMonitor monitor) {
                                if (this.translators != null) {
                                    for (ISystemDefinition translator : this.translators) {
                                        if (!(translator instanceof IZosTranslator) || ((IZosTranslator)translator).getCallMethod() != 4) continue;
                                        result[0] = true;
                                        break;
                                    }
                                }
                                return super.runInUI(monitor);
                            }
                        };
                        job.schedule();
                        try {
                            job.join();
                        }
                        catch (InterruptedException e) {
                            return result[0];
                        }
                    }
                }
            } else {
                result[0] = true;
            }
            return result[0];
        }
    }
}

