/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.zcomponent.ui.property.pages;

import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.build.ui.metadata.api.IMetadata;
import com.ibm.team.enterprise.build.ui.property.pages.EnterpriseMetadataPropertiesComposite;
import com.ibm.team.enterprise.common.client.util.ZComponentUtils;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.domain.actions.EditSystemDefinitionActionDelegate;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.DataSetDefinitionSelectionDialog;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.teamz.internal.zcomponent.ui.nls.Messages;
import com.ibm.teamz.internal.zcomponent.ui.property.pages.DataSetDefinitionLabelHelper;
import com.ibm.teamz.internal.zcomponent.ui.property.pages.DataSetViewerFilter;
import com.ibm.teamz.internal.zcomponent.ui.property.pages.IDataSetDefinitionContext;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class FolderMetadataPropertiesComposite
extends EnterpriseMetadataPropertiesComposite {
    protected Text fDataDefField;
    protected Link DSTitleLink;
    protected String fDataDefUUID;
    private final IResource fResource;
    private final boolean fProjectShared;
    private ITeamRepository fTeamRepository;
    private IShareable fShareable;
    private IStatus errorStatus;

    public FolderMetadataPropertiesComposite(Composite parent, IResource resource) {
        super(parent);
        this.fResource = resource;
        this.fProjectShared = this.isProjectShared(this.fResource.getProject());
        this.errorStatus = null;
        this.createContents();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.build.ui.property_page_zfolder");
    }

    protected boolean isProjectShared(IProject project) {
        return ZComponentUtils.isShared((IProject)project);
    }

    protected void createContents() {
        GridLayout layout = new GridLayout(4, false);
        this.setLayout((Layout)layout);
        if (!this.fProjectShared) {
            Label l = new Label((Composite)this, 0);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 4;
            l.setLayoutData((Object)gd);
            l.setText(Messages.FolderMetadataPropertiesPage_MUST_SHARE_PROJECT);
        }
        GridData gridDataLink = new GridData();
        gridDataLink.horizontalAlignment = 4;
        this.DSTitleLink = new Link((Composite)this, 0);
        this.DSTitleLink.setText("<a>" + Messages.FolderMetadataPropertiesPage_DATA_DEFN + "</a>");
        this.DSTitleLink.setLayoutData((Object)gridDataLink);
        this.DSTitleLink.addSelectionListener(this.getDSDLinkListener());
        this.setDSTitleLinkEnablement(false);
        this.fDataDefField = new Text((Composite)this, 2052);
        this.fDataDefField.setLayoutData((Object)new GridData(768));
        this.fDataDefField.setEnabled(true);
        this.fDataDefField.setEditable(false);
        Button button = new Button((Composite)this, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ISystemDefinition dataset;
                    DataSetDefinitionSelectionDialog dialog;
                    if (FolderMetadataPropertiesComposite.this.fProjectShared && (dialog = new DataSetDefinitionSelectionDialog(FolderMetadataPropertiesComposite.this.getShell(), FolderMetadataPropertiesComposite.this.fTeamRepository, null, FolderMetadataPropertiesComposite.this.getDataSetDefFilter(), null, true, null)).open() == 0 && (dataset = dialog.getSelectedSystemDefinition()) != null) {
                        FolderMetadataPropertiesComposite.this.fDataDefUUID = dataset.getItemId().getUuidValue();
                        FolderMetadataPropertiesComposite.this.fDataDefField.setText(dataset.getName());
                        FolderMetadataPropertiesComposite.this.setDSTitleLinkEnablement(true);
                    }
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    // empty catch block
                }
            }
        });
        button.setText(Messages.BUILDZ_SELECTION_BUTTON_LABEL);
        if (!this.fProjectShared) {
            this.errorStatus = new Status(1, "com.ibm.teamz.zcomponent.ui", Messages.BUILDZ_ZFOLDER_WIZARD_PROJECT_NOT_SHARED_WARNING);
            button.setEnabled(false);
        }
        Button clearButton = new Button((Composite)this, 0);
        clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FolderMetadataPropertiesComposite.this.fDataDefUUID = null;
                FolderMetadataPropertiesComposite.this.fDataDefField.setText("");
                FolderMetadataPropertiesComposite.this.setDSTitleLinkEnablement(false);
            }
        });
        clearButton.setText(Messages.BUILDZ_CLEAR_BUTTON_LABEL);
    }

    public void initialize(IMetadata metadata) {
        boolean hasUUID;
        this.fShareable = (IShareable)this.fResource.getProject().getAdapter(IShareable.class);
        this.fTeamRepository = ZComponentUtils.getTeamRepository((IShareable)this.fShareable);
        String datadefUUID = metadata == null ? "" : metadata.getProperty("team.enterprise.resource.definition");
        boolean bl = hasUUID = datadefUUID != null && datadefUUID.length() > 0;
        if (hasUUID) {
            this.fDataDefField.setText(Messages.FolderMetadataPropertiesPage_PENDING);
            this.fDataDefUUID = datadefUUID;
            this.setDSTitleLinkEnablement(true);
            DataSetDefinitionLabelHelper labelHelper = this.getLabelHelper();
            IDataSetDefinitionContext context = this.getDataSetDefinitionContext(datadefUUID);
            labelHelper.getDataSetDefinitionLabelInBackground(context);
        }
    }

    protected DataSetDefinitionLabelHelper getLabelHelper() {
        return new DataSetDefinitionLabelHelper(){

            @Override
            public void labelAvailable(String label, String dsdefUUID) {
                if (!FolderMetadataPropertiesComposite.this.fDataDefField.isDisposed()) {
                    FolderMetadataPropertiesComposite.this.fDataDefField.setText(label);
                    if (label.length() > 0) {
                        FolderMetadataPropertiesComposite.this.setDSTitleLinkEnablement(true);
                    }
                }
            }
        };
    }

    protected IDataSetDefinitionContext getDataSetDefinitionContext(final String dsdefUUID) {
        return new IDataSetDefinitionContext(){

            @Override
            public String getDataSetDefinitionUUID() {
                return dsdefUUID;
            }

            @Override
            public ITeamRepository getTeamRepository() {
                return FolderMetadataPropertiesComposite.this.fTeamRepository;
            }

            @Override
            public IProjectAreaHandle getProjectArea() {
                return null;
            }
        };
    }

    private ViewerFilter getDataSetDefFilter() {
        return new DataSetViewerFilter(this.fResource){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IResourceDefinition) {
                    IResourceDefinition dsd = (IResourceDefinition)element;
                    if (this.isZBinFolder()) {
                        return dsd.getUsageType() == 1 || dsd.getUsageType() == 3;
                    }
                    return dsd.getUsageType() == 0;
                }
                return true;
            }
        };
    }

    public Properties getProperties() {
        Properties props = new Properties();
        if (this.fDataDefUUID != null) {
            props.put("team.enterprise.resource.definition", this.fDataDefUUID);
        } else {
            props.put("team.enterprise.resource.definition", "");
        }
        return props;
    }

    public IStatus getErrorStatus() {
        return this.errorStatus;
    }

    private void setDSTitleLinkEnablement(boolean enabled) {
        this.DSTitleLink.setEnabled(enabled);
    }

    protected SelectionListener getDSDLinkListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FolderMetadataPropertiesComposite.this.openDSDEditor();
            }
        };
    }

    private void openDSDEditor() {
        String uuid = this.fDataDefUUID;
        if (uuid == null || uuid.isEmpty()) {
            return;
        }
        OpenDSDEditorJob job = new OpenDSDEditorJob();
        job.schedule();
    }

    class OpenDSDEditorJob
    extends TeamBuildJob {
        private final String fResolvedUUID;
        private IDataSetDefinition fDataDef;

        OpenDSDEditorJob() {
            super(Messages.FolderMetadataPropertiesPage_DATA_DEFN, false);
            this.fResolvedUUID = FolderMetadataPropertiesComposite.this.fDataDefUUID;
        }

        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
            try {
                ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)FolderMetadataPropertiesComposite.this.fTeamRepository.getClientLibrary(ISystemDefinitionModelClient.class);
                this.fDataDef = (IDataSetDefinition)client.findSystemDefinitionComplete(this.fResolvedUUID, null, IDataSetDefinition.ITEM_TYPE, monitor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return Status.OK_STATUS;
        }

        protected void jobFinished(IStatus status) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window != null) {
                        IWorkbenchPage page = window.getActivePage();
                        String projectAreaUUID = OpenDSDEditorJob.this.fDataDef.getProjectArea().getItemId().getUuidValue();
                        IProjectAreaHandle itemHandle = (IProjectAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle((Object)FolderMetadataPropertiesComposite.this.fTeamRepository, UUID.valueOf((String)projectAreaUUID), null);
                        EditSystemDefinitionActionDelegate.run((ISystemDefinition)OpenDSDEditorJob.this.fDataDef, (IProjectAreaHandle)itemHandle, (IWorkbenchPage)page, (boolean)true, (boolean)true);
                    }
                }
            });
        }
    }
}

