/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.zcomponent.ui.property.pages;

import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.SystemDefinitionJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.teamz.internal.zcomponent.ui.nls.Messages;
import com.ibm.teamz.internal.zcomponent.ui.property.pages.IDataSetDefinitionContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;

public class DataSetDefinitionLabelHelper {
    public void labelAvailable(String label, String dataSetDefUUID) {
    }

    public void getDataSetDefinitionLabelInBackground(final IDataSetDefinitionContext context) {
        SystemDefinitionJob job = new SystemDefinitionJob(Messages.DataSetDefinitionLabelHelper_JOB_LABEL, false){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                String dataDefUuid;
                String label = dataDefUuid = context.getDataSetDefinitionUUID();
                if (dataDefUuid.length() > 0) {
                    IDataSetDefinition dataDef = this.fetchDataDefinition(UUID.valueOf((String)dataDefUuid), context.getTeamRepository(), monitor);
                    label = dataDef.getName();
                    if (dataDef.isArchived()) {
                        label = String.valueOf(label) + com.ibm.team.enterprise.systemdefinition.ui.nls.Messages.SystemDefinition_ARCHIVED_SUFFIX;
                    }
                }
                DataSetDefinitionLabelHelper.this.asyncLabelAvailable(label, context.getDataSetDefinitionUUID());
                return Status.OK_STATUS;
            }

            protected IDataSetDefinition fetchDataDefinition(UUID datasetUUID, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
                ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)teamRepository.getClientLibrary(ISystemDefinitionModelClient.class);
                return (IDataSetDefinition)client.findSystemDefinitionComplete(datasetUUID.getUuidValue(), null, IDataSetDefinition.ITEM_TYPE, monitor);
            }

            protected void jobFinished(IStatus status) {
                if (status.getException() instanceof ItemNotFoundException || status.getException() instanceof NullPointerException) {
                    DataSetDefinitionLabelHelper.this.asyncLabelAvailable(Messages.LabelHelper_DatasetMissing, context.getDataSetDefinitionUUID());
                } else if (status.getSeverity() == 4) {
                    DataSetDefinitionLabelHelper.this.asyncLabelAvailable(status.getMessage() != null && status.getMessage().length() > 0 ? status.getMessage() : Messages.LabelHelper_EXCEPTION_OCCURRED, context.getDataSetDefinitionUUID());
                }
            }
        };
        job.schedule();
    }

    protected void asyncLabelAvailable(final String label, final String dsdefUUID) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DataSetDefinitionLabelHelper.this.labelAvailable(label, dsdefUUID);
            }
        });
    }
}

