/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.zcomponent.ui;

import com.ibm.teamz.internal.zcomponent.ui.nls.Messages;
import com.ibm.teamz.internal.zcomponent.ui.utils.ZArtifactValidationUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;

public class ZFileRenameParticipant
extends RenameParticipant {
    private IFile file;

    protected boolean initialize(Object element) {
        if (element instanceof IFile) {
            this.file = (IFile)element;
            return true;
        }
        return false;
    }

    public String getName() {
        return Messages.ZFileRenameParticipant_Name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        IResourceDelta memberDelta;
        ResourceChangeChecker checker;
        if (this.file != null && this.isZFile() && (checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class)) != null && (memberDelta = checker.getDeltaFactory().getDelta().findMember(this.file.getFullPath())) != null) {
            return RefactoringStatus.create((IStatus)ZArtifactValidationUtils.validateZFile(memberDelta.getMovedToPath().lastSegment(), (IFolder)this.file.getParent(), this.file));
        }
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    private boolean isZFile() {
        IContainer project;
        IContainer zOSSrcFolder;
        IContainer parent = this.file.getParent();
        return parent != null && parent instanceof IFolder && (zOSSrcFolder = parent.getParent()) != null && zOSSrcFolder instanceof IFolder && "zOSsrc".equalsIgnoreCase(zOSSrcFolder.getName()) && (project = zOSSrcFolder.getParent()) != null && project instanceof IProject;
    }
}

