/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.zcomponent.ui;

import com.ibm.teamz.internal.zcomponent.ui.nls.Messages;
import com.ibm.teamz.internal.zcomponent.ui.utils.ZArtifactValidationUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;

public class ZFileMoveParticipant
extends MoveParticipant {
    private IFile file;

    protected boolean initialize(Object element) {
        if (element instanceof IFile) {
            this.file = (IFile)element;
            return true;
        }
        return false;
    }

    public String getName() {
        return Messages.ZFileMoveParticipant_Name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        IResourceDelta memberDelta;
        ResourceChangeChecker checker;
        if (this.file != null && (checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class)) != null && (memberDelta = checker.getDeltaFactory().getDelta().findMember(this.file.getFullPath())) != null) {
            IPath movedTo = memberDelta.getMovedToPath();
            IFolder movedToFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(movedTo.removeLastSegments(1));
            if (movedToFolder != null && movedToFolder.exists()) {
                return RefactoringStatus.create((IStatus)ZArtifactValidationUtils.validateZFile(movedTo.lastSegment(), movedToFolder, this.file));
            }
        }
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }
}

