/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.filesystem.cli.client.util;

import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.api.MappingValidation;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.teamz.internal.filesystem.cli.client.nls.Messages;
import org.eclipse.osgi.util.NLS;

public class CmdValidation {
    public static String checkPrefix(MappingValidation vld, String prefix) {
        String msg = "";
        if (prefix.indexOf(".") > -1) {
            int rc = vld.isValidDSName(prefix);
            if (rc == 1) {
                msg = Messages.zCmd_errpfx1;
            }
            if (rc == 2) {
                msg = Messages.zCmd_errpfx2;
            }
            if (rc == 3) {
                msg = Messages.zCmd_errpfx3;
            }
            if (rc == 4) {
                msg = Messages.zCmd_errpfx4;
            }
            if (rc == 5) {
                msg = Messages.zCmd_errpfx5;
            }
        } else {
            int rc = vld.isValidMemberName(prefix);
            if (rc == 1) {
                msg = Messages.zCmd_errpfx1;
            }
            if (rc == 2) {
                msg = Messages.zCmd_errpfx2;
            }
        }
        return msg;
    }

    public static String checkParams(ICommandLine subargs, IOptionKey option, String message) throws CLIFileSystemClientException {
        String ret_val = "";
        if (!subargs.hasOption(option)) {
            throw StatusHelper.inappropriateArgument((String)message);
        }
        ret_val = subargs.getOption(option);
        return ret_val;
    }

    public static String checkParamsWithCondition(ICommandLine subargs, IOptionKey option, String message, boolean needed) throws CLIFileSystemClientException {
        String ret_val = "";
        if (subargs.hasOption(option)) {
            ret_val = subargs.getOption(option);
        } else if (needed) {
            throw StatusHelper.inappropriateArgument((String)message);
        }
        return ret_val;
    }

    public static String checkPrimaryQty(MappingValidation vld, String qty) {
        int rc;
        String msg = "";
        boolean isValidInt = false;
        try {
            Integer.parseInt(qty);
            isValidInt = true;
        }
        catch (NumberFormatException nfe) {
            msg = Messages.zcrdsdef_errqty1;
        }
        if (isValidInt && (rc = vld.isValidPrimary(qty)) > 0 && rc == 2) {
            msg = NLS.bind((String)Messages.zcrdsdef_errqty2, (Object)1, (Object)"16777215");
        }
        return msg;
    }

    public static String checkDataset(MappingValidation vld, String dataset) {
        String msg = "";
        if (dataset.indexOf(".") > -1) {
            int rc = vld.isValidDSName(dataset);
            if (rc == 1) {
                msg = Messages.zCmd_errDataset1;
            }
            if (rc == 2) {
                msg = Messages.zCmd_errDataset2;
            }
            if (rc == 3) {
                msg = Messages.zCmd_errDataset3;
            }
            if (rc == 4) {
                msg = Messages.zCmd_errDataset4;
            }
            if (rc == 5) {
                msg = Messages.zCmd_errDataset5;
            }
        } else {
            msg = Messages.zCmd_errDataset0;
        }
        return msg;
    }
}

