/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.filesystem.cli.client.util;

import com.ibm.team.enterprise.systemdefinition.client.util.DataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class CLIUtility {
    public static void printOut(String message) {
        IndentingPrintStream printStream = new IndentingPrintStream((OutputStream)System.out);
        printStream.println((CharSequence)message);
    }

    public static IProjectAreaHandle findProjectArea(ITeamRepository repo, String nameOrUUID) throws FileSystemException {
        IProjectArea handle = null;
        IProcessItemService itemService = null;
        Object obj = repo.getClientLibrary(IProcessItemService.class);
        if (obj instanceof IProcessItemService) {
            itemService = (IProcessItemService)obj;
        }
        if (itemService != null) {
            List projectAreas = new ArrayList();
            try {
                projectAreas = itemService.findAllProjectAreas(IProcessClientService.ALL_PROPERTIES, null);
            }
            catch (TeamRepositoryException ex) {
                throw StatusHelper.argSyntax((String)ex.getMessage());
            }
            int size = projectAreas.size();
            int numProjectAreas = 0;
            if (size > 0) {
                numProjectAreas = size;
            }
            int i = 0;
            while (i < numProjectAreas) {
                IProjectArea thisProjArea = (IProjectArea)projectAreas.get(i);
                if (nameOrUUID.equals(thisProjArea.getName()) || nameOrUUID.equals(thisProjArea.getItemId().getUuidValue())) {
                    handle = thisProjArea;
                    break;
                }
                ++i;
            }
        }
        return handle;
    }

    public static int getDSDefTotal(ITeamRepository repo, IProjectAreaHandle handle) throws CLIFileSystemClientException {
        int total = 0;
        try {
            total = DataSetDefinition.get((ITeamRepository)repo, (IProjectAreaHandle)handle).size();
        }
        catch (TeamRepositoryException e) {
            StatusHelper.createException((String)e.getLocalizedMessage(), (int)3, (Throwable)e);
        }
        return total;
    }

    public static IDataSetDefinition findOneDatasetDefinition(ITeamRepository repo, IProjectAreaHandle handle, String defName) throws FileSystemException {
        IDataSetDefinition result;
        try {
            result = DataSetDefinition.get((ITeamRepository)repo, (String)defName);
        }
        catch (TeamRepositoryException e) {
            throw new FileSystemException((Throwable)e);
        }
        return result;
    }
}

