/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.filesystem.cli.client.subcommand;

import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.teamz.fileagent.Zutility;
import com.ibm.teamz.filesystem.cli.client.AbstractSubcommand;
import com.ibm.teamz.internal.filesystem.cli.client.nls.Messages;
import com.ibm.teamz.internal.filesystem.cli.client.subcommand.ZLoadXmlCmdOptions;
import com.ibm.teamz.internal.filesystem.cli.client.util.CLIUtility;
import com.ibm.teamz.internal.filesystem.cli.client.util.CmdValidation;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class ZLoadXmlCmd
extends AbstractSubcommand {
    @Override
    public void run() throws FileSystemException {
        NamedOptionDefinition optUri = CommonOptions.OPT_URI;
        NamedOptionDefinition optUsrName = CommonOptions.OPT_USERNAME;
        ICommandLine subargs = this.config.getSubcommandCommandLine();
        String uri = CmdValidation.checkParams(subargs, (IOptionKey)optUri, Messages.zloadxml_erruri);
        String user = CmdValidation.checkParams(subargs, (IOptionKey)optUsrName, Messages.zloadxml_erruser);
        String pwdf = subargs.getOption(ZLoadXmlCmdOptions.OPT_PWDF_KEY, "defaultPWDF");
        String xmlf = subargs.getOption(ZLoadXmlCmdOptions.OPT_XMLF_KEY, "defaultXML");
        File pwdFile = new File(pwdf);
        if (pwdFile.exists()) {
            if (pwdFile.length() == 0L) {
                String errMsg = NLS.bind((String)Messages.zloadxml_errpwdf2, (Object)pwdf);
                throw StatusHelper.inappropriateArgument((String)errMsg);
            }
        } else {
            String errMsg = NLS.bind((String)Messages.zloadxml_errpwdf1, (Object)pwdf);
            throw StatusHelper.inappropriateArgument((String)errMsg);
        }
        File xmlFile = new File(xmlf);
        if (xmlFile.exists()) {
            if (xmlFile.length() == 0L) {
                String errMsg = NLS.bind((String)Messages.zloadxml_errxmlf2, (Object)xmlf);
                throw StatusHelper.inappropriateArgument((String)errMsg);
            }
        } else {
            String errMsg = NLS.bind((String)Messages.zloadxml_errxmlf1, (Object)xmlf);
            throw StatusHelper.inappropriateArgument((String)errMsg);
        }
        try {
            Zutility.zloadxml((String)uri, (String)user, (String)pwdf, (String)xmlf, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            throw StatusHelper.argSyntax((String)e.getMessage());
        }
        String msgOut = NLS.bind((String)Messages.zloadxml_out1, (Object)xmlf);
        CLIUtility.printOut(msgOut);
    }
}

