/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.filesystem.cli.client.subcommand;

import com.ibm.team.enterprise.scmee.zos.DataSetLocationFactory;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.api.MappingValidation;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.load.LoadFilter;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.teamz.fileagent.PDSUtility;
import com.ibm.teamz.fileagent.internal.operations.LoadOperationDilemmaHandler;
import com.ibm.teamz.filesystem.cli.client.AbstractSubcommand;
import com.ibm.teamz.internal.filesystem.cli.client.nls.Messages;
import com.ibm.teamz.internal.filesystem.cli.client.subcommand.AbsoluteLoadOperation;
import com.ibm.teamz.internal.filesystem.cli.client.subcommand.ZCommonOptions;
import com.ibm.teamz.internal.filesystem.cli.client.subcommand.ZLoadCmdOptions;
import com.ibm.teamz.internal.filesystem.cli.client.util.CLIUtility;
import com.ibm.teamz.internal.filesystem.cli.client.util.CmdValidation;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class ZLoadCmd
extends AbstractSubcommand {
    private static final boolean DEBUG = false;

    @Override
    public void run() throws FileSystemException {
        ConnectionInfo connectionInfo = this.config.getConnectionInfo();
        ICommandLine subargs = this.config.getSubcommandCommandLine();
        if (!(subargs.hasOption(ZLoadCmdOptions.OPT_HFS_KEY) || subargs.hasOption((IOptionKey)ZCommonOptions.OPT_PREFIX) || subargs.hasOption(ZLoadCmdOptions.OPT_DATASET_KEY))) {
            throw StatusHelper.inappropriateArgument((String)Messages.zload_erratleastoneprefix);
        }
        String hfs = "";
        if (subargs.hasOption(ZLoadCmdOptions.OPT_HFS_KEY)) {
            hfs = CmdValidation.checkParams(subargs, ZLoadCmdOptions.OPT_HFS_KEY, Messages.zload_errhfs);
            this.checkHFSPath(hfs);
        }
        hfs = hfs.trim().length() > 0 ? hfs.trim() : null;
        String pfx = "";
        if (subargs.hasOption((IOptionKey)ZCommonOptions.OPT_PREFIX)) {
            pfx = CmdValidation.checkParams(subargs, (IOptionKey)ZCommonOptions.OPT_PREFIX, Messages.zload_errpfx);
            this.checkPrefix(pfx);
        }
        pfx = pfx.trim().length() > 0 ? pfx.trim() : null;
        String dataset = "";
        if (subargs.hasOption(ZLoadCmdOptions.OPT_DATASET_KEY)) {
            dataset = CmdValidation.checkParams(subargs, ZLoadCmdOptions.OPT_DATASET_KEY, Messages.zload_errDatasetAbsolute);
            this.checkDataset(dataset);
        }
        String string = dataset = dataset.trim().length() > 0 ? dataset.trim() : null;
        if (dataset != null && (pfx != null || hfs != null)) {
            throw StatusHelper.inappropriateArgument((String)Messages.zload_errDatasetAbsoluteUniqueDestination);
        }
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue(ZLoadCmdOptions.OPT_WKS_SELECTOR), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE);
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ITeamRepository tRepository = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)connectionInfo);
        IWorkspace wks = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)false, (ITeamRepository)tRepository, (IScmClientConfiguration)this.config);
        List remotes = null;
        if (subargs.hasOption(ZLoadCmdOptions.OPT_REMOTE_PATHS)) {
            List remoteCLIArgs = null;
            remoteCLIArgs = ScmCommandLineArgument.createList((List)subargs.getOptionValues(ZLoadCmdOptions.OPT_REMOTE_PATHS), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((List)remoteCLIArgs, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
            RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT, (List)remoteCLIArgs, (ITeamRepository)tRepository, (IScmClientConfiguration)this.config);
            remotes = RepoUtil.getSelectors((List)remoteCLIArgs);
        }
        try {
            this.loadItems(tRepository, client, wks, remotes, pfx, hfs, dataset);
        }
        catch (TeamRepositoryException ex) {
            if (remotes == null) {
                throw StatusHelper.failure((String)Messages.zload_command_error_while_loading, (Throwable)ex);
            }
            throw StatusHelper.failure((String)Messages.zload_command_error_while_loading_items, (Throwable)ex);
        }
        if (remotes == null) {
            CLIUtility.printOut(NLS.bind((String)Messages.zload_out1, (Object)wks.getName()));
        } else {
            CLIUtility.printOut(NLS.bind((String)Messages.zload_out1_items, (Object)wks.getName()));
        }
    }

    private void loadItems(ITeamRepository tRepository, IFilesystemRestClient client, IWorkspace wks, List<String> remotes, String pfx, String hfs, String dataset) throws ItemNotFoundException, ComponentNotInWorkspaceException, TeamRepositoryException {
        AbsoluteLoadOperation mvsAbsoluteLoadOp = null;
        if (dataset != null) {
            int index = dataset.lastIndexOf(".");
            if (index == -1) {
                throw StatusHelper.inappropriateArgument((String)Messages.zload_errDatasetAbsoluteNotConform);
            }
            mvsAbsoluteLoadOp = new AbsoluteLoadOperation(FileSystemCore.getSharingManager().getSandbox(DataSetLocationFactory.createDataSetLocation((String)dataset.substring(0, index)), false), dataset.substring(index + 1), tRepository);
        }
        ILoadOperation mvsLoadOp = null;
        ISandbox mvsSandbox = null;
        if (pfx != null) {
            mvsSandbox = FileSystemCore.getSharingManager().getSandbox(DataSetLocationFactory.createDataSetLocation((String)pfx), false);
            mvsLoadOp = IOperationFactory.instance.getLoadOperation((LoadDilemmaHandler)new LoadOperationDilemmaHandler());
        }
        ILoadOperation ussLoadOp = null;
        ISandbox ussSandbox = null;
        if (hfs != null) {
            ussSandbox = FileSystemCore.getSharingManager().getSandbox((ILocation)new PathLocation(SubcommandUtil.canonicalize((File)new File(hfs)).getAbsolutePath()), false);
            ussLoadOp = IOperationFactory.instance.getLoadOperation((LoadDilemmaHandler)new LoadOperationDilemmaHandler());
            ussLoadOp.setLoadFilter(LoadFilter.exclude((String[])new String[]{"zOSsrc", ".zOSbin", "zOSout"}));
        }
        if (remotes == null || remotes.size() == 0) {
            remotes = new ArrayList<String>(1);
            remotes.add(Character.toString('/'));
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        IWorkspaceConnection workspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)tRepository).getWorkspaceConnection((IWorkspaceHandle)wks, (IProgressMonitor)monitor);
        List workspaceComponents = null;
        workspaceComponents = tRepository.itemManager().fetchCompleteItems(workspaceConnection.getComponents(), 1, (IProgressMonitor)monitor);
        for (String selector : remotes) {
            String[] path = StringUtil.splitEscapedPath((String)selector);
            if (path.length == 0) {
                if (mvsAbsoluteLoadOp != null) {
                    throw StatusHelper.inappropriateArgument((String)Messages.zload_errDatasetAbsoluteNotForWorkspace);
                }
                for (IComponent comp : workspaceComponents) {
                    Collection itemsToLoad = workspaceConnection.configuration((IComponentHandle)comp).childEntries(comp.getRootFolder(), null).values();
                    if (mvsLoadOp != null) {
                        mvsLoadOp.requestLoad(mvsSandbox, null, workspaceConnection, (IComponentHandle)comp, itemsToLoad);
                    }
                    if (ussLoadOp == null) continue;
                    ussLoadOp.requestLoad(ussSandbox, null, workspaceConnection, (IComponentHandle)comp, itemsToLoad);
                }
                continue;
            }
            IComponent component = this.getComponent(tRepository, workspaceComponents, path[0], this.config);
            if (path.length > 1) {
                String[] remoteItemPath = new String[path.length - 1];
                System.arraycopy(path, 1, remoteItemPath, 0, remoteItemPath.length);
                IConfiguration configuration = workspaceConnection.configuration((IComponentHandle)component);
                IVersionableHandle remoteItemHandle = configuration.resolvePath(component.getRootFolder(), remoteItemPath, (IProgressMonitor)monitor);
                if (remoteItemHandle != null) {
                    if (mvsAbsoluteLoadOp != null) {
                        mvsAbsoluteLoadOp.requestLoadItemsAbsolute(remoteItemPath, remoteItemHandle, configuration, (IProgressMonitor)monitor);
                    }
                    if (mvsLoadOp != null) {
                        mvsLoadOp.requestLoad(mvsSandbox, null, workspaceConnection, (IComponentHandle)component, Collections.singleton(remoteItemHandle));
                    }
                    if (ussLoadOp == null) continue;
                    ussLoadOp.requestLoad(ussSandbox, null, workspaceConnection, (IComponentHandle)component, Collections.singleton(remoteItemHandle));
                    continue;
                }
                throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.zload_remote_item_not_found, (Object)selector));
            }
            if (mvsAbsoluteLoadOp != null) {
                throw StatusHelper.inappropriateArgument((String)Messages.zload_errDatasetAbsoluteNotForComponent);
            }
            Collection itemsToLoad = workspaceConnection.configuration((IComponentHandle)component).childEntries(component.getRootFolder(), null).values();
            if (mvsLoadOp != null) {
                mvsLoadOp.requestLoad(mvsSandbox, null, workspaceConnection, (IComponentHandle)component, itemsToLoad);
            }
            if (ussLoadOp == null) continue;
            ussLoadOp.requestLoad(ussSandbox, null, workspaceConnection, (IComponentHandle)component, itemsToLoad);
        }
        boolean bRequest = false;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (mvsLoadOp != null && mvsLoadOp.getLoadRequests().size() > 0) {
            bRequest = true;
            mvsLoadOp.run((IProgressMonitor)progress.newChild(80));
        }
        if (ussLoadOp != null && ussLoadOp.getLoadRequests().size() > 0) {
            bRequest = true;
            ussLoadOp.run((IProgressMonitor)progress.newChild(20));
        }
        if (mvsAbsoluteLoadOp != null && mvsAbsoluteLoadOp.getLoadRequests().size() > 0) {
            bRequest = true;
            mvsAbsoluteLoadOp.run((IProgressMonitor)progress.newChild(100));
        }
        if (!bRequest) {
            this.config.getContext().stdout().println(Messages.zload_no_load_requests);
            return;
        }
    }

    private IComponent getComponent(ITeamRepository repo, List<IComponent> workspaceComponents, String compSelector, IScmClientConfiguration config) throws CLIFileSystemClientException {
        IComponent matchedComp = null;
        IUuidAliasRegistry.IUuidAlias compAlias = RepoUtil.lookupUuidAndAlias((String)compSelector);
        if (compAlias != null) {
            // empty if block
        }
        ArrayList<SubcommandUtil.ItemInfo> compsMatched = new ArrayList<SubcommandUtil.ItemInfo>();
        for (IComponent comp : workspaceComponents) {
            if ((compAlias == null || !compAlias.getUuid().getUuidValue().equals(comp.getItemId().getUuidValue())) && !comp.getName().equals(compSelector)) continue;
            matchedComp = comp;
            SubcommandUtil.ItemInfo itemInfo = new SubcommandUtil.ItemInfo(comp.getName(), comp.getItemId().getUuidValue(), repo.getRepositoryURI(), RepoUtil.ItemType.COMPONENT);
            compsMatched.add(itemInfo);
        }
        if (compsMatched.size() > 1) {
            SubcommandUtil.displayAmbiguousSelectorException((String)compSelector, compsMatched, (IScmClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.zload_ambiguous_component, (Object)compSelector));
        }
        if (matchedComp == null) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.zload_component_not_found, (Object)compSelector));
        }
        return matchedComp;
    }

    private void checkHFSPath(String hfs) throws FileSystemStatusException {
        if (!new File(hfs).isAbsolute()) {
            throw StatusHelper.inappropriateArgument((String)Messages.zload_errhfsAbsolute);
        }
    }

    private String checkPrefix(String prefix) throws FileSystemException {
        MappingValidation vld = new MappingValidation();
        String msg = CmdValidation.checkPrefix(vld, prefix);
        if (!"".equals(msg)) {
            throw StatusHelper.inappropriateArgument((String)msg);
        }
        return msg;
    }

    private String checkDataset(String dataset) throws FileSystemException {
        MappingValidation vld = new MappingValidation();
        String msg = CmdValidation.checkDataset(vld, dataset);
        if (!"".equals(msg)) {
            throw StatusHelper.inappropriateArgument((String)msg);
        }
        if (!PDSUtility.isPDSExists((String)dataset)) {
            throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.zload_errDatasetAbsoluteDoesNotExist, (Object)dataset));
        }
        return msg;
    }

    private static void display(String mess) {
        System.out.println(mess);
    }
}

