/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.filesystem.cli.client.subcommand;

import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.IFileOptions;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IShareableInternal;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.api.storage.FileOptionsFactory;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.teamz.internal.filesystem.cli.client.nls.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class AbsoluteLoadOperation {
    private static final boolean DEBUG = false;
    private final ISandbox mvsSandbox;
    private final String datasetSuffix;
    private final ITeamRepository repository;
    private final Map<IFileItem, String> fileItems;
    static final boolean SKIP_MODIFICATION_STAMPS = "true".equals(System.getenv("JAZZ_CCM_SKIP_MOD_TIME"));

    public AbsoluteLoadOperation(ISandbox mvsCFAAbsoluteSandbox, String datasetSuffix, ITeamRepository repository) {
        this.mvsSandbox = mvsCFAAbsoluteSandbox;
        this.datasetSuffix = datasetSuffix;
        this.repository = repository;
        this.fileItems = new HashMap<IFileItem, String>();
    }

    public Map<IFileItem, String> getLoadRequests() {
        return this.fileItems;
    }

    public void requestLoadItemsAbsolute(String[] remoteItemPath, IVersionableHandle remoteItemHandle, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!this.checkRemotePath(remoteItemPath, remoteItemHandle)) {
            throw StatusHelper.inappropriateArgument((String)Messages.zload_errDatasetAbsoluteRemotePathInvalid);
        }
        if (ResourceType.getResourceType((IVersionableHandle)remoteItemHandle) == ResourceType.FILE) {
            this.requestloadFileItemAbsolute(configuration, remoteItemHandle, monitor);
        } else if (ResourceType.getResourceType((IVersionableHandle)remoteItemHandle) == ResourceType.FOLDER) {
            Map children = configuration.childEntries((IFolderHandle)remoteItemHandle, monitor);
            for (Object child : children.values()) {
                this.requestloadFileItemAbsolute(configuration, (IVersionableHandle)child, monitor);
            }
        }
    }

    private boolean checkRemotePath(String[] remoteItemPath, IVersionableHandle remoteItemHandle) {
        return ResourceType.getResourceType((IVersionableHandle)remoteItemHandle) == ResourceType.FILE ? remoteItemPath.length == 4 && remoteItemPath[remoteItemPath.length - 3].equalsIgnoreCase("zOSsrc") : ResourceType.getResourceType((IVersionableHandle)remoteItemHandle) == ResourceType.FOLDER && remoteItemPath.length == 3 && remoteItemPath[remoteItemPath.length - 2].equalsIgnoreCase("zOSsrc");
    }

    private void requestloadFileItemAbsolute(IConfiguration configuration, IVersionableHandle remoteItemHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IFileItem fileItem = (IFileItem)configuration.fetchCompleteItem(remoteItemHandle, null);
        this.fileItems.put(fileItem, FilenameUtils.removeExtension((String)fileItem.getName()));
    }

    public void run(IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkValidity();
        for (IFileItem file : this.fileItems.keySet()) {
            this.loadFileItemAbsolute(file);
        }
    }

    private void checkValidity() throws TeamRepositoryException {
        Collection<String> names = this.fileItems.values();
        HashSet<String> namesSet = new HashSet<String>(names);
        if (names.size() != namesSet.size()) {
            throw StatusHelper.inappropriateArgument((String)Messages.zload_errDatasetAbsoluteEqualFileNames);
        }
    }

    private void loadFileItemAbsolute(IFileItem fileItem) throws TeamRepositoryException {
        RelativeLocation localPath = new RelativeLocation(new String[]{this.datasetSuffix, FilenameUtils.removeExtension((String)fileItem.getName())});
        IShareable sharable = this.mvsSandbox.findShareable((IRelativeLocation)localPath, ResourceType.FILE);
        IFileStorage storage = ((IShareableInternal)sharable).getFileStorage();
        HashMap properties = fileItem.getUserProperties();
        long timeToSet = this.getModificationStampToProcess(fileItem.getFileTimestamp(), storage.exists(null) ? new Date(storage.getModificationStamp()) : null);
        if (timeToSet != -1L) {
            HashMap enhancedProperties = new HashMap(properties.size() + 1);
            enhancedProperties.putAll(properties);
            enhancedProperties.put("PrivateZOSProp_Timestamp", Long.toString(timeToSet, 10));
            properties = enhancedProperties;
        }
        IFileOptions fileOptions = FileOptionsFactory.getFileOptions((boolean)true, (FileLineDelimiter)fileItem.getContent().getLineDelimiter(), (String)fileItem.getContent().getCharacterEncoding(), (Map)properties);
        InputStream inputStream = null;
        boolean bSuccess = false;
        try {
            inputStream = FileSystemCore.getContentManager((ITeamRepository)this.repository).retrieveContentStream((IFileItemHandle)fileItem, fileItem.getContent(), null);
            storage.create(fileOptions, inputStream, null);
            bSuccess = true;
        }
        finally {
            block10: {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        if (!bSuccess) break block10;
                        throw new FileSystemException(NLS.bind((String)Messages.zload_errFileIO, (Object)fileItem.getName(), (Object)e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
    }

    public long getModificationStampToProcess(Date remoteFileDate, Date localFileDate) throws FileSystemException {
        if (!SKIP_MODIFICATION_STAMPS) {
            Date now = new Date();
            if (remoteFileDate.getTime() != -1L && now.after(remoteFileDate) && (localFileDate == null || remoteFileDate.after(localFileDate))) {
                return remoteFileDate.getTime();
            }
        }
        return -1L;
    }

    private static void display(String mess) {
        System.out.println(mess);
    }
}

