/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.filesystem.cli.client.listcommand;

import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.teamz.filesystem.cli.client.AbstractSubcommand;
import com.ibm.teamz.internal.filesystem.cli.client.listcommand.ZListDSDefinitionsCmdOptions;
import com.ibm.teamz.internal.filesystem.cli.client.nls.Messages;
import com.ibm.teamz.internal.filesystem.cli.client.util.CLIUtility;
import com.ibm.teamz.internal.filesystem.cli.client.util.CmdValidation;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class ZListDSDefinitionsCmd
extends AbstractSubcommand {
    @Override
    public void run() throws FileSystemException {
        String prjOpt;
        ConnectionInfo connectionInfo = this.config.getConnectionInfo();
        ICommandLine subargs = this.config.getSubcommandCommandLine();
        ITeamRepository tRepository = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config), (ConnectionInfo)connectionInfo);
        IProjectAreaHandle prjArea = CLIUtility.findProjectArea(tRepository, prjOpt = CmdValidation.checkParams(subargs, ZListDSDefinitionsCmdOptions.OPT_PRJ_KEY, Messages.zlstdsdef_errprj2));
        if (prjArea == null) {
            String prjErrMsg = NLS.bind((String)Messages.zlstdsdef_errprj1, (Object)prjOpt);
            throw StatusHelper.inappropriateArgument((String)prjErrMsg);
        }
        String dsdefName = null;
        if (subargs.hasOption(ZListDSDefinitionsCmdOptions.OPT_DSDEF_KEY)) {
            dsdefName = subargs.getOption(ZListDSDefinitionsCmdOptions.OPT_DSDEF_KEY);
        }
        if (dsdefName == null) {
            this.listDatasetDefinitions(tRepository, prjArea);
        } else {
            IDataSetDefinition dsdef = CLIUtility.findOneDatasetDefinition(tRepository, prjArea, dsdefName);
            if (dsdef == null) {
                String errDefMsg = NLS.bind((String)Messages.zlstdsdef_errdef1, (Object)dsdefName);
                throw StatusHelper.inappropriateArgument((String)errDefMsg);
            }
            this.printOut(dsdef, tRepository);
        }
    }

    private void listDatasetDefinitions(ITeamRepository repo, IProjectAreaHandle handle) throws CLIFileSystemClientException {
        ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)repo.getClientLibrary(ISystemDefinitionModelClient.class);
        List dsdefs = Collections.emptyList();
        try {
            dsdefs = client.findSystemDefinitions(IDataSetDefinition.ITEM_TYPE, handle, -1, false, Arrays.asList(IDataSetDefinition.SMALL_PROFILE), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (TeamRepositoryException e) {
            StatusHelper.createException((String)e.getLocalizedMessage(), (int)3, (Throwable)e);
        }
        for (ISystemDefinition dsdef : dsdefs) {
            IDataSetDefinition definition = (IDataSetDefinition)dsdef;
            this.printOut(definition, repo);
        }
    }

    private void printOut(IDataSetDefinition definition, ITeamRepository repo) {
        String out1 = Messages.zlstdsdef_dsdefinfo;
        String out2 = Messages.zlstdsdef_dsname;
        IndentingPrintStream printStream = new IndentingPrintStream((OutputStream)System.out);
        printStream.println((CharSequence)NLS.bind((String)out1, (Object[])new Object[]{AliasUtil.alias((UUID)definition.getItemId(), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.UNKNOWN), definition.getName()}));
        String dsName = definition.getDsName();
        if (dsName == null) {
            dsName = "";
        }
        printStream.indent().println((CharSequence)NLS.bind((String)out2, (Object)dsName));
        printStream.println((CharSequence)"");
    }
}

