/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.filesystem.cli.client.listcommand;

import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.teamz.filesystem.cli.client.AbstractSubcommand;
import com.ibm.teamz.internal.filesystem.cli.client.util.CLIUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ListUUIDCmd
extends AbstractSubcommand {
    @Override
    public void run() throws FileSystemException {
        String out1 = "CRHTC0380I Starting UUIDs list";
        CLIUtility.printOut("CRHTC0380I Starting UUIDs list");
        ConnectionInfo connectionInfo = this.config.getConnectionInfo();
        ITeamRepository tRepository = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config), (ConnectionInfo)connectionInfo);
        try {
            this.listProjectAreas(tRepository);
        }
        catch (TeamRepositoryException e) {
            String errNbr = "CRHTC0386E ";
            String errMsg = this.getErrorMessageNbr(e.getMessage(), "CRHTC0386E ");
            throw StatusHelper.argSyntax((String)errMsg);
        }
    }

    private void listProjectAreas(ITeamRepository repo) throws TeamRepositoryException {
        IProcessItemService itemService = null;
        Object obj = repo.getClientLibrary(IProcessItemService.class);
        if (obj instanceof IProcessItemService) {
            itemService = (IProcessItemService)obj;
        }
        List projectAreas = new ArrayList();
        projectAreas = itemService.findAllProjectAreas(IProcessClientService.ALL_PROPERTIES, null);
        if (!projectAreas.isEmpty()) {
            for (IProjectArea projectArea : projectAreas) {
                String namePrj = projectArea.getName();
                String header = "CRHTC0382I Project name: ";
                String out = this.getOutMessage("CRHTC0382I Project name: ", namePrj);
                CLIUtility.printOut(out);
                this.listDatasetDefinitions(repo, projectArea.getProjectArea());
            }
        }
    }

    private void listDatasetDefinitions(ITeamRepository repo, IProjectAreaHandle handle) throws TeamRepositoryException {
        ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)repo.getClientLibrary(ISystemDefinitionModelClient.class);
        List dsdefs = client.findSystemDefinitions(IDataSetDefinition.ITEM_TYPE, handle, -1, false, Arrays.asList(IDataSetDefinition.SMALL_PROFILE), (IProgressMonitor)new NullProgressMonitor());
        for (ISystemDefinition dsdef : dsdefs) {
            IDataSetDefinition definition = (IDataSetDefinition)dsdef;
            String outLine = "******************************************************";
            CLIUtility.printOut("******************************************************");
            String hdr1 = "CRHTC0383I Definition name: ";
            String dsdefNameMsg = this.getOutMessage("CRHTC0383I Definition name: ", definition.getName());
            CLIUtility.printOut(dsdefNameMsg);
            String hdr2 = "CRHTC0384I Definition UUID: ";
            String dsdefUUIDMsg = this.getOutMessage("CRHTC0384I Definition UUID: ", definition.getItemId().toString());
            CLIUtility.printOut(dsdefUUIDMsg);
            String dsName = definition.getDsName();
            String hdr3 = "CRHTC0385I Data set name: ";
            String dsNameMsg = this.getOutMessage("CRHTC0385I Data set name: ", dsName);
            CLIUtility.printOut(dsNameMsg);
            CLIUtility.printOut("******************************************************");
        }
    }

    private String getErrorMessageNbr(String msg, String nbr) {
        StringBuffer bf = new StringBuffer();
        bf.append(nbr);
        bf.append(msg);
        return bf.toString();
    }

    private String getOutMessage(String hdr, String foot) {
        StringBuffer bf = new StringBuffer();
        bf.append(hdr);
        bf.append(foot);
        return bf.toString();
    }
}

