/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.internal.filesystem.cli.client.createcommand;

import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.teamz.fileagent.AllocateDataSetCapacity;
import com.ibm.teamz.fileagent.FileAgentException;
import com.ibm.teamz.fileagent.FileAgentRepositoryException;
import com.ibm.teamz.filesystem.cli.client.AbstractSubcommand;
import com.ibm.teamz.internal.filesystem.cli.client.createcommand.ZCreateDataSetCmdOpts;
import com.ibm.teamz.internal.filesystem.cli.client.nls.Messages;
import com.ibm.teamz.internal.filesystem.cli.client.util.CLIUtility;
import com.ibm.teamz.internal.filesystem.cli.client.util.CmdValidation;
import org.eclipse.osgi.util.NLS;

public class ZCreateDataSetCmd
extends AbstractSubcommand {
    public static final boolean FROMZOS = true;
    private final String dsName;
    private final boolean isPrefixed = false;

    public ZCreateDataSetCmd() {
        this.dsName = null;
    }

    @Override
    public void run() throws FileSystemException {
        ConnectionInfo connectionInfo = this.config.getConnectionInfo();
        ICommandLine subargs = this.config.getSubcommandCommandLine();
        ITeamRepository tRepository = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config), (ConnectionInfo)connectionInfo);
        String uuidSlct = subargs.getOption(ZCreateDataSetCmdOpts.OPT_UUID_SELECTOR);
        String errUUIDMsg = NLS.bind((String)Messages.zcrdataset_erruuid, (Object)uuidSlct);
        try {
            UUID.valueOf((String)uuidSlct);
        }
        catch (IllegalArgumentException e) {
            throw StatusHelper.argSyntax((String)errUUIDMsg);
        }
        IProjectAreaHandle projectArea = this.findProjectArea(tRepository, uuidSlct);
        if (projectArea == null) {
            throw StatusHelper.argSyntax((String)errUUIDMsg);
        }
        boolean isNeeded = false;
        String prefix = CmdValidation.checkParamsWithCondition(subargs, (IOptionKey)ZCreateDataSetCmdOpts.OPT_PFX_KEY, Messages.zcrdataset_errpfx1, isNeeded);
        try {
            AllocateDataSetCapacity.allocateDataSet((ITeamRepository)tRepository, (String)uuidSlct, null, (String)prefix);
        }
        catch (FileAgentRepositoryException fare) {
            throw StatusHelper.argSyntax((String)fare.getMessage());
        }
        catch (FileAgentException fae) {
            String errmsg = fae.getMessage();
            if (errmsg.contains("RC=1460142080")) {
                throw StatusHelper.argSyntax((String)Messages.zCmd_errpfx6);
            }
            throw StatusHelper.argSyntax((String)errmsg);
        }
        String out = "";
        if (this.dsName != null) {
            String fullName = this.getFullName(prefix, this.dsName);
            out = NLS.bind((String)Messages.zcrdataset_out1, (Object)fullName);
            CLIUtility.printOut(out);
        }
    }

    private IProjectAreaHandle findProjectArea(ITeamRepository repo, String uuid) throws CLIFileSystemClientException {
        ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)repo.getClientLibrary(ISystemDefinitionModelClient.class);
        ISystemDefinition sysdef = null;
        try {
            sysdef = client.findSystemDefinition(uuid, null, IDataSetDefinition.ITEM_TYPE, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.argSyntax((String)Messages.zcrdataset_errdef2);
        }
        if (sysdef == null) {
            throw StatusHelper.argSyntax((String)Messages.zcrdataset_errdef2);
        }
        return sysdef.getProjectArea();
    }

    private String getFullName(String prefix, String name) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix);
        sb.append(".");
        sb.append(name);
        return sb.toString();
    }
}

