/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.operations;

import com.ibm.teamz.fileagent.FileAgentRepositoryException;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import com.ibm.teamz.fileagent.internal.utility.PasswordHelper;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.eclipse.osgi.util.NLS;

public class ConnectionInfo {
    private String fJazzRepositoryUri;
    private String fUserId;
    private File fPasswordFile;
    private String fPassword;
    private String fClearPassword;
    private String fCertificateFile;
    private String fSmartCard;
    private String fKerberos;

    public ConnectionInfo(String jazzRepositoryUri, String userID, File passwordFile, String certificateFile, String smartCard, String kerberos) {
        this.fJazzRepositoryUri = jazzRepositoryUri;
        this.fUserId = userID;
        this.fPasswordFile = passwordFile;
        this.fCertificateFile = certificateFile;
        this.fSmartCard = smartCard;
        this.fKerberos = kerberos;
    }

    public ConnectionInfo(String jazzRepositoryUri, String userID, String password, String certificateFile, String smartCard, String kerberos) {
        this.fJazzRepositoryUri = jazzRepositoryUri;
        this.fUserId = userID;
        this.fPassword = password;
        this.fCertificateFile = certificateFile;
        this.fSmartCard = smartCard;
        this.fKerberos = kerberos;
    }

    public String getCertificateFile() {
        return this.fCertificateFile;
    }

    public String getSmartCard() {
        return this.fSmartCard;
    }

    public String getKerberos() {
        return this.fKerberos;
    }

    public String getJazzRepositoryUri() {
        return this.fJazzRepositoryUri;
    }

    public String getUserId() {
        return this.fUserId;
    }

    public File getPasswordFile() {
        return this.fPasswordFile;
    }

    public String getPassword() {
        return this.fPassword;
    }

    public String getClearPassword() throws FileAgentRepositoryException {
        if (this.fPasswordFile != null) {
            try {
                this.fClearPassword = PasswordHelper.getClearPasswordFromFile(this.fPasswordFile);
            }
            catch (IOException e) {
                throw new FileAgentRepositoryException(NLS.bind((String)Messages.INVALID_PASSWORD_FILE, (Object)this.fPasswordFile.getName()), e);
            }
            catch (GeneralSecurityException e) {
                throw new FileAgentRepositoryException(Messages.INVALID_PASSWORD, e);
            }
        } else {
            this.fClearPassword = this.fPassword != null ? PasswordHelper.getClearPasswordFromString(this.fPassword) : "";
        }
        return this.fClearPassword;
    }
}

