/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.xml;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.util.ObfuscationHelper;
import com.ibm.teamz.build.ant.zos.utils.LogUtility;
import com.ibm.teamz.fileagent.ConnectionFactory;
import com.ibm.teamz.fileagent.IConnection;
import com.ibm.teamz.fileagent.internal.utility.PasswordHelper;
import com.ibm.teamz.fileagent.macrooperations.IMacroOperation;
import com.ibm.teamz.fileagent.macrooperations.MacroOperationFactory;
import com.ibm.teamz.fileagent.operations.ConnectionInfo;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OperationListParser {
    private static final Log LOG = LogFactory.getLog(OperationListParser.class);
    private String fRepositoryAddress;
    private String fUserID;
    private String fUserPW;
    private String certificateFile;
    private String smartCard;
    private String kerberos;
    private IMacroOperation fMacroOperation;
    private ITeamRepository fRepository;
    private static final String LOAD_WORKSPACE_ELEMENT = "loadWorkspace";
    private static final String LOAD_FILES_ELEMENT = "loadFiles";
    private static final String LOAD_FOLDERS_ELEMENT = "loadFolders";
    private static final String CREATE_DATA_SETS_ELEMENT = "createDataSets";
    private static final String WORKSPACE_UUID_ATTRIBUTE = "workspaceUUID";
    private static final String DATA_SET_PREFIX_ATTRIBUTE = "dataSetPrefix";
    private static final String HFS_DESTINATION_ATTRIBUTE = "HFSDestination";
    private static final String LOAD_ONLY_USS_ATTRIBUTE = "loadOnlyUSS";
    private static final String FILE_ELEMENT = "file";
    private static final String FOLDER_ELEMENT = "folder";
    private static final String DATA_SET_ELEMENT = "dataSet";
    private static final String DATA_SET_DEFINITION_UUID_ATTRIBUTE = "dataSetDefinitionUUID";
    private static final String DATA_SET_DEFINITION_STATEID_UUID_ATTRIBUTE = "dataSetDefinitionStateIdUUID";
    private static final String DATA_SET_NAME_ATTRIBUTE = "dataSetName";
    private static final String COMPONENT_NAME_ATTRIBUTE = "componentName";
    private static final String COMPONENT_UUID_ATTRIBUTE = "componentUUID";
    private static final String FILE_PATH_ATTRIBUTE = "filePath";
    private static final String FOLDER_PATH_ATTRIBUTE = "folderPath";
    private static final String RESULT_FILE_ATTRIBUTE = "resultFile";
    private static final String LOAD_ONLY_USS_VALUE = "Y";
    private static final String AUTH_ELEMENT = "authentication";
    private static final String USER_ATTRIBUTE = "user";
    private static final String TOKEN_ATTRIBUTE = "token";

    public OperationListParser(String repositoryAddress, String userID, String userPW, String certificateFile, String smartCard, String kerberos) {
        this.fRepositoryAddress = repositoryAddress;
        this.fUserID = userID;
        this.fUserPW = userPW;
        this.certificateFile = certificateFile;
        this.smartCard = smartCard;
        this.kerberos = kerberos;
    }

    public OperationListParser(ITeamRepository repository) {
        this.fRepository = repository;
    }

    public IMacroOperation createMacroOperation(String operationListFilePath) throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        this.createOperations(docBuilderFactory.newDocumentBuilder().parse(operationListFilePath));
        return this.fMacroOperation;
    }

    public IMacroOperation createMacroOperation(InputStream operationListFileStream) throws Exception {
        LogUtility.logDebug((Log)LOG, null, (String[])new String[]{"createMacroOperation begins"});
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        this.createOperations(docBuilderFactory.newDocumentBuilder().parse(operationListFileStream));
        LogUtility.logDebug((Log)LOG, null, (String[])new String[]{"createMacroOperation end"});
        return this.fMacroOperation;
    }

    private void createOperations(Document operationList) throws Exception {
        Element element;
        Node node;
        LogUtility.logDebug((Log)LOG, null, (String[])new String[]{"createOperations begins"});
        IConnection connection = null;
        if (this.fRepository != null) {
            connection = ConnectionFactory.getConnection(this.fRepository);
        } else {
            boolean needHelper = true;
            if (this.fUserID == null && this.fUserPW == null || this.certificateFile == null && this.fUserPW == null) {
                LogUtility.logDebug((Log)LOG, null, (String[])new String[]{"No credentials supplied by config file. Checking operation."});
                NodeList list = operationList.getElementsByTagName(AUTH_ELEMENT);
                if (list != null && list.getLength() > 0) {
                    Element authElement = (Element)list.item(0);
                    this.fUserID = authElement.getAttribute(USER_ATTRIBUTE);
                    this.fUserPW = ObfuscationHelper.decryptString((String)authElement.getAttribute(TOKEN_ATTRIBUTE));
                    needHelper = false;
                    LogUtility.logDebug((Log)LOG, null, (String[])new String[]{"Found token for user " + this.fUserID + " in operation."});
                }
            }
            ConnectionInfo connInfo = new ConnectionInfo(this.fRepositoryAddress, this.fUserID, needHelper ? PasswordHelper.getClearPassword(this.fUserPW) : this.fUserPW, this.certificateFile, this.smartCard, this.kerberos);
            connection = ConnectionFactory.getConnection(connInfo);
        }
        this.fMacroOperation = MacroOperationFactory.getMacroOperation(connection);
        NodeList list = operationList.getElementsByTagName(LOAD_WORKSPACE_ELEMENT);
        int i = 0;
        while (i < list.getLength()) {
            LogUtility.logDebug((Log)LOG, null, (String[])new String[]{"createOperations: Workspace"});
            node = list.item(i);
            if (node.getNodeType() == 1) {
                element = (Element)node;
                this.loadWorkspace(element);
            }
            ++i;
        }
        list = operationList.getElementsByTagName(LOAD_FOLDERS_ELEMENT);
        i = 0;
        while (i < list.getLength()) {
            LogUtility.logDebug((Log)LOG, null, (String[])new String[]{"createOperations: Folders"});
            node = list.item(i);
            if (node.getNodeType() == 1) {
                element = (Element)node;
                this.loadFolders(element);
            }
            ++i;
        }
        list = operationList.getElementsByTagName(LOAD_FILES_ELEMENT);
        i = 0;
        while (i < list.getLength()) {
            LogUtility.logDebug((Log)LOG, null, (String[])new String[]{"createOperations: Files"});
            node = list.item(i);
            if (node.getNodeType() == 1) {
                element = (Element)node;
                this.loadFiles(element);
            }
            ++i;
        }
        list = operationList.getElementsByTagName(CREATE_DATA_SETS_ELEMENT);
        i = 0;
        while (i < list.getLength()) {
            LogUtility.logDebug((Log)LOG, null, (String[])new String[]{"createOperations: dataset"});
            node = list.item(i);
            if (node.getNodeType() == 1) {
                element = (Element)node;
                this.allocateDataSets(element);
            }
            ++i;
        }
        LogUtility.logDebug((Log)LOG, null, (String[])new String[]{"createOperations ends"});
    }

    private void loadWorkspace(Element element) {
        String workspaceID = element.getAttribute(WORKSPACE_UUID_ATTRIBUTE);
        String componentName = element.getAttribute(COMPONENT_NAME_ATTRIBUTE);
        String componentUUID = element.getAttribute(COMPONENT_UUID_ATTRIBUTE);
        String datasetPrefix = element.getAttribute(DATA_SET_PREFIX_ATTRIBUTE);
        String destinationHFS = element.getAttribute(HFS_DESTINATION_ATTRIBUTE);
        String resultFile = element.getAttribute(RESULT_FILE_ATTRIBUTE);
        String loadOnlyUSS = element.getAttribute(LOAD_ONLY_USS_ATTRIBUTE);
        String componentSelector = null;
        if (componentUUID != null && componentUUID.trim().length() > 0) {
            componentSelector = componentUUID;
        }
        if (componentSelector == null && componentName != null && componentName.trim().length() > 0) {
            componentSelector = componentName;
        }
        if (componentSelector == null) {
            if (loadOnlyUSS.trim().toUpperCase().equals(LOAD_ONLY_USS_VALUE)) {
                this.fMacroOperation.requestToLoadWorkspaceForUSS(workspaceID, datasetPrefix, destinationHFS, resultFile);
            } else {
                this.fMacroOperation.requestToLoadWorkspace(workspaceID, datasetPrefix, destinationHFS, resultFile);
            }
        } else if (loadOnlyUSS.trim().toUpperCase().equals(LOAD_ONLY_USS_VALUE)) {
            this.fMacroOperation.requestToLoadComponentWorkspaceForUSS(workspaceID, componentSelector, datasetPrefix, destinationHFS, resultFile);
        } else {
            this.fMacroOperation.requestToLoadComponentWorkspace(workspaceID, componentSelector, datasetPrefix, destinationHFS, resultFile);
        }
    }

    private void loadFiles(Element element) {
        LogUtility.logDebug((Log)LOG, null, (String[])new String[]{"loadFiles begins"});
        String workspaceID = element.getAttribute(WORKSPACE_UUID_ATTRIBUTE);
        String datasetPrefix = element.getAttribute(DATA_SET_PREFIX_ATTRIBUTE);
        NodeList list = element.getElementsByTagName(FILE_ELEMENT);
        LogUtility.logDebug((Log)LOG, null, (String[])new String[]{"loadFiles workspaceID, datasetPrefix," + workspaceID + datasetPrefix});
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeType() == 1) {
                Element file = (Element)node;
                String componentName = file.getAttribute(COMPONENT_NAME_ATTRIBUTE);
                String componentUUID = file.getAttribute(COMPONENT_UUID_ATTRIBUTE);
                String filePath = file.getAttribute(FILE_PATH_ATTRIBUTE);
                String dataSetName = file.getAttribute(DATA_SET_NAME_ATTRIBUTE);
                String dataSetDefinitionUUID = file.getAttribute(DATA_SET_DEFINITION_UUID_ATTRIBUTE);
                String dataSetDefinitionStateUUID = file.getAttribute(DATA_SET_DEFINITION_STATEID_UUID_ATTRIBUTE);
                LogUtility.logDebug((Log)LOG, null, (String[])new String[]{"loadFiles workspaceID, datasetPrefix, componentName, filePath, dataSetName" + workspaceID + datasetPrefix + componentName + filePath + dataSetName});
                if (dataSetName != null && dataSetName.length() > 0) {
                    this.fMacroOperation.requestToLoadFileInDataSetName(workspaceID, datasetPrefix, componentUUID, componentName, filePath, dataSetName);
                } else {
                    this.fMacroOperation.requestToLoadFile(workspaceID, datasetPrefix, componentUUID, componentName, filePath, dataSetDefinitionUUID, dataSetDefinitionStateUUID);
                }
            }
            ++i;
        }
    }

    private void loadFolders(Element element) {
        String workspaceID = element.getAttribute(WORKSPACE_UUID_ATTRIBUTE);
        String datasetPrefix = element.getAttribute(DATA_SET_PREFIX_ATTRIBUTE);
        NodeList list = element.getElementsByTagName(FOLDER_ELEMENT);
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeType() == 1) {
                Element folder = (Element)node;
                String componentName = folder.getAttribute(COMPONENT_NAME_ATTRIBUTE);
                String componentUUID = folder.getAttribute(COMPONENT_UUID_ATTRIBUTE);
                String folderPath = folder.getAttribute(FOLDER_PATH_ATTRIBUTE);
                String dataSetDefinitionUUID = folder.getAttribute(DATA_SET_DEFINITION_UUID_ATTRIBUTE);
                String dataSetDefinitionStateUUID = folder.getAttribute(DATA_SET_DEFINITION_STATEID_UUID_ATTRIBUTE);
                this.fMacroOperation.requestToLoadFolder(workspaceID, datasetPrefix, componentUUID, componentName, folderPath, dataSetDefinitionUUID, dataSetDefinitionStateUUID);
            }
            ++i;
        }
    }

    private void allocateDataSets(Element element) {
        String datasetPrefix = element.getAttribute(DATA_SET_PREFIX_ATTRIBUTE);
        NodeList list = element.getElementsByTagName(DATA_SET_ELEMENT);
        ArrayList<String> dataSetDefinitionIDs = new ArrayList<String>();
        ArrayList<String> dataSetDefinitionStateIDs = new ArrayList<String>();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeType() == 1) {
                Element dataSet = (Element)node;
                String dataSetDefinitionID = dataSet.getAttribute(DATA_SET_DEFINITION_UUID_ATTRIBUTE);
                String dataSetDefinitionStateID = dataSet.getAttribute(DATA_SET_DEFINITION_STATEID_UUID_ATTRIBUTE);
                dataSetDefinitionIDs.add(dataSetDefinitionID);
                dataSetDefinitionStateIDs.add(dataSetDefinitionStateID);
            }
            ++i;
        }
        this.fMacroOperation.requestToAllocateDataSets(datasetPrefix, dataSetDefinitionIDs, dataSetDefinitionStateIDs);
    }
}

