/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.utility;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class UnsynchronizedByteArrayOutputStreamEE
extends OutputStream {
    protected byte[] buffer;
    protected int pos;

    public UnsynchronizedByteArrayOutputStreamEE() {
        this(32);
    }

    public UnsynchronizedByteArrayOutputStreamEE(int initialSize) {
        this.allocateBuffer(initialSize);
    }

    protected void allocateBuffer(int size) {
        this.buffer = new byte[size];
    }

    protected void reallocate(int size) {
        byte[] tmp = this.buffer;
        this.allocateBuffer(size);
        System.arraycopy(tmp, 0, this.buffer, 0, this.pos);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.pos == this.buffer.length) {
            this.reallocate(Math.max(this.pos * 2, this.pos + 1));
        }
        this.buffer[this.pos++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.buffer.length - this.pos < len) {
            this.reallocate(Math.max(this.pos + len, this.buffer.length * 2));
        }
        System.arraycopy(b, off, this.buffer, this.pos, len);
        this.pos += len;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buffer, 0, this.pos);
    }

    public void reset() {
        this.pos = 0;
    }

    public byte[] toByteArray() {
        byte[] buf = new byte[this.pos];
        System.arraycopy(this.buffer, 0, buf, 0, this.pos);
        return buf;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int size() {
        return this.pos;
    }

    public String toString() {
        try {
            return new String(this.buffer, 0, this.pos, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString(String charset) throws UnsupportedEncodingException {
        return new String(this.buffer, 0, this.pos, charset);
    }

    public void readFrom(InputStream in) throws IOException {
        while (true) {
            int read;
            if (this.buffer.length - this.pos < 32768) {
                this.reallocate(Math.max(this.pos + 32768, this.buffer.length * 2));
            }
            if ((read = in.read(this.buffer, this.pos, this.buffer.length - this.pos)) == -1) break;
            this.pos += read;
        }
    }
}

