/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.utility;

import com.ibm.team.repository.common.util.Base64;
import com.ibm.team.repository.common.util.ObfuscationHelper;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public final class PasswordHelper {
    private static final String DES3EncType = "DESede";
    private static final String PasswordTag = "password";
    private static final String VersionTag = "version";
    private static final String DefaultVersion = "0";
    private static final String CurrentVersion = "1";
    private static final byte[] tripleDESKey = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 8, 7, 6, 5, 4, 3, 2, 1, 1, 2, 3, 4, 4, 3, 2, 1};

    private PasswordHelper() {
    }

    public static String getClearPassword(String password) throws GeneralSecurityException {
        String clearPass = null;
        if (password != null) {
            try {
                clearPass = PasswordHelper.getNewClearPasswordFromFile(new File(password));
            }
            catch (IOException e) {
                clearPass = PasswordHelper.getClearPasswordFromString(password);
            }
        }
        return clearPass;
    }

    private static String decryptString(String cipherText, byte[] key) throws UnsupportedEncodingException, GeneralSecurityException {
        if (cipherText == null) {
            throw new IllegalArgumentException("Parameter \"cipherText\" must not be null.");
        }
        if (key == null) {
            throw new IllegalArgumentException("Parameter \"key\" must not be null.");
        }
        SecretKeySpec keySpec = new SecretKeySpec(key, DES3EncType);
        Cipher cp = Cipher.getInstance(DES3EncType);
        cp.init(2, keySpec);
        byte[] clearText = cp.doFinal(Base64.decode((byte[])cipherText.getBytes("UTF-8")));
        return new String(clearText, "UTF-8");
    }

    /*
     * Unable to fully structure code
     */
    public static String getNewClearPasswordFromFile(File passwordFile) throws IOException, GeneralSecurityException {
        block18: {
            if (!passwordFile.exists()) {
                throw new FileNotFoundException(Messages.PasswordHelper_FILE_MISSING);
            }
            if (passwordFile.isDirectory()) {
                throw new FileNotFoundException(Messages.PasswordHelper_FILE_IS_DIRECTORY);
            }
            password = null;
            inputStream = new FileInputStream(passwordFile);
            try {
                try {
                    properties = new Properties();
                    properties.loadFromXML(inputStream);
                    password = properties.getProperty("password");
                    if (password == null) {
                        throw new IOException(Messages.PasswordHelper_INVALID_FORMAT);
                    }
                    version = properties.getProperty("version", "0");
                    password = version.equals("1") ? PasswordHelper.decryptString(password, PasswordHelper.tripleDESKey) : ObfuscationHelper.decryptString((String)password);
                    break block18;
                }
                catch (InvalidPropertiesFormatException ipfe) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException version) {
                        // empty catch block
                    }
                    inputStream = new FileInputStream(passwordFile);
                    fileContent = new StringBuffer();
                    buffer = new byte[256];
                    bytesRead = inputStream.read(buffer);
                    ** while (bytesRead != -1)
                }
lbl-1000:
                // 1 sources

                {
                    fileContent.append(new String(buffer, 0, bytesRead));
                    bytesRead = inputStream.read(buffer);
                    continue;
                }
lbl32:
                // 1 sources

                content = fileContent.toString();
                if (content.length() == 0) {
                    throw new IOException(Messages.PasswordHelper_FILE_EMPTY);
                }
                password = new String(ObfuscationHelper.decrypt((byte[])content.getBytes()));
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException var9_13) {}
            }
        }
        return password;
    }

    /*
     * Unable to fully structure code
     */
    public static String getClearPasswordFromFile(File passwordFile) throws IOException, GeneralSecurityException {
        block8: {
            clearPass = null;
            inputStream = new FileInputStream(passwordFile);
            try {
                try {
                    properties = new Properties();
                    properties.loadFromXML(inputStream);
                    clearPass = properties.getProperty("password");
                    if (clearPass == null) {
                        throw new IOException();
                    }
                    clearPass = ObfuscationHelper.decryptString((String)clearPass);
                    break block8;
                }
                catch (InvalidPropertiesFormatException ipfe) {
                    inputStream = new FileInputStream(passwordFile);
                    fileContent = new StringBuffer();
                    buffer = new byte[256];
                    bytesRead = inputStream.read(buffer);
                    ** while (bytesRead != -1)
                }
lbl-1000:
                // 1 sources

                {
                    fileContent.append(new String(buffer, 0, bytesRead));
                    bytesRead = inputStream.read(buffer);
                    continue;
                }
lbl22:
                // 1 sources

                clearPass = new String(ObfuscationHelper.decrypt((byte[])fileContent.toString().getBytes()));
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return clearPass;
    }

    public static String getClearPasswordFromString(String password) {
        String clearPass = null;
        try {
            clearPass = ObfuscationHelper.decryptString((String)password);
        }
        catch (GeneralSecurityException e) {
            clearPass = PasswordHelper.internalDecryptPasswaordV3(password);
        }
        catch (UnsupportedEncodingException e) {
            clearPass = PasswordHelper.internalDecryptPasswaordV3(password);
        }
        catch (IllegalArgumentException e) {
            clearPass = password;
        }
        return clearPass;
    }

    private static String internalDecryptPasswaordV3(String password) {
        String clearPass = null;
        try {
            clearPass = new String(ObfuscationHelper.decrypt((byte[])password.toString().getBytes()));
        }
        catch (GeneralSecurityException e1) {
            clearPass = password;
        }
        catch (IllegalArgumentException e1) {
            clearPass = password;
        }
        return clearPass;
    }
}

