/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.utility;

import com.ibm.team.enterprise.systemdefinition.client.util.DataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.repository.client.ILoginHandler2;
import com.ibm.team.repository.client.ILoginInfo2;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.SavedPasswordNotObtainedException;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.login.IAliasChooser;
import com.ibm.team.repository.client.login.KerberosLoginInfo;
import com.ibm.team.repository.client.login.SSLCertificateLoginInfo;
import com.ibm.team.repository.client.login.SmartCardLoginInfo;
import com.ibm.team.repository.client.login.UsernameAndPasswordLoginInfo;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.teamz.build.ant.zos.utils.LogUtility;
import com.ibm.teamz.fileagent.FileAgentRepositoryException;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import com.ibm.teamz.fileagent.internal.utility.InternalEMFInitialization;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class InternalRepoUtility {
    private static final Log LOG = LogFactory.getLog(InternalRepoUtility.class);
    public static boolean fromZos = true;
    private static final String KERBEROS_REALM_PROP = "java.security.krb5.realm";
    private static final String KERBEROS_KDC_PROP = "java.security.krb5.kdc";
    private static final String KERBEROS_CONFIG_PROP = "java.security.krb5.conf";

    static {
        new InternalRepoUtility();
    }

    private InternalRepoUtility() {
    }

    public static void login(ITeamRepository repo) throws FileAgentRepositoryException {
        LogUtility.logTrace((Log)LOG, null, (String[])new String[]{"Try to log in the TeamRepositor: " + repo.getRepositoryURI()});
        try {
            repo.login((IProgressMonitor)new NullProgressMonitor());
        }
        catch (TeamRepositoryException e) {
            throw new FileAgentRepositoryException(NLS.bind((String)Messages.OPERATION_LOGIN_UNABLE, (Object)repo.getRepositoryURI(), (Object[])new Object[0]), e);
        }
        if (!repo.loggedIn()) {
            throw new FileAgentRepositoryException(NLS.bind((String)Messages.OPERATION_LOGIN_UNABLE, (Object)repo.getRepositoryURI(), (Object[])new Object[0]));
        }
        LogUtility.logTrace((Log)LOG, null, (String[])new String[]{"logged in the TeamRepositor: " + repo.getRepositoryURI()});
    }

    public static IWorkspaceConnection getWorkspaceConnection(ITeamRepository repo, IWorkspaceHandle workspace, IProgressMonitor monitor) throws TeamRepositoryException {
        return SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(workspace, monitor);
    }

    public static final IWorkspaceConnection getWorkspaceConnection(ITeamRepository repo, String wsUUID, IProgressMonitor monitor) throws TeamRepositoryException {
        return InternalRepoUtility.getWorkspaceConnection(repo, (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)wsUUID), null), monitor);
    }

    public static List<IComponentHandle> getAllComponentHandles(IWorkspaceConnection wksConn, IProgressMonitor progress) throws FileAgentRepositoryException {
        try {
            wksConn.refresh(progress);
            return wksConn.getComponents();
        }
        catch (TeamRepositoryException e) {
            throw new FileAgentRepositoryException(NLS.bind((String)Messages.OPERATION_NO_VALID_COMPONENT, (Object)wksConn.getName(), (Object[])new Object[0]), e);
        }
    }

    public static IWorkspace fetchCompleteWorkspaceItem(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IProgressMonitor progress) throws FileAgentRepositoryException {
        IWorkspace workspace = null;
        if (workspaceHandle instanceof IWorkspace) {
            workspace = (IWorkspace)workspaceHandle;
        } else {
            IItem item = null;
            try {
                item = repository.itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 1, progress);
            }
            catch (TeamRepositoryException e) {
                throw new FileAgentRepositoryException(NLS.bind((String)Messages.OPERATION_MISSING_WORKSPACE, (Object)workspaceHandle, (Object[])new Object[0]), e);
            }
            if (!(item instanceof IWorkspace)) {
                throw new FileAgentRepositoryException(NLS.bind((String)Messages.OPERATION_WRONG_TYPE_WORKSPACE, (Object)workspaceHandle, (Object[])new Object[]{item.getItemType().getName()}));
            }
            workspace = (IWorkspace)item;
        }
        return workspace;
    }

    public static IDataSetDefinition retrieveDataDefinition(String dataDefinitionID, ITeamRepository teamRepository) throws IllegalArgumentException, TeamRepositoryException {
        return DataSetDefinition.get((ITeamRepository)teamRepository, (String)dataDefinitionID, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IDataSetDefinition retrieveDataDefinition(String dataDefinitionID, String dataDefinitionStateID, ITeamRepository teamRepository) throws IllegalArgumentException, TeamRepositoryException {
        return DataSetDefinition.getState((ITeamRepository)teamRepository, (String)dataDefinitionID, (String)dataDefinitionStateID, (IProgressMonitor)new NullProgressMonitor());
    }

    public static ITeamRepository getTeamRepository(String uri, String username, String password, String certificateFile, String smartCard, String kerberos) {
        if (!TeamPlatform.isStarted()) {
            LogUtility.logTrace((Log)LOG, null, (String[])new String[]{"TeamPlatform not started"});
            new InternalEMFInitialization().inititialize();
            LogUtility.logTrace((Log)LOG, null, (String[])new String[]{"==TeamPlatform.startup() to do.  Should see following traces:"});
            TeamPlatform.startup();
            LogUtility.logTrace((Log)LOG, null, (String[])new String[]{"==TeamPlatform.startup done!"});
        }
        ITeamRepository repo = null;
        repo = TeamPlatform.getTeamRepositoryService().getUnmanagedRepository(uri);
        LogUtility.logTrace((Log)LOG, null, (String[])new String[]{"==TeamRepository obtained with timeout of: " + repo.getConnectionTimeout()});
        if (certificateFile == null || certificateFile.length() <= 0) {
            if (kerberos == null || kerberos.length() <= 0) {
                if (smartCard == null || smartCard.length() <= 0) {
                    repo.registerLoginHandler((ITeamRepository.ILoginHandler)new LoginHandler(username, password));
                } else {
                    repo.registerLoginHandler((ILoginHandler2)new SmartCardLoginHandler(username));
                }
            } else {
                repo.registerLoginHandler((ILoginHandler2)new KerberosLoginHandler());
            }
        } else {
            repo.registerLoginHandler((ILoginHandler2)new CertificateLoginHandler(certificateFile, password));
        }
        return repo;
    }

    private static abstract class AbstractLoginHandler {
        private final ILoginInfo2 loginInfo;

        protected AbstractLoginHandler(ILoginInfo2 loginInfo) {
            this.loginInfo = loginInfo;
        }

        protected final ILoginInfo2 getLoginInfo() {
            return this.loginInfo;
        }
    }

    private static abstract class AbstractLoginHandler2
    extends AbstractLoginHandler
    implements ILoginHandler2 {
        protected AbstractLoginHandler2(ILoginInfo2 loginInfo) {
            super(loginInfo);
        }

        public ILoginInfo2 challenge(ITeamRepository repository) {
            return this.getLoginInfo();
        }
    }

    private static class CertificateLoginHandler
    extends AbstractLoginHandler2 {
        private CertificateLoginHandler(String certificateFile, String password) {
            super((ILoginInfo2)new SSLCertificateLoginInfo(certificateFile, password));
        }
    }

    public static class KerberosLoginHandler
    extends AbstractLoginHandler2 {
        public static KerberosLoginHandler create(String kerberosConfigPath, String kerberosKdc, String kerberosRealm) {
            KerberosLoginInfo kerberosLoginInfo = new KerberosLoginInfo();
            if (kerberosConfigPath != null && kerberosConfigPath.trim().length() > 0) {
                System.setProperty(InternalRepoUtility.KERBEROS_CONFIG_PROP, kerberosConfigPath);
            }
            if (kerberosKdc != null && kerberosKdc.trim().length() > 0) {
                System.setProperty(InternalRepoUtility.KERBEROS_KDC_PROP, kerberosKdc);
            }
            if (kerberosRealm != null && kerberosRealm.trim().length() > 0) {
                System.setProperty(InternalRepoUtility.KERBEROS_REALM_PROP, kerberosRealm);
            }
            return new KerberosLoginHandler(kerberosLoginInfo);
        }

        private KerberosLoginHandler(KerberosLoginInfo kerberosLoginInfo) {
            super((ILoginInfo2)kerberosLoginInfo);
        }

        public KerberosLoginHandler() {
            this(new KerberosLoginInfo());
        }
    }

    private static class LoginHandler
    extends AbstractLoginHandler
    implements ITeamRepository.ILoginHandler,
    ITeamRepository.ILoginHandler.ILoginInfo {
        private LoginHandler(String username, String password) {
            super((ILoginInfo2)new UsernameAndPasswordLoginInfo(username, password));
        }

        public ITeamRepository.ILoginHandler.ILoginInfo challenge(ITeamRepository repository) {
            return this;
        }

        public String getPassword() {
            try {
                return this.getUsernameAndPasswordLoginInfo().getPassword();
            }
            catch (SavedPasswordNotObtainedException e) {
                return null;
            }
        }

        public String getUserId() {
            return this.getUsernameAndPasswordLoginInfo().getUsername();
        }

        private UsernameAndPasswordLoginInfo getUsernameAndPasswordLoginInfo() {
            return (UsernameAndPasswordLoginInfo)this.getLoginInfo();
        }
    }

    private static class SmartCardLoginHandler
    extends AbstractLoginHandler2 {
        private static IAliasChooser createAliasChooser(final String requestedAlias) {
            return new IAliasChooser(){

                public String chooseAlias(List<String> aliases) {
                    for (String alias : aliases) {
                        if (!alias.equals(requestedAlias)) continue;
                        return alias;
                    }
                    return null;
                }
            };
        }

        private static SmartCardLoginInfo createSmartCardLoginInfo(String requestedAlias) {
            IAliasChooser chooser = SmartCardLoginHandler.createAliasChooser(requestedAlias);
            return new SmartCardLoginInfo(chooser);
        }

        public SmartCardLoginHandler(String alias) {
            super((ILoginInfo2)SmartCardLoginHandler.createSmartCardLoginInfo(alias));
        }
    }
}

