/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.operations;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.teamz.build.ant.zos.utils.LogUtility;
import com.ibm.teamz.fileagent.FileAgentException;
import com.ibm.teamz.fileagent.FileAgentRepositoryException;
import com.ibm.teamz.fileagent.IConnection;
import com.ibm.teamz.fileagent.Zutility;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import com.ibm.teamz.fileagent.internal.operations.LoadOperation;
import com.ibm.teamz.fileagent.operations.ILoadWorkspaceOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class LoadWorkspaceOperation
extends LoadOperation
implements ILoadWorkspaceOperation {
    private static final Log LOG = LogFactory.getLog(LoadWorkspaceOperation.class);
    String fDestinationHFS;
    String fListOfOutArtifacts;
    boolean fUSSOnly = false;
    String componentSelector;

    public LoadWorkspaceOperation(IConnection connection, String workspaceID, String datasetPrefix) {
        super(connection, workspaceID, datasetPrefix);
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileAgentException, FileAgentRepositoryException {
        LogUtility.logDebug((Log)LOG, null, (String[])new String[]{"LoadWorkspaceOperation.execute starts"});
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        IWorkspace workspace = this.getWorkspace(this.fConnection.getLoggedTeamrepository());
        try {
            ITeamRepository repo = this.fConnection.getLoggedTeamrepository();
            IWorkspaceConnection workspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)workspace, (IProgressMonitor)progress.newChild(1));
            List<IComponent> components = null;
            if (this.componentSelector == null || this.componentSelector.trim().length() == 0) {
                LogUtility.logDebug((Log)LOG, null, (String[])new String[]{"LoadWorkspaceOperation.execute load the whole workspaceID:<" + this.fWorkspaceID + ">"});
                components = this.fConnection.getLoggedTeamrepository().itemManager().fetchCompleteItems(workspaceConnection.getComponents(), 1, (IProgressMonitor)progress.newChild(2));
            } else {
                LogUtility.logDebug((Log)LOG, null, (String[])new String[]{"LoadWorkspaceOperation.execute load the componentID:<" + this.componentSelector + " for workspaceID:<" + this.fWorkspaceID + ">"});
                ArrayList<String> properties = new ArrayList<String>();
                properties.add(IComponent.NAME_PROPERTY);
                properties.add(IComponent.ITEM_ID_PROPERTY);
                List<IComponent> tmpComponents = LoadWorkspaceOperation.getPartialComponentsInWorkspace(properties, repo, workspaceConnection, progress.newChild(1));
                IComponent component = LoadWorkspaceOperation.getComponent(this.componentSelector, tmpComponents, repo, workspaceConnection, (IProgressMonitor)progress.newChild(1));
                if (component != null) {
                    components = Collections.singletonList(component);
                }
                LogUtility.logDebug((Log)LOG, null, (String[])new String[]{"LoadWorkspaceOperation.execute the componentID:<" + this.componentSelector + " exist in workspaceID:<" + this.fWorkspaceID + ">"});
            }
            if (this.fUSSOnly) {
                Zutility.zloadOnUSS(true, workspaceConnection, components, this.fDestinationHFS, this.bDeregister, (IProgressMonitor)progress.newChild(6));
            } else {
                Zutility.zload2(this.fConnection.getLoggedTeamrepository(), workspaceConnection, components, this.fDestinationHFS, this.fDatasetPrefix, this.bDeregister, (IProgressMonitor)progress.newChild(6));
            }
        }
        catch (TeamRepositoryException e) {
            String message = NLS.bind((String)Messages.OPERATION_FETCH_WORKSPACE_TO_PATH_ERROR, (Object)workspace.getName(), (Object)this.fDatasetPrefix);
            LogUtility.logError((Log)LOG, null, (String[])new String[]{message});
            throw new FileAgentRepositoryException(message, e);
        }
        LogUtility.logDebug((Log)LOG, null, (String[])new String[]{"LoadWorkspaceOperation.execute ends"});
    }

    @Override
    public void requestToLoadWorkspace(String destinationHFS, String resultFile) {
        this.fDestinationHFS = destinationHFS;
        this.fListOfOutArtifacts = resultFile;
        this.fUSSOnly = false;
    }

    @Override
    public void requestToLoadComponentWorkspace(String componentSelector, String destinationHFS, String resultFile) {
        this.componentSelector = componentSelector;
        this.fDestinationHFS = destinationHFS;
        this.fListOfOutArtifacts = resultFile;
        this.fUSSOnly = false;
    }

    @Override
    public void requestToLoadWorkspaceForUSS(String destinationHFS, String resultFile) {
        this.fDestinationHFS = destinationHFS;
        this.fListOfOutArtifacts = resultFile;
        this.fUSSOnly = true;
    }

    @Override
    public void requestToLoadComponentWorkspaceForUSS(String componentSelector, String destinationHFS, String resultFile) {
        this.componentSelector = componentSelector;
        this.fDestinationHFS = destinationHFS;
        this.fListOfOutArtifacts = resultFile;
        this.fUSSOnly = true;
    }
}

