/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.operations;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.teamz.build.ant.zos.utils.LogUtility;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadOperationDilemmaHandler
extends LoadDilemmaHandler {
    private static final Log LOG = LogFactory.getLog(LoadOperationDilemmaHandler.class);

    public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
        for (ICollision collision : collisions) {
            if (collision.getLocations().size() > 1) {
                return 2;
            }
            collision.setLoadLocation((ILoadLocation)collision.getLocations().iterator().next());
        }
        if (removedShares != null) {
            for (IRemovedShare removedShare : removedShares) {
                removedShare.isToBeDeleted(true);
            }
        }
        return 0;
    }

    public int deletedContent(Collection<IShareable> contentDeleted) {
        if (LOG.isTraceEnabled() && contentDeleted != null) {
            LogUtility.logTrace((Log)LOG, null, (String[])new String[]{"The content for these files could not be retrieved because it has been permanently deleted from the repository. A default content should be set in file(s):"});
            for (IShareable shareable : contentDeleted) {
                LogUtility.logTrace((Log)LOG, null, (String[])new String[]{shareable.getLocalPath().getName()});
            }
        }
        return 0;
    }
}

