/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.teamz.fileagent.FileAgentException;
import com.ibm.teamz.fileagent.FileAgentRepositoryException;
import com.ibm.teamz.fileagent.IConnection;
import com.ibm.teamz.fileagent.core.RepositoryUtility;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import com.ibm.teamz.fileagent.internal.operations.ZosFileSystemOperation;
import com.ibm.teamz.fileagent.operations.ILoadOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class LoadOperation
extends ZosFileSystemOperation
implements ILoadOperation {
    protected String fWorkspaceID;
    protected boolean bDeregister = false;

    public LoadOperation(IConnection connection, String workspaceID, String datasetPrefix) {
        super(connection, datasetPrefix);
        this.fWorkspaceID = workspaceID;
    }

    @Override
    public String getWorkspaceID() {
        return this.fWorkspaceID;
    }

    @Override
    public boolean isLoadOperationEqualTo(ILoadOperation compareTo) {
        return this.getConnection().equals(compareTo.getConnection()) && this.getWorkspaceID().equals(compareTo.getWorkspaceID()) && this.getDatasetPrefix().equals(compareTo.getDatasetPrefix());
    }

    @Override
    protected void validateOperationAttributes() throws FileAgentRepositoryException {
        if (this.fWorkspaceID == null || this.fWorkspaceID.length() == 0) {
            throw new FileAgentRepositoryException(Messages.OPERATION_WORKSPACE_REQUIRED);
        }
    }

    protected IWorkspace getWorkspace(ITeamRepository teamRepository) throws FileAgentRepositoryException {
        IWorkspace workspace = null;
        UUID workspaceUUID = null;
        String workspaceName = null;
        try {
            workspaceUUID = UUID.valueOf((String)this.fWorkspaceID);
        }
        catch (IllegalArgumentException exception) {
            workspaceName = this.fWorkspaceID;
        }
        if (workspaceUUID != null) {
            workspace = RepositoryUtility.getWorkspaceFromUUID(workspaceUUID, teamRepository);
            if (workspace == null) {
                throw new FileAgentRepositoryException(NLS.bind((String)Messages.OPERATION_COULD_NOT_FIND_WORKSPACE, (Object)workspaceUUID.toString()));
            }
        } else if (workspaceName != null) {
            workspace = RepositoryUtility.getWorkspaceFromName(workspaceName, teamRepository);
            if (workspace == null) {
                throw new FileAgentRepositoryException(NLS.bind((String)Messages.OPERATION_COULD_NOT_FIND_WORKSPACE, (Object)workspaceName));
            }
        } else {
            throw new FileAgentRepositoryException(Messages.OPERATION_WORKSPACE_REQUIRED);
        }
        return workspace;
    }

    @Override
    public void setToDeregister(boolean bDeregister) {
        this.bDeregister = bDeregister;
    }

    protected static IComponent getComponent(String compSelector, List<IComponent> components, ITeamRepository repo, IWorkspaceConnection wsConn, IProgressMonitor monitor) throws FileAgentException, FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        UUID uuid = null;
        try {
            uuid = UUID.valueOf((String)compSelector);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ArrayList<String> matchedComps = new ArrayList<String>();
        if (uuid != null) {
            for (IComponent comp : components) {
                if (!comp.getItemId().equals((Object)uuid)) continue;
                matchedComps.add(comp.getItemId().getUuidValue());
            }
        }
        for (IComponent comp : components) {
            if (!comp.getName().equals(compSelector) || matchedComps.contains(comp.getItemId().getUuidValue())) continue;
            matchedComps.add(comp.getItemId().getUuidValue());
        }
        if (matchedComps.size() == 0) {
            throw new FileAgentException(NLS.bind((String)Messages.AbstractLoadItemOperation_0, (Object)compSelector, (Object)wsConn.getName()));
        }
        if (matchedComps.size() > 1) {
            throw new FileAgentException(NLS.bind((String)Messages.AbstractLoadItemOperation_2, (Object)compSelector, (Object)wsConn.getName()));
        }
        IComponent component = (IComponent)LoadOperation.getItem(IComponent.ITEM_TYPE, UUID.valueOf((String)((String)matchedComps.get(0))), repo, (IProgressMonitor)progress);
        return component;
    }

    private static IItem getItem(IItemType itemType, UUID itemId, ITeamRepository repo, IProgressMonitor monitor) throws FileSystemException {
        return LoadOperation.getItem(itemType, itemId, repo, 0, monitor);
    }

    private static IItem getItem(IItemType itemType, UUID itemId, ITeamRepository repo, int flags, IProgressMonitor monitor) throws FileSystemException {
        IItem item;
        int totalWork = 1;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)totalWork);
        IItemHandle itemHandle = itemType.createItemHandle(itemId, null);
        try {
            item = repo.itemManager().fetchCompleteItem(itemHandle, flags, (IProgressMonitor)progress.newChild(totalWork));
            if (!item.getItemType().equals(itemType)) {
                throw new FileSystemException(NLS.bind((String)Messages.AbstractLoadItemOperation_3, (Object[])new Object[]{itemId.getUuidValue(), itemType.getName(), item.getItemType().getName()}));
            }
        }
        catch (TeamRepositoryException e) {
            throw new FileSystemException(NLS.bind((String)Messages.AbstractLoadItemOperation_4, (Object)itemType.getName(), (Object)itemId.getUuidValue()), (Throwable)e);
        }
        return item;
    }

    protected static List<IComponent> getPartialComponentsInWorkspace(Collection<String> properties, ITeamRepository repo, IWorkspaceConnection wsConn, SubMonitor subMonitor) throws FileSystemException {
        int totalWork = 2;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)subMonitor, (int)totalWork);
        List componentHandles = null;
        try {
            wsConn.refresh((IProgressMonitor)progress.newChild(totalWork / 2));
            componentHandles = wsConn.getComponents();
        }
        catch (TeamRepositoryException e) {
            throw new FileSystemException(NLS.bind((String)Messages.AbstractLoadItemOperation_6, (Object)wsConn.getName()), (Throwable)e);
        }
        return LoadOperation.getPartialItems(IComponent.ITEM_TYPE, componentHandles, properties, repo, progress.newChild(totalWork / 2));
    }

    private static List<? extends IItem> getPartialItems(IItemType itemType, List<? extends IItemHandle> itemHandles, Collection<String> properties, ITeamRepository repo, SubMonitor subMonitor) throws FileSystemException {
        List items;
        int totalWork = 1;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)subMonitor, (int)totalWork);
        try {
            items = repo.itemManager().fetchPartialItems(itemHandles, 1, properties, (IProgressMonitor)progress.newChild(totalWork));
            for (IItem item : items) {
                if (item.getItemType().equals(itemType)) continue;
                throw new FileSystemException(NLS.bind((String)Messages.AbstractLoadItemOperation_3, (Object[])new Object[]{item.getItemId().getUuidValue(), itemType.getName(), item.getItemType().getName()}));
            }
        }
        catch (TeamRepositoryException e) {
            throw new FileSystemException(NLS.bind((String)Messages.AbstractLoadItemOperation_5, (Object)itemType.getName()), (Throwable)e);
        }
        return items;
    }
}

