/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.operations;

import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.agent.AgentMapping;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.agent.MappingException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.teamz.build.ant.zos.exceptions.JzosException;
import com.ibm.teamz.build.ant.zos.utils.JzosUtility;
import com.ibm.teamz.build.ant.zos.utils.LogUtility;
import com.ibm.teamz.fileagent.FileAgentException;
import com.ibm.teamz.fileagent.FileAgentRepositoryException;
import com.ibm.teamz.fileagent.IConnection;
import com.ibm.teamz.fileagent.internal.jazzscm.FileAgentAllocateDataSetException;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import com.ibm.teamz.fileagent.internal.operations.ZosFileSystemOperation;
import com.ibm.teamz.fileagent.operations.IAllocateDataSetOperation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class AllocateDataSetOperation
extends ZosFileSystemOperation
implements IAllocateDataSetOperation {
    private static final Log LOG = LogFactory.getLog(AllocateDataSetOperation.class);
    private Set<String> dataSetDefinitionIDs = null;
    private Set<String> dataSetDefinitionStateIDs = null;
    private ISystemDefinitionModelClient dsDefinitionClient = null;

    public AllocateDataSetOperation(IConnection connection, String datasetPrefix) {
        super(connection, datasetPrefix);
        this.initialize();
    }

    private void initialize() {
        this.resetAllRequestsToAllocateDataSet();
    }

    @Override
    public void resetAllRequestsToAllocateDataSet() {
        this.dataSetDefinitionIDs = new HashSet<String>();
        this.dataSetDefinitionStateIDs = new HashSet<String>();
    }

    public void requestToAllocateDataSet(String dataSetDefinitionID) {
        this.requestToAllocateDataSet(dataSetDefinitionID, null);
    }

    @Override
    public void requestToAllocateDataSet(String dataSetDefinitionID, String dataSetDefinitionStateID) {
        this.dataSetDefinitionIDs.add(dataSetDefinitionID);
        this.dataSetDefinitionStateIDs.add(dataSetDefinitionStateID);
    }

    @Override
    public void requestToAllocateDataSets(List<String> dataSetDefinitionIDs, List<String> dataSetDefinitionStateIDs) {
        this.dataSetDefinitionIDs.addAll(dataSetDefinitionIDs);
        this.dataSetDefinitionStateIDs.addAll(dataSetDefinitionStateIDs);
    }

    @Override
    public Set<String> getSetOfAllRequests() {
        return this.dataSetDefinitionIDs;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileAgentException, FileAgentRepositoryException {
        if (this.fDatasetPrefix == null || this.fDatasetPrefix.trim().length() == 0) {
            this.fDatasetPrefix = "";
        }
        this.dsDefinitionClient = (ISystemDefinitionModelClient)this.fConnection.getLoggedTeamrepository().getClientLibrary(ISystemDefinitionModelClient.class);
        for (String dataSetDefinitionID : this.dataSetDefinitionIDs) {
            String dataSetDefinitionStateID = this.dataSetDefinitionStateIDs.iterator().next();
            this.allocateDataSet(dataSetDefinitionID, dataSetDefinitionStateID, monitor);
        }
    }

    private void allocateDataSet(String dataSetDefinitionID, String dataSetDefinitionStateID, IProgressMonitor monitor) throws FileAgentAllocateDataSetException {
        IDataSetDefinition datasetDefinition;
        try {
            datasetDefinition = dataSetDefinitionStateID == null || dataSetDefinitionStateID.trim().length() == 0 ? (IDataSetDefinition)this.dsDefinitionClient.findSystemDefinition(dataSetDefinitionID, null, IResourceDefinition.ITEM_TYPE, monitor) : (IDataSetDefinition)this.dsDefinitionClient.findSystemDefinition(dataSetDefinitionID, dataSetDefinitionStateID, IResourceDefinition.ITEM_TYPE, monitor);
        }
        catch (TeamRepositoryException e1) {
            throw new FileAgentAllocateDataSetException(e1);
        }
        if (datasetDefinition.getUsageType() != 1 && datasetDefinition.getUsageType() != 0) {
            String message = NLS.bind((String)Messages.INVALID_DATA_DEFINITION_FOR_CREATE_DATASET, (Object)dataSetDefinitionID, (Object)datasetDefinition.getUsageType());
            LogUtility.logError((Log)LOG, null, (String[])new String[]{message});
            throw new FileAgentAllocateDataSetException(message);
        }
        try {
            this.internalAllocateDataSet(datasetDefinition);
        }
        catch (FileAgentAllocateDataSetException e) {
            LogUtility.logError((Log)LOG, (Exception)e, (String[])new String[]{NLS.bind((String)Messages.UNABLE_TO_ALLOCATE_PDS, (Object)(String.valueOf(this.fDatasetPrefix) + "." + datasetDefinition.getDsName()))});
            throw e;
        }
    }

    private void internalAllocateDataSet(IDataSetDefinition datasetDefinition) throws FileAgentAllocateDataSetException {
        boolean exists;
        String prefixToPrepend = this.fDatasetPrefix;
        if (datasetDefinition.getUsageType() == 1 && !datasetDefinition.isPrefixDSN()) {
            prefixToPrepend = "";
        }
        try {
            exists = JzosUtility.dataSetAlreadyExists((String)datasetDefinition.getDsName(), (String)prefixToPrepend);
        }
        catch (JzosException e) {
            throw new FileAgentAllocateDataSetException(e);
        }
        if (!exists) {
            String cmd = null;
            AgentMapping mapping = new AgentMapping();
            try {
                cmd = mapping.pdsMapping(datasetDefinition, prefixToPrepend);
            }
            catch (MappingException e) {
                LogUtility.logTrace((Log)LOG, (Exception)((Object)e), (String[])new String[]{"-- Allocation not done, MappingException on: " + cmd});
                throw new FileAgentAllocateDataSetException(e);
            }
            catch (Exception e) {
                LogUtility.logTrace((Log)LOG, (Exception)e, (String[])new String[]{"-- Allocation not done, Exception on: " + cmd});
                throw new FileAgentAllocateDataSetException(e);
            }
            LogUtility.logTrace((Log)LOG, null, (String[])new String[]{"Allocation command on: " + cmd});
            try {
                JzosUtility.executeCommand((String)cmd, null);
            }
            catch (JzosException e) {
                throw new FileAgentAllocateDataSetException(e);
            }
            try {
                cmd = mapping.pdsFree();
            }
            catch (MappingException e) {
                LogUtility.logTrace((Log)LOG, (Exception)((Object)e), (String[])new String[]{"-- Free allocated resource, MappingException on: " + cmd});
                throw new FileAgentAllocateDataSetException(e);
            }
            try {
                JzosUtility.executeCommand((String)cmd, null);
            }
            catch (JzosException e) {
                throw new FileAgentAllocateDataSetException(e);
            }
        }
        LogUtility.logTrace((Log)LOG, null, (String[])new String[]{"<<allocPDS=="});
    }

    @Override
    protected void validateOperationAttributes() throws FileAgentRepositoryException {
    }
}

