/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.operations;

import com.ibm.team.enterprise.scmee.zos.DataSetLocation;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.teamz.build.ant.zos.utils.LogUtility;
import com.ibm.teamz.fileagent.FileAgentException;
import com.ibm.teamz.fileagent.FileAgentRepositoryException;
import com.ibm.teamz.fileagent.IConnection;
import com.ibm.teamz.fileagent.internal.jazzscm.ZItem;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import com.ibm.teamz.fileagent.internal.operations.LoadOperation;
import com.ibm.teamz.fileagent.internal.operations.LoadOperationDilemmaHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractLoadItemOperation
extends LoadOperation {
    private static final Log LOG = LogFactory.getLog(AbstractLoadItemOperation.class);
    protected List<ZItem> fZItemList = new ArrayList<ZItem>();

    public AbstractLoadItemOperation(IConnection connection, String workspaceID, String datasetPrefix) {
        super(connection, workspaceID, datasetPrefix);
    }

    protected abstract String getMessage(String var1);

    @Override
    protected void execute(IProgressMonitor monitor) throws FileAgentException, FileAgentRepositoryException {
        LogUtility.logDebug((Log)LOG, null, (String[])new String[]{"in AbstractLoadItemOperation.execute"});
        if (!this.fZItemList.isEmpty()) {
            IWorkspace workspace = this.getWorkspace(this.fConnection.getLoggedTeamrepository());
            try {
                LogUtility.logDebug((Log)LOG, null, (String[])new String[]{"in AbstractLoadItemOperation.execute updating zOS with zItems"});
                this.loadOnMvsZItems(this.fConnection.getLoggedTeamrepository(), (IWorkspaceHandle)workspace, this.fDatasetPrefix, this.fZItemList, monitor);
            }
            catch (FileAgentRepositoryException e) {
                String message = this.getMessage(workspace.getName());
                LogUtility.logError((Log)LOG, null, (String[])new String[]{message});
                throw e;
            }
            catch (FileAgentException e) {
                String message = this.getMessage(workspace.getName());
                LogUtility.logError((Log)LOG, null, (String[])new String[]{message});
                throw e;
            }
            catch (TeamRepositoryException e) {
                String message = this.getMessage(workspace.getName());
                LogUtility.logError((Log)LOG, null, (String[])new String[]{message});
                throw new FileAgentRepositoryException(e);
            }
        }
    }

    protected void loadOnMvsZItems(ITeamRepository repository, IWorkspaceHandle workspaceHandle, String prefix, List<ZItem> zItems, IProgressMonitor monitor) throws FileAgentException, TeamRepositoryException {
        int monitorSize = 100 + 2 * zItems.size();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)monitorSize);
        HashMap<String, ArrayList<ZItem>> zItemsByComponentSelector = new HashMap<String, ArrayList<ZItem>>();
        List zItemsTmp = null;
        String compSelector = null;
        for (ZItem each : zItems) {
            compSelector = each.getComponentName();
            if (each.getComponentUUID() != null && each.getComponentUUID().length() > 0) {
                compSelector = each.getComponentUUID();
            }
            if (compSelector == null || compSelector.length() == 0) {
                throw new IllegalArgumentException(Messages.AbstractLoadItemOperation_1);
            }
            zItemsTmp = (ArrayList<ZItem>)zItemsByComponentSelector.get(compSelector);
            if (zItemsTmp == null) {
                zItemsTmp = new ArrayList<ZItem>();
                zItemsByComponentSelector.put(compSelector, (ArrayList<ZItem>)zItemsTmp);
            }
            zItemsTmp.add(each);
        }
        IWorkspaceConnection wsConn = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).getWorkspaceConnection(workspaceHandle, (IProgressMonitor)progress.newChild(1));
        HashMap zItemsByComponent = new HashMap();
        ArrayList<String> properties = new ArrayList<String>();
        properties.add(IComponent.NAME_PROPERTY);
        properties.add(IComponent.ITEM_ID_PROPERTY);
        List<IComponent> components = AbstractLoadItemOperation.getPartialComponentsInWorkspace(properties, repository, wsConn, progress.newChild(20));
        for (String compSel : zItemsByComponentSelector.keySet()) {
            IComponent component = AbstractLoadItemOperation.getComponent(compSel, components, repository, wsConn, (IProgressMonitor)progress.newChild(1));
            if (component != null) {
                zItemsTmp = (List)zItemsByComponentSelector.get(compSel);
                if (zItemsByComponent.containsKey(component)) {
                    zItemsTmp.addAll((Collection)zItemsByComponent.get(component));
                }
                zItemsByComponent.put(component, zItemsTmp);
                continue;
            }
            throw new FileAgentException(NLS.bind((String)Messages.AbstractLoadItemOperation_0, (Object)compSel, (Object)wsConn.getName()));
        }
        ISandbox mvsSandbox = FileSystemCore.getSharingManager().getSandbox((ILocation)new DataSetLocation(prefix), false);
        try {
            ILoadOperation loadOp = IOperationFactory.instance.getLoadOperation((LoadDilemmaHandler)new LoadOperationDilemmaHandler());
            for (Map.Entry entry : zItemsByComponent.entrySet()) {
                IComponent component = (IComponent)entry.getKey();
                List zItemsToLoad = (List)entry.getValue();
                IConfiguration config = wsConn.configuration((IComponentHandle)component);
                ArrayList<IVersionableHandle> versionablesToLoad = new ArrayList<IVersionableHandle>(zItemsToLoad.size());
                for (ZItem item : zItemsToLoad) {
                    String[] path = item.getArrayPath();
                    IVersionableHandle remoteItem = config.resolvePath(component.getRootFolder(), path, (IProgressMonitor)progress.newChild(1));
                    versionablesToLoad.add(remoteItem);
                }
                loadOp.requestLoad(mvsSandbox, null, wsConn, (IComponentHandle)component, versionablesToLoad);
            }
            loadOp.run((IProgressMonitor)progress.newChild(77));
        }
        finally {
            if (this.bDeregister) {
                FileSystemCore.getSharingManager().deregister(mvsSandbox, (IProgressMonitor)progress.newChild(1));
            }
        }
    }
}

