/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.macrooperations;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.teamz.build.ant.zos.utils.LogUtility;
import com.ibm.teamz.fileagent.FileAgentException;
import com.ibm.teamz.fileagent.FileAgentRepositoryException;
import com.ibm.teamz.fileagent.IConnection;
import com.ibm.teamz.fileagent.internal.macrooperations.Operation;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import com.ibm.teamz.fileagent.macrooperations.IMacroOperation;
import com.ibm.teamz.fileagent.operations.IAllocateDataSetOperation;
import com.ibm.teamz.fileagent.operations.ILoadFileOperation;
import com.ibm.teamz.fileagent.operations.ILoadFolderOperation;
import com.ibm.teamz.fileagent.operations.ILoadWorkspaceOperation;
import com.ibm.teamz.fileagent.operations.OperationFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class MacroOperation
extends Operation
implements IMacroOperation {
    private static final Log LOG = LogFactory.getLog(MacroOperation.class);
    private ITeamRepository repository;
    private IConnection fConnection;
    private boolean bDeregister;
    private List<ILoadWorkspaceOperation> fLoadWorkspaceOpList;
    private Set<ILoadFolderOperation> fLoadFolderOpSet;
    private Set<ILoadFileOperation> fLoadFileOpSet;
    private List<IAllocateDataSetOperation> fAllocateDataSetOpList;

    public MacroOperation(IConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.ILLEGAL_ARG, (Object)"null", (Object)"ConnectionInfo"));
        }
        this.fConnection = connection;
        this.initialize();
    }

    @Override
    public IConnection getConnection() {
        return this.fConnection;
    }

    private void initialize() {
        this.fLoadWorkspaceOpList = new ArrayList<ILoadWorkspaceOperation>();
        this.fLoadFolderOpSet = new HashSet<ILoadFolderOperation>();
        this.fLoadFileOpSet = new HashSet<ILoadFileOperation>();
        this.fAllocateDataSetOpList = new ArrayList<IAllocateDataSetOperation>();
        this.bDeregister = false;
    }

    @Override
    public void requestToLoadWorkspace(String workspaceID, String datasetPrefix, String destinationHFS, String resultFile) {
        ILoadWorkspaceOperation operation = OperationFactory.getLoadWorkspaceOperation(this.fConnection, workspaceID, datasetPrefix);
        this.fLoadWorkspaceOpList.add(operation);
        operation.requestToLoadWorkspace(destinationHFS, resultFile);
    }

    @Override
    public void requestToLoadComponentWorkspace(String workspaceID, String componentSelector, String datasetPrefix, String destinationHFS, String resultFile) {
        ILoadWorkspaceOperation operation = OperationFactory.getLoadWorkspaceOperation(this.fConnection, workspaceID, datasetPrefix);
        this.fLoadWorkspaceOpList.add(operation);
        operation.requestToLoadComponentWorkspace(componentSelector, destinationHFS, resultFile);
    }

    @Override
    public void requestToLoadWorkspaceForUSS(String workspaceID, String datasetPrefix, String destinationHFS, String resultFile) {
        ILoadWorkspaceOperation operation = OperationFactory.getLoadWorkspaceOperation(this.fConnection, workspaceID, datasetPrefix);
        this.fLoadWorkspaceOpList.add(operation);
        operation.requestToLoadWorkspaceForUSS(destinationHFS, resultFile);
    }

    @Override
    public void requestToLoadComponentWorkspaceForUSS(String workspaceID, String componentSelector, String datasetPrefix, String destinationHFS, String resultFile) {
        ILoadWorkspaceOperation operation = OperationFactory.getLoadWorkspaceOperation(this.fConnection, workspaceID, datasetPrefix);
        this.fLoadWorkspaceOpList.add(operation);
        operation.requestToLoadComponentWorkspaceForUSS(componentSelector, destinationHFS, resultFile);
    }

    public void requestToLoadFolder(String workspaceID, String datasetPrefix, String componentName, String folderPath, String dataSetDefinitionID) {
        this.requestToLoadFolder(workspaceID, datasetPrefix, componentName, folderPath, dataSetDefinitionID, null);
    }

    @Override
    public void requestToLoadFolder(String workspaceID, String datasetPrefix, String componentName, String folderPath, String dataSetDefinitionID, String dataSetDefinitionStateID) {
        this.requestToLoadFolder(workspaceID, datasetPrefix, null, componentName, folderPath, dataSetDefinitionID, null);
    }

    @Override
    public void requestToLoadFolder(String workspaceID, String datasetPrefix, String componentUUID, String componentName, String folderPath, String dataSetDefinitionUUID, String dataSetDefinitionStateUUID) {
        ILoadFolderOperation currentOp = OperationFactory.getLoadFolderOperation(this.fConnection, workspaceID, datasetPrefix);
        for (ILoadFolderOperation op : this.fLoadFolderOpSet) {
            if (!op.isLoadOperationEqualTo(currentOp)) continue;
            currentOp = op;
            break;
        }
        this.fLoadFolderOpSet.add(currentOp);
        currentOp.requestToLoadFolder(componentUUID, componentName, folderPath, dataSetDefinitionUUID, dataSetDefinitionStateUUID);
    }

    public void requestToLoadFile(String workspaceID, String datasetPrefix, String componentName, String filePath, String dataSetDefinitionID) {
        this.requestToLoadFile(workspaceID, datasetPrefix, componentName, filePath, dataSetDefinitionID, null);
    }

    @Override
    public void requestToLoadFile(String workspaceID, String datasetPrefix, String componentName, String filePath, String dataSetDefinitionID, String dataSetDefinitionStateID) {
        this.requestToLoadFile(workspaceID, datasetPrefix, null, componentName, filePath, dataSetDefinitionID, null);
    }

    @Override
    public void requestToLoadFile(String workspaceID, String datasetPrefix, String componentUUID, String componentName, String filePath, String dataSetDefinitionUUID, String dataSetDefinitionStateUUID) {
        ILoadFileOperation currentOp = OperationFactory.getLoadFileOperation(this.fConnection, workspaceID, datasetPrefix);
        for (ILoadFileOperation op : this.fLoadFileOpSet) {
            if (!op.isLoadOperationEqualTo(currentOp)) continue;
            currentOp = op;
            break;
        }
        this.fLoadFileOpSet.add(currentOp);
        currentOp.requestToLoadFile(componentUUID, componentName, filePath, dataSetDefinitionUUID, dataSetDefinitionStateUUID);
    }

    @Override
    public void requestToLoadFileInDataSetName(String workspaceID, String datasetPrefix, String componentName, String filePath, String dataSetName) {
        this.requestToLoadFileInDataSetName(workspaceID, datasetPrefix, null, componentName, filePath, dataSetName);
    }

    @Override
    public void requestToLoadFileInDataSetName(String workspaceID, String datasetPrefix, String componentUUID, String componentName, String filePath, String dataSetName) {
        ILoadFileOperation currentOp = OperationFactory.getLoadFileOperation(this.fConnection, workspaceID, datasetPrefix);
        for (ILoadFileOperation op : this.fLoadFileOpSet) {
            if (!op.isLoadOperationEqualTo(currentOp)) continue;
            currentOp = op;
            break;
        }
        this.fLoadFileOpSet.add(currentOp);
        currentOp.requestToLoadFileInDataSetName(componentUUID, componentName, filePath, dataSetName);
    }

    @Override
    public void requestToAllocateDataSet(String datasetPrefix, String dataSetDefinitionID, String dataSetDefinitionStateID) {
        IAllocateDataSetOperation operation = OperationFactory.getAllocateDataSetOperation(this.fConnection, datasetPrefix);
        this.fAllocateDataSetOpList.add(operation);
        operation.requestToAllocateDataSet(dataSetDefinitionID, dataSetDefinitionStateID);
    }

    @Override
    public void requestToAllocateDataSets(String datasetPrefix, List<String> dataSetDefinitionIDs, List<String> dataSetDefinitionStateIDs) {
        IAllocateDataSetOperation operation = OperationFactory.getAllocateDataSetOperation(this.fConnection, datasetPrefix);
        this.fAllocateDataSetOpList.add(operation);
        operation.requestToAllocateDataSets(dataSetDefinitionIDs, dataSetDefinitionStateIDs);
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileAgentException, FileAgentRepositoryException {
        for (ILoadWorkspaceOperation iLoadWorkspaceOperation : this.fLoadWorkspaceOpList) {
            iLoadWorkspaceOperation.setToDeregister(this.bDeregister);
            iLoadWorkspaceOperation.run((IProgressMonitor)new NullProgressMonitor());
        }
        for (ILoadFolderOperation iLoadFolderOperation : this.fLoadFolderOpSet) {
            iLoadFolderOperation.setToDeregister(this.bDeregister);
            iLoadFolderOperation.run((IProgressMonitor)new NullProgressMonitor());
        }
        for (ILoadFileOperation iLoadFileOperation : this.fLoadFileOpSet) {
            LogUtility.logDebug((Log)LOG, null, (String[])new String[]{"in MacroOperation loadFile execute"});
            iLoadFileOperation.setToDeregister(this.bDeregister);
            iLoadFileOperation.run((IProgressMonitor)new NullProgressMonitor());
        }
        for (IAllocateDataSetOperation iAllocateDataSetOperation : this.fAllocateDataSetOpList) {
            iAllocateDataSetOperation.run((IProgressMonitor)new NullProgressMonitor());
        }
        this.initialize();
    }

    @Override
    public ITeamRepository getTeamRepository() {
        return this.repository;
    }

    @Override
    protected void validateOperationAttributes() throws FileAgentRepositoryException {
    }

    @Override
    public void setToDeregister(boolean bDeregister) {
        this.bDeregister = bDeregister;
    }
}

