/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.jazzscm;

import com.ibm.teamz.build.ant.zos.utils.LogUtility;
import com.ibm.teamz.fileagent.internal.jazzscm.ZItem;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.osgi.util.NLS;

public class ZFile
extends ZItem {
    private static final Log LOG = LogFactory.getLog(ZFile.class);
    private String fDataSetName;
    private String fZFileName;

    public ZFile(String componentName, String filePath, String dataSetDefinitionUUID, String dataSetDefinitionStateUUID, String dataSetDefinitionName) {
        this(null, componentName, filePath, dataSetDefinitionUUID, dataSetDefinitionStateUUID, dataSetDefinitionName);
    }

    public ZFile(String componentUUID, String componentName, String filePath, String dataSetDefinitionUUID, String dataSetDefinitionStateUUID, String dataSetDefinitionName) {
        super(componentUUID, componentName, filePath, dataSetDefinitionUUID, dataSetDefinitionStateUUID);
        this.fDataSetName = dataSetDefinitionName;
        if (!this.isValid()) {
            LogUtility.logError((Log)LOG, null, (String[])new String[]{NLS.bind((String)Messages.XML_ELEMENT_INVALID, (Object)"for loadFiles")});
            throw new IllegalArgumentException(NLS.bind((String)Messages.XML_ELEMENT_INVALID, (Object)"for loadFiles"));
        }
    }

    @Override
    protected boolean isValid() {
        if (super.isValid()) {
            this.initialize();
            return true;
        }
        return false;
    }

    @Override
    protected void initialize() {
        StringTokenizer tokenizer = new StringTokenizer(this.fPath, "/");
        int iToken = tokenizer.countTokens();
        if (iToken != 4) {
            LogUtility.logError((Log)LOG, null, (String[])new String[]{NLS.bind((String)Messages.XML_ATTRIBUTE_INVALID, (Object)"filePath")});
            throw new IllegalArgumentException(NLS.bind((String)Messages.XML_ATTRIBUTE_INVALID, (Object)"filePath"));
        }
        this.fZComponentProjectName = tokenizer.nextToken();
        tokenizer.nextToken();
        this.fZFolderName = tokenizer.nextToken();
        this.fZFileName = tokenizer.nextToken();
    }

    public String getDataSetName() {
        return this.fDataSetName;
    }

    public String getZFileName() {
        return this.fZFileName;
    }

    @Override
    public String getZFolderPath() {
        int i = this.getPath().lastIndexOf("/" + this.fZFileName);
        return this.getPath().substring(0, i);
    }

    public boolean parentDatasetMustExist() {
        return this.fDataSetName != null && this.fDataSetName.length() != 0;
    }
}

