/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.jazzscm;

import com.ibm.teamz.fileagent.internal.messages.Messages;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class StringUtil {
    private static final Map<Character, Character> PATH_ESCAPE_MAPPING = new HashMap<Character, Character>();

    static {
        PATH_ESCAPE_MAPPING.put(Character.valueOf('/'), Character.valueOf('/'));
    }

    public static String[] splitEscapedPath(String str) {
        List<String> segments = StringUtil.splitEscaped(str, PATH_ESCAPE_MAPPING, '/', '\\');
        Iterator<String> i = segments.iterator();
        while (i.hasNext()) {
            String segment = i.next();
            assert (segment != null);
            if (segment.length() != 0) continue;
            i.remove();
        }
        return segments.toArray(new String[0]);
    }

    private static List<String> splitEscaped(String str, Map<Character, Character> toEscape, char splitOn, char escapeChar) {
        LinkedList<String> toReturn = new LinkedList<String>();
        StringBuffer accumulator = new StringBuffer(str.length());
        boolean isEscaped = false;
        char[] cArray = str.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (isEscaped) {
                accumulator.append(c);
                isEscaped = false;
            } else if (c == escapeChar) {
                isEscaped = true;
                accumulator.append(c);
            } else if (c == splitOn) {
                toReturn.add(StringUtil.unescape(accumulator.toString(), toEscape, escapeChar));
                accumulator = new StringBuffer(str.length());
            } else {
                accumulator.append(c);
            }
            ++n2;
        }
        toReturn.add(accumulator.toString());
        return toReturn;
    }

    private static String unescape(String str, Map<Character, Character> toEscape, char escapeChar) {
        StringBuffer buf = new StringBuffer(str.length());
        HashMap<Character, Character> escaped = new HashMap<Character, Character>();
        for (Map.Entry<Character, Character> entry : toEscape.entrySet()) {
            if (escaped.containsKey(entry.getValue())) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.StringUtil_0, (Object)entry.getValue()));
            }
            escaped.put(entry.getValue(), entry.getKey());
        }
        boolean isEscaped = false;
        char[] cArray = str.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            Character item = Character.valueOf(c);
            if (isEscaped) {
                if (!escaped.containsKey(item)) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages.StringUtil_1, (Object)item));
                }
                buf.append(escaped.get(item));
                isEscaped = false;
            } else if (c == escapeChar) {
                isEscaped = true;
            } else {
                buf.append(c);
            }
            ++n2;
        }
        return buf.toString();
    }
}

