/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.importz;

import com.ibm.team.enterprise.common.common.AntzBuildNature;
import com.ibm.team.enterprise.common.common.RdzLocalNature;
import com.ibm.team.enterprise.common.common.ZComponentException;
import com.ibm.team.enterprise.common.common.ZComponentNature;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.content.AbstractVersionedContentManagerInputStreamProvider;
import com.ibm.team.scm.client.content.util.VersionedContentManagerByteArrayInputStreamPovider;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.teamz.client.ZComponentFactory;
import com.ibm.teamz.fileagent.importz.PDSMemberInfo;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class SCMOperationMgr {
    public static final int PROJECT = 1;
    public static final int ZFOLDER = 2;
    public static final int ZFILE = 3;
    private ITeamRepository repo = null;
    private IWorkspaceConnection workspace = null;
    private IComponentHandle component = null;
    private IConfiguration config;
    private IFolder zOSPrjFolder = null;
    private String zosPrjName;
    private final String zFolderName;

    public SCMOperationMgr(ITeamRepository repository, IWorkspaceConnection wks, IComponentHandle comp, String zosProjectName, String zFolder) throws TeamRepositoryException {
        this.repo = repository;
        this.workspace = wks;
        this.component = comp;
        this.zosPrjName = zosProjectName;
        this.zFolderName = zFolder;
        this.initializeContext();
    }

    public boolean projectexists() {
        return this.zOSPrjFolder != null;
    }

    private void initializeContext() throws TeamRepositoryException {
        IFolderHandle fldHandle;
        if (this.workspace != null && this.component != null) {
            this.config = this.workspace.configuration(this.component);
        }
        IFolder rootFld = null;
        if (this.config != null) {
            rootFld = this.workspace.configuration(this.component).completeRootFolder(null);
        }
        if (this.config != null && (fldHandle = (IFolderHandle)this.findChildEntry(this.config, (IFolderHandle)rootFld, this.zosPrjName)) != null) {
            this.zOSPrjFolder = (IFolder)this.config.fetchCompleteItem((IVersionableHandle)fldHandle, null);
        }
    }

    public void commitPDSMember(PDSMemberInfo mbr, ByteArrayOutputStream bos) throws TeamRepositoryException {
        String mbrName;
        IFileItem file;
        if (mbr != null && (file = this.retrieveMember(mbrName = mbr.getName(), this.zFolderName)) != null) {
            if (!file.isWorkingCopy()) {
                file = (IFileItem)file.getWorkingCopy();
            }
            byte[] bytes = null;
            bytes = bos.toByteArray();
            if (bytes != null) {
                VersionedContentManagerByteArrayInputStreamPovider inStream = new VersionedContentManagerByteArrayInputStreamPovider(bytes);
                IFileContent content = FileSystemCore.getContentManager((ITeamRepository)this.repo).storeContent("UTF-8", FileLineDelimiter.LINE_DELIMITER_NONE, (AbstractVersionedContentManagerInputStreamProvider)inStream, null, null);
                file.setContent(content);
                file.setFileTimestamp(new Date());
                IChangeSetHandle changeSet = this.getChangeSetHandle(this.workspace, this.component, (IVersionable)file);
                this.workspace.commit(changeSet, Collections.singletonList(this.workspace.configurationOpFactory().save((IVersionable)file)), null);
                this.workspace.closeChangeSets(Collections.singletonList(changeSet), null);
            }
        }
    }

    public void commitPDSMember(PDSMemberInfo mbr, ByteArrayOutputStream bos, String zFileName, UUID csUuid) throws TeamRepositoryException {
        IFileItem file;
        if (mbr != null && (file = this.retrieveMember(zFileName, this.zFolderName)) != null) {
            if (!file.isWorkingCopy()) {
                file = (IFileItem)file.getWorkingCopy();
            }
            byte[] bytes = null;
            bytes = bos.toByteArray();
            if (bytes != null) {
                VersionedContentManagerByteArrayInputStreamPovider inStream = new VersionedContentManagerByteArrayInputStreamPovider(bytes);
                IFileContent content = FileSystemCore.getContentManager((ITeamRepository)this.repo).storeContent("UTF-8", FileLineDelimiter.LINE_DELIMITER_NONE, (AbstractVersionedContentManagerInputStreamProvider)inStream, null, null);
                file.setContent(content);
                file.setFileTimestamp(new Date());
                file.setContentType("text/plain");
                IChangeSetHandle changeSet = null;
                if (csUuid == null) {
                    changeSet = this.getChangeSetHandle(this.workspace, this.component, (IVersionable)file);
                } else {
                    changeSet = this.findActiveChangeSet(this.workspace, this.component, csUuid);
                    if (changeSet == null) {
                        throw new TeamRepositoryException(NLS.bind((String)Messages.SCMOperationMgr_0, (Object)csUuid));
                    }
                }
                this.workspace.commit(changeSet, Collections.singletonList(this.workspace.configurationOpFactory().save((IVersionable)file)), null);
            }
        }
    }

    private IFileItem retrieveMember(String memberName, String folderName) throws TeamRepositoryException {
        IFileItem file = null;
        IFolder folder = this.retrieveFolder(folderName);
        if (folder != null && this.config != null) {
            IFileItemHandle fileHandle = (IFileItemHandle)this.findChildEntry(this.config, (IFolderHandle)folder, memberName);
            if (fileHandle != null) {
                file = (IFileItem)this.config.fetchCompleteItem((IVersionableHandle)fileHandle, null);
            } else {
                file = (IFileItem)IFileItem.ITEM_TYPE.createItem();
                file.setName(memberName);
                file.setParent((IFolderHandle)folder);
            }
        }
        return file;
    }

    private IFolder retrieveFolder(String folderName) throws TeamRepositoryException {
        IFolderHandle fldSrcHandle = null;
        IFolderHandle fldHandle = null;
        IFolder fld = null;
        if (this.config != null && (fldSrcHandle = (IFolderHandle)this.findChildEntry(this.config, (IFolderHandle)this.zOSPrjFolder, "zOSsrc")) != null && (fldHandle = (IFolderHandle)this.findChildEntry(this.config, fldSrcHandle, folderName)) != null) {
            fld = (IFolder)this.config.fetchCompleteItem((IVersionableHandle)fldHandle, null);
        }
        return fld;
    }

    private IVersionableHandle findChildEntry(IConfiguration config, IFolderHandle folder, String name) throws TeamRepositoryException {
        return (IVersionableHandle)config.childEntries(folder, null).get(name);
    }

    private IChangeSetHandle getChangeSetHandle(IWorkspaceConnection workspace, IComponentHandle component, IVersionable versionable) throws TeamRepositoryException {
        IChangeSetHandle changeSet2;
        List changesetHandles = workspace.activeChangeSets(component);
        List changeSets = this.repo.itemManager().fetchCompleteItems(changesetHandles, 0, null);
        for (IChangeSetHandle changeSet2 : changeSets) {
            for (IChange change : changeSet2.changes()) {
                IVersionableHandle item = change.item();
                if (!versionable.sameItemId((IItemHandle)item)) continue;
                return changeSet2;
            }
        }
        changeSet2 = workspace.getCurrentChangeSet(component);
        if (changeSet2 == null) {
            changeSet2 = workspace.createChangeSet(component, "", true, null);
        }
        return changeSet2;
    }

    private IChangeSetHandle findActiveChangeSet(IWorkspaceConnection wsConn, IComponentHandle comp, UUID csUuid) {
        List candidates = wsConn.activeChangeSets(comp);
        for (IChangeSetHandle csHandle : candidates) {
            if (!csUuid.equals((Object)csHandle.getItemId())) continue;
            return csHandle;
        }
        return null;
    }

    private IFolder createFolder(IFolder parent, String name) {
        IFolder folder = (IFolder)IFolder.ITEM_TYPE.createItem();
        folder.setParent((IFolderHandle)parent);
        folder.setName(name);
        return folder;
    }

    private static IFileItem createXmlFile(ITeamRepository fTeamRepository, IFolder parent, String filename) throws TeamRepositoryException {
        byte[] bytes;
        try {
            bytes = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project name=\"SAMPLE\" default=\"all\" xmlns:antz=\"antlib:com.ibm.team.enterprise.zos.build.ant\" \n\txmlns:rsel=\"antlib:org.apache.tools.ant.types.resources.selectors\">\n\t<description>EWM EE sample build</description>\n\n\t<taskdef name=\"startBuildActivity\"\n\t\t classname=\"com.ibm.team.build.ant.task.StartBuildActivityTask\" />\n\t<taskdef name=\"artifactFilePublisher\"\n\t\t classname=\"com.ibm.team.build.ant.task.ArtifactFilePublisherTask\" />\n\n\t<import file=\"${team.enterprise.scm.fetchDestination}/macrodefs.xml\"/>\n\n\t<!-- Compile all source files with data set names that -->\t<!-- do not end with 'LINK'. The sample script assumes -->\t<!-- data sets that ends in 'LINK' are link-edit input -->\t<!-- files.                                            -->\t<target name=\"compile\" description=\"Compile\">\n\t\t<startBuildActivity label=\"Compile\"\n\t\t\tautoComplete=\"true\"\n\t\t\tbuildResultUUID=\"${buildResultUUID}\"\n\t\t\trepositoryAddress=\"${repositoryAddress}\"\n\t\t\tuserId=\"${userId}\"\n\t\t\tpasswordFile=\"${passwordFile}\"/>\n\t\t<antz:compile buildResultUUID=\"${buildResultUUID}\"\n\t\t\trepositoryAddress=\"${repositoryAddress}\"\n\t\t\tuserId=\"${userId}\"\n\t\t\tpasswordFile=\"${passwordFile}\">\n\t\t\t<restrict>\n\t\t\t\t<antz:buildableset buildableList=\"${team.enterprise.scm.fetchDestination}/buildableFiles.xml\"/>\n\t\t\t\t<rsel:not>\n\t\t\t\t\t<rsel:name name=\"*LINK(*)\"/>\n\t\t\t\t</rsel:not>\n\t\t\t</restrict>\n\t\t</antz:compile>\n\t</target>\n\t   \n\t<!-- Link-Edit -->\n\t<target name=\"linkedit\" description=\"Link-Edit\">\n\t\t<startBuildActivity label=\"Link-Edit\"\n\t\t\tautoComplete=\"true\"\n\t\t\tbuildResultUUID=\"${buildResultUUID}\"\n\t\t\trepositoryAddress=\"${repositoryAddress}\"\n\t\t\tuserId=\"${userId}\"\n\t\t\tpasswordFile=\"${passwordFile}\"/>\n\t\t<antz:compile buildResultUUID=\"${buildResultUUID}\"\n\t\t\trepositoryAddress=\"${repositoryAddress}\"\n\t\t\tuserId=\"${userId}\"\n\t\t\tpasswordFile=\"${passwordFile}\">\n\t\t\t<restrict>\n\t\t\t\t<antz:buildableset buildableList=\"${team.enterprise.scm.fetchDestination}/buildableFiles.xml\"/>\n\t\t\t\t<rsel:name name=\"*LINK(*)\"/>\n\t\t\t</restrict>\n\t\t</antz:compile>\n\t</target>\n\t\n\t<!-- Build -->\n\t<target name=\"all\" depends=\"compile,linkedit\" description=\"Build\"/>\n\t\n</project>\n".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            bytes = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project name=\"SAMPLE\" default=\"all\" xmlns:antz=\"antlib:com.ibm.team.enterprise.zos.build.ant\" \n\txmlns:rsel=\"antlib:org.apache.tools.ant.types.resources.selectors\">\n\t<description>EWM EE sample build</description>\n\n\t<taskdef name=\"startBuildActivity\"\n\t\t classname=\"com.ibm.team.build.ant.task.StartBuildActivityTask\" />\n\t<taskdef name=\"artifactFilePublisher\"\n\t\t classname=\"com.ibm.team.build.ant.task.ArtifactFilePublisherTask\" />\n\n\t<import file=\"${team.enterprise.scm.fetchDestination}/macrodefs.xml\"/>\n\n\t<!-- Compile all source files with data set names that -->\t<!-- do not end with 'LINK'. The sample script assumes -->\t<!-- data sets that ends in 'LINK' are link-edit input -->\t<!-- files.                                            -->\t<target name=\"compile\" description=\"Compile\">\n\t\t<startBuildActivity label=\"Compile\"\n\t\t\tautoComplete=\"true\"\n\t\t\tbuildResultUUID=\"${buildResultUUID}\"\n\t\t\trepositoryAddress=\"${repositoryAddress}\"\n\t\t\tuserId=\"${userId}\"\n\t\t\tpasswordFile=\"${passwordFile}\"/>\n\t\t<antz:compile buildResultUUID=\"${buildResultUUID}\"\n\t\t\trepositoryAddress=\"${repositoryAddress}\"\n\t\t\tuserId=\"${userId}\"\n\t\t\tpasswordFile=\"${passwordFile}\">\n\t\t\t<restrict>\n\t\t\t\t<antz:buildableset buildableList=\"${team.enterprise.scm.fetchDestination}/buildableFiles.xml\"/>\n\t\t\t\t<rsel:not>\n\t\t\t\t\t<rsel:name name=\"*LINK(*)\"/>\n\t\t\t\t</rsel:not>\n\t\t\t</restrict>\n\t\t</antz:compile>\n\t</target>\n\t   \n\t<!-- Link-Edit -->\n\t<target name=\"linkedit\" description=\"Link-Edit\">\n\t\t<startBuildActivity label=\"Link-Edit\"\n\t\t\tautoComplete=\"true\"\n\t\t\tbuildResultUUID=\"${buildResultUUID}\"\n\t\t\trepositoryAddress=\"${repositoryAddress}\"\n\t\t\tuserId=\"${userId}\"\n\t\t\tpasswordFile=\"${passwordFile}\"/>\n\t\t<antz:compile buildResultUUID=\"${buildResultUUID}\"\n\t\t\trepositoryAddress=\"${repositoryAddress}\"\n\t\t\tuserId=\"${userId}\"\n\t\t\tpasswordFile=\"${passwordFile}\">\n\t\t\t<restrict>\n\t\t\t\t<antz:buildableset buildableList=\"${team.enterprise.scm.fetchDestination}/buildableFiles.xml\"/>\n\t\t\t\t<rsel:name name=\"*LINK(*)\"/>\n\t\t\t</restrict>\n\t\t</antz:compile>\n\t</target>\n\t\n\t<!-- Build -->\n\t<target name=\"all\" depends=\"compile,linkedit\" description=\"Build\"/>\n\t\n</project>\n".getBytes();
        }
        VersionedContentManagerByteArrayInputStreamPovider inStream = new VersionedContentManagerByteArrayInputStreamPovider(bytes);
        IFileContent fileContent = FileSystemCore.getContentManager((ITeamRepository)fTeamRepository).storeContent("UTF-8", FileLineDelimiter.LINE_DELIMITER_NONE, (AbstractVersionedContentManagerInputStreamProvider)inStream, null, null);
        IFileItem file = (IFileItem)IFileItem.ITEM_TYPE.createItem();
        file.setName(filename);
        file.setParent((IFolderHandle)parent);
        file.setContent(fileContent);
        file.setFileTimestamp(new Date());
        file.setContentType("application/xml");
        return file;
    }

    private IFileItem createXMLProjectFile(String projectName, List<String> natures, String filename, IFolder parent) throws TeamRepositoryException {
        byte[] bytes;
        try {
            bytes = this.getProjectXMLContents(projectName, natures).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            bytes = this.getProjectXMLContents(projectName, natures).getBytes();
        }
        VersionedContentManagerByteArrayInputStreamPovider inStream = new VersionedContentManagerByteArrayInputStreamPovider(bytes);
        IFileContent fileContent = FileSystemCore.getContentManager((ITeamRepository)this.repo).storeContent("UTF-8", FileLineDelimiter.LINE_DELIMITER_NONE, (AbstractVersionedContentManagerInputStreamProvider)inStream, null, null);
        IFileItem file = (IFileItem)IFileItem.ITEM_TYPE.createItem();
        file.setName(filename);
        file.setParent((IFolderHandle)parent);
        file.setContent(fileContent);
        file.setFileTimestamp(new Date());
        file.setContentType("application/xml");
        return file;
    }

    private String getProjectXMLContents(String projectName, List<String> natures) {
        StringBuffer blockNature = new StringBuffer();
        blockNature.append("\t<natures>\n");
        for (String n : natures) {
            blockNature.append("\t\t<nature>");
            blockNature.append(n);
            blockNature.append("</nature>\n");
        }
        blockNature.append("\t</natures>\n");
        String contents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>" + projectName + "</name>\n" + "\t<comment></comment>\n" + "\t<projects>\n" + "\t</projects>\n" + "\t<buildSpec>\n" + "\t</buildSpec>\n" + blockNature.toString() + "</projectDescription>\n";
        return contents;
    }

    public ArrayList<IWorkspaceConnection.ISaveOp> createZComponentProject(String projectName, List<String> natures, IProgressMonitor progressMonitor) throws ZComponentException, TeamRepositoryException {
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        if (natures == null) {
            natures = new ArrayList<String>();
        }
        if (natures.isEmpty()) {
            natures.add(AntzBuildNature.ID);
        }
        natures.add(ZComponentNature.ID);
        natures.add(RdzLocalNature.ID);
        ZComponentFactory.validateName((String)projectName, (int)1);
        this.zosPrjName = projectName;
        IConfiguration config = this.workspace.configuration(this.component);
        IFolder rootFolder = (IFolder)config.completeRootFolder(null).getWorkingCopy();
        IFolder zprojectFolder = this.createFolder(rootFolder, projectName);
        IFolder zOsFolder = this.createFolder(zprojectFolder, "zOSsrc");
        IFileItem projectFile = this.createXMLProjectFile(this.zosPrjName, natures, ".project", zprojectFolder);
        IFileItem xmlFile = SCMOperationMgr.createXmlFile(this.repo, zprojectFolder, "build.xml");
        ArrayList<IWorkspaceConnection.ISaveOp> col = new ArrayList<IWorkspaceConnection.ISaveOp>();
        IWorkspaceConnection.IConfigurationOpFactory icof = this.workspace.configurationOpFactory();
        col.add(icof.save((IVersionable)zprojectFolder));
        col.add(icof.save((IVersionable)zOsFolder));
        col.add(icof.save((IVersionable)projectFile));
        col.add(icof.save((IVersionable)xmlFile));
        return col;
    }

    public ArrayList<IWorkspaceConnection.ISaveOp> createZComponentFolder(String zFolderName, String dsdfuuid) throws ZComponentException, TeamRepositoryException {
        ArrayList<IWorkspaceConnection.ISaveOp> col = new ArrayList<IWorkspaceConnection.ISaveOp>();
        IWorkspaceConnection.IConfigurationOpFactory icof = this.workspace.configurationOpFactory();
        ZComponentFactory.validateName((String)zFolderName, (int)2);
        IFolder zOSsrcFolder = null;
        if (this.config != null) {
            IFolderHandle fldHandle = (IFolderHandle)this.findChildEntry(this.config, (IFolderHandle)this.zOSPrjFolder, "zOSsrc");
            if (fldHandle == null) {
                throw new ZComponentException(NLS.bind((String)Messages.SCMOperationMgr_1, (Object)zFolderName));
            }
            zOSsrcFolder = (IFolder)this.config.fetchCompleteItem((IVersionableHandle)fldHandle, null);
            IFolder zFolder = this.createFolder(zOSsrcFolder, zFolderName);
            if (dsdfuuid != null) {
                zFolder.setUserProperty("team.enterprise.resource.definition", dsdfuuid);
            }
            col.add(icof.save((IVersionable)zFolder));
            return col;
        }
        return null;
    }
}

