/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.extensions.uss;

import com.ibm.team.filesystem.client.internal.IFileOptions;
import com.ibm.team.filesystem.client.internal.api.storage.LocalFileAccessExtension;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.teamz.build.ant.zos.utils.LogUtility;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UssLocalFileAccessExtension
extends LocalFileAccessExtension {
    private static final Log LOG = LogFactory.getLog(UssLocalFileAccessExtension.class);

    public InputStream prepareContentsToReceive(IFileOptions fileInfo, InputStream rawIn) {
        String zosEncoding;
        String serverEncoding;
        InputStream result = rawIn;
        if (fileInfo != null && fileInfo.getLineDelimiter() != FileLineDelimiter.LINE_DELIMITER_NONE && fileInfo.getProperties().containsKey("mvsCodePage") && !(serverEncoding = fileInfo.getCharacterEncoding()).equals(zosEncoding = this.getPlatformEncoding(fileInfo))) {
            try {
                result = new ReaderToInputStream((Reader)new InputStreamReader(rawIn, zosEncoding), serverEncoding);
            }
            catch (UnsupportedEncodingException e) {
                LogUtility.logError((Log)LOG, (Exception)e, (String[])new String[]{NLS.bind((String)"Unknown encoding {0} encountered when reading contents, no conversion performed", (Object)zosEncoding, (Object[])new Object[0])});
                return result;
            }
        }
        return result;
    }

    private String getPlatformEncoding(IFileOptions fileInfo) {
        String zosEncodingPreference = (String)fileInfo.getProperties().get("mvsCodePage");
        if ((zosEncodingPreference == null || zosEncodingPreference.length() == 0) && (zosEncodingPreference = System.getenv("ZLANG")) == null) {
            zosEncodingPreference = System.getProperty("file.encoding");
        }
        return zosEncodingPreference;
    }

    public InputStream prepareContentsToSet(IFileOptions fileInfo, InputStream in) {
        String zosEncoding;
        String serverEncoding;
        if (fileInfo != null && !fileInfo.getLineDelimiter().equals((Object)FileLineDelimiter.LINE_DELIMITER_NONE) && fileInfo.getProperties().containsKey("mvsCodePage") && !(serverEncoding = fileInfo.getCharacterEncoding()).equals(zosEncoding = this.getPlatformEncoding(fileInfo))) {
            try {
                in = new ReaderToInputStream((Reader)new InputStreamReader(in, serverEncoding), zosEncoding);
            }
            catch (UnsupportedEncodingException e) {
                LogUtility.logError((Log)LOG, (Exception)e, (String[])new String[]{NLS.bind((String)"Unknown encoding ({0} or {1}) encountered when reading contents, no conversion performed", (Object)zosEncoding, (Object[])new Object[]{serverEncoding})});
            }
        }
        return in;
    }

    public boolean transformsContents() {
        return true;
    }
}

