/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.extensions.uss;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.api.content.MagicContentExaminer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;

public class USSSniffer {
    public static String sniffEncoding(MagicContentExaminer.IStreamSource data, String platformDefaultEncoding) throws FileSystemException {
        InputStream input = data.getStream();
        if (input == null) {
            return null;
        }
        try {
            int bufSize = 20;
            byte[] buffer = new byte[bufSize];
            int len = 0;
            int offset = 0;
            int max = buffer.length;
            while (len != -1 && offset < buffer.length) {
                len = input.read(buffer, offset, max);
                if (len == -1) continue;
                offset += len;
                max -= len;
            }
            if (offset < bufSize) {
                byte[] newBuf = new byte[offset];
                int i = 0;
                while (i < offset) {
                    newBuf[i] = buffer[i];
                    ++i;
                }
                buffer = newBuf;
            }
            if (USSSniffer.matched(buffer, "UTF-8") && !USSSniffer.matched(buffer, platformDefaultEncoding)) {
                return "UTF-8";
            }
            return null;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static boolean isValid(char c) {
        switch (Character.getType(c)) {
            case 15: {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        return true;
                    }
                }
                return false;
            }
            case 18: {
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean matched(byte[] bytes, String possibleEncoding) {
        CharsetDecoder decoder = Charset.forName(possibleEncoding).newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            char c;
            CharBuffer buf = decoder.decode(ByteBuffer.wrap(bytes));
            do {
                if (buf.hasRemaining()) continue;
                return true;
            } while (USSSniffer.isValid(c = buf.get()));
            return false;
        }
        catch (CharacterCodingException ex) {
            return false;
        }
    }
}

