/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.extensions.uss;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IContentExaminer;
import com.ibm.team.filesystem.client.IContentProperties;
import com.ibm.team.filesystem.client.IMetadataProperties;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.api.content.MagicContentExaminer;
import com.ibm.team.filesystem.client.internal.api.content.SniffContentExaminer;
import com.ibm.team.filesystem.client.internal.magic.ContentProperties;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.teamz.fileagent.Zutility;
import com.ibm.teamz.fileagent.internal.extensions.uss.USSSniffer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;

public class USSContentExaminer
extends MagicContentExaminer
implements IContentExaminer {
    public static final String ENCODING_OVERRIDE_PROPERTY_NAME = "file.encoding";
    public static final String PRESERVE_ENCODING_PROPERTY_NAME = "preserve.file.encoding";
    private static final String DEFAULT_SCM_ENCODING = "UTF-8";
    private static volatile USSContentExaminer instance = new USSContentExaminer();
    private static final SniffContentExaminer sniffContentExaminer = new SniffContentExaminer();

    public static IContentExaminer getInstance() {
        return instance;
    }

    public USSContentExaminer() {
    }

    public USSContentExaminer(String pathToUserHome) {
        super(pathToUserHome);
    }

    public IContentProperties examine(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        IContentProperties contentProperties = this.getMagicProperties(shareable.getLocalPath().getName(), (IProgressMonitor)progress.newChild(5));
        return new ContentProperties(this.getEncoding(shareable, (IProgressMonitor)progress.newChild(5)), contentProperties.getMimeType(), contentProperties.getLineDelimiter());
    }

    public IContentProperties findStoredProperties(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        String encoding;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)101);
        File file = (File)shareable.getAdapter(File.class);
        ResourceType type = shareable.getResourceType((IProgressMonitor)progress.newChild(1));
        if (file == null || type == null) {
            return ContentProperties.UNKNOWN;
        }
        String mimeType = shareable.getContentType((IProgressMonitor)progress.newChild(25));
        FileLineDelimiter lineDelimiter = shareable.getLineDelimiter((IProgressMonitor)progress.newChild(25));
        if (mimeType == null || lineDelimiter == null) {
            IContentProperties props = this.examine(shareable, (IProgressMonitor)progress.newChild(50));
            if (mimeType == null) {
                mimeType = props.getMimeType();
            }
            if (lineDelimiter == null) {
                lineDelimiter = props.getLineDelimiter();
            }
            encoding = props.getEncoding();
        } else {
            encoding = this.getEncoding(shareable, (IProgressMonitor)progress.newChild(50));
        }
        return new ContentProperties(encoding, mimeType, lineDelimiter);
    }

    public String getEncoding(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        return this.getEncoding(shareable, this.getEncodingHint(shareable, (IProgressMonitor)progress.newChild(5)), (IProgressMonitor)progress.newChild(5));
    }

    private String getEncoding(IShareable shareable, String encodingHint, IProgressMonitor monitor) throws FileSystemException {
        final ResourceType type = shareable.getResourceType(monitor);
        if (type == ResourceType.FILE && shareable.getMetadataProperties(monitor).getCurrentProperties().get("mvsCodePage") != null) {
            String encoding;
            if (encodingHint != null) {
                return encodingHint;
            }
            FileItemInfo fileItemInfo = ((Shareable)shareable).getFileItemInfo(monitor);
            if (fileItemInfo != null && (encoding = fileItemInfo.getStoredEncoding()) != null) {
                return encoding;
            }
            encoding = System.getenv("JAZZ_ENCODING");
            if (encoding != null) {
                return encoding;
            }
            return DEFAULT_SCM_ENCODING;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        String encoding = null;
        final File file = (File)shareable.getAdapter(File.class);
        MagicContentExaminer.IStreamSource streamSource = new MagicContentExaminer.IStreamSource(){

            public InputStream getStream() throws FileSystemException {
                block3: {
                    try {
                        if (file != null && type == ResourceType.FILE && file.canRead()) break block3;
                        return null;
                    }
                    catch (FileNotFoundException e) {
                        return null;
                    }
                }
                return new FileInputStream(file);
            }
        };
        encoding = sniffContentExaminer.sniffEncoding(streamSource);
        if (encoding == null) {
            encoding = encodingHint;
        }
        if (encoding == null) {
            encoding = this.getMagicEncoding(shareable.getLocalPath().getName(), (IProgressMonitor)progress);
        }
        if (encoding == null) {
            encoding = USSSniffer.sniffEncoding(streamSource, Zutility.getDefaultPlatformEncoding());
        }
        if (encoding == null) {
            encoding = System.getenv("ZLANG");
        }
        if (encoding == null) {
            encoding = Zutility.getDefaultPlatformEncoding();
        }
        if (encoding == null) {
            encoding = System.getProperty(ENCODING_OVERRIDE_PROPERTY_NAME);
        }
        return encoding;
    }

    private String getEncodingHint(IShareable shareable, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            String encoding;
            FileItemInfo fileItemInfo;
            boolean preserveEncoding;
            IMetadataProperties metadataProperties = shareable.getMetadataProperties((IProgressMonitor)progress.newChild(1));
            String preserveString = (String)metadataProperties.getCurrentProperties().get(PRESERVE_ENCODING_PROPERTY_NAME);
            if (preserveString != null && (preserveEncoding = Boolean.valueOf(preserveString).booleanValue()) && (fileItemInfo = ((Shareable)shareable).getFileItemInfo((IProgressMonitor)progress.newChild(1))) != null && (encoding = fileItemInfo.getStoredEncoding()) != null) {
                return encoding;
            }
            return (String)metadataProperties.getCurrentProperties().get(ENCODING_OVERRIDE_PROPERTY_NAME);
        }
        catch (FileSystemException e) {
            LoggingHelper.log((IStatus)FileSystemStatusUtil.getStatusFor((Throwable)e));
            return null;
        }
    }
}

