/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.extensions.simuler;

import com.ibm.team.filesystem.client.internal.MetronomeModel;
import com.ibm.team.repository.client.IStatistics;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.IPropertyChangeEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class MetronomeReporter
implements IListener {
    private final ITeamRepository repo;
    private long startTime = 0L;
    private final Map<Class<?>, Set<Method>> serviceMap;

    public MetronomeReporter(ITeamRepository repository) {
        this.repo = repository;
        this.serviceMap = new HashMap();
        this.repo.statistics().addGenericListener((Object)"com.ibm.team.repository.statistics.serviceMethod", (IListener)this);
        MetronomeModel model = MetronomeModel.getInstance();
        model.addedRepository(repository);
        model.resetServiceMethodStats(this.repo.statistics());
        this.startTime = System.currentTimeMillis();
    }

    public void reset() {
        MetronomeModel model = MetronomeModel.getInstance();
        model.resetServiceMethodStats(this.repo.statistics());
        this.startTime = System.currentTimeMillis();
    }

    public String report(String operationLabel) {
        long endTime = System.currentTimeMillis();
        StringBuffer report = new StringBuffer();
        report.append("\n" + operationLabel + ": Service Trip Statistics\n");
        IStatistics stats = this.repo.statistics();
        stats.purgeGenericListener((IListener)this);
        MetronomeModel model = MetronomeModel.getInstance();
        TreeSet orderedClasses = new TreeSet(new ClassNameComparator());
        orderedClasses.addAll(this.serviceMap.keySet());
        ArrayList vals = new ArrayList(this.serviceMap.size() * 8);
        Collections.addAll(vals, "Interface/method", "Calls", "Time(ms)", "Time(%)", "Avg(ms)");
        int maxCol1width = "Interface/method".length();
        long totalElapsedTime = model.getTotalElapsedTime(stats);
        for (Class clazz : orderedClasses) {
            String serviceFullName = clazz.getName();
            String serviceName = serviceFullName.substring(serviceFullName.lastIndexOf(46) + 1);
            long serviceCallCount = model.getServiceCallCount(stats, clazz);
            long serviceElapsedTime = model.getServiceElapsedTime(stats, clazz);
            long servicePercentage = Math.round((double)serviceElapsedTime / (double)totalElapsedTime * 100.0);
            double serviceAverage = (double)Math.round(100.0 * (double)serviceElapsedTime / (double)serviceCallCount) / 100.0;
            Collections.addAll(vals, "  " + serviceName, Long.toString(serviceCallCount), Long.toString(serviceElapsedTime), Long.toString(servicePercentage), Double.toString(serviceAverage));
            maxCol1width = Math.max(maxCol1width, 2 + serviceName.length());
            TreeSet<Method> orderedMethods = new TreeSet<Method>(new MethodNameComparator());
            orderedMethods.addAll((Collection<Method>)this.serviceMap.get(clazz));
            for (Method serviceMethod : orderedMethods) {
                long methodCallCount = model.getMethodCallCount(stats, clazz, serviceMethod);
                long methodElapsedTime = model.getMethodElapsedTime(stats, clazz, serviceMethod);
                long methodPercentage = Math.round((double)methodElapsedTime / (double)totalElapsedTime * 100.0);
                double methodAverage = (double)Math.round(100.0 * (double)methodElapsedTime / (double)methodCallCount) / 100.0;
                Collections.addAll(vals, "    " + serviceMethod.getName(), Long.toString(methodCallCount), Long.toString(methodElapsedTime), Long.toString(methodPercentage), Double.toString(methodAverage));
                maxCol1width = Math.max(maxCol1width, 4 + serviceMethod.getName().length());
            }
        }
        this.printStats(report, vals.toArray(new String[vals.size()]), new int[]{maxCol1width, 15, 15, 10, 15});
        report.append("-- Total time in service calls: " + totalElapsedTime + "ms\n");
        report.append("-- Total elapsed time: " + (endTime - this.startTime) + "ms\n");
        return report.toString();
    }

    private void printStats(StringBuffer report, String[] stats, int[] columnWidths) {
        int statsLength = stats.length;
        int i = 0;
        while (i < statsLength) {
            StringBuilder line = new StringBuilder();
            boolean padRight = true;
            int column = 0;
            while (column < columnWidths.length) {
                this.append(line, stats[i], columnWidths[column], padRight);
                ++i;
                padRight = false;
                ++column;
            }
            report.append(line.toString()).append("\n");
        }
    }

    private void append(StringBuilder line, String columnData, int width, boolean padRight) {
        if (padRight) {
            line.append(columnData);
        }
        int i = columnData.length();
        while (i < width) {
            line.append(" ");
            ++i;
        }
        if (!padRight) {
            line.append(columnData);
        }
    }

    public void handleEvents(List events) {
        for (Object eventObj : events) {
            IPropertyChangeEvent event = (IPropertyChangeEvent)eventObj;
            Object eventObject = event.getObject();
            if (!(eventObject instanceof Method)) continue;
            Method eventMethod = (Method)eventObject;
            Class<?> service = eventMethod.getDeclaringClass();
            if (!this.serviceMap.containsKey(service)) {
                this.serviceMap.put(service, new HashSet());
            }
            this.serviceMap.get(service).add(eventMethod);
        }
    }

    private static class ClassNameComparator
    implements Comparator<Class<?>> {
        private ClassNameComparator() {
        }

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName());
        }
    }

    public static class MethodNameComparator
    implements Comparator<Method> {
        @Override
        public int compare(Method o1, Method o2) {
            return String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName());
        }
    }
}

