/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.extensions.mutators;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.teamz.fileagent.internal.extensions.mutators.IDataSetUpdater;
import com.ibm.teamz.fileagent.internal.extensions.mutators.IProgressMonitoringSession;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public abstract class ProgressHandlingDataSetUpdateSession
implements IProgressMonitoringSession {
    private long startTime = -1L;
    private long lastMonitorUpdate = -1L;
    private static final long UPDATE_INTERVAL = 500000000L;
    private long updateCount = 0L;
    protected final long expectedUpdates;
    private long completedUpdates;
    protected final SubMonitor monitor;
    private final Object lock = new Object();
    private boolean externallyTrackedMonitoring;

    public ProgressHandlingDataSetUpdateSession(String name, long totalWork, boolean externallyTrackedMonitoring, IProgressMonitor mon) {
        this.monitor = SubMonitor.convert((IProgressMonitor)mon, (String)name, (int)1000);
        this.expectedUpdates = totalWork;
        this.externallyTrackedMonitoring = externallyTrackedMonitoring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementUpdateCount(long howMuch) {
        if (this.isCanceled()) {
            throw new OperationCanceledException();
        }
        Object object = this.lock;
        synchronized (object) {
            int oldWorked = this.expectedUpdates <= 0L ? 0 : (int)(this.completedUpdates * 1000L / this.expectedUpdates);
            this.completedUpdates += howMuch;
            int newWorked = this.expectedUpdates <= 0L ? 0 : (int)(this.completedUpdates * 1000L / this.expectedUpdates);
            if ((newWorked -= oldWorked) != 0) {
                this.monitor.worked(newWorked);
            }
            assert (this.completedUpdates <= this.expectedUpdates);
        }
        this.updateProgressMonitor(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDataSet(IDataSetUpdater updater) throws TeamRepositoryException {
        Object object = this.lock;
        synchronized (object) {
            ++this.updateCount;
        }
        this.internalUpdateDataSet(updater);
    }

    protected abstract void internalUpdateDataSet(IDataSetUpdater var1) throws TeamRepositoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logUpdateStart() {
        if (this.isCanceled()) {
            throw new OperationCanceledException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.startTime == -1L) {
                this.startTime = System.nanoTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logUpdateCompleted() {
        boolean finished;
        boolean forceUpdate;
        Object object = this.lock;
        synchronized (object) {
            --this.updateCount;
            int oldWorked = 0;
            if (!this.externallyTrackedMonitoring && this.expectedUpdates > 0L) {
                oldWorked = (int)(this.completedUpdates * 1000L / this.expectedUpdates);
            }
            ++this.completedUpdates;
            if (!this.externallyTrackedMonitoring) {
                int newWorked = this.expectedUpdates <= 0L ? 0 : (int)(this.completedUpdates * 1000L / this.expectedUpdates);
                if ((newWorked -= oldWorked) != 0) {
                    this.monitor.worked(newWorked);
                }
            }
            assert (this.completedUpdates <= this.expectedUpdates);
            assert (this.updateCount >= 0L);
            forceUpdate = this.updateCount == 0L;
            finished = this.expectedUpdates == this.completedUpdates;
        }
        if (this.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.updateProgressMonitor(forceUpdate);
        if (finished) {
            this.monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateProgressMonitor(boolean force) {
        long snapStartTime;
        long snapLastUpdate;
        long now = System.nanoTime();
        Object object = this.lock;
        synchronized (object) {
            snapLastUpdate = this.lastMonitorUpdate;
            snapStartTime = this.startTime;
        }
        if (force || snapLastUpdate == -1L || now - snapLastUpdate > 500000000L) {
            this.monitor.subTask(this.getUpdateStats(snapStartTime == -1L ? 0L : now - snapStartTime));
            object = this.lock;
            synchronized (object) {
                this.lastMonitorUpdate = now;
            }
        }
    }

    protected String getUpdateStats(long totalTime) {
        return NLS.bind((String)Messages.ProgressHandlingDataSetUpdateSession_0, (Object)this.completedUpdates, (Object[])new Object[]{this.expectedUpdates});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.lock;
        synchronized (object) {
            return this.monitor.isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getCompletedTransfers() {
        Object object = this.lock;
        synchronized (object) {
            return this.completedUpdates;
        }
    }
}

