/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.extensions.mutators;

import com.ibm.team.enterprise.common.common.utils.LoadTracing;
import com.ibm.team.enterprise.scmee.common.DeferredFileLoadInformation;
import com.ibm.team.enterprise.scmee.common.nls.SCMEEMessages;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IShareableInternal;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.load.UpdateOrder;
import com.ibm.team.filesystem.client.internal.operations.IUpdateMutator;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.NonCancellingProgressMonitor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport2;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.VersionablePermissionDeniedException;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import com.ibm.teamz.fileagent.internal.extensions.mutators.ASyncDataSetUpdateSession;
import com.ibm.teamz.fileagent.internal.extensions.mutators.DataSetUpdateMutator;
import com.ibm.teamz.fileagent.internal.extensions.mutators.MVSMutator;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class MVSThreadedUpdateMutator
extends MVSMutator
implements IUpdateMutator {
    private final IConnection connection;
    private final IContextHandle connectionHandle;
    private final ITeamRepository repository;
    private final FileAreaUpdateReport2 updates;
    private final Collection<IItemUpdateReport> rawUpdates;
    private final UpdateDilemmaHandler problemHandler;
    private final IDownloadListener downloadMonitor;
    private final Collection<ICopyFileArea> copyFileAreasToUpdate;
    private ASyncDataSetUpdateSession updateSession;
    private final Map<UUID, Map<UUID, IDataSetDefinition>> definitionsEncountered;
    private final HashMap<UUID, List<ICopyFileArea>> copyFileAreasByComponent;
    private boolean lastComponentSharedResult;
    private IComponentHandle lastComponentShareTested;
    private final HashMap<UUID, IComponentStateSummary> componentStatesBefore;
    private final HashMap<UUID, IComponentStateSummary> componentStatesAfter;
    private final HashSet<UUID> componentNotShared;
    private final Shed shed;
    private final Map<UUID, Set<IShare>> inconsistentShares;
    private final Map<UUID, Set<IShare>> newShares;
    private final Map<ILocation, DataSetUpdateMutator> dataSetUpdater;

    public MVSThreadedUpdateMutator(IConnection connection, Collection<IComponentStateSummary> componentStatesBefore, Collection<IComponentStateSummary> componentStatesAfter, FileAreaUpdateReport2 updates, Collection<IItemUpdateReport> rawUpdates, Collection<ICopyFileArea> copyFileAreasToUpdate, UpdateDilemmaHandler problemHandler, LoadTracing loadTracing, IDownloadListener downloadMonitor) {
        super((DilemmaHandler)(problemHandler == null ? UpdateDilemmaHandler.getDefault() : problemHandler), loadTracing);
        this.connection = connection;
        this.connectionHandle = connection.getContextHandle();
        this.repository = connection.teamRepository();
        this.updates = updates;
        this.rawUpdates = rawUpdates;
        this.problemHandler = problemHandler == null ? UpdateDilemmaHandler.getDefault() : problemHandler;
        this.componentStatesBefore = new HashMap();
        for (IComponentStateSummary componentState : componentStatesBefore) {
            this.componentStatesBefore.put(componentState.getComponent().getItemId(), componentState);
        }
        this.componentStatesAfter = new HashMap();
        for (IComponentStateSummary componentState : componentStatesAfter) {
            this.componentStatesAfter.put(componentState.getComponent().getItemId(), componentState);
        }
        this.componentNotShared = new HashSet();
        this.downloadMonitor = downloadMonitor;
        this.copyFileAreasToUpdate = new HashSet<ICopyFileArea>(copyFileAreasToUpdate);
        this.copyFileAreasByComponent = new HashMap();
        this.shed = new Shed(this.problemHandler.getBackupDilemmaHandler());
        this.newShares = new HashMap<UUID, Set<IShare>>();
        this.inconsistentShares = new HashMap<UUID, Set<IShare>>();
        this.dataSetUpdater = new HashMap<ILocation, DataSetUpdateMutator>();
        this.definitionsEncountered = new HashMap<UUID, Map<UUID, IDataSetDefinition>>();
    }

    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        if (this.shouldReload()) {
            this.reloadThroughVerify(monitor);
        } else {
            this.handleUpdates(monitor);
        }
    }

    private boolean shouldReload() {
        if (!this.updates.getMoves().isEmpty()) {
            return true;
        }
        for (FileAreaUpdate update : this.updates.getModifies()) {
            if (!(update.getItem() instanceof IFolderHandle)) continue;
            return true;
        }
        return false;
    }

    private void reloadThroughVerify(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        HashMap<UUID, IComponentHandle> affectedComponents = new HashMap<UUID, IComponentHandle>();
        if (this.rawUpdates.size() != 0) {
            for (IItemUpdateReport report : this.rawUpdates) {
                this.trackAffectedComponents(report.getComponent(), report.getPriorComponent(), affectedComponents);
            }
        } else {
            for (IItemUpdateReport report : this.updates.getAdds()) {
                this.trackAffectedComponents(report.getComponent(), report.getPreviousComponent(), affectedComponents);
            }
            for (IItemUpdateReport report : this.updates.getDeletes()) {
                this.trackAffectedComponents(report.getComponent(), report.getPreviousComponent(), affectedComponents);
            }
            for (IItemUpdateReport report : this.updates.getModifies()) {
                this.trackAffectedComponents(report.getComponent(), report.getPreviousComponent(), affectedComponents);
            }
            for (IItemUpdateReport report : this.updates.getMoves()) {
                this.trackAffectedComponents(report.getComponent(), report.getPreviousComponent(), affectedComponents);
            }
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 + affectedComponents.size()));
        ArrayList sharesToVerify = new ArrayList();
        IContextHandle connectionHandle = this.connection.getContextHandle();
        for (ICopyFileArea cfa : this.copyFileAreasToUpdate) {
            for (IComponentHandle componentHandle : affectedComponents.values()) {
                Collection shares = cfa.allShares(connectionHandle, componentHandle, (IProgressMonitor)progress.newChild(1));
                sharesToVerify.addAll(shares);
            }
        }
        final UpdateDilemmaHandler forDeletedContentHandler = this.problemHandler;
        OutOfSyncDilemmaHandler reloadHandler = new OutOfSyncDilemmaHandler(){

            public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                return 100;
            }

            public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
                for (ICollision collision : collisions) {
                    if (collision.getLocations().size() > 1) {
                        return 2;
                    }
                    ILoadLocation loadLocation = (ILoadLocation)collision.getLocations().iterator().next();
                    collision.setLoadLocation(loadLocation);
                }
                for (IRemovedShare share : removedShares) {
                    share.isToBeDeleted(true);
                }
                return 0;
            }

            public int deletedContent(Collection<IShareable> contentDeleted) {
                return forDeletedContentHandler.deletedContent(contentDeleted);
            }
        };
        IVerifyInSyncOperation reloadOp = IOperationFactory.instance.getVerifyInSyncOperation(reloadHandler);
        reloadOp.addToVerify(this.connection, sharesToVerify);
        reloadOp.run((IProgressMonitor)progress);
    }

    private void trackAffectedComponents(IComponentHandle component, IComponentHandle previousComponent, Map<UUID, IComponentHandle> affectedComponents) {
        affectedComponents.put(component.getItemId(), component);
        if (previousComponent != null && !component.sameItemId((IItemHandle)previousComponent)) {
            affectedComponents.put(previousComponent.getItemId(), previousComponent);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void handleUpdates(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)105);
        orderer = new UpdateOrder((Collection)this.updates.getAdds(), (Collection)this.updates.getDeletes(), (Collection)this.updates.getMoves(), (Collection)this.updates.getModifies(), this.rawUpdates);
        maxContentToDownLoad = orderer.getFileMoves().size() + orderer.getFileAdds().size() + orderer.getGroupedModifies().size() + orderer.getFolderAdds().size();
        deferredDownloadInfo = new ArrayList<DeferredFileLoadInformation>(maxContentToDownLoad);
        this.updateSession = new ASyncDataSetUpdateSession("", SCMPlatform.getMaxContentThreads(), true, maxContentToDownLoad, (IProgressMonitor)subMonitor.newChild(80));
        progress = new CancellationMonitor((IProgressMonitor)subMonitor);
        isCancelled = false;
        component = null;
        try {
            for (FileAreaUpdate update : orderer.getFolderAdds()) {
                component = this.getFullComponent(update, component, (IProgressMonitor)progress);
                this.createFolder(component, update, (IProgressMonitor)progress);
                this.checkCancelled((IProgressMonitor)progress);
            }
            var10_9 = orderer.getFolderMoves().iterator();
            if (var10_9.hasNext()) {
                update = (FileAreaUpdate)var10_9.next();
                throw new IllegalStateException("Moves are not yet supported by this mutator");
            }
            var10_9 = orderer.getLinkMoves().iterator();
            if (var10_9.hasNext()) {
                update = (FileAreaUpdate)var10_9.next();
                throw new IllegalStateException("Moves are not yet supported by this mutator");
            }
            var10_9 = orderer.getFileMoves().iterator();
            if (var10_9.hasNext()) {
                update = (FileAreaUpdate)var10_9.next();
                throw new IllegalStateException("Moves are not yet supported by this mutator");
            }
            for (FileAreaUpdate update : orderer.getOrderedDeletes()) {
                component = this.getFullComponent(update, component, (IProgressMonitor)progress);
                this.deleteSubtree(component, update.getSourceParent(), update.getName(), update.beforeState(), orderer, (IProgressMonitor)progress);
                orderer.processed(update);
                this.checkCancelled((IProgressMonitor)progress);
            }
            inaccessibleUpdates = (List)orderer.getInaccessibleUpdates();
            if (!inaccessibleUpdates.isEmpty()) {
                this.cleanupInaccessible(inaccessibleUpdates, (IProgressMonitor)progress);
            }
            for (FileAreaUpdate update : orderer.getGroupedModifies()) {
                if (update.getItem() instanceof IFileItemHandle) {
                    component = this.getFullComponent(update, component, (IProgressMonitor)progress);
                    this.modifyFile(component, update, update.getFileTimestamp(), (IProgressMonitor)progress);
                } else if (!(update.getItem() instanceof ISymbolicLinkHandle) && update.getItem() instanceof IFolderHandle) {
                    throw new IllegalStateException("Folder modifications are not supported by this mutator");
                }
                this.checkCancelled((IProgressMonitor)progress);
            }
            for (FileAreaUpdate update : orderer.getFileAdds()) {
                component = this.getFullComponent(update, component, (IProgressMonitor)progress);
                this.createFile(component, update, update.getFileTimestamp(), (IProgressMonitor)progress);
                this.checkCancelled((IProgressMonitor)progress);
            }
            for (DataSetUpdateMutator dataSetUpdateMutator : this.dataSetUpdater.values()) {
                this.updateSession.updateDataSet(dataSetUpdateMutator);
            }
        }
        finally {
            this.updateSession.join();
            ** for (dataSetUpdateMutator : this.dataSetUpdater.values())
        }
lbl-1000:
        // 1 sources

        {
            deferredDownloadInfo.addAll(dataSetUpdateMutator.getDownloadInfo());
            continue;
        }
lbl61:
        // 1 sources

        isCancelled = isCancelled != false || progress.isCanceled() != false || this.updateSession.isCanceled() != false || this.isUpdateCancelled(deferredDownloadInfo) != false;
        nonCancellableMonitor = new NonCancellingProgressMonitor((IProgressMonitor)subMonitor.newChild(5));
        metaDataMonitor = SubMonitor.convert((IProgressMonitor)nonCancellableMonitor, (int)(deferredDownloadInfo.size() * 4));
        for (DeferredFileLoadInformation downloadInfo : deferredDownloadInfo) {
            if (!downloadInfo.contentUpdated()) continue;
            skipUpdate = this.skipUpdate(downloadInfo.getCopyFileArea().getRoot(), downloadInfo.getComponent(), downloadInfo.getShareable().getRemote((IProgressMonitor)metaDataMonitor.newChild(1)));
            this.updateMetaData(downloadInfo, skipUpdate, (IProgressMonitor)metaDataMonitor.newChild(1));
            if (skipUpdate) continue;
            downloadInfo.getShareable().getFileStorage().setExecutable(downloadInfo.isExecutable(), (IProgressMonitor)metaDataMonitor.newChild(1));
        }
        metaDataMonitor.done();
        seriousFailures = this.reportDownloadFailures(this.updateSession, this.dataSetUpdater.values(), deferredDownloadInfo, (IProgressMonitor)subMonitor.newChild(5));
        generalErrorMessage = Messages.MVSReloadingUpdateMutator_0;
        if (isCancelled || subMonitor.isCanceled()) {
            failures = this.getErrors();
            if (failures.length > 0 && (multi = new MultiStatus("com.ibm.team.filesystem.client", 0, failures, generalErrorMessage, null)).matches(4)) {
                throw new FileSystemStatusException((IStatus)multi);
            }
            throw new OperationCanceledException();
        }
        this.updateConfigStates(seriousFailures, (IProgressMonitor)subMonitor.newChild(5));
        this.handleDeletedContent(deferredDownloadInfo, (IProgressMonitor)subMonitor.newChild(5));
        failures = this.getErrors();
        if (failures.length > 0 && (multi = new MultiStatus("com.ibm.team.filesystem.client", 0, failures, generalErrorMessage, null)).matches(4)) {
            throw new FileSystemStatusException((IStatus)multi);
        }
    }

    @Override
    protected int notifyHandlerOfDeletedContent(List<IShareable> contentDeleted) {
        return this.problemHandler.deletedContent(contentDeleted);
    }

    @Override
    protected String getDeletedContentMessage() {
        return Messages.MVSReloadingUpdateMutator_11;
    }

    /*
     * WARNING - void declaration
     */
    private void cleanupInaccessible(List<FileAreaUpdate> inaccessibles, IProgressMonitor monitor) throws TeamRepositoryException {
        block15: {
            SubMonitor totalProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 * inaccessibles.size()));
            HashMap<Shareable, IComponent> shareablesToDelete = new HashMap<Shareable, IComponent>();
            IComponent component = null;
            for (FileAreaUpdate inaccessibleUpdate : inaccessibles) {
                void var8_12;
                if (!inaccessibleUpdate.isChangeType(8)) {
                    IComponentHandle iComponentHandle = inaccessibleUpdate.getComponent();
                } else {
                    IComponentHandle iComponentHandle = inaccessibleUpdate.getPreviousComponent();
                }
                component = this.getFullComponent((IComponentHandle)var8_12, component, monitor);
                if (!this.isComponentShared((IComponentHandle)component, (IProgressMonitor)totalProgress.newChild(1))) continue;
                IVersionableHandle item = inaccessibleUpdate.getItem();
                List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(component.getItemId());
                SubMonitor subMonitor = totalProgress.newChild(1);
                subMonitor.setWorkRemaining(copyFileAreas.size() * 100);
                for (ICopyFileArea cfa : copyFileAreas) {
                    Shareable toDeleteShareable;
                    SubMonitor progress = subMonitor.newChild(100);
                    progress.subTask(SCMEEMessages.UpdateMutator_0);
                    IRelativeLocation toDeletePath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)component, item, (IProgressMonitor)progress.newChild(1));
                    if (toDeletePath == null) {
                        if (inaccessibleUpdate.isChangeType(8) && !component.sameItemId((IItemHandle)inaccessibleUpdate.getComponent())) {
                            IComponentHandle iComponentHandle = inaccessibleUpdate.getComponent();
                            component = this.getFullComponent(iComponentHandle, component, monitor);
                            toDeletePath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)component, item, (IProgressMonitor)progress.newChild(1));
                        }
                        if (toDeletePath == null) {
                            cfa.forget(this.connectionHandle, (IComponentHandle)component, item, null);
                            continue;
                        }
                    }
                    if (!(toDeleteShareable = new Shareable(cfa.getRoot(), toDeletePath, ResourceType.getResourceType((IVersionableHandle)item))).exists((IProgressMonitor)progress.newChild(1))) {
                        FileItemInfo info = cfa.getItemInfo(toDeletePath);
                        if (info == null) {
                            SharingManager.getInstance().forget(cfa.getRoot(), this.connectionHandle, (IComponentHandle)component, item, (IProgressMonitor)progress.newChild(1));
                            continue;
                        }
                        SharingManager.getInstance().forget((IShareableInternal)toDeleteShareable, (IProgressMonitor)progress.newChild(1));
                        continue;
                    }
                    if (!(item instanceof IFileItemHandle)) continue;
                    if (inaccessibleUpdate.isChangeType(2)) {
                        this.deleteSubtree(component, toDeleteShareable, (IProgressMonitor)progress.newChild(98));
                        continue;
                    }
                    shareablesToDelete.put(toDeleteShareable, component);
                }
            }
            if (shareablesToDelete.isEmpty()) break block15;
            totalProgress.setWorkRemaining(shareablesToDelete.size());
            ArrayList inaccessibleShareables = new ArrayList(shareablesToDelete.keySet());
            int direction = this.problemHandler.inaccessibleForUpdate(inaccessibleShareables);
            if (direction == 1) {
                throw new OperationCanceledException();
            }
            if (direction == 0) {
                for (Map.Entry entry : shareablesToDelete.entrySet()) {
                    this.deleteSubtree((IComponent)entry.getValue(), (Shareable)entry.getKey(), (IProgressMonitor)totalProgress.newChild(1));
                }
            } else {
                MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, SCMEEMessages.UpdateMutator_1, null);
                for (Map.Entry entry : shareablesToDelete.entrySet()) {
                    this.recordInconsistentShare((IComponentHandle)entry.getValue(), ((Shareable)entry.getKey()).getShare((IProgressMonitor)totalProgress.newChild(1)));
                    multiStatus.add(FileSystemStatusUtil.getStatusFor((int)4, (String)NLS.bind((String)SCMEEMessages.UpdateMutator_2, (Object)((Shareable)entry.getKey()).getLocalPath().toString(), (Object[])new Object[0])));
                }
            }
        }
    }

    private final void createFile(IComponent component, FileAreaUpdate update, Date date, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor totalProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)101);
        IFileItemHandle fileItemState = (IFileItemHandle)update.afterState();
        if (!this.isComponentShared((IComponentHandle)component, (IProgressMonitor)totalProgress.newChild(1))) {
            return;
        }
        IDataSetDefinition dataSetDefinition = this.getFileDataSetDefinition(update, monitor);
        if (dataSetDefinition == null) {
            return;
        }
        IRelativeLocation path = MVSThreadedUpdateMutator.getLocation(update, dataSetDefinition);
        List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(component.getItemId());
        totalProgress.setWorkRemaining(100 * copyFileAreas.size());
        for (ICopyFileArea cfa : copyFileAreas) {
            SubMonitor progress = totalProgress.newChild(100);
            String errorMsgFileName = cfa.getRoot().append(path).toOSString();
            ISandbox sandbox = SharingManager.getInstance().getSandbox(cfa.getRoot(), false);
            Shareable existingNewFileShareable = (Shareable)SharingManager.getInstance().findShareable(cfa.getRoot(), this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)fileItemState, (IProgressMonitor)progress.newChild(1));
            if (existingNewFileShareable != null && !existingNewFileShareable.getLocalPath().equals((Object)path)) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)new FileSystemException(NLS.bind((String)Messages.MVSReloadingUpdateMutator_1, (Object)existingNewFileShareable.getFullPath().toOSString(), (Object[])new Object[]{errorMsgFileName, component.getName()}))));
                this.recordInconsistentShare((IComponentHandle)component, existingNewFileShareable.getShare((IProgressMonitor)progress.newChild(1)));
                continue;
            }
            Shareable potentialCollision = new Shareable(cfa.getRoot(), path, ResourceType.FILE);
            IShare share = potentialCollision.getShare((IProgressMonitor)progress.newChild(1));
            if (!(share == null || share.getSharingDescriptor().getConnectionHandle().sameItemId((IItemHandle)this.connectionHandle) && share.getSharingDescriptor().getComponent().sameItemId((IItemHandle)component) && share.getSharingDescriptor().getRootVersionable().sameItemId((IItemHandle)fileItemState))) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)new FileSystemException(NLS.bind((String)Messages.MVSReloadingUpdateMutator_2, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()}))));
                if (existingNewFileShareable == null) continue;
                this.recordInconsistentShare((IComponentHandle)component, existingNewFileShareable.getShare((IProgressMonitor)progress.newChild(1)));
                continue;
            }
            IRelativeLocation dataSetName = path.getParent();
            DataSetUpdateMutator updater = this.getDataSetUpdater(sandbox, cfa, dataSetName, component, dataSetDefinition);
            updater.addMember(update);
        }
    }

    private DataSetUpdateMutator getDataSetUpdater(ISandbox sandbox, ICopyFileArea cfa, IRelativeLocation dataSetName, IComponent component, IDataSetDefinition dataSetDefinition) {
        ILocation dataSetToUpdate = sandbox.getRoot().append(dataSetName);
        DataSetUpdateMutator updater = this.dataSetUpdater.get(dataSetToUpdate);
        if (updater == null) {
            updater = new DataSetUpdateMutator(cfa, this.connection, component, sandbox, dataSetName, this.shed, this.downloadMonitor);
            this.dataSetUpdater.put(dataSetToUpdate, updater);
        }
        if (dataSetDefinition != null) {
            updater.setDataSetDefinition(dataSetDefinition);
        }
        return updater;
    }

    private void recordInconsistentShare(IComponentHandle component, IShare share) {
        if (share != null) {
            Set<IShare> sharesInComponent = this.inconsistentShares.get(component.getItemId());
            if (sharesInComponent == null) {
                sharesInComponent = new HashSet<IShare>();
                this.inconsistentShares.put(component.getItemId(), sharesInComponent);
            }
            sharesInComponent.add(share);
        }
    }

    private final void createFolder(IComponent component, FileAreaUpdate update, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        IDataSetDefinition dataSetDefinition;
        SubMonitor totalProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)105);
        if (!this.isComponentShared((IComponentHandle)component, (IProgressMonitor)totalProgress.newChild(1))) {
            return;
        }
        try {
            dataSetDefinition = this.getFolderDataSetDefinition(update.getName(), update, (IProgressMonitor)totalProgress.newChild(4));
            this.recordFolderEncountered(update.getComponent(), update.getItem(), dataSetDefinition);
            if (dataSetDefinition == null) {
                return;
            }
        }
        catch (TeamRepositoryException e) {
            this.collectStatus((IStatus)new Status(4, "com.ibm.teamz.fileagent", NLS.bind((String)Messages.MVSLoadMutator_7, (Object)update.getName(), (Object[])new Object[]{component.getName()}), (Throwable)e));
            return;
        }
        List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(component.getItemId());
        totalProgress.setWorkRemaining(100 * copyFileAreas.size());
        for (ICopyFileArea cfa : copyFileAreas) {
            ISandbox sandbox = SharingManager.getInstance().getSandbox(cfa.getRoot(), false);
            IRelativeLocation dataSetName = MVSThreadedUpdateMutator.getLocation(update, dataSetDefinition);
            DataSetUpdateMutator updater = this.getDataSetUpdater(sandbox, cfa, dataSetName, component, dataSetDefinition);
            updater.createDataSet(update);
        }
    }

    private void recordFolderEncountered(IComponentHandle component, IVersionableHandle item, IDataSetDefinition dataSetDefinition) {
        Map<UUID, IDataSetDefinition> foldersInComponent = this.definitionsEncountered.get(component.getItemId());
        if (foldersInComponent == null) {
            foldersInComponent = new HashMap<UUID, IDataSetDefinition>();
            this.definitionsEncountered.put(component.getItemId(), foldersInComponent);
        }
        foldersInComponent.put(item.getItemId(), dataSetDefinition);
    }

    private IDataSetDefinition getFolderDataSetDefinition(String errorName, FileAreaUpdate update, IProgressMonitor cMon) throws TeamRepositoryException {
        IDataSetDefinition dataSetDefinition = null;
        IVersionableHandle item = update.afterState();
        String uuid = (String)update.getProperties().get("team.enterprise.resource.definition");
        if (uuid != null) {
            IDataSetDefinitionHandle dataSetDefinitionHandle = (IDataSetDefinitionHandle)IDataSetDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), null);
            dataSetDefinition = this.getCachedDataSetDefinition(errorName, this.repository, dataSetDefinitionHandle, cMon);
        }
        this.recordFolderEncountered(update.getComponent(), item, dataSetDefinition);
        return dataSetDefinition;
    }

    private IDataSetDefinition getFileDataSetDefinition(FileAreaUpdate update, IProgressMonitor cMon) throws TeamRepositoryException {
        IDataSetDefinition dataSetDefinition = null;
        Map<UUID, IDataSetDefinition> foldersInComponents = this.definitionsEncountered.get(update.getComponent().getItemId());
        if (foldersInComponents != null && foldersInComponents.containsKey(update.getDestinationParent().getItemId())) {
            return foldersInComponents.get(update.getDestinationParent().getItemId());
        }
        IFolderHandle parentFolderHandle = update.getDestinationParent();
        if (parentFolderHandle != null) {
            IConfiguration configuration = this.connection instanceof IWorkspaceConnection ? ((IWorkspaceConnection)this.connection).configuration(update.component()) : ((IBaselineConnection)this.connection).configuration();
            IFolder parentFolder = null;
            try {
                parentFolder = (IFolder)configuration.fetchCompleteItem((IVersionableHandle)update.parent(), cMon);
            }
            catch (VersionablePermissionDeniedException e) {
                return null;
            }
            String uuid = (String)parentFolder.getUserProperties().get("team.enterprise.resource.definition");
            if (uuid != null) {
                IDataSetDefinitionHandle dataSetDefinitionHandle = (IDataSetDefinitionHandle)IDataSetDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), null);
                dataSetDefinition = this.getCachedDataSetDefinition(update.getName(), this.repository, dataSetDefinitionHandle, cMon);
            }
            this.recordFolderEncountered(update.getComponent(), (IVersionableHandle)parentFolderHandle, dataSetDefinition);
        }
        return dataSetDefinition;
    }

    private final void deleteSubtree(IComponent component, IFolderHandle parent, String name, IVersionableHandle itemState, UpdateOrder updateInfo, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor totalProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)101);
        if (!this.isComponentShared((IComponentHandle)component, (IProgressMonitor)totalProgress.newChild(1))) {
            return;
        }
        List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(component.getItemId());
        totalProgress.setWorkRemaining(100 * copyFileAreas.size());
        for (ICopyFileArea cfa : copyFileAreas) {
            Shareable toDeleteShareable;
            SubMonitor progress = totalProgress.newChild(100);
            if (parent == null) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor((int)4, (String)NLS.bind((String)Messages.MVSReloadingUpdateMutator_3, (Object)component.getName(), (Object[])new Object[0]), null));
                this.recordInconsistentComponent(cfa, (IComponentHandle)component, (IProgressMonitor)progress.newChild(1));
                continue;
            }
            IRelativeLocation toDeletePath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)component, itemState, (IProgressMonitor)progress.newChild(1));
            if (toDeletePath == null) {
                IComponentHandle alternateComponent = updateInfo.getCurrentComponent(component, parent);
                if (alternateComponent != null) {
                    toDeletePath = cfa.getLocalPathFor(this.connectionHandle, alternateComponent, itemState, (IProgressMonitor)progress.newChild(1));
                    component = (IComponent)this.connection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)alternateComponent, 0, (IProgressMonitor)totalProgress.newChild(1));
                }
                if (toDeletePath == null) {
                    SharingManager.getInstance().forget(cfa.getRoot(), this.connectionHandle, (IComponentHandle)component, itemState, (IProgressMonitor)progress.newChild(1));
                    continue;
                }
            }
            if (!(toDeleteShareable = new Shareable(cfa.getRoot(), toDeletePath, ResourceType.getResourceType((IVersionableHandle)itemState))).exists((IProgressMonitor)progress.newChild(1))) {
                FileItemInfo info = cfa.getItemInfo(toDeletePath);
                if (info == null) {
                    SharingManager.getInstance().forget(cfa.getRoot(), this.connectionHandle, (IComponentHandle)component, itemState, (IProgressMonitor)progress.newChild(1));
                    continue;
                }
                SharingManager.getInstance().forget((IShareableInternal)toDeleteShareable, (IProgressMonitor)progress.newChild(1));
                continue;
            }
            if (!(itemState instanceof IFileItemHandle)) continue;
            this.deleteSubtree(component, toDeleteShareable, (IProgressMonitor)progress.newChild(98));
        }
    }

    private void deleteSubtree(IComponent component, Shareable toDeleteShareable, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IVersionableHandle remote = toDeleteShareable.getRemote((IProgressMonitor)progress.newChild(1));
        if (remote == null || !this.skipUpdate(toDeleteShareable.getCopyFileAreaRoot(), (IComponentHandle)component, remote)) {
            final IFileStorage storage = toDeleteShareable.getFileStorage();
            try {
                SharingManager.getInstance().doSilentChange(new SharingManager.FileSystemAccessor(){

                    public void run() throws FileSystemException {
                        storage.delete(MVSThreadedUpdateMutator.this.shed, (IProgressMonitor)progress.newChild(50));
                    }
                });
            }
            catch (FileSystemException e) {
                this.recordInconsistentShare((IComponentHandle)component, toDeleteShareable.getShare((IProgressMonitor)progress.newChild(1)));
                this.collectStatus(FileSystemStatusUtil.getStatusFor((int)4, (String)NLS.bind((String)Messages.MVSReloadingUpdateMutator_4, (Object)toDeleteShareable.getFullPath().toOSString(), (Object[])new Object[]{component.getName()}), (Throwable)e));
            }
        }
        toDeleteShareable.forget((IProgressMonitor)progress.newChild(50));
        progress.done();
    }

    protected final void modifyFile(IComponent component, FileAreaUpdate update, Date timestamp, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor totalProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)101);
        if (!this.isComponentShared((IComponentHandle)component, (IProgressMonitor)totalProgress.newChild(1))) {
            return;
        }
        List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(component.getItemId());
        totalProgress.setWorkRemaining(100 * copyFileAreas.size());
        IFileItemHandle fileItemState = (IFileItemHandle)update.afterState();
        for (ICopyFileArea cfa : copyFileAreas) {
            SubMonitor progress = totalProgress.newChild(100);
            String errorMsgFileName = update.getName();
            try {
                IShareable toModifyShareable;
                ResourceType resourceType;
                IRelativeLocation toModifyPath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)fileItemState, (IProgressMonitor)progress.newChild(1));
                if (toModifyPath == null) {
                    InverseFileItemInfo info = cfa.getItemInfo((IVersionableHandle)fileItemState, (IComponentHandle)component, this.connectionHandle, false);
                    if (info == null) continue;
                    IRelativeLocation remotePath = cfa.getRemotePathFor(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)fileItemState, (IProgressMonitor)progress.newChild(1));
                    if (remotePath != null) {
                        errorMsgFileName = cfa.getRoot().append(remotePath).toOSString();
                    }
                    this.collectStatus(FileSystemStatusUtil.getStatusFor((int)2, (String)NLS.bind((String)Messages.MVSReloadingUpdateMutator_5, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
                    continue;
                }
                ISandbox sandbox = SharingManager.getInstance().getSandbox(cfa.getRoot(), false);
                DataSetUpdateMutator updater = this.getDataSetUpdater(sandbox, cfa, toModifyPath.getParent(), component, null);
                updater.modifyMember(update);
                if (updater.getDataSetDefinition() == null) {
                    IDataSetDefinition dataSetDefinition = this.getFileDataSetDefinition(update, (IProgressMonitor)progress.newChild(1));
                    if (dataSetDefinition == null) {
                        SharingManager.getInstance().forget(cfa.getRoot(), this.connection.getContextHandle(), (IComponentHandle)component, (IVersionableHandle)fileItemState, (IProgressMonitor)progress.newChild(1));
                        continue;
                    }
                    updater.setDataSetDefinition(dataSetDefinition);
                }
                if ((resourceType = (toModifyShareable = sandbox.findShareable(toModifyPath, ResourceType.FILE)).getResourceType((IProgressMonitor)progress.newChild(1))) != null && resourceType != ResourceType.FILE) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)new FileSystemException(NLS.bind((String)Messages.MVSReloadingUpdateMutator_6, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()}))));
                    this.recordInconsistentShare((IComponentHandle)component, toModifyShareable.getShare((IProgressMonitor)progress.newChild(1)));
                    continue;
                }
                updater.modifyMember(update);
            }
            finally {
                progress.done();
            }
        }
    }

    protected final boolean isComponentShared(IComponentHandle component, IProgressMonitor monitor) throws FileSystemException {
        if (component.sameItemId((IItemHandle)this.lastComponentShareTested)) {
            return this.lastComponentSharedResult;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.copyFileAreasToUpdate.size());
        this.lastComponentShareTested = component;
        List<ICopyFileArea> cfas = this.copyFileAreasByComponent.get(component.getItemId());
        if (cfas != null) {
            this.lastComponentSharedResult = true;
            return this.lastComponentSharedResult;
        }
        if (this.componentNotShared.contains(component.getItemId())) {
            this.lastComponentSharedResult = false;
            return this.lastComponentSharedResult;
        }
        cfas = new ArrayList<ICopyFileArea>(2);
        for (ICopyFileArea cfa : this.copyFileAreasToUpdate) {
            if (!cfa.isConfigurationShared(this.connectionHandle, component, (IProgressMonitor)progress.newChild(1))) continue;
            cfas.add(cfa);
        }
        boolean bl = this.lastComponentSharedResult = !cfas.isEmpty();
        if (this.lastComponentSharedResult) {
            this.copyFileAreasByComponent.put(component.getItemId(), cfas);
        } else {
            this.componentNotShared.add(component.getItemId());
        }
        return this.lastComponentSharedResult;
    }

    private void recordInconsistentComponent(ICopyFileArea cfa, IComponentHandle component, IProgressMonitor monitor) throws FileSystemException {
        Collection sharesNowInconsistent = cfa.allShares(this.connectionHandle, component, monitor);
        for (IShare share : sharesNowInconsistent) {
            this.recordInconsistentShare(component, share);
        }
    }

    private boolean isUpdateCancelled(ArrayList<DeferredFileLoadInformation> deferredDownloadInfo) {
        for (DeferredFileLoadInformation info : deferredDownloadInfo) {
            if (info.getFailure() == null || !(this.getCauseOfFailure(info) instanceof OperationCanceledException)) continue;
            return true;
        }
        return false;
    }

    private boolean reportDownloadFailures(ASyncDataSetUpdateSession updateSession, Collection<DataSetUpdateMutator> dataSetUpdaters, ArrayList<DeferredFileLoadInformation> deferredDownloadInfo, IProgressMonitor monitor) throws FileSystemException {
        IStatus[] updateSessionStatus;
        boolean seriousErrorsOccurred = false;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)deferredDownloadInfo.size());
        IStatus[] iStatusArray = updateSessionStatus = updateSession.getErrorStatus();
        int n = updateSessionStatus.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status = iStatusArray[n2];
            if (!status.isOK()) {
                this.collectStatus(status);
                seriousErrorsOccurred = true;
            }
            ++n2;
        }
        for (DataSetUpdateMutator dataSetUpdateMutator : dataSetUpdaters) {
            List<IStatus> seriousErrors = dataSetUpdateMutator.getErrors();
            if (seriousErrors.isEmpty()) continue;
            seriousErrorsOccurred = true;
            for (IStatus status : seriousErrors) {
                this.collectStatus(status);
            }
        }
        boolean reportedSupportedCharSets = false;
        for (DeferredFileLoadInformation deferredUpdateInformation : deferredDownloadInfo) {
            IStatus status;
            if (deferredUpdateInformation == null || deferredUpdateInformation.getFailure() == null) continue;
            Throwable rootCause = this.getCauseOfFailure(deferredUpdateInformation);
            if (rootCause instanceof UnsupportedEncodingException || rootCause instanceof UnsupportedCharsetException) {
                if (!reportedSupportedCharSets) {
                    StringBuffer charSetsAvailable = new StringBuffer();
                    for (String charsetName : Charset.availableCharsets().keySet()) {
                        charSetsAvailable.append(charsetName).append(' ');
                    }
                    IStatus infoStatus = FileSystemStatusUtil.getStatusFor((int)1, (String)NLS.bind((String)Messages.MVSReloadingUpdateMutator_7, (Object)charSetsAvailable.toString(), (Object[])new Object[0]));
                    this.collectStatus(infoStatus);
                    reportedSupportedCharSets = true;
                }
                status = FileSystemStatusUtil.getStatusFor((int)4, (String)NLS.bind((String)Messages.MVSReloadingUpdateMutator_8, (Object)deferredUpdateInformation.getShareable().getFullPath().toOSString(), (Object[])new Object[]{deferredUpdateInformation.getContent().getCharacterEncoding()}), (Throwable)deferredUpdateInformation.getFailure());
            } else if (rootCause instanceof CharacterCodingException) {
                status = FileSystemStatusUtil.getStatusFor((int)4, (String)NLS.bind((String)Messages.MVSReloadingUpdateMutator_9, (Object)deferredUpdateInformation.getShareable().getFullPath().toOSString(), (Object[])new Object[]{deferredUpdateInformation.getContent().getCharacterEncoding()}), (Throwable)deferredUpdateInformation.getFailure());
            } else {
                if (rootCause instanceof OperationCanceledException) continue;
                status = FileSystemStatusUtil.getStatusFor((int)4, (String)NLS.bind((String)Messages.MVSReloadingUpdateMutator_10, (Object)deferredUpdateInformation.getShareable().getFullPath().toOSString(), (Object[])new Object[0]), (Throwable)deferredUpdateInformation.getFailure());
            }
            this.collectStatus(status);
            IShare share = null;
            try {
                share = deferredUpdateInformation.getShareable().getShare((IProgressMonitor)progress.newChild(1));
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
            if (share == null) {
                this.recordInconsistentComponent(deferredUpdateInformation.getCopyFileArea(), deferredUpdateInformation.getComponent(), (IProgressMonitor)progress.newChild(1));
                continue;
            }
            this.recordInconsistentShare(deferredUpdateInformation.getComponent(), deferredUpdateInformation.getShareable().getShare((IProgressMonitor)progress.newChild(1)));
        }
        return seriousErrorsOccurred;
    }

    private Throwable getCauseOfFailure(DeferredFileLoadInformation deferredUpdateInformation) {
        Throwable rootCause = deferredUpdateInformation.getFailure().getCause();
        if (rootCause == null) {
            rootCause = deferredUpdateInformation.getFailure();
        }
        int paranoiaCount = 0;
        while (rootCause instanceof TeamRepositoryException && paranoiaCount < 50) {
            Throwable cause = ((TeamRepositoryException)rootCause).getCause();
            if (cause == null) break;
            rootCause = cause;
            ++paranoiaCount;
        }
        return rootCause;
    }

    protected void updateMetaData(DeferredFileLoadInformation downloadInfo, boolean skipUpdate, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)new NonCancellingProgressMonitor(monitor), (int)100);
        IShareableInternal shareable = downloadInfo.getShareable();
        IFileStorage file = shareable.getFileStorage();
        if (file != null) {
            boolean isLoadedWithAnotherName;
            String name;
            IFolderHandle parent;
            long modificationStamp = file.getModificationStamp();
            FileContent content = (FileContent)downloadInfo.getContent();
            FileItemInfo oldInfo = downloadInfo.getCopyFileArea().getItemInfo(shareable.getLocalPath());
            if (oldInfo == null) {
                parent = downloadInfo.getRemoteParent();
                name = downloadInfo.getRemoteName();
                isLoadedWithAnotherName = PathUtils.isLoadedWithAnotherName((ISandbox)shareable.getSandbox(), (IRelativeLocation)shareable.getLocalPath(), (String)name);
            } else {
                parent = oldInfo.getParent();
                name = oldInfo.getName();
                isLoadedWithAnotherName = oldInfo.isLoadedWithAnotherName();
            }
            FileItemInfoProxy infoProxy = new FileItemInfoProxy(downloadInfo.getFileItemState(), parent, name, isLoadedWithAnotherName);
            infoProxy.setContentInfo(modificationStamp, downloadInfo.getHash(), downloadInfo.getContentSize(), content);
            infoProxy.setExecutable(downloadInfo.isExecutable(), downloadInfo.isExecutable());
            infoProxy.setContentType(downloadInfo.getContentType());
            if (skipUpdate) {
                infoProxy.setContentChanged(true, modificationStamp);
            }
            ISharingDescriptor sharingDescriptor = downloadInfo.getSharingDescriptor();
            IShare share = SharingManager.getInstance().share(shareable, sharingDescriptor, infoProxy.getFileItemInfo(), downloadInfo.getMetadataProperties(), 2, (IProgressMonitor)progress);
            Set<IShare> sharesInComponent = this.newShares.get(downloadInfo.getComponent().getItemId());
            if (sharesInComponent == null) {
                sharesInComponent = new HashSet<IShare>();
                this.newShares.put(downloadInfo.getComponent().getItemId(), sharesInComponent);
            }
            sharesInComponent.add(share);
            if (skipUpdate && !shareable.exists((IProgressMonitor)progress.newChild(1))) {
                downloadInfo.getCopyFileArea().makePendingDeletion(downloadInfo.getShareable().getLocalPath(), (IProgressMonitor)progress);
            }
        }
        progress.done();
    }

    private IComponent getFullComponent(FileAreaUpdate update, IComponent currentComponent, IProgressMonitor monitor) throws TeamRepositoryException {
        IComponentHandle component = update.component();
        return this.getFullComponent(component, currentComponent, monitor);
    }

    private IComponent getFullComponent(IComponentHandle component, IComponent currentComponent, IProgressMonitor monitor) throws TeamRepositoryException {
        if (component instanceof IComponent) {
            return (IComponent)component;
        }
        if (!component.sameItemId((IItemHandle)currentComponent)) {
            currentComponent = (IComponent)this.repository.itemManager().fetchCompleteItem((IItemHandle)component, 0, monitor);
        }
        return currentComponent;
    }

    private void updateConfigStates(boolean seriousFailures, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        SubMonitor progress;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.newShares.size() + this.inconsistentShares.size() + this.componentStatesAfter.size()));
        for (Map.Entry<UUID, Set<IShare>> entry : this.newShares.entrySet()) {
            progress = subMonitor.newChild(1);
            Set<IShare> newSharesInComponent = entry.getValue();
            Set<IShare> inconsistentSharesInComponent = this.inconsistentShares.get(entry.getKey());
            if (inconsistentSharesInComponent != null) {
                newSharesInComponent.removeAll(inconsistentSharesInComponent);
            }
            progress.setWorkRemaining(newSharesInComponent.size());
            IComponentStateSummary summary = this.componentStatesAfter.get(entry.getKey());
            for (IShare newShare : newSharesInComponent) {
                ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(newShare.getSandbox().getRoot());
                cfa.setConfigurationState(this.connectionHandle, newShare.getSharingDescriptor().getComponent(), newShare.getSharingDescriptor().getRootVersionable(), summary.getConfigurationTime(), (IProgressMonitor)progress.newChild(1));
            }
        }
        for (Map.Entry<UUID, Set<IShare>> entry : this.inconsistentShares.entrySet()) {
            progress = subMonitor.newChild(1);
            Set<IShare> inconsistentSharesInComponent = entry.getValue();
            progress.setWorkRemaining(inconsistentSharesInComponent.size());
            for (IShare inconsistentShare : inconsistentSharesInComponent) {
                ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(inconsistentShare.getSandbox().getRoot());
                cfa.setUnknownConfigurationState(this.connectionHandle, inconsistentShare.getSharingDescriptor().getComponent(), inconsistentShare.getShareable().getLocalPath(), (IProgressMonitor)subMonitor.newChild(1));
            }
        }
        if (!seriousFailures) {
            for (IComponentStateSummary stateAfter : this.componentStatesAfter.values()) {
                IComponentStateSummary stateBefore = this.componentStatesBefore.get(stateAfter.getComponent().getItemId());
                if (stateBefore == null) continue;
                for (ICopyFileArea cfa : this.copyFileAreasToUpdate) {
                    cfa.setConfigurationState(this.connectionHandle, stateAfter.getComponent(), stateBefore.getConfigurationTime(), stateAfter.getConfigurationTime(), (IProgressMonitor)subMonitor.newChild(1));
                }
            }
        }
    }

    protected void reportErrorsAsException(IStatus[] errors) throws FileSystemException {
        if (errors.length == 0) {
            return;
        }
        if (this.inconsistentShares.size() > 0) {
            MultiStatus result = new MultiStatus("com.ibm.team.filesystem.client", 0, errors, Messages.MVSReloadingUpdateMutator_0, null);
            throw new FileSystemStatusException((IStatus)result);
        }
        super.reportErrorsAsException(errors);
    }

    public void setSkipStoreContent(Map<ILocation, Map<ConfigurationFacade, Set<UUID>>> ignoreList) {
    }

    protected final boolean skipUpdate(ILocation cfa, IComponentHandle comp, IVersionableHandle remote) {
        return false;
    }
}

