/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.extensions.mutators;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogField;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.enterprise.common.common.utils.LoadTracing;
import com.ibm.team.enterprise.scmee.common.DeferredFileLoadInformation;
import com.ibm.team.enterprise.scmee.common.DownloadHandler;
import com.ibm.team.enterprise.scmee.common.nls.SCMEEMessages;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.filesystem.client.FileDownloadHandler;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.IFileContentManagerSession;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IShareableInternal;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.load.UpdateOrder;
import com.ibm.team.filesystem.client.internal.operations.IUpdateMutator;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.NonCancellingProgressMonitor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport2;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.VersionablePermissionDeniedException;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import com.ibm.teamz.fileagent.internal.extensions.impl.AbortLoadOperationException;
import com.ibm.teamz.fileagent.internal.extensions.impl.ZSharingData;
import com.ibm.teamz.fileagent.internal.extensions.mutators.MVSMutator;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class MVSReloadingUpdateMutator
extends MVSMutator
implements IUpdateMutator {
    private static final String cls = MVSReloadingUpdateMutator.class.getSimpleName();
    private final IConnection connection;
    private final IContextHandle connectionHandle;
    private final ITeamRepository repository;
    private final FileAreaUpdateReport2 updates;
    private final Collection<IItemUpdateReport> rawUpdates;
    private final UpdateDilemmaHandler problemHandler;
    private final IDownloadListener downloadMonitor;
    private final Collection<ICopyFileArea> copyFileAreasToUpdate;
    private IFileContentManagerSession contentSession;
    private final Map<UUID, Map<UUID, IDataSetDefinition>> definitionsEncountered;
    private final HashMap<UUID, List<ICopyFileArea>> copyFileAreasByComponent;
    private final HashMap<UUID, IComponentStateSummary> componentStatesBefore;
    private final HashMap<UUID, IComponentStateSummary> componentStatesAfter;
    private final HashSet<UUID> componentNotShared;
    private final Map<UUID, Set<IShare>> inconsistentShares;
    private final Map<UUID, Set<IShare>> newShares;
    private boolean isAborted;
    private boolean lastComponentSharedResult;
    private IComponentHandle lastComponentShareTested;
    private final Shed shed;

    public MVSReloadingUpdateMutator(IConnection connection, Collection<IComponentStateSummary> componentStatesBefore, Collection<IComponentStateSummary> componentStatesAfter, FileAreaUpdateReport2 updates, Collection<IItemUpdateReport> rawUpdates, Collection<ICopyFileArea> copyFileAreasToUpdate, UpdateDilemmaHandler problemHandler, LoadTracing loadTracing, IDownloadListener downloadMonitor) {
        super((DilemmaHandler)(problemHandler == null ? UpdateDilemmaHandler.getDefault() : problemHandler), loadTracing);
        this.connection = connection;
        this.connectionHandle = connection.getContextHandle();
        this.repository = connection.teamRepository();
        this.updates = updates;
        this.rawUpdates = rawUpdates;
        this.problemHandler = problemHandler == null ? UpdateDilemmaHandler.getDefault() : problemHandler;
        this.componentStatesBefore = new HashMap();
        for (IComponentStateSummary componentState : componentStatesBefore) {
            this.componentStatesBefore.put(componentState.getComponent().getItemId(), componentState);
        }
        this.componentStatesAfter = new HashMap();
        for (IComponentStateSummary componentState : componentStatesAfter) {
            this.componentStatesAfter.put(componentState.getComponent().getItemId(), componentState);
        }
        this.componentNotShared = new HashSet();
        this.downloadMonitor = downloadMonitor;
        this.copyFileAreasToUpdate = new HashSet<ICopyFileArea>(copyFileAreasToUpdate);
        this.copyFileAreasByComponent = new HashMap();
        this.definitionsEncountered = new HashMap<UUID, Map<UUID, IDataSetDefinition>>();
        this.shed = new Shed(this.problemHandler.getBackupDilemmaHandler());
        this.newShares = new HashMap<UUID, Set<IShare>>();
        this.inconsistentShares = new HashMap<UUID, Set<IShare>>();
        this.isAborted = false;
        if (this.debug) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls});
        }
    }

    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        if (this.shouldReload()) {
            this.reloadThroughVerify(monitor);
        } else {
            this.handleUpdates(monitor);
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }

    private boolean shouldReload() {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        boolean result = false;
        if (!this.updates.getMoves().isEmpty()) {
            result = true;
        }
        if (!result) {
            for (FileAreaUpdate update : this.updates.getModifies()) {
                if (!(update.getItem() instanceof IFolderHandle)) continue;
                result = true;
                break;
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogString.value((Object)result)});
        }
        return result;
    }

    private void reloadThroughVerify(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        HashMap<UUID, IComponentHandle> affectedComponents = new HashMap<UUID, IComponentHandle>();
        if (this.rawUpdates.size() != 0) {
            for (IItemUpdateReport report : this.rawUpdates) {
                this.trackAffectedComponents(report.getComponent(), report.getPriorComponent(), affectedComponents);
            }
        } else {
            for (IItemUpdateReport report : this.updates.getAdds()) {
                this.trackAffectedComponents(report.getComponent(), report.getPreviousComponent(), affectedComponents);
            }
            for (IItemUpdateReport report : this.updates.getDeletes()) {
                this.trackAffectedComponents(report.getComponent(), report.getPreviousComponent(), affectedComponents);
            }
            for (IItemUpdateReport report : this.updates.getModifies()) {
                this.trackAffectedComponents(report.getComponent(), report.getPreviousComponent(), affectedComponents);
            }
            for (IItemUpdateReport report : this.updates.getMoves()) {
                this.trackAffectedComponents(report.getComponent(), report.getPreviousComponent(), affectedComponents);
            }
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 + affectedComponents.size()));
        ArrayList sharesToVerify = new ArrayList();
        IContextHandle connectionHandle = this.connection.getContextHandle();
        for (ICopyFileArea cfa : this.copyFileAreasToUpdate) {
            for (IComponentHandle componentHandle : affectedComponents.values()) {
                Collection shares = cfa.allShares(connectionHandle, componentHandle, (IProgressMonitor)progress.newChild(1));
                sharesToVerify.addAll(shares);
            }
        }
        final UpdateDilemmaHandler forDeletedContentHandler = this.problemHandler;
        OutOfSyncDilemmaHandler reloadHandler = new OutOfSyncDilemmaHandler(){

            public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                return 100;
            }

            public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
                for (ICollision collision : collisions) {
                    if (collision.getLocations().size() > 1) {
                        return 2;
                    }
                    ILoadLocation loadLocation = (ILoadLocation)collision.getLocations().iterator().next();
                    collision.setLoadLocation(loadLocation);
                }
                for (IRemovedShare share : removedShares) {
                    share.isToBeDeleted(true);
                }
                return 0;
            }

            public int deletedContent(Collection<IShareable> contentDeleted) {
                return forDeletedContentHandler.deletedContent(contentDeleted);
            }
        };
        IVerifyInSyncOperation reloadOp = IOperationFactory.instance.getVerifyInSyncOperation(reloadHandler);
        reloadOp.addToVerify(this.connection, sharesToVerify);
        reloadOp.run((IProgressMonitor)progress);
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }

    private void trackAffectedComponents(IComponentHandle component, IComponentHandle previousComponent, Map<UUID, IComponentHandle> affectedComponents) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        affectedComponents.put(component.getItemId(), component);
        if (previousComponent != null && !component.sameItemId((IItemHandle)previousComponent)) {
            affectedComponents.put(previousComponent.getItemId(), previousComponent);
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogString.value(affectedComponents)});
        }
    }

    /*
     * Unable to fully structure code
     */
    private void handleUpdates(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        block29: {
            v0 = mnm = this.dbg.isOn() != false ? new Mnm(){}.get() : null;
            if (this.debug) {
                Debug.enter((IDebugger)this.dbg, (String[])new String[]{MVSReloadingUpdateMutator.cls, mnm});
            }
            ThreadCheck.checkLongOpsAllowed();
            subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)105);
            orderer = new UpdateOrder((Collection)this.updates.getAdds(), (Collection)this.updates.getDeletes(), (Collection)this.updates.getMoves(), (Collection)this.updates.getModifies(), this.rawUpdates);
            maxContentToDownLoad = orderer.getFileMoves().size() + orderer.getFileAdds().size() + orderer.getGroupedModifies().size();
            deferredDownloadInfo = new ArrayList<DeferredFileLoadInformation>(maxContentToDownLoad);
            this.contentSession = FileSystemCore.getContentManager((ITeamRepository)this.repository).createSession(0, true, "", (long)maxContentToDownLoad, (IProgressMonitor)subMonitor.newChild(80));
            progress = new CancellationMonitor((IProgressMonitor)subMonitor);
            isCancelled = false;
            component = null;
            try {
                for (FileAreaUpdate update : orderer.getFolderAdds()) {
                    component = this.getFullComponent(update, component, (IProgressMonitor)progress);
                    this.createFolder(component, update, (IProgressMonitor)progress);
                    this.checkCancelled((IProgressMonitor)progress);
                }
                var11_10 = orderer.getFolderMoves().iterator();
                if (var11_10.hasNext()) {
                    update = (FileAreaUpdate)var11_10.next();
                    throw new IllegalStateException("Moves are not yet supported by this mutator");
                }
                var11_10 = orderer.getLinkMoves().iterator();
                if (var11_10.hasNext()) {
                    update = (FileAreaUpdate)var11_10.next();
                    throw new IllegalStateException("Moves are not yet supported by this mutator");
                }
                var11_10 = orderer.getFileMoves().iterator();
                if (var11_10.hasNext()) {
                    update = (FileAreaUpdate)var11_10.next();
                    throw new IllegalStateException("Moves are not yet supported by this mutator");
                }
                for (FileAreaUpdate update : orderer.getOrderedDeletes()) {
                    component = this.getFullComponent(update, component, (IProgressMonitor)progress);
                    this.deleteSubtree(component, update.getSourceParent(), update.getName(), update.beforeState(), orderer, (IProgressMonitor)progress);
                    orderer.processed(update);
                    this.checkCancelled((IProgressMonitor)progress);
                }
                inaccessibleUpdates = (List)orderer.getInaccessibleUpdates();
                if (!inaccessibleUpdates.isEmpty()) {
                    this.cleanupInaccessible(inaccessibleUpdates, (IProgressMonitor)progress);
                }
                for (FileAreaUpdate update : orderer.getGroupedModifies()) {
                    if (this.isAborted) break;
                    if (update.getItem() instanceof IFileItemHandle) {
                        component = this.getFullComponent(update, component, (IProgressMonitor)progress);
                        this.modifyFile(component, update, deferredDownloadInfo, update.getFileTimestamp(), (IProgressMonitor)progress);
                    } else if (!(update.getItem() instanceof ISymbolicLinkHandle) && update.getItem() instanceof IFolderHandle) {
                        throw new IllegalStateException("Folder modifications are not supported by this mutator");
                    }
                    this.checkCancelled((IProgressMonitor)progress);
                }
                for (FileAreaUpdate update : orderer.getFileAdds()) {
                    if (!this.isAborted) {
                        component = this.getFullComponent(update, component, (IProgressMonitor)progress);
                        this.createFile(component, update, deferredDownloadInfo, update.getFileTimestamp(), (IProgressMonitor)progress);
                        this.checkCancelled((IProgressMonitor)progress);
                        continue;
                    }
                    break block29;
                }
                break block29;
            }
            catch (Throwable var13_13) {
                this.contentSession.join();
                isCancelled = isCancelled != false || progress.isCanceled() != false || this.contentSession.isCanceled() != false || this.isUpdateCancelled(deferredDownloadInfo) != false;
                try {
                    if (isCancelled) ** break block30
                    if (!this.isAborted) {
                        this.doDilemmaHandling(deferredDownloadInfo, (IProgressMonitor)subMonitor.newChild(10));
                        isCancelled = isCancelled != false || this.isUpdateCancelled(deferredDownloadInfo) != false;
                    }
                    break block31;
                }
                finally {
                    nonCancellableMonitor = new NonCancellingProgressMonitor((IProgressMonitor)subMonitor.newChild(5));
                    metaDataMonitor = SubMonitor.convert((IProgressMonitor)nonCancellableMonitor, (int)(deferredDownloadInfo.size() * 4));
                    var18_25 = deferredDownloadInfo.iterator();
                    if (true) ** GOTO lbl84
                }
                {
                    block31: {
                    }
                }
            }
            do {
                if (!(downloadInfo = var18_25.next()).contentUpdated()) continue;
                skipUpdate = this.skipUpdate(downloadInfo.getCopyFileArea().getRoot(), downloadInfo.getComponent(), downloadInfo.getShareable().getRemote((IProgressMonitor)metaDataMonitor.newChild(1)));
                this.updateMetaData(downloadInfo, skipUpdate, (IProgressMonitor)metaDataMonitor.newChild(1));
                if (skipUpdate) continue;
                downloadInfo.getShareable().getFileStorage().setExecutable(downloadInfo.isExecutable(), (IProgressMonitor)metaDataMonitor.newChild(1));
lbl84:
                // 4 sources

            } while (var18_25.hasNext());
            metaDataMonitor.done();
            throw var13_13;
        }
        this.contentSession.join();
        isCancelled = isCancelled != false || progress.isCanceled() != false || this.contentSession.isCanceled() != false || this.isUpdateCancelled(deferredDownloadInfo) != false;
        try {
            if (isCancelled) ** break block32
            if (!this.isAborted) {
                this.doDilemmaHandling(deferredDownloadInfo, (IProgressMonitor)subMonitor.newChild(10));
                isCancelled = isCancelled != false || this.isUpdateCancelled(deferredDownloadInfo) != false;
            }
            break block33;
        }
        finally {
            nonCancellableMonitor = new NonCancellingProgressMonitor((IProgressMonitor)subMonitor.newChild(5));
            metaDataMonitor = SubMonitor.convert((IProgressMonitor)nonCancellableMonitor, (int)(deferredDownloadInfo.size() * 4));
            var18_27 = deferredDownloadInfo.iterator();
            if (true) ** GOTO lbl113
        }
        {
            block33: {
            }
        }
        do {
            if (!(downloadInfo = var18_27.next()).contentUpdated()) continue;
            skipUpdate = this.skipUpdate(downloadInfo.getCopyFileArea().getRoot(), downloadInfo.getComponent(), downloadInfo.getShareable().getRemote((IProgressMonitor)metaDataMonitor.newChild(1)));
            this.updateMetaData(downloadInfo, skipUpdate, (IProgressMonitor)metaDataMonitor.newChild(1));
            if (skipUpdate) continue;
            downloadInfo.getShareable().getFileStorage().setExecutable(downloadInfo.isExecutable(), (IProgressMonitor)metaDataMonitor.newChild(1));
lbl113:
            // 4 sources

        } while (var18_27.hasNext());
        metaDataMonitor.done();
        this.reportDownloadFailures(deferredDownloadInfo, (IProgressMonitor)subMonitor.newChild(5));
        generalErrorMessage = Messages.MVSReloadingUpdateMutator_0;
        if (isCancelled || subMonitor.isCanceled()) {
            failures = this.getErrors();
            if (failures.length > 0 && (multi = new MultiStatus("com.ibm.team.filesystem.client", 0, failures, generalErrorMessage, null)).matches(4)) {
                throw new FileSystemStatusException((IStatus)multi);
            }
            throw new OperationCanceledException();
        }
        this.updateConfigStates((IProgressMonitor)subMonitor.newChild(5));
        this.handleDeletedContent(deferredDownloadInfo, (IProgressMonitor)subMonitor.newChild(5));
        failures = this.getErrors();
        if (failures.length > 0 && (multi = new MultiStatus("com.ibm.team.filesystem.client", 0, failures, generalErrorMessage, null)).matches(4)) {
            throw new FileSystemStatusException((IStatus)multi);
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{MVSReloadingUpdateMutator.cls, mnm});
        }
    }

    @Override
    protected int notifyHandlerOfDeletedContent(List<IShareable> contentDeleted) {
        return this.problemHandler.deletedContent(contentDeleted);
    }

    @Override
    protected String getDeletedContentMessage() {
        return Messages.MVSReloadingUpdateMutator_11;
    }

    /*
     * WARNING - void declaration
     */
    private void cleanupInaccessible(List<FileAreaUpdate> inaccessibles, IProgressMonitor monitor) throws TeamRepositoryException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        SubMonitor totalProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 * inaccessibles.size()));
        HashMap<Shareable, IComponent> shareablesToDelete = new HashMap<Shareable, IComponent>();
        IComponent component = null;
        for (FileAreaUpdate inaccessibleUpdate : inaccessibles) {
            void var9_13;
            if (!inaccessibleUpdate.isChangeType(8)) {
                IComponentHandle iComponentHandle = inaccessibleUpdate.getComponent();
            } else {
                IComponentHandle iComponentHandle = inaccessibleUpdate.getPreviousComponent();
            }
            component = this.getFullComponent((IComponentHandle)var9_13, component, monitor);
            if (!this.isComponentShared((IComponentHandle)component, (IProgressMonitor)totalProgress.newChild(1))) continue;
            IVersionableHandle item = inaccessibleUpdate.getItem();
            List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(component.getItemId());
            SubMonitor subMonitor = totalProgress.newChild(1);
            subMonitor.setWorkRemaining(copyFileAreas.size() * 100);
            for (ICopyFileArea cfa : copyFileAreas) {
                Shareable toDeleteShareable;
                SubMonitor progress = subMonitor.newChild(100);
                progress.subTask(SCMEEMessages.UpdateMutator_0);
                IRelativeLocation toDeletePath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)component, item, (IProgressMonitor)progress.newChild(1));
                if (toDeletePath == null) {
                    if (inaccessibleUpdate.isChangeType(8) && !component.sameItemId((IItemHandle)inaccessibleUpdate.getComponent())) {
                        IComponentHandle iComponentHandle = inaccessibleUpdate.getComponent();
                        component = this.getFullComponent(iComponentHandle, component, monitor);
                        toDeletePath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)component, item, (IProgressMonitor)progress.newChild(1));
                    }
                    if (toDeletePath == null) {
                        cfa.forget(this.connectionHandle, (IComponentHandle)component, item, null);
                        continue;
                    }
                }
                if (!(toDeleteShareable = new Shareable(cfa.getRoot(), toDeletePath, ResourceType.getResourceType((IVersionableHandle)item))).exists((IProgressMonitor)progress.newChild(1))) {
                    FileItemInfo info = cfa.getItemInfo(toDeletePath);
                    if (info == null) {
                        SharingManager.getInstance().forget(cfa.getRoot(), this.connectionHandle, (IComponentHandle)component, item, (IProgressMonitor)progress.newChild(1));
                        continue;
                    }
                    SharingManager.getInstance().forget((IShareableInternal)toDeleteShareable, (IProgressMonitor)progress.newChild(1));
                    continue;
                }
                if (!(item instanceof IFileItemHandle)) continue;
                if (inaccessibleUpdate.isChangeType(2)) {
                    this.deleteSubtree(component, toDeleteShareable, (IProgressMonitor)progress.newChild(98));
                    continue;
                }
                shareablesToDelete.put(toDeleteShareable, component);
            }
        }
        if (!shareablesToDelete.isEmpty()) {
            totalProgress.setWorkRemaining(shareablesToDelete.size());
            ArrayList inaccessibleShareables = new ArrayList(shareablesToDelete.keySet());
            int direction = this.problemHandler.inaccessibleForUpdate(inaccessibleShareables);
            if (direction == 1) {
                throw new OperationCanceledException();
            }
            if (direction == 0) {
                for (Map.Entry entry : shareablesToDelete.entrySet()) {
                    this.deleteSubtree((IComponent)entry.getValue(), (Shareable)entry.getKey(), (IProgressMonitor)totalProgress.newChild(1));
                }
            } else {
                MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, SCMEEMessages.UpdateMutator_1, null);
                for (Map.Entry entry : shareablesToDelete.entrySet()) {
                    this.recordInconsistentShare((IComponentHandle)entry.getValue(), ((Shareable)entry.getKey()).getShare((IProgressMonitor)totalProgress.newChild(1)));
                    multiStatus.add(FileSystemStatusUtil.getStatusFor((int)4, (String)NLS.bind((String)SCMEEMessages.UpdateMutator_2, (Object)((Shareable)entry.getKey()).getLocalPath().toString(), (Object[])new Object[0])));
                }
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }

    private final void createFile(IComponent component, FileAreaUpdate update, ArrayList<DeferredFileLoadInformation> deferredDownloadInfo, Date date, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        IDataSetDefinition dataSetDefinition;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        SubMonitor totalProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)101);
        IFileItemHandle fileItemState = (IFileItemHandle)update.afterState();
        if (!this.isComponentShared((IComponentHandle)component, (IProgressMonitor)totalProgress.newChild(1))) {
            if (this.debug) {
                Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, "not shared"});
            }
            return;
        }
        boolean needToVerifyDataSetExists = false;
        IFolderHandle parent = update.getDestinationParent();
        Map<UUID, IDataSetDefinition> foldersInComponent = this.definitionsEncountered.get(update.getComponent().getItemId());
        if (foldersInComponent == null || !foldersInComponent.containsKey(parent.getItemId())) {
            needToVerifyDataSetExists = true;
        }
        if ((dataSetDefinition = this.getFileDataSetDefinition(update, monitor)) == null) {
            if (this.debug) {
                Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, "not loaded"});
            }
            return;
        }
        IRelativeLocation path = MVSReloadingUpdateMutator.getLocation(update, dataSetDefinition);
        List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(component.getItemId());
        totalProgress.setWorkRemaining(100 * copyFileAreas.size());
        for (ICopyFileArea cfa : copyFileAreas) {
            IRelativeLocation dsPath;
            IShareableInternal datasetShareable;
            SubMonitor progress = totalProgress.newChild(100);
            String errorMsgFileName = cfa.getRoot().append(path).toOSString();
            ISandbox sandbox = SharingManager.getInstance().getSandbox(cfa.getRoot(), false);
            Shareable existingNewFileShareable = (Shareable)SharingManager.getInstance().findShareable(cfa.getRoot(), this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)fileItemState, (IProgressMonitor)progress.newChild(1));
            if (existingNewFileShareable != null && !existingNewFileShareable.getLocalPath().equals((Object)path)) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)new FileSystemException(NLS.bind((String)Messages.MVSReloadingUpdateMutator_1, (Object)existingNewFileShareable.getFullPath().toOSString(), (Object[])new Object[]{errorMsgFileName, component.getName()}))));
                this.recordInconsistentShare((IComponentHandle)component, existingNewFileShareable.getShare((IProgressMonitor)progress.newChild(1)));
                continue;
            }
            Shareable potentialCollision = new Shareable(cfa.getRoot(), path, ResourceType.FILE);
            IShare share = potentialCollision.getShare((IProgressMonitor)progress.newChild(1));
            if (!(share == null || share.getSharingDescriptor().getConnectionHandle().sameItemId((IItemHandle)this.connectionHandle) && share.getSharingDescriptor().getComponent().sameItemId((IItemHandle)component) && share.getSharingDescriptor().getRootVersionable().sameItemId((IItemHandle)fileItemState))) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)new FileSystemException(NLS.bind((String)Messages.MVSReloadingUpdateMutator_2, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()}))));
                if (existingNewFileShareable == null) continue;
                this.recordInconsistentShare((IComponentHandle)component, existingNewFileShareable.getShare((IProgressMonitor)progress.newChild(1)));
                continue;
            }
            if (potentialCollision.exists((IProgressMonitor)progress.newChild(1))) {
                potentialCollision.getFileStorage().delete(this.shed, (IProgressMonitor)progress.newChild(1));
            }
            if (needToVerifyDataSetExists && !(datasetShareable = (IShareableInternal)sandbox.findShareable(dsPath = path.getParent(), ResourceType.FOLDER)).exists((IProgressMonitor)progress.newChild(1))) {
                datasetShareable.getFileStorage().create(true, (Object)dataSetDefinition, (IProgressMonitor)progress.newChild(1));
            }
            progress.setWorkRemaining(100);
            Shareable fileToCreate = new Shareable(cfa.getRoot(), path, ResourceType.FILE);
            Map<String, byte[]> clientData = new ZSharingData((IDataSetDefinitionHandle)dataSetDefinition).getClientData();
            SharingDescriptor descriptor = SharingDescriptor.create((IConnection)this.connection, (IComponent)component, (IVersionableHandle)fileItemState, (IFolderHandle)parent, clientData);
            DeferredFileLoadInformation deferredDownload = new DeferredFileLoadInformation(cfa, (IShareableInternal)potentialCollision, update, (ISharingDescriptor)descriptor, null);
            deferredDownloadInfo.add(deferredDownload);
            boolean skipWrite = this.skipUpdate(cfa.getRoot(), (IComponentHandle)component, (IVersionableHandle)fileItemState);
            this.storeFileContent(deferredDownload, (IShareableInternal)fileToCreate, skipWrite, (IProgressMonitor)progress);
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }

    private void recordInconsistentShare(IComponentHandle component, IShare share) {
        if (share != null) {
            Set<IShare> sharesInComponent = this.inconsistentShares.get(component.getItemId());
            if (sharesInComponent == null) {
                sharesInComponent = new HashSet<IShare>();
                this.inconsistentShares.put(component.getItemId(), sharesInComponent);
            }
            sharesInComponent.add(share);
        }
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
    }

    private final void createFolder(IComponent component, FileAreaUpdate update, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        IDataSetDefinition dataSetDefinition;
        SubMonitor totalProgress;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        if (!this.isComponentShared((IComponentHandle)component, (IProgressMonitor)(totalProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)105)).newChild(1))) {
            return;
        }
        try {
            dataSetDefinition = this.getFolderDataSetDefinition(update.getName(), update, (IProgressMonitor)totalProgress.newChild(4));
            this.recordFolderEncountered(update.getComponent(), update.getItem(), dataSetDefinition);
            if (dataSetDefinition == null) {
                return;
            }
        }
        catch (TeamRepositoryException e) {
            this.collectStatus((IStatus)new Status(4, "com.ibm.teamz.fileagent", NLS.bind((String)Messages.MVSLoadMutator_7, (Object)update.getName(), (Object[])new Object[]{component.getName()}), (Throwable)e));
            return;
        }
        List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(component.getItemId());
        totalProgress.setWorkRemaining(100 * copyFileAreas.size());
        for (ICopyFileArea cfa : copyFileAreas) {
            SubMonitor progress = totalProgress.newChild(100);
            ISandbox sandbox = SharingManager.getInstance().getSandbox(cfa.getRoot(), false);
            IRelativeLocation path = MVSReloadingUpdateMutator.getLocation(update, dataSetDefinition);
            try {
                IShareableInternal shareable = (IShareableInternal)sandbox.findShareable(path, ResourceType.FOLDER);
                if (shareable.exists((IProgressMonitor)progress.newChild(5))) continue;
                shareable.getFileStorage().create(true, (Object)dataSetDefinition, (IProgressMonitor)progress.newChild(80));
            }
            catch (FileSystemException e) {
                this.collectStatus((IStatus)new Status(4, "com.ibm.teamz.fileagent", NLS.bind((String)Messages.MVSLoadMutator_8, (Object)sandbox.getRoot().append(path).toOSString(), (Object[])new Object[]{update.getName(), component.getName()}), (Throwable)e));
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }

    private void recordFolderEncountered(IComponentHandle component, IVersionableHandle item, IDataSetDefinition dataSetDefinition) {
        Map<UUID, IDataSetDefinition> foldersInComponent;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        if ((foldersInComponent = this.definitionsEncountered.get(component.getItemId())) == null) {
            foldersInComponent = new HashMap<UUID, IDataSetDefinition>();
            this.definitionsEncountered.put(component.getItemId(), foldersInComponent);
        }
        foldersInComponent.put(item.getItemId(), dataSetDefinition);
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }

    private IDataSetDefinition getFolderDataSetDefinition(String errorName, FileAreaUpdate update, IProgressMonitor cMon) throws TeamRepositoryException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        IDataSetDefinition dataSetDefinition = null;
        IVersionableHandle item = update.afterState();
        String uuid = (String)update.getProperties().get("team.enterprise.resource.definition");
        if (uuid != null) {
            IDataSetDefinitionHandle dataSetDefinitionHandle = (IDataSetDefinitionHandle)IDataSetDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), null);
            dataSetDefinition = this.getCachedDataSetDefinition(errorName, this.repository, dataSetDefinitionHandle, cMon);
        }
        this.recordFolderEncountered(update.getComponent(), item, dataSetDefinition);
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((IItem)dataSetDefinition)});
        }
        return dataSetDefinition;
    }

    private IDataSetDefinition getFileDataSetDefinition(FileAreaUpdate update, IProgressMonitor cMon) throws TeamRepositoryException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        IDataSetDefinition dataSetDefinition = null;
        Map<UUID, IDataSetDefinition> foldersInComponents = this.definitionsEncountered.get(update.getComponent().getItemId());
        if (foldersInComponents != null && foldersInComponents.containsKey(update.getDestinationParent().getItemId())) {
            dataSetDefinition = foldersInComponents.get(update.getDestinationParent().getItemId());
        } else {
            IFolderHandle parentFolderHandle = update.getDestinationParent();
            if (parentFolderHandle != null) {
                IConfiguration configuration = this.connection instanceof IWorkspaceConnection ? ((IWorkspaceConnection)this.connection).configuration(update.component()) : ((IBaselineConnection)this.connection).configuration();
                IFolder parentFolder = null;
                try {
                    parentFolder = (IFolder)configuration.fetchCompleteItem((IVersionableHandle)update.parent(), cMon);
                }
                catch (VersionablePermissionDeniedException versionablePermissionDeniedException) {
                    // empty catch block
                }
                if (parentFolder != null) {
                    String uuid = (String)parentFolder.getUserProperties().get("team.enterprise.resource.definition");
                    if (uuid != null) {
                        IDataSetDefinitionHandle dataSetDefinitionHandle = (IDataSetDefinitionHandle)IDataSetDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), null);
                        dataSetDefinition = this.getCachedDataSetDefinition(update.getName(), this.repository, dataSetDefinitionHandle, cMon);
                    }
                    this.recordFolderEncountered(update.getComponent(), (IVersionableHandle)parentFolderHandle, dataSetDefinition);
                }
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((IItem)dataSetDefinition)});
        }
        return dataSetDefinition;
    }

    private final void deleteSubtree(IComponent component, IFolderHandle parent, String name, IVersionableHandle itemState, UpdateOrder updateInfo, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor totalProgress;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        if (!this.isComponentShared((IComponentHandle)component, (IProgressMonitor)(totalProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)101)).newChild(1))) {
            if (this.debug) {
                Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, "skip"});
            }
            return;
        }
        List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(component.getItemId());
        totalProgress.setWorkRemaining(100 * copyFileAreas.size());
        for (ICopyFileArea cfa : copyFileAreas) {
            Shareable toDeleteShareable;
            SubMonitor progress = totalProgress.newChild(100);
            if (parent == null) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor((int)4, (String)NLS.bind((String)Messages.MVSReloadingUpdateMutator_3, (Object)component.getName(), (Object[])new Object[0]), null));
                this.recordInconsistentComponent(cfa, (IComponentHandle)component, (IProgressMonitor)progress.newChild(1));
                continue;
            }
            IRelativeLocation toDeletePath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)component, itemState, (IProgressMonitor)progress.newChild(1));
            if (toDeletePath == null) {
                IComponentHandle alternateComponent = updateInfo.getCurrentComponent(component, parent);
                if (alternateComponent != null) {
                    toDeletePath = cfa.getLocalPathFor(this.connectionHandle, alternateComponent, itemState, (IProgressMonitor)progress.newChild(1));
                    component = (IComponent)this.connection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)alternateComponent, 0, (IProgressMonitor)totalProgress.newChild(1));
                }
                if (toDeletePath == null) {
                    SharingManager.getInstance().forget(cfa.getRoot(), this.connectionHandle, (IComponentHandle)component, itemState, (IProgressMonitor)progress.newChild(1));
                    continue;
                }
            }
            if (!(toDeleteShareable = new Shareable(cfa.getRoot(), toDeletePath, ResourceType.getResourceType((IVersionableHandle)itemState))).exists((IProgressMonitor)progress.newChild(1))) {
                FileItemInfo info = cfa.getItemInfo(toDeletePath);
                if (info == null) {
                    SharingManager.getInstance().forget(cfa.getRoot(), this.connectionHandle, (IComponentHandle)component, itemState, (IProgressMonitor)progress.newChild(1));
                    continue;
                }
                SharingManager.getInstance().forget((IShareableInternal)toDeleteShareable, (IProgressMonitor)progress.newChild(1));
                continue;
            }
            if (!(itemState instanceof IFileItemHandle)) continue;
            this.deleteSubtree(component, toDeleteShareable, (IProgressMonitor)progress.newChild(98));
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }

    private void deleteSubtree(IComponent component, Shareable toDeleteShareable, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress;
        IVersionableHandle remote;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        if ((remote = toDeleteShareable.getRemote((IProgressMonitor)(progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100)).newChild(1))) == null || !this.skipUpdate(toDeleteShareable.getCopyFileAreaRoot(), (IComponentHandle)component, remote)) {
            final IFileStorage storage = toDeleteShareable.getFileStorage();
            try {
                SharingManager.getInstance().doSilentChange(new SharingManager.FileSystemAccessor(){

                    public void run() throws FileSystemException {
                        storage.delete(MVSReloadingUpdateMutator.this.shed, (IProgressMonitor)progress.newChild(50));
                    }
                });
            }
            catch (FileSystemException e) {
                this.recordInconsistentShare((IComponentHandle)component, toDeleteShareable.getShare((IProgressMonitor)progress.newChild(1)));
                this.collectStatus(FileSystemStatusUtil.getStatusFor((int)4, (String)NLS.bind((String)Messages.MVSReloadingUpdateMutator_4, (Object)toDeleteShareable.getFullPath().toOSString(), (Object[])new Object[]{component.getName()}), (Throwable)e));
            }
        }
        toDeleteShareable.forget((IProgressMonitor)progress.newChild(50));
        progress.done();
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }

    protected final void modifyFile(IComponent component, FileAreaUpdate update, ArrayList<DeferredFileLoadInformation> deferredDownloadInfo, Date timestamp, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor totalProgress;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        if (!this.isComponentShared((IComponentHandle)component, (IProgressMonitor)(totalProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)101)).newChild(1))) {
            return;
        }
        List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(component.getItemId());
        totalProgress.setWorkRemaining(100 * copyFileAreas.size());
        IFileItemHandle fileItemState = (IFileItemHandle)update.afterState();
        for (ICopyFileArea cfa : copyFileAreas) {
            SubMonitor progress = totalProgress.newChild(100);
            String errorMsgFileName = update.getName();
            try {
                IRelativeLocation toModifyPath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)fileItemState, (IProgressMonitor)progress.newChild(1));
                if (toModifyPath == null) {
                    InverseFileItemInfo info = cfa.getItemInfo((IVersionableHandle)fileItemState, (IComponentHandle)component, this.connectionHandle, false);
                    if (info == null) continue;
                    IRelativeLocation remotePath = cfa.getRemotePathFor(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)fileItemState, (IProgressMonitor)progress.newChild(1));
                    if (remotePath != null) {
                        errorMsgFileName = cfa.getRoot().append(remotePath).toOSString();
                    }
                    this.collectStatus(FileSystemStatusUtil.getStatusFor((int)2, (String)NLS.bind((String)Messages.MVSReloadingUpdateMutator_5, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
                    continue;
                }
                errorMsgFileName = toModifyPath.toString();
                ISandbox sandbox = SharingManager.getInstance().getSandbox(cfa.getRoot(), false);
                IShareable toModifyShareable = sandbox.findShareable(toModifyPath, ResourceType.FILE);
                ResourceType resourceType = toModifyShareable.getResourceType((IProgressMonitor)progress.newChild(1));
                if (resourceType == null) {
                    IRelativeLocation dsPath;
                    IShareableInternal datasetShareable;
                    IDataSetDefinition dataSetDefinition;
                    boolean needToVerifyDataSetExists = false;
                    IFolderHandle parent = update.getDestinationParent();
                    Map<UUID, IDataSetDefinition> foldersInComponent = this.definitionsEncountered.get(update.getComponent().getItemId());
                    if (foldersInComponent == null || !foldersInComponent.containsKey(parent.getItemId())) {
                        needToVerifyDataSetExists = true;
                    }
                    if ((dataSetDefinition = this.getFileDataSetDefinition(update, monitor)) == null) {
                        SharingManager.getInstance().forget(cfa.getRoot(), this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)fileItemState, (IProgressMonitor)progress.newChild(1));
                    }
                    IRelativeLocation path = MVSReloadingUpdateMutator.getLocation(update, dataSetDefinition);
                    if (needToVerifyDataSetExists && !(datasetShareable = (IShareableInternal)sandbox.findShareable(dsPath = path.getParent(), ResourceType.FOLDER)).exists((IProgressMonitor)progress.newChild(1))) {
                        datasetShareable.getFileStorage().create(true, (Object)dataSetDefinition, (IProgressMonitor)progress.newChild(1));
                    }
                    Map<String, byte[]> clientData = new ZSharingData((IDataSetDefinitionHandle)dataSetDefinition).getClientData();
                    SharingDescriptor descriptor = SharingDescriptor.create((IConnection)this.connection, (IComponent)component, (IVersionableHandle)fileItemState, (IFolderHandle)parent, clientData);
                    DeferredFileLoadInformation deferredDownload = new DeferredFileLoadInformation(cfa, (IShareableInternal)toModifyShareable, update, (ISharingDescriptor)descriptor, null);
                    deferredDownloadInfo.add(deferredDownload);
                    boolean skipWrite = this.skipUpdate(cfa.getRoot(), deferredDownload.getComponent(), toModifyShareable.getRemote((IProgressMonitor)progress));
                    this.storeFileContent(deferredDownload, (IShareableInternal)toModifyShareable, skipWrite, (IProgressMonitor)progress);
                    continue;
                }
                if (resourceType == ResourceType.FILE) {
                    ISharingDescriptor oldDescriptor = toModifyShareable.getShare((IProgressMonitor)progress).getSharingDescriptor();
                    Map<String, byte[]> clientData = null;
                    ZSharingData sharingData = ZSharingData.createFrom(oldDescriptor);
                    if (sharingData != null) {
                        clientData = sharingData.getClientData();
                    }
                    SharingDescriptor descriptor = SharingDescriptor.create((IConnection)this.connection, (IComponent)component, (IVersionableHandle)fileItemState, (IFolderHandle)update.getDestinationParent(), clientData);
                    DeferredFileLoadInformation deferredDownload = new DeferredFileLoadInformation(cfa, (IShareableInternal)toModifyShareable, update, (ISharingDescriptor)descriptor, new Date(((IShareableInternal)toModifyShareable).getFileStorage().getModificationStamp()));
                    deferredDownloadInfo.add(deferredDownload);
                    boolean skipWrite = this.skipUpdate(toModifyShareable.getSandbox().getRoot(), deferredDownload.getComponent(), toModifyShareable.getRemote((IProgressMonitor)progress));
                    this.storeFileContent(deferredDownload, (IShareableInternal)toModifyShareable, skipWrite, (IProgressMonitor)progress);
                    continue;
                }
                this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)new FileSystemException(NLS.bind((String)Messages.MVSReloadingUpdateMutator_6, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()}))));
                this.recordInconsistentShare((IComponentHandle)component, toModifyShareable.getShare((IProgressMonitor)progress.newChild(1)));
            }
            finally {
                progress.done();
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }

    private void storeFileContent(DeferredFileLoadInformation downloadInfo, IShareableInternal shareable, boolean skipWrite, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        if (skipWrite && shareable.getRemote((IProgressMonitor)monitor.newChild(1)) != null && !FileSystemCore.getContentManager((ITeamRepository)this.repository).convertDelimitersDuringRetrieval(downloadInfo.getContent())) {
            IFileContent content = downloadInfo.getContent();
            downloadInfo.setContentUpdated(content.getHash(), content.getRawLength());
        } else {
            this.contentSession.retrieveContent((IFileItemHandle)downloadInfo.getFileItemState(), downloadInfo.getContent(), (FileDownloadHandler)new DownloadHandler(shareable, downloadInfo, this.downloadMonitor, false, this.shed));
            this.checkIsAborted(downloadInfo);
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }

    protected final boolean isComponentShared(IComponentHandle component, IProgressMonitor monitor) throws FileSystemException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        if (component.sameItemId((IItemHandle)this.lastComponentShareTested)) {
            if (this.debug) {
                Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, "0", LogField.valueOf((boolean)this.lastComponentSharedResult)});
            }
            return this.lastComponentSharedResult;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.copyFileAreasToUpdate.size());
        this.lastComponentShareTested = component;
        List<ICopyFileArea> cfas = this.copyFileAreasByComponent.get(component.getItemId());
        if (cfas != null) {
            this.lastComponentSharedResult = true;
            if (this.debug) {
                Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, "1", LogField.valueOf((boolean)this.lastComponentSharedResult)});
            }
            return this.lastComponentSharedResult;
        }
        if (this.componentNotShared.contains(component.getItemId())) {
            this.lastComponentSharedResult = false;
            if (this.debug) {
                Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, "2", LogField.valueOf((boolean)this.lastComponentSharedResult)});
            }
            return this.lastComponentSharedResult;
        }
        cfas = new ArrayList<ICopyFileArea>(2);
        for (ICopyFileArea cfa : this.copyFileAreasToUpdate) {
            if (!cfa.isConfigurationShared(this.connectionHandle, component, (IProgressMonitor)progress.newChild(1))) continue;
            cfas.add(cfa);
        }
        boolean bl = this.lastComponentSharedResult = !cfas.isEmpty();
        if (this.lastComponentSharedResult) {
            this.copyFileAreasByComponent.put(component.getItemId(), cfas);
        } else {
            this.componentNotShared.add(component.getItemId());
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, "3", LogField.valueOf((boolean)this.lastComponentSharedResult)});
        }
        return this.lastComponentSharedResult;
    }

    private void recordInconsistentComponent(ICopyFileArea cfa, IComponentHandle component, IProgressMonitor monitor) throws FileSystemException {
        Collection sharesNowInconsistent = cfa.allShares(this.connectionHandle, component, monitor);
        for (IShare share : sharesNowInconsistent) {
            this.recordInconsistentShare(component, share);
        }
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
    }

    private boolean isUpdateCancelled(ArrayList<DeferredFileLoadInformation> deferredDownloadInfo) {
        boolean result = false;
        for (DeferredFileLoadInformation info : deferredDownloadInfo) {
            if (info.getFailure() == null || !(this.getCauseOfFailure(info) instanceof OperationCanceledException)) continue;
            result = true;
            break;
        }
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), Boolean.toString(result)});
        }
        return result;
    }

    private void doDilemmaHandling(ArrayList<DeferredFileLoadInformation> deferredDownloadInfo, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.setWorkRemaining(100);
        ArrayList<DeferredFileLoadInformation> encodingFailures = new ArrayList<DeferredFileLoadInformation>();
        for (DeferredFileLoadInformation deferredUpdateInformation : deferredDownloadInfo) {
            if (deferredUpdateInformation == null || deferredUpdateInformation.getFailure() == null) continue;
            Throwable rootCause = deferredUpdateInformation.getFailure().getCause();
            int digParanoiaCount = 0;
            while (rootCause instanceof TeamRepositoryException && digParanoiaCount < 50) {
                Throwable cause = ((TeamRepositoryException)rootCause).getCause();
                if (cause == null) break;
                rootCause = cause;
                ++digParanoiaCount;
            }
            if (rootCause instanceof UnsupportedEncodingException || rootCause instanceof UnsupportedCharsetException) {
                encodingFailures.add(deferredUpdateInformation);
                continue;
            }
            if (!(rootCause instanceof OperationCanceledException)) continue;
            throw new OperationCanceledException();
        }
        if (encodingFailures.size() > 0) {
            this.contentSession = FileSystemCore.getContentManager((ITeamRepository)this.repository).createSession(0, true, "", (long)encodingFailures.size(), (IProgressMonitor)progress.newChild(75));
            boolean moreContentUploaded = false;
            try {
                if (Charset.isSupported("ISO-8859-1")) {
                    for (DeferredFileLoadInformation failure : encodingFailures) {
                        failure.setAlternateEncoding("ISO-8859-1");
                        IVersionableHandle fileItemState = failure.getFileItemState();
                        this.contentSession.retrieveContent((IFileItemHandle)fileItemState, failure.getContent(), failure.getEncoding(), failure.getLineDelimiter(), (FileDownloadHandler)new DownloadHandler(failure.getShareable(), failure, this.downloadMonitor, false, this.shed));
                        if (this.checkIsAborted(failure)) {
                            return;
                        }
                        moreContentUploaded = true;
                    }
                }
            }
            finally {
                if (moreContentUploaded) {
                    this.contentSession.join();
                }
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }

    private void reportDownloadFailures(ArrayList<DeferredFileLoadInformation> deferredDownloadInfo, IProgressMonitor monitor) throws FileSystemException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)deferredDownloadInfo.size());
        boolean reportedSupportedCharSets = false;
        for (DeferredFileLoadInformation deferredUpdateInformation : deferredDownloadInfo) {
            IStatus status;
            if (deferredUpdateInformation == null || deferredUpdateInformation.getFailure() == null) continue;
            Throwable rootCause = this.getCauseOfFailure(deferredUpdateInformation);
            if (rootCause instanceof UnsupportedEncodingException || rootCause instanceof UnsupportedCharsetException) {
                if (!reportedSupportedCharSets) {
                    StringBuffer charSetsAvailable = new StringBuffer();
                    for (String charsetName : Charset.availableCharsets().keySet()) {
                        charSetsAvailable.append(charsetName).append(' ');
                    }
                    IStatus infoStatus = FileSystemStatusUtil.getStatusFor((int)1, (String)NLS.bind((String)Messages.MVSReloadingUpdateMutator_7, (Object)charSetsAvailable.toString(), (Object[])new Object[0]));
                    this.collectStatus(infoStatus);
                    reportedSupportedCharSets = true;
                }
                status = FileSystemStatusUtil.getStatusFor((int)4, (String)NLS.bind((String)Messages.MVSReloadingUpdateMutator_8, (Object)deferredUpdateInformation.getShareable().getFullPath().toOSString(), (Object[])new Object[]{deferredUpdateInformation.getContent().getCharacterEncoding()}), (Throwable)deferredUpdateInformation.getFailure());
            } else if (rootCause instanceof CharacterCodingException) {
                status = FileSystemStatusUtil.getStatusFor((int)4, (String)NLS.bind((String)Messages.MVSReloadingUpdateMutator_9, (Object)deferredUpdateInformation.getShareable().getFullPath().toOSString(), (Object[])new Object[]{deferredUpdateInformation.getContent().getCharacterEncoding()}), (Throwable)deferredUpdateInformation.getFailure());
            } else {
                if (rootCause instanceof OperationCanceledException) continue;
                status = FileSystemStatusUtil.getStatusFor((int)4, (String)NLS.bind((String)Messages.MVSReloadingUpdateMutator_10, (Object)deferredUpdateInformation.getShareable().getFullPath().toOSString(), (Object[])new Object[0]), (Throwable)deferredUpdateInformation.getFailure());
            }
            this.collectStatus(status);
            IShare share = null;
            try {
                share = deferredUpdateInformation.getShareable().getShare((IProgressMonitor)progress.newChild(1));
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
            if (share == null) {
                this.recordInconsistentComponent(deferredUpdateInformation.getCopyFileArea(), deferredUpdateInformation.getComponent(), (IProgressMonitor)progress.newChild(1));
                continue;
            }
            this.recordInconsistentShare(deferredUpdateInformation.getComponent(), deferredUpdateInformation.getShareable().getShare((IProgressMonitor)progress.newChild(1)));
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }

    private Throwable getCauseOfFailure(DeferredFileLoadInformation deferredUpdateInformation) {
        Throwable rootCause = deferredUpdateInformation.getFailure().getCause();
        if (rootCause == null) {
            rootCause = deferredUpdateInformation.getFailure();
        }
        int paranoiaCount = 0;
        while (rootCause instanceof TeamRepositoryException && paranoiaCount < 50) {
            Throwable cause = ((TeamRepositoryException)rootCause).getCause();
            if (cause == null) break;
            rootCause = cause;
            ++paranoiaCount;
        }
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), rootCause.getMessage()});
        }
        return rootCause;
    }

    protected void updateMetaData(DeferredFileLoadInformation downloadInfo, boolean skipUpdate, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)new NonCancellingProgressMonitor(monitor), (int)100);
        IShareableInternal shareable = downloadInfo.getShareable();
        IFileStorage file = shareable.getFileStorage();
        if (file != null) {
            boolean isLoadedWithAnotherName;
            String name;
            IFolderHandle parent;
            long modificationStamp = file.getModificationStamp();
            FileContent content = (FileContent)downloadInfo.getContent();
            FileItemInfo oldInfo = downloadInfo.getCopyFileArea().getItemInfo(shareable.getLocalPath());
            if (oldInfo == null) {
                parent = downloadInfo.getRemoteParent();
                name = downloadInfo.getRemoteName();
                isLoadedWithAnotherName = PathUtils.isLoadedWithAnotherName((ISandbox)shareable.getSandbox(), (IRelativeLocation)shareable.getLocalPath(), (String)name);
            } else {
                parent = oldInfo.getParent();
                name = oldInfo.getName();
                isLoadedWithAnotherName = oldInfo.isLoadedWithAnotherName();
            }
            FileItemInfoProxy infoProxy = new FileItemInfoProxy(downloadInfo.getFileItemState(), parent, name, isLoadedWithAnotherName);
            infoProxy.setContentInfo(modificationStamp, downloadInfo.getHash(), downloadInfo.getContentSize(), content);
            infoProxy.setExecutable(downloadInfo.isExecutable(), downloadInfo.isExecutable());
            infoProxy.setContentType(downloadInfo.getContentType());
            if (skipUpdate) {
                infoProxy.setContentChanged(true, modificationStamp);
            }
            ISharingDescriptor sharingDescriptor = downloadInfo.getSharingDescriptor();
            IShare share = SharingManager.getInstance().share(shareable, sharingDescriptor, infoProxy.getFileItemInfo(), downloadInfo.getMetadataProperties(), 2, (IProgressMonitor)progress);
            Set<IShare> sharesInComponent = this.newShares.get(downloadInfo.getComponent().getItemId());
            if (sharesInComponent == null) {
                sharesInComponent = new HashSet<IShare>();
                this.newShares.put(downloadInfo.getComponent().getItemId(), sharesInComponent);
            }
            sharesInComponent.add(share);
            if (skipUpdate && !shareable.exists((IProgressMonitor)progress.newChild(1))) {
                downloadInfo.getCopyFileArea().makePendingDeletion(downloadInfo.getShareable().getLocalPath(), (IProgressMonitor)progress);
            }
        }
        progress.done();
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }

    private IComponent getFullComponent(FileAreaUpdate update, IComponent currentComponent, IProgressMonitor monitor) throws TeamRepositoryException {
        IComponentHandle component = update.component();
        return this.getFullComponent(component, currentComponent, monitor);
    }

    private IComponent getFullComponent(IComponentHandle component, IComponent currentComponent, IProgressMonitor monitor) throws TeamRepositoryException {
        IComponent result = null;
        if (component instanceof IComponent) {
            result = (IComponent)component;
        }
        if (result == null && !component.sameItemId((IItemHandle)currentComponent)) {
            result = (IComponent)this.repository.itemManager().fetchCompleteItem((IItemHandle)component, 0, monitor);
        }
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), LogField.valueOf((IItem)result)});
        }
        return result;
    }

    private void updateConfigStates(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        SubMonitor progress;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.newShares.size() + this.inconsistentShares.size() + this.componentStatesAfter.size()));
        for (Map.Entry<UUID, Set<IShare>> entry : this.newShares.entrySet()) {
            progress = subMonitor.newChild(1);
            Set<IShare> newSharesInComponent = entry.getValue();
            Set<IShare> inconsistentSharesInComponent = this.inconsistentShares.get(entry.getKey());
            if (inconsistentSharesInComponent != null) {
                newSharesInComponent.removeAll(inconsistentSharesInComponent);
            }
            progress.setWorkRemaining(newSharesInComponent.size());
            IComponentStateSummary summary = this.componentStatesAfter.get(entry.getKey());
            for (IShare newShare : newSharesInComponent) {
                ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(newShare.getSandbox().getRoot());
                cfa.setConfigurationState(this.connectionHandle, newShare.getSharingDescriptor().getComponent(), newShare.getSharingDescriptor().getRootVersionable(), summary.getConfigurationTime(), (IProgressMonitor)progress.newChild(1));
            }
        }
        for (Map.Entry<UUID, Set<IShare>> entry : this.inconsistentShares.entrySet()) {
            progress = subMonitor.newChild(1);
            Set<IShare> inconsistentSharesInComponent = entry.getValue();
            progress.setWorkRemaining(inconsistentSharesInComponent.size());
            for (IShare inconsistentShare : inconsistentSharesInComponent) {
                ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(inconsistentShare.getSandbox().getRoot());
                cfa.setUnknownConfigurationState(this.connectionHandle, inconsistentShare.getSharingDescriptor().getComponent(), inconsistentShare.getShareable().getLocalPath(), (IProgressMonitor)subMonitor.newChild(1));
            }
        }
        for (IComponentStateSummary stateAfter : this.componentStatesAfter.values()) {
            IComponentStateSummary stateBefore = this.componentStatesBefore.get(stateAfter.getComponent().getItemId());
            if (stateBefore == null) continue;
            for (ICopyFileArea cfa : this.copyFileAreasToUpdate) {
                cfa.setConfigurationState(this.connectionHandle, stateAfter.getComponent(), stateBefore.getConfigurationTime(), stateAfter.getConfigurationTime(), (IProgressMonitor)subMonitor.newChild(1));
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }

    protected void reportErrorsAsException(IStatus[] errors) throws FileSystemException {
        if (errors.length > 0) {
            if (this.inconsistentShares.size() > 0) {
                MultiStatus result = new MultiStatus("com.ibm.team.filesystem.client", 0, errors, Messages.MVSReloadingUpdateMutator_0, null);
                throw new FileSystemStatusException((IStatus)result);
            }
            super.reportErrorsAsException(errors);
        }
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), LogField.valueOf((Object[])errors)});
        }
    }

    public void setSkipStoreContent(Map<ILocation, Map<ConfigurationFacade, Set<UUID>>> ignoreList) {
    }

    protected final boolean skipUpdate(ILocation cfa, IComponentHandle comp, IVersionableHandle remote) {
        return false;
    }

    private boolean checkIsAborted(DeferredFileLoadInformation deferredFileLoadInformation) {
        if (!this.isAborted && AbortLoadOperationException.isRootCause(deferredFileLoadInformation.getFailure())) {
            this.isAborted = true;
        }
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), LogField.value((Object)this.isAborted)});
        }
        return this.isAborted;
    }
}

