/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.extensions.mutators;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogField;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.enterprise.common.common.utils.LoadTracing;
import com.ibm.team.enterprise.scmee.common.DeferredFileLoadInformation;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IShareableInternal;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.teamz.build.ant.zos.utils.JzosUtility;
import com.ibm.teamz.build.ant.zos.utils.LogUtility;
import com.ibm.teamz.fileagent.internal.extensions.impl.MVSStorageManager;
import com.ibm.teamz.fileagent.internal.extensions.impl.ZSharingData;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public abstract class MVSMutator
extends FileSystemOperation {
    private static final String cls = MVSMutator.class.getSimpleName();
    protected static Log LOG = LogFactory.getLog(MVSMutator.class);
    protected LoadTracing loadTracing = null;
    protected final IDebugger dbg;
    protected final boolean debug;
    protected final boolean trace;
    private final Map<UUID, IDataSetDefinition> cachedDataSetDefinitionCurrent;
    private final Map<UUID, IDataSetDefinition> cachedDataSetDefinitionState;

    protected MVSMutator(DilemmaHandler dilemmaHandler, LoadTracing loadTracing) {
        super(dilemmaHandler);
        this.loadTracing = loadTracing;
        this.dbg = MVSStorageManager.getCommonDbg();
        this.debug = this.dbg.isDebug();
        this.trace = this.dbg.isTrace();
        this.cachedDataSetDefinitionCurrent = new HashMap<UUID, IDataSetDefinition>();
        this.cachedDataSetDefinitionState = new HashMap<UUID, IDataSetDefinition>();
        if (this.debug) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls});
        }
    }

    protected static final IRelativeLocation getLocation(FileAreaUpdate update, IDataSetDefinition dataSetDefinition) {
        String[] dsName;
        IDebugger dbg = MVSStorageManager.getCommonDbg();
        if (update.getItem() instanceof IFolderHandle) {
            dsName = new String[]{dataSetDefinition.getDsName()};
        } else {
            dsName = new String[]{JzosUtility.substituteSystemSymbols((String)dataSetDefinition.getDsName()), update.getName().toUpperCase()};
            if (dsName[1].indexOf(".") > 0) {
                dsName[1] = dsName[1].substring(0, dsName[1].indexOf("."));
            }
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{cls, new Mnm(){}.get(), dataSetDefinition.getDsName()});
        }
        return new RelativeLocation(dsName);
    }

    protected IDataSetDefinition getCachedDataSetDefinition(String errorName, ITeamRepository repo, IDataSetDefinitionHandle dataSetDefinitionHandle, IProgressMonitor progress) throws TeamRepositoryException {
        return this.getCachedDataSetDefinition(errorName, repo, dataSetDefinitionHandle, false, progress);
    }

    private IDataSetDefinition getCachedDataSetDefinition(String errorName, ITeamRepository repo, IDataSetDefinitionHandle dataSetDefinitionHandle, boolean byState, IProgressMonitor progress) throws TeamRepositoryException {
        IDataSetDefinition dataSetDefinition;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        if (dataSetDefinitionHandle.hasStateId() && byState) {
            dataSetDefinition = this.cachedDataSetDefinitionState.get(dataSetDefinitionHandle.getStateId());
            if (dataSetDefinition == null) {
                ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)repo.getClientLibrary(ISystemDefinitionModelClient.class);
                dataSetDefinition = (IDataSetDefinition)client.findSystemDefinition(dataSetDefinitionHandle.getItemId().getUuidValue(), dataSetDefinitionHandle.getStateId().getUuidValue(), IResourceDefinition.ITEM_TYPE, progress);
                if (dataSetDefinition == null) {
                    throw new TeamRepositoryException(NLS.bind((String)Messages.MVSMutator_0, (Object)errorName, (Object[])new Object[0]));
                }
                this.cachedDataSetDefinitionState.put(dataSetDefinition.getStateId(), dataSetDefinition);
            }
        } else {
            dataSetDefinition = this.cachedDataSetDefinitionCurrent.get(dataSetDefinitionHandle.getItemId());
            if (dataSetDefinition == null) {
                ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)repo.getClientLibrary(ISystemDefinitionModelClient.class);
                dataSetDefinition = (IDataSetDefinition)client.findSystemDefinition(dataSetDefinitionHandle.getItemId().getUuidValue(), null, IResourceDefinition.ITEM_TYPE, progress);
                if (dataSetDefinition == null) {
                    throw new TeamRepositoryException(NLS.bind((String)Messages.MVSMutator_1, (Object)errorName, (Object[])new Object[0]));
                }
                this.cachedDataSetDefinitionCurrent.put(dataSetDefinition.getItemId(), dataSetDefinition);
            }
            this.cachedDataSetDefinitionState.put(dataSetDefinition.getStateId(), dataSetDefinition);
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((IItem)dataSetDefinition), dataSetDefinition.getDsName()});
        }
        return dataSetDefinition;
    }

    protected IDataSetDefinition getDataSetDefinition(String errorName, ITeamRepository repo, IShare share, IProgressMonitor cMon) throws TeamRepositoryException {
        IDataSetDefinition dataSetDefinition = null;
        IDataSetDefinitionHandle dataSetDefinitionHandle = this.getDataSetDefinitionHandle(share);
        if (dataSetDefinitionHandle != null) {
            dataSetDefinition = this.getCachedDataSetDefinition(errorName, repo, dataSetDefinitionHandle, true, cMon);
        }
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), LogField.valueOf((IItem)dataSetDefinition), dataSetDefinition.getDsName()});
        }
        return dataSetDefinition;
    }

    protected IDataSetDefinitionHandle getDataSetDefinitionHandle(IShare share) throws FileSystemException {
        IDataSetDefinitionHandle result = null;
        ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
        ZSharingData data = ZSharingData.createFrom(sharingDescriptor);
        if (data != null) {
            result = data.getDataSetDefinitionStateHandle();
        }
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), LogField.valueOf((IItemHandle)result)});
        }
        return result;
    }

    protected abstract int notifyHandlerOfDeletedContent(List<IShareable> var1);

    protected abstract String getDeletedContentMessage();

    protected void handleDeletedContent(ArrayList<DeferredFileLoadInformation> pathsToUpdate, IProgressMonitor progress) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(pathsToUpdate.size() * 2));
        LocalChangeManager lcm = LocalChangeManager.getInstance();
        ArrayList<IShareable> contentDeleted = new ArrayList<IShareable>();
        for (DeferredFileLoadInformation deferredUpdateInformation : pathsToUpdate) {
            if (deferredUpdateInformation != null && deferredUpdateInformation.contentDeleted()) {
                IShareableInternal shareable = deferredUpdateInformation.getShareable();
                contentDeleted.add((IShareable)shareable);
                try {
                    IFileStorage storage = deferredUpdateInformation.getShareable().getFileStorage();
                    long currentLastmod = storage.getLocalTimeStamp();
                    long now = System.currentTimeMillis() / 1000L * 1000L;
                    if (now <= currentLastmod) {
                        now = currentLastmod + 1000L;
                    }
                    storage.setLocalTimeStamp(now, (IProgressMonitor)monitor.newChild(1));
                    lcm.computeChanges((IShareable)shareable, (IProgressMonitor)monitor.newChild(1));
                }
                catch (FileSystemException e) {
                    LogUtility.logError((Log)LOG, (Exception)((Object)e), (String[])new String[0]);
                }
                continue;
            }
            monitor.worked(2);
        }
        if (!contentDeleted.isEmpty()) {
            int response = this.notifyHandlerOfDeletedContent(contentDeleted);
            if (response == 1) {
                throw new OperationCanceledException();
            }
            if (response != 0) {
                for (IShareable sharable : contentDeleted) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor((int)2, (String)NLS.bind((String)this.getDeletedContentMessage(), (Object)sharable.getLocalPath().toString(), (Object[])new Object[0])));
                }
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }
}

