/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.extensions.mutators;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogField;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.enterprise.common.common.BuildPropertyTable;
import com.ibm.team.enterprise.common.common.utils.LoadTracing;
import com.ibm.team.enterprise.scmee.common.DeferredFileLoadInformation;
import com.ibm.team.enterprise.scmee.common.IThreadOwner;
import com.ibm.team.enterprise.scmee.zos.DataSetLocation;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ILoadFilter;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileOptions;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IShareableInternal;
import com.ibm.team.filesystem.client.internal.MetadataProperties;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.ILoadMutator;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.internal.utils.NonCancellingProgressMonitor;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.teamz.build.ant.jni.SystemServices;
import com.ibm.teamz.build.ant.zos.utils.LogUtility;
import com.ibm.teamz.fileagent.UniqueDD;
import com.ibm.teamz.fileagent.internal.extensions.impl.DataSetInformation;
import com.ibm.teamz.fileagent.internal.extensions.impl.DataSetInformationCache;
import com.ibm.teamz.fileagent.internal.extensions.impl.DataSetLoadUpdater;
import com.ibm.teamz.fileagent.internal.extensions.impl.IDataSetInformation;
import com.ibm.teamz.fileagent.internal.extensions.impl.MVSStorageManager;
import com.ibm.teamz.fileagent.internal.extensions.impl.ZFileInterface;
import com.ibm.teamz.fileagent.internal.extensions.impl.ZSharingData;
import com.ibm.teamz.fileagent.internal.extensions.mutators.ASyncDataSetUpdateSession;
import com.ibm.teamz.fileagent.internal.extensions.mutators.MVSMutator;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class MVSLoadByDatasetMutator
extends MVSMutator
implements ILoadMutator {
    private static final String cls = MVSLoadByDatasetMutator.class.getSimpleName();
    public static boolean TIMING = System.getenv("SCMEE_TRACE_ELAPSED_TIMES") != null ? true : System.getProperty("scmee.trace.elapsed.times") != null;
    private static boolean TRUST_INPUTS = BuildPropertyTable.getInstance().get() == null || BuildPropertyTable.getInstance().get().get("team.enterprise.build.dependency.trustInputs") == null ? Boolean.parseBoolean(System.getProperty("scmee.trust.already.loaded.files", "false")) : Boolean.parseBoolean((String)BuildPropertyTable.getInstance().get().get("team.enterprise.build.dependency.trustInputs"));
    private IDownloadListener downloadMonitor;
    private IConnection connection;
    private IComponent component;
    private IContextHandle connectionHandle;
    private final ISandbox sandbox;
    private LoadTree loadTree;
    private Set<IRemovedShare> sharesToRemove;
    private ITeamRepository repo;
    private Map<UUID, ILoadLocation> loadLocations;
    private final Shed shed;
    private final LoadDilemmaHandler problemHandler;
    private LocalChangeManager localChangeManager;
    private Map<UUID, IDataSetDefinition> definitionsEncountered;
    private Map<UUID, HashMap<String, UUID>> allFolderChildren;
    private ArrayList<DeferredFileLoadInformation> pathsToUpdate;
    private ArrayList<DataSetLoadUpdater> datasetUpdaters;
    HashSet<UUID> inconsistentShares;
    ArrayList<IVersionableHandle> shares = new ArrayList();
    private Map<IDataSetDefinition, HashSet<FileAreaUpdate>> allFilesForDefinitions;
    private Map<IDataSetDefinition, IDataSetInformation> informationForDefinitions;
    private ASyncDataSetUpdateSession dsUpdateSession = null;
    private IThreadOwner threadOwner = null;
    private long time4Pending = 0L;
    private long time4Refresh = 0L;
    private long time4Content = 0L;
    private long time4Reloads = 0L;

    public MVSLoadByDatasetMutator(ISandbox sandbox, LoadDilemmaHandler loadProblemHandler, LoadTracing loadTracing) {
        super((DilemmaHandler)(loadProblemHandler == null ? LoadDilemmaHandler.getDefault() : loadProblemHandler), loadTracing);
        this.problemHandler = loadProblemHandler == null ? LoadDilemmaHandler.getDefault() : loadProblemHandler;
        this.sandbox = sandbox;
        this.shed = new Shed(this.problemHandler.getBackupDilemmaHandler());
        if (this.debug) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls});
        }
    }

    public void configureLoad(int options, IConnection connection, IComponent component, List<? extends ILoadLocation> itemsToLoad, LoadTree loadTree, IDownloadListener downloadMonitor, ILoadFilter filter) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        if (connection == null) {
            throw new IllegalArgumentException(Messages.MVSLoadMutator_0);
        }
        if (component == null) {
            throw new IllegalArgumentException(Messages.MVSLoadMutator_1);
        }
        if (itemsToLoad == null) {
            throw new IllegalArgumentException(Messages.MVSLoadMutator_2);
        }
        if (loadTree == null) {
            throw new IllegalArgumentException(Messages.MVSLoadMutator_3);
        }
        this.connection = connection;
        this.component = component;
        this.repo = connection.teamRepository();
        this.loadTree = loadTree;
        this.loadLocations = new HashMap<UUID, ILoadLocation>();
        this.downloadMonitor = downloadMonitor;
        for (ILoadLocation iLoadLocation : itemsToLoad) {
            if (!component.sameItemId((IItemHandle)iLoadLocation.getComponent())) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.MVSLoadMutator_4, (Object)component.getName(), (Object[])new Object[0]));
            }
            this.loadLocations.put(iLoadLocation.getRootToLoad().getItemId(), iLoadLocation);
        }
        this.connectionHandle = connection instanceof IWorkspaceConnection ? (IContextHandle)((IWorkspaceConnection)connection).getResolvedWorkspace().getItemHandle() : ((IBaselineConnection)connection).getBaseline();
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }

    public void configureShareRemoval(Set<IRemovedShare> sharesToRemove) {
        this.sharesToRemove = sharesToRemove;
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
    }

    protected final void execute(IProgressMonitor monitor) throws TeamRepositoryException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        ThreadCheck.checkLongOpsAllowed();
        int work = this.sharesToRemove == null ? 0 : 5;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(work += this.loadTree == null ? 0 : 95));
        if (this.sharesToRemove != null) {
            this.removeShares((IProgressMonitor)progress.newChild(5));
        }
        if (this.loadTree != null) {
            this.load((IProgressMonitor)progress.newChild(95));
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }

    public void load(IProgressMonitor monitor) throws TeamRepositoryException {
        IStatus[] failures;
        IStatus[] updateSessionStatus;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        long time01 = 0L;
        long time02 = 0L;
        long time03 = 0L;
        long time04 = 0L;
        if (TIMING) {
            time01 = System.currentTimeMillis();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)105);
        this.allFolderChildren = new HashMap<UUID, HashMap<String, UUID>>();
        this.pathsToUpdate = new ArrayList();
        this.inconsistentShares = new HashSet();
        this.shares = new ArrayList();
        this.definitionsEncountered = new HashMap<UUID, IDataSetDefinition>();
        this.allFilesForDefinitions = new HashMap<IDataSetDefinition, HashSet<FileAreaUpdate>>();
        this.informationForDefinitions = new HashMap<IDataSetDefinition, IDataSetInformation>();
        this.datasetUpdaters = new ArrayList();
        List updates = this.loadTree.getFileAreaUpdates();
        this.localChangeManager = LocalChangeManager.getInstance();
        ICopyFileArea cfa = ICopyFileAreaManager.instance.getCopyFileAreaForPath(this.sandbox.getRoot());
        CancellationMonitor cMon = new CancellationMonitor((IProgressMonitor)progress);
        for (FileAreaUpdate update : updates) {
            IVersionableHandle versionableState = update.afterState();
            ResourceType type = ResourceType.getResourceType((IVersionableHandle)versionableState);
            IFolderHandle loadRoot = this.getLoadRoot(update.getDestinationParent(), versionableState);
            if (this.trace) {
                Debug.debug((IDebugger)this.dbg, (String[])new String[]{cls, mnm, update.getName(), LogField.value((Object)type)});
            }
            if (type == ResourceType.FOLDER) {
                this.collectFolderToUpdate(cfa, update, (IVersionableHandle)loadRoot, cMon);
                continue;
            }
            if (type == ResourceType.FILE) {
                this.collectFileToUpdate(cfa, update, loadRoot, cMon);
                continue;
            }
            if (type != ResourceType.SYMBOLIC_LINK) continue;
            this.handleLinkUpdate(cfa, update, (IVersionableHandle)loadRoot, cMon);
        }
        HashMap<String, IDataSetDefinition> dsNames = new HashMap<String, IDataSetDefinition>();
        HashSet<IDataSetDefinition> removedDsDef = new HashSet<IDataSetDefinition>();
        int totalSize = 0;
        for (IDataSetDefinition dsdef : this.allFilesForDefinitions.keySet()) {
            totalSize += this.allFilesForDefinitions.get(dsdef).size();
            if (!dsNames.containsKey(dsdef.getDsName())) {
                dsNames.put(dsdef.getDsName(), dsdef);
                continue;
            }
            IDataSetDefinition firstDsDefWithSameName = (IDataSetDefinition)dsNames.get(dsdef.getDsName());
            HashSet<FileAreaUpdate> firstFiles = this.allFilesForDefinitions.get(firstDsDefWithSameName);
            firstFiles.addAll((Collection<FileAreaUpdate>)this.allFilesForDefinitions.get(dsdef));
            removedDsDef.add(dsdef);
            if (firstDsDefWithSameName.getItemId().equals((Object)dsdef.getItemId())) {
                LogUtility.logDebug((Log)LOG, null, (String[])new String[]{NLS.bind((String)Messages.MVSLoadMutator_20, (Object)firstDsDefWithSameName.getName(), (Object[])new Object[]{firstDsDefWithSameName.getItemId()})});
                continue;
            }
            this.collectStatus((IStatus)new Status(2, "com.ibm.teamz.fileagent", NLS.bind((String)Messages.MVSLoadMutator_19, (Object)firstDsDefWithSameName.getName(), (Object[])new Object[]{firstDsDefWithSameName.getItemId(), dsdef.getDsName(), dsdef.getName(), dsdef.getItemId()})));
        }
        for (IDataSetDefinition dsdef : removedDsDef) {
            this.allFilesForDefinitions.remove(dsdef);
        }
        for (IDataSetDefinition dsdef : this.allFilesForDefinitions.keySet()) {
            if (this.informationForDefinitions.containsKey(dsdef)) continue;
            this.informationForDefinitions.put(dsdef, this.getDatasetInformation(dsdef, cMon));
        }
        if (TIMING) {
            time02 = System.currentTimeMillis();
            this.traceTime("1- Time spends during collecting zFiles:", time02 - time01);
        }
        this.dsUpdateSession = new ASyncDataSetUpdateSession("datasetUpdate", Math.max(1, SCMPlatform.getMaxContentThreads()), true, totalSize, this.threadOwner, (IProgressMonitor)progress.newChild(90));
        try {
            for (IDataSetDefinition dsdef : this.allFilesForDefinitions.keySet()) {
                IDataSetInformation dsinfo = this.informationForDefinitions.get(dsdef);
                DataSetLoadUpdater updater = new DataSetLoadUpdater(this.connection, this.repo, this.sandbox, this.component, this.downloadMonitor, this.shed, dsdef, dsinfo, this.threadOwner, MVSLoadByDatasetMutator.getUniqueDDName());
                this.datasetUpdaters.add(updater);
                HashSet<FileAreaUpdate> files = this.allFilesForDefinitions.get(dsdef);
                ICopyFileArea cfa2 = cfa;
                for (FileAreaUpdate update : files) {
                    IVersionableHandle versionableState = update.afterState();
                    IFolderHandle loadRoot = this.getLoadRoot(update.getDestinationParent(), versionableState);
                    this.handleFileUpdateBis(dsdef, cfa2, updater, update, loadRoot, cMon);
                }
                this.dsUpdateSession.updateDataSet(updater);
            }
        }
        finally {
            this.dsUpdateSession.join();
            if (TIMING) {
                time03 = System.currentTimeMillis();
                this.traceTime("2- Time spends during downloading zFiles:", time03 - time02);
                if (this.time4Pending != 0L || this.time4Reloads != 0L || this.time4Refresh != 0L || this.time4Content != 0L) {
                    this.traceTime(" 2a- Intermediate time spent on pending chgs:", this.time4Pending);
                    this.traceTime(" 2b- Intermediate time spent reloading share:", this.time4Reloads);
                    this.traceTime(" 2c- Intermediate time spent refreshing chgs:", this.time4Refresh);
                    this.traceTime(" 2d- Intermediate time spent analysing dirty:", this.time4Content);
                }
            }
            this.updateContentLoadedMetaData(cfa, this.pathsToUpdate, (IProgressMonitor)new NonCancellingProgressMonitor((IProgressMonitor)progress.newChild(7)));
            if (TIMING) {
                time04 = System.currentTimeMillis();
                this.traceTime("3- Time spends during updating metadata:", time04 - time03);
            }
        }
        boolean seriousFailure = false;
        IStatus[] iStatusArray = updateSessionStatus = this.dsUpdateSession.getErrorStatus();
        int n = updateSessionStatus.length;
        int updater = 0;
        while (updater < n) {
            IStatus status = iStatusArray[updater];
            if (!status.isOK()) {
                this.collectStatus(status);
                seriousFailure = true;
            }
            ++updater;
        }
        IStatus[] iStatusArray2 = failures = this.getDatasetUpdateFailures(this.datasetUpdaters);
        int n2 = failures.length;
        n = 0;
        while (n < n2) {
            IStatus failure = iStatusArray2[n];
            if (failure.getSeverity() == 4 || failure.getSeverity() == 8) {
                seriousFailure = true;
            }
            this.collectStatus(failure);
            ++n;
        }
        iStatusArray2 = failures = this.getDownloadFailures(this.pathsToUpdate, progress.newChild(5));
        n2 = failures.length;
        n = 0;
        while (n < n2) {
            IStatus failure = iStatusArray2[n];
            if (failure.getSeverity() == 4 || failure.getSeverity() == 8) {
                seriousFailure = true;
            }
            this.collectStatus(failure);
            ++n;
        }
        if (seriousFailure) {
            failures = this.getErrors();
            this.throwAppropriateException(Messages.MVSLoadMutator_5, failures);
        } else if (this.dsUpdateSession != null && this.dsUpdateSession.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.removeExtraneousMetadata(cfa, this.allFolderChildren, (IProgressMonitor)progress.newChild(5));
        this.updateConfigurationStates(cfa, this.shares, this.inconsistentShares, (IProgressMonitor)progress);
        this.handleDeletedContent(this.pathsToUpdate, (IProgressMonitor)progress.newChild(5));
        if (TIMING) {
            long time05 = System.currentTimeMillis();
            this.traceTime("Total Time spends during load method:", time05 - time01);
        }
        progress.done();
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }

    @Override
    protected int notifyHandlerOfDeletedContent(List<IShareable> contentDeleted) {
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return this.problemHandler.deletedContent(contentDeleted);
    }

    @Override
    protected String getDeletedContentMessage() {
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return Messages.MVSLoadByDatasetMutator_0;
    }

    private static String getUniqueDDName() {
        return UniqueDD.getInstance().get();
    }

    private void handleLinkUpdate(ICopyFileArea cfa, FileAreaUpdate update, IVersionableHandle loadRoot, CancellationMonitor cMon) {
        IDataSetDefinition dataSetDefinition;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)update.getName())});
        }
        if ((dataSetDefinition = this.getDataSetDefinition(update.getDestinationParent(), cMon)) != null) {
            this.collectStatus((IStatus)new Status(4, "com.ibm.teamz.fileagent", NLS.bind((String)Messages.MVSLoadMutator_6, (Object)update.getName(), (Object[])new Object[0])));
            this.recordInconsistentShare(cfa, update, this.inconsistentShares, (IProgressMonitor)cMon);
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)update.getName())});
        }
    }

    private void collectFolderToUpdate(ICopyFileArea cfa, FileAreaUpdate update, IVersionableHandle loadRoot, CancellationMonitor cMon) {
        IDataSetDefinition dataSetDefinition;
        IFolderHandle versionableState;
        String mnm;
        block11: {
            block12: {
                String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
                if (this.debug) {
                    Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)update.getName())});
                }
                versionableState = (IFolderHandle)update.getItem();
                dataSetDefinition = this.getFolderDataSetDefinition(update.getName(), update, (IProgressMonitor)cMon);
                this.definitionsEncountered.put(versionableState.getItemId(), dataSetDefinition);
                if (dataSetDefinition != null) break block11;
                if (!this.debug) break block12;
                Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)update.getName())});
            }
            return;
        }
        try {
            try {
                if (!this.informationForDefinitions.containsKey(dataSetDefinition)) {
                    this.informationForDefinitions.put(dataSetDefinition, this.getDatasetInformation(dataSetDefinition, cMon));
                }
                this.allFolderChildren.put(versionableState.getItemId(), new HashMap());
                if (!this.allFilesForDefinitions.containsKey(dataSetDefinition)) {
                    this.allFilesForDefinitions.put(dataSetDefinition, new HashSet());
                }
            }
            catch (TeamRepositoryException e) {
                this.collectStatus((IStatus)new Status(4, "com.ibm.teamz.fileagent", NLS.bind((String)Messages.MVSLoadMutator_7, (Object)update.getName(), (Object[])new Object[]{this.component.getName()}), (Throwable)e));
                this.recordInconsistentShare(cfa, update, this.inconsistentShares, (IProgressMonitor)cMon);
                if (this.debug) {
                    Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)update.getName())});
                }
                return;
            }
        }
        catch (Throwable throwable) {
            if (this.debug) {
                Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)update.getName())});
            }
            throw throwable;
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)update.getName())});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void collectFileToUpdate(ICopyFileArea cfa, FileAreaUpdate update, IFolderHandle loadRoot, CancellationMonitor cMon) {
        IDataSetDefinition dataSetDefinition;
        String errorName;
        String mnm;
        block9: {
            String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
            if (this.debug) {
                Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)update.getName())});
            }
            IVersionableHandle versionableState = update.afterState();
            if (update.getName().trim().startsWith(".")) {
                if (!this.debug) return;
                Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)update.getName()), "Hidden"});
                return;
            }
            errorName = update.getName();
            IShareableInternal shareableLoaded = (IShareableInternal)this.sandbox.findShareable(this.connectionHandle, (IComponentHandle)this.component, versionableState, (IProgressMonitor)cMon);
            dataSetDefinition = this.getFileDataSetDefinition(update, (IProgressMonitor)cMon);
            if (dataSetDefinition != null) break block9;
            if (shareableLoaded != null) {
                this.deleteShareableLoaded(shareableLoaded, this.connectionHandle, (IComponentHandle)this.component, versionableState, (IProgressMonitor)cMon);
            }
            if (!this.debug) return;
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)update.getName())});
            return;
        }
        try {
            try {
                if (!this.allFilesForDefinitions.containsKey(dataSetDefinition)) {
                    this.allFilesForDefinitions.put(dataSetDefinition, new HashSet());
                }
                HashSet<FileAreaUpdate> files = this.allFilesForDefinitions.get(dataSetDefinition);
                files.add(update);
            }
            catch (TeamRepositoryException e) {
                this.collectStatus((IStatus)new Status(4, "com.ibm.teamz.fileagent", NLS.bind((String)Messages.MVSLoadMutator_11, (Object)update.getName(), (Object[])new Object[]{this.component.getName(), errorName}), (Throwable)e));
                this.recordInconsistentShare(cfa, update, this.inconsistentShares, (IProgressMonitor)cMon);
                if (!this.debug) return;
                Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)update.getName())});
                return;
            }
        }
        catch (Throwable throwable) {
            if (!this.debug) throw throwable;
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)update.getName())});
            throw throwable;
        }
        if (!this.debug) return;
        Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)update.getName())});
    }

    private IDataSetInformation getDatasetInformation(IDataSetDefinition datasetDefinition, CancellationMonitor cMon) throws TeamRepositoryException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)datasetDefinition.getDsName())});
        }
        IShareableInternal shareable = (IShareableInternal)this.sandbox.findShareable((IRelativeLocation)new RelativeLocation(new String[]{datasetDefinition.getDsName()}), ResourceType.FOLDER);
        SystemServices services = new SystemServices();
        DataSetInformation result = !MVSLoadByDatasetMutator.isSimulatedModeOn() ? new DataSetInformation(this.dbg) : new DataSetInformation(this.dbg, shareable);
        DataSetLocation datasetLocation = new DataSetLocation(this.sandbox.getRoot().toOSString(), datasetDefinition.getDsName(), null);
        try {
            result.setDatasetExists(services.locateDataset(datasetLocation.getDatasetName()));
            result.setDatasetDefinition(datasetDefinition);
            result.setDatasetLocation(datasetLocation);
            result.setDatasetPDSInfo();
            result.setDatasetMemberMap();
            result.setTeamRepository(this.repo);
            result.setProjectAreaHandle(datasetDefinition.getProjectArea());
            result.setConfiguration();
            DataSetInformationCache.getInstance().put(datasetLocation, result);
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        this.logLoadTrace(NLS.bind((String)Messages.MVSLoadByDatasetMutator_Logging_0, (Object)datasetLocation.getDatasetName(), (Object[])new Object[]{this.component.getName()}));
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)datasetDefinition.getDsName()), LogField.valueOf((String)datasetLocation.getDatasetName())});
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private void handleFileUpdateBis(IDataSetDefinition dataSetDefinition, ICopyFileArea cfa, DataSetLoadUpdater updater, FileAreaUpdate update, IFolderHandle loadRoot, CancellationMonitor cMon) throws FileSystemException {
        block35: {
            block33: {
                block34: {
                    block38: {
                        block31: {
                            block32: {
                                block37: {
                                    block36: {
                                        v0 = mnm = this.dbg.isOn() != false ? new Mnm(){}.get() : null;
                                        if (this.debug) {
                                            Debug.enter((IDebugger)this.dbg, (String[])new String[]{MVSLoadByDatasetMutator.cls, mnm, LogField.valueOf((String)update.getName())});
                                        }
                                        versionableState = update.afterState();
                                        errorName = update.getName();
                                        shareableLoaded = (IShareableInternal)this.sandbox.findShareable(this.connectionHandle, (IComponentHandle)this.component, versionableState, (IProgressMonitor)cMon);
                                        path = MVSLoadByDatasetMutator.getLocation(update, dataSetDefinition);
                                        errorName = this.sandbox.getRoot().append(path).toOSString();
                                        shareableToLoad = (IShareableInternal)this.sandbox.findShareable(path, ResourceType.FILE);
                                        memberZFile = (ZFileInterface)shareableToLoad.getFileStorage().getAdapter(ZFileInterface.class);
                                        if (memberZFile == null) {
                                            shareableToLoad.getFileStorage().getResourceType((IProgressMonitor)cMon);
                                        }
                                        type = shareableToLoad.getResourceType((IProgressMonitor)cMon);
                                        if (this.trace) {
                                            Debug.debug((IDebugger)this.dbg, (String[])new String[]{MVSLoadByDatasetMutator.cls, mnm, errorName, "type:" + LogField.value((Object)type)});
                                        }
                                        if (this.trace) {
                                            Debug.debug((IDebugger)this.dbg, (String[])new String[]{MVSLoadByDatasetMutator.cls, mnm, errorName, "share:" + LogField.value((Object)shareableLoaded)});
                                        }
                                        if (type != null || shareableLoaded != null) break block36;
                                        LogUtility.logTrace((Log)MVSLoadByDatasetMutator.LOG, null, (String[])new String[]{errorName, " not on disk."});
                                        if (this.debug) {
                                            Debug.trace((IDebugger)this.dbg, (String[])new String[]{MVSLoadByDatasetMutator.cls, mnm, errorName, "Not on disk"});
                                        }
                                        SharingManager.getInstance().forget(this.sandbox.getRoot(), this.connectionHandle, (IComponentHandle)this.component, update.getItem(), (IProgressMonitor)cMon);
                                        descriptor = this.getSharingDescriptor(dataSetDefinition, versionableState, loadRoot);
                                        this.createNewFile(cfa, shareableToLoad, dataSetDefinition, updater, update, descriptor, (IProgressMonitor)cMon);
                                        ** GOTO lbl119
                                    }
                                    if (type != null || shareableLoaded == null) break block37;
                                    LogUtility.logTrace((Log)MVSLoadByDatasetMutator.LOG, null, (String[])new String[]{errorName, " on disk but elsewhere."});
                                    if (this.debug) {
                                        Debug.trace((IDebugger)this.dbg, (String[])new String[]{MVSLoadByDatasetMutator.cls, mnm, errorName, "On disk, but elsewhere"});
                                    }
                                    this.deleteShareableLoaded(shareableLoaded, this.connectionHandle, (IComponentHandle)this.component, versionableState, (IProgressMonitor)cMon);
                                    descriptor = this.getSharingDescriptor(dataSetDefinition, versionableState, loadRoot);
                                    this.createNewFile(cfa, shareableToLoad, dataSetDefinition, updater, update, descriptor, (IProgressMonitor)cMon);
                                    ** GOTO lbl119
                                }
                                if (type == null || shareableLoaded != null) ** GOTO lbl58
                                LogUtility.logTrace((Log)MVSLoadByDatasetMutator.LOG, null, (String[])new String[]{errorName, " not on disk but there is already a file there."});
                                if (this.debug) {
                                    Debug.trace((IDebugger)this.dbg, (String[])new String[]{MVSLoadByDatasetMutator.cls, mnm, errorName, "Not on disk, but file is there"});
                                }
                                if ((parent = update.getDestinationParent()) == null || (children = this.allFolderChildren.get(parent.getItemId())) == null || !children.containsKey(shareableToLoad.getLocalPath().getName())) break block31;
                                this.collectStatus((IStatus)new Status(4, "com.ibm.teamz.fileagent", NLS.bind((String)Messages.MVSLoadMutator_9, (Object)update.getName(), (Object[])new Object[]{this.component.getName(), shareableToLoad.getFullPath().toOSString()})));
                                this.recordInconsistentShare(cfa, update, this.inconsistentShares, (IProgressMonitor)cMon);
                                if (!this.debug) break block32;
                                Debug.leave((IDebugger)this.dbg, (String[])new String[]{MVSLoadByDatasetMutator.cls, mnm, LogField.valueOf((String)update.getName())});
                            }
                            return;
                        }
                        if (!MVSLoadByDatasetMutator.TRUST_INPUTS) {
                            descriptor = this.getSharingDescriptor(dataSetDefinition, versionableState, loadRoot);
                            this.createNewFile(cfa, shareableToLoad, dataSetDefinition, updater, update, descriptor, (IProgressMonitor)cMon);
                        } else {
                            descriptor = this.getSharingDescriptor(dataSetDefinition, versionableState, loadRoot);
                            this.updateFile(cfa, shareableToLoad, dataSetDefinition, updater, update, descriptor, (IProgressMonitor)cMon);
                        }
                        ** GOTO lbl119
lbl58:
                        // 1 sources

                        if (!shareableToLoad.getLocalPath().equals((Object)shareableLoaded.getLocalPath())) break block38;
                        isDirty = false;
                        time01 = 0L;
                        time02 = 0L;
                        time03 = 0L;
                        time04 = 0L;
                        time05 = 0L;
                        v1 = isDirty = versionableState.sameStateId((IItemHandle)shareableToLoad.getRemote((IProgressMonitor)cMon)) == false;
                        if (!MVSLoadByDatasetMutator.TRUST_INPUTS) {
                            if (MVSLoadByDatasetMutator.TIMING) {
                                time01 = System.currentTimeMillis();
                            }
                            if (!isDirty) {
                                change = this.localChangeManager.getPendingChange((IShareable)shareableToLoad, (IProgressMonitor)cMon);
                                v2 = isDirty = change != null && change.getType() != 0;
                            }
                            if (MVSLoadByDatasetMutator.TIMING) {
                                time02 = System.currentTimeMillis();
                                this.time4Pending += time02 - time01;
                            }
                            if (!isDirty) {
                                share = shareableToLoad.getShare((IProgressMonitor)cMon);
                                if (MVSLoadByDatasetMutator.TIMING) {
                                    time03 = System.currentTimeMillis();
                                    this.time4Reloads += time03 - time02;
                                }
                                if (share != null) {
                                    this.localChangeManager.refreshChanges(new IShare[]{share}, ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN, (IProgressMonitor)cMon);
                                    if (MVSLoadByDatasetMutator.TIMING) {
                                        time04 = System.currentTimeMillis();
                                        this.time4Refresh += time04 - time03;
                                    }
                                    isDirty = this.localChangeManager.isContentDirty((IShareable)shareableToLoad, (IProgressMonitor)cMon);
                                    if (MVSLoadByDatasetMutator.TIMING) {
                                        time05 = System.currentTimeMillis();
                                        this.time4Content += time05 - time04;
                                    }
                                }
                            }
                        }
                        if (isDirty) {
                            LogUtility.logTrace((Log)MVSLoadByDatasetMutator.LOG, null, (String[])new String[]{errorName, " already on disk and dirty."});
                            if (this.debug) {
                                Debug.trace((IDebugger)this.dbg, (String[])new String[]{MVSLoadByDatasetMutator.cls, mnm, errorName, "On disk and dirty"});
                            }
                            descriptor = this.getSharingDescriptor(dataSetDefinition, versionableState, loadRoot);
                            this.modifyFile(cfa, shareableToLoad, dataSetDefinition, updater, update, descriptor, shareableLoaded, (IProgressMonitor)cMon);
                        } else {
                            LogUtility.logTrace((Log)MVSLoadByDatasetMutator.LOG, null, (String[])new String[]{errorName, " already on disk and identical than in SCM."});
                            if (this.debug) {
                                Debug.trace((IDebugger)this.dbg, (String[])new String[]{MVSLoadByDatasetMutator.cls, mnm, errorName, "On disk and identical"});
                            }
                            this.shares.add(versionableState);
                        }
                        ** GOTO lbl119
                    }
                    LogUtility.logTrace((Log)MVSLoadByDatasetMutator.LOG, null, (String[])new String[]{errorName, " already on disk but elsewhere with another file here."});
                    if (this.debug) {
                        Debug.trace((IDebugger)this.dbg, (String[])new String[]{MVSLoadByDatasetMutator.cls, mnm, errorName, "On disk, but elsewhere and file is there"});
                    }
                    if ((parent = update.getDestinationParent()) == null || (children = this.allFolderChildren.get(parent.getItemId())) == null || !children.containsKey(shareableToLoad.getLocalPath().getName())) break block33;
                    this.collectStatus((IStatus)new Status(4, "com.ibm.teamz.fileagent", NLS.bind((String)Messages.MVSLoadMutator_10, (Object)update.getName(), (Object[])new Object[]{this.component.getName(), shareableLoaded.getFullPath().toOSString()})));
                    this.recordInconsistentShare(cfa, update, this.inconsistentShares, (IProgressMonitor)cMon);
                    if (!this.debug) break block34;
                    Debug.leave((IDebugger)this.dbg, (String[])new String[]{MVSLoadByDatasetMutator.cls, mnm, LogField.valueOf((String)update.getName())});
                }
                return;
            }
            try {
                try {
                    this.deleteShareableLoaded(shareableToLoad, null, null, null, (IProgressMonitor)cMon);
                    descriptor = this.getSharingDescriptor(dataSetDefinition, versionableState, loadRoot);
                    this.createNewFile(cfa, shareableToLoad, dataSetDefinition, updater, update, descriptor, (IProgressMonitor)cMon);
lbl119:
                    // 7 sources

                    if (this.loadLocations.containsKey(versionableState.getItemId()) || (contents = this.allFolderChildren.get(update.parent().getItemId())) == null) break block35;
                    memberName = path.getName();
                    contents.put(memberName, update.getItem().getItemId());
                }
                catch (TeamRepositoryException e) {
                    this.collectStatus((IStatus)new Status(4, "com.ibm.teamz.fileagent", NLS.bind((String)Messages.MVSLoadMutator_11, (Object)update.getName(), (Object[])new Object[]{this.component.getName(), errorName}), (Throwable)e));
                    this.recordInconsistentShare(cfa, update, this.inconsistentShares, (IProgressMonitor)cMon);
                    if (!this.debug) ** GOTO lbl137
                    Debug.leave((IDebugger)this.dbg, (String[])new String[]{MVSLoadByDatasetMutator.cls, mnm, LogField.valueOf((String)update.getName())});
                }
            }
            catch (Throwable var27_31) {
                if (this.debug) {
                    Debug.leave((IDebugger)this.dbg, (String[])new String[]{MVSLoadByDatasetMutator.cls, mnm, LogField.valueOf((String)update.getName())});
                }
                throw var27_31;
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{MVSLoadByDatasetMutator.cls, mnm, LogField.valueOf((String)update.getName())});
        }
lbl137:
        // 5 sources

    }

    private ISharingDescriptor getSharingDescriptor(IDataSetDefinition dataSetDefinition, IVersionableHandle fileItem, IFolderHandle loadRoot) throws FileSystemException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)dataSetDefinition.getName())});
        }
        ZSharingData sharingData = new ZSharingData((IDataSetDefinitionHandle)dataSetDefinition);
        SharingDescriptor descriptor = SharingDescriptor.create((IConnection)this.connection, (IComponent)this.component, (IVersionableHandle)fileItem, (IFolderHandle)loadRoot, sharingData.getClientData());
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)dataSetDefinition.getName())});
        }
        return descriptor;
    }

    private void deleteShareableLoaded(final IShareableInternal shareableLoaded, IContextHandle connectionHandle, IComponentHandle componentHandle, IVersionableHandle versionable, IProgressMonitor progress) throws FileSystemException {
        String shr;
        String mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        String string = shr = shareableLoaded == null ? "null" : shareableLoaded.getFullPath().toString();
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)shr)});
        }
        final SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        if (shareableLoaded != null) {
            LogUtility.logTrace((Log)LOG, null, (String[])new String[]{shareableLoaded.getFullPath().toOSString(), " to delete."});
            SharingManager.getInstance().doSilentChange(new SharingManager.FileSystemAccessor(){

                public void run() throws FileSystemException {
                    if (shareableLoaded.getFileStorage().exists((IProgressMonitor)monitor.newChild(5))) {
                        shareableLoaded.getFileStorage().delete(MVSLoadByDatasetMutator.this.shed, (IProgressMonitor)monitor.newChild(90));
                    }
                }
            });
            FileItemInfo info = shareableLoaded.getFileItemInfo((IProgressMonitor)monitor.newChild(1));
            if (info != null) {
                SharingManager.getInstance().forget(shareableLoaded, (IProgressMonitor)monitor.newChild(5));
            } else if (versionable != null) {
                SharingManager.getInstance().forget(this.sandbox.getRoot(), connectionHandle, componentHandle, versionable, (IProgressMonitor)monitor.newChild(5));
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)shr)});
        }
    }

    private IFolderHandle getLoadRoot(IFolderHandle parent, IVersionableHandle versionable) {
        IFolderHandle root = null;
        ILoadLocation loadLocation = this.loadLocations.get(versionable.getItemId());
        root = loadLocation != null ? null : parent;
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return root;
    }

    private void removeShare(IShare share, IProgressMonitor progress) throws FileSystemException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IShareableInternal shareable = (IShareableInternal)share.getShareable();
        this.deleteShareableLoaded(shareable, share.getSharingDescriptor().getConnectionHandle(), share.getSharingDescriptor().getComponent(), share.getSharingDescriptor().getRootVersionable(), (IProgressMonitor)monitor.newChild(70));
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }

    private void removeShares(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)this.sharesToRemove.size());
        for (IRemovedShare shareToRemove : this.sharesToRemove) {
            IShare share = shareToRemove.getShare();
            mon.setTaskName(NLS.bind((String)Messages.MVSLoadMutator_12, (Object)share.getPath().toString(), (Object[])new Object[0]));
            if (shareToRemove.isToBeDeleted()) {
                this.removeShare(share, (IProgressMonitor)mon.newChild(1));
            } else {
                ResourceType type = ResourceType.FOLDER;
                ISharingDescriptor descriptor = share.getSharingDescriptor();
                if (descriptor != null) {
                    type = ResourceType.getResourceType((IVersionableHandle)descriptor.getRootVersionable());
                }
                Shareable shareable = (Shareable)share.getSandbox().findShareable(share.getPath(), type);
                shareable.unshare((IProgressMonitor)mon.newChild(1));
            }
            if (!mon.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        mon.done();
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }

    private void updateContentLoadedMetaData(ICopyFileArea cfa, ArrayList<DeferredFileLoadInformation> pathsToUpdate, IProgressMonitor progress) throws FileSystemException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress, (int)(pathsToUpdate.size() * 2 + 10));
        for (DeferredFileLoadInformation loadInfo : pathsToUpdate) {
            if (!loadInfo.contentUpdated()) {
                subProgress.worked(1);
                continue;
            }
            FileAreaUpdate update = loadInfo.getFileAreaUpdate();
            IShareableInternal shareable = loadInfo.getShareable();
            this.updateMetaInfoForPath(cfa, update.getComponent(), update.afterState(), shareable, loadInfo, (IProgressMonitor)subProgress.newChild(1));
        }
        subProgress.done();
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }

    private void updateMetaInfoForPath(ICopyFileArea copyFileArea, IComponentHandle componentHandle, IVersionableHandle fileItem, IShareableInternal shareable, DeferredFileLoadInformation updateInfo, IProgressMonitor monitor) throws FileSystemException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)shareable.getFullPath().toString())});
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)new NonCancellingProgressMonitor(monitor), (int)100);
        IFileStorage file = shareable.getFileStorage();
        IFolderHandle parent = null;
        String name = null;
        boolean loadedWithAnotherName = false;
        parent = updateInfo.getRemoteParent();
        name = updateInfo.getRemoteName();
        loadedWithAnotherName = true;
        FileContent content = (FileContent)updateInfo.getContent();
        FileItemInfoProxy newInfoProxy = new FileItemInfoProxy(fileItem, parent, name, loadedWithAnotherName);
        newInfoProxy.setContentInfo(file.getModificationStamp(), updateInfo.getHash(), updateInfo.getContentSize(), content);
        newInfoProxy.setExecutable(updateInfo.isExecutable(), updateInfo.isExecutable());
        newInfoProxy.setContentType(updateInfo.getFileAreaUpdate().getContentType());
        FileItemInfo newInfo = newInfoProxy.getFileItemInfo();
        MetadataProperties properties = updateInfo.getMetadataProperties();
        if (updateInfo.isShare()) {
            ISharingDescriptor descriptor = updateInfo.getSharingDescriptor();
            SharingManager.getInstance().share(shareable, descriptor, newInfo, properties, 2, (IProgressMonitor)progress.newChild(10));
        } else {
            copyFileArea.setItemMetaData(updateInfo.getShareable().getLocalPath(), newInfo, ICopyFileArea.PropertyUpdate.REPLACE, properties, (IProgressMonitor)progress.newChild(10));
        }
        file.setExecutable(updateInfo.isExecutable(), (IProgressMonitor)progress.newChild(10));
        progress.done();
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)shareable.getFullPath().toString())});
        }
    }

    private void recordInconsistentShare(ICopyFileArea cfa, FileAreaUpdate update, HashSet<UUID> inconsistentShares, IProgressMonitor monitor) {
        inconsistentShares.add(update.getItem().getItemId());
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
    }

    private void updateConfigurationStates(ICopyFileArea cfa, ArrayList<IVersionableHandle> shares, HashSet<UUID> inconsistentShares, IProgressMonitor progress) throws FileSystemException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)shares.size());
        ISyncTime syncTime = ISyncTime.FACTORY.createFrom(this.loadTree.getConfigurationState());
        for (IVersionableHandle shareRoot : shares) {
            if (inconsistentShares.contains(shareRoot.getItemId())) continue;
            cfa.setConfigurationState(this.connectionHandle, (IComponentHandle)this.component, shareRoot, syncTime, (IProgressMonitor)monitor.newChild(1));
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }

    private void modifyFile(ICopyFileArea cfa, IShareableInternal shareable, IDataSetDefinition dataSetDefinition, DataSetLoadUpdater updater, FileAreaUpdate update, ISharingDescriptor sharingDescriptor, IShareableInternal shareableLoaded, IProgressMonitor monitor) throws FileSystemException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)shareable.getFullPath().toString())});
        }
        LogUtility.logTrace((Log)LOG, null, (String[])new String[]{shareable.getFullPath().toOSString(), " to modify."});
        DeferredFileLoadInformation deferredFileLoadInformation = new DeferredFileLoadInformation(cfa, shareable, update, sharingDescriptor, new Date(shareableLoaded.getFileStorage().getModificationStamp()));
        this.pathsToUpdate.add(deferredFileLoadInformation);
        this.shares.add(deferredFileLoadInformation.getFileItemState());
        updater.modifyFile(deferredFileLoadInformation);
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)shareable.getFullPath().toString())});
        }
    }

    private void updateFile(ICopyFileArea cfa, IShareableInternal shareable, IDataSetDefinition dataSetDefinition, DataSetLoadUpdater updater, FileAreaUpdate update, ISharingDescriptor sharingDescriptor, IProgressMonitor monitor) throws FileSystemException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)shareable.getFullPath().toString())});
        }
        LogUtility.logTrace((Log)LOG, null, (String[])new String[]{shareable.getFullPath().toOSString(), " to update."});
        DeferredFileLoadInformation deferredFileLoadInformation = new DeferredFileLoadInformation(cfa, shareable, update, sharingDescriptor, new Date(shareable.getFileStorage().getModificationStamp()));
        deferredFileLoadInformation.setContentUpdated(update.getOptionalContent().getHash(), update.getOptionalContent().getRawLength());
        this.pathsToUpdate.add(deferredFileLoadInformation);
        this.shares.add(deferredFileLoadInformation.getFileItemState());
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)shareable.getFullPath().toString())});
        }
    }

    private void createNewFile(ICopyFileArea cfa, IShareableInternal shareable, IDataSetDefinition dataSetDefinition, DataSetLoadUpdater updater, FileAreaUpdate update, ISharingDescriptor sharingDescriptor, IProgressMonitor monitor) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)shareable.getFullPath().toString())});
        }
        LogUtility.logTrace((Log)LOG, null, (String[])new String[]{shareable.getFullPath().toOSString(), " to create."});
        DeferredFileLoadInformation deferredFileLoadInformation = new DeferredFileLoadInformation(cfa, shareable, update, sharingDescriptor, null);
        this.pathsToUpdate.add(deferredFileLoadInformation);
        this.shares.add(deferredFileLoadInformation.getFileItemState());
        updater.addFile(deferredFileLoadInformation);
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)shareable.getFullPath().toString())});
        }
    }

    private IDataSetDefinition getFolderDataSetDefinition(String errorName, FileAreaUpdate update, IProgressMonitor cMon) throws TeamRepositoryException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)errorName)});
        }
        IDataSetDefinition dataSetDefinition = null;
        IVersionableHandle item = update.afterState();
        String uuid = (String)update.getProperties().get("team.enterprise.resource.definition");
        if (uuid != null) {
            IDataSetDefinitionHandle dataSetDefinitionHandle = (IDataSetDefinitionHandle)IDataSetDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), null);
            dataSetDefinition = this.getCachedDataSetDefinition(errorName, this.repo, dataSetDefinitionHandle, cMon);
        }
        this.definitionsEncountered.put(item.getItemId(), dataSetDefinition);
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)errorName), LogField.valueOf((IItem)dataSetDefinition)});
        }
        return dataSetDefinition;
    }

    private IDataSetDefinition getDataSetDefinition(IFolderHandle folder, CancellationMonitor cMon) {
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), LogString.value((Object)folder.getItemId())});
        }
        return this.definitionsEncountered.get(folder.getItemId());
    }

    private IDataSetDefinition getFileDataSetDefinition(FileAreaUpdate update, IProgressMonitor cMon) throws TeamRepositoryException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)update.getName())});
        }
        IDataSetDefinition dataSetDefinition = null;
        if (this.definitionsEncountered.containsKey(update.getDestinationParent().getItemId())) {
            dataSetDefinition = this.definitionsEncountered.get(update.getDestinationParent().getItemId());
            if (this.debug) {
                Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)update.getName()), LogField.valueOf((IItem)dataSetDefinition)});
            }
            return dataSetDefinition;
        }
        IFolderHandle parentFolderHandle = update.getDestinationParent();
        if (parentFolderHandle != null) {
            IConfiguration configuration = this.connection instanceof IWorkspaceConnection ? ((IWorkspaceConnection)this.connection).configuration((IComponentHandle)this.component) : ((IBaselineConnection)this.connection).configuration();
            IFolder parentFolder = (IFolder)configuration.fetchCompleteItem((IVersionableHandle)update.parent(), cMon);
            String uuid = (String)parentFolder.getUserProperties().get("team.enterprise.resource.definition");
            if (uuid != null) {
                IDataSetDefinitionHandle dataSetDefinitionHandle = (IDataSetDefinitionHandle)IDataSetDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), null);
                dataSetDefinition = this.getCachedDataSetDefinition(update.getName(), this.repo, dataSetDefinitionHandle, cMon);
            }
            this.definitionsEncountered.put(parentFolder.getItemId(), dataSetDefinition);
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)update.getName()), LogField.valueOf((IItem)dataSetDefinition)});
        }
        return dataSetDefinition;
    }

    private void removeExtraneousMetadata(ICopyFileArea cfa, Map<UUID, HashMap<String, UUID>> allFolderChildren, IProgressMonitor progress) throws FileSystemException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)allFolderChildren.size());
        Collection allShares = cfa.allShares(this.connectionHandle, (IComponentHandle)this.component, (IProgressMonitor)monitor.newChild(1));
        Map<UUID, Set<IShare>> relatedShares = this.organizeSharesByLoadRoot(allShares);
        for (Map.Entry<UUID, HashMap<String, UUID>> entry : allFolderChildren.entrySet()) {
            SubMonitor subProgress = monitor.newChild(1);
            HashMap<String, UUID> namesOfChildrenLoaded = entry.getValue();
            Set<IShare> shares = relatedShares.get(entry.getKey());
            if (shares != null) {
                subProgress.setWorkRemaining(shares.size() * 4);
                for (IShare share : shares) {
                    IShareableInternal shareable = (IShareableInternal)share.getShareable();
                    UUID childLoaded = namesOfChildrenLoaded.get(shareable.getLocalPath().getName());
                    if (childLoaded == null) {
                        SharingManager.getInstance().disableChangeMonitoring();
                        try {
                            if (!shareable.exists((IProgressMonitor)subProgress.newChild(1))) continue;
                            shareable.getFileStorage().delete((IProgressMonitor)subProgress.newChild(1));
                            continue;
                        }
                        finally {
                            SharingManager.getInstance().enableChangeMonitoring();
                            FileItemInfo info = cfa.getItemInfo(shareable.getLocalPath());
                            if (info != null) {
                                cfa.forget(shareable.getLocalPath(), (IProgressMonitor)subProgress.newChild(1));
                            } else {
                                cfa.forget(this.connectionHandle, (IComponentHandle)this.component, share.getSharingDescriptor().getRootVersionable(), (IProgressMonitor)subProgress.newChild(1));
                            }
                        }
                    }
                    if (share.getSharingDescriptor().getRootVersionable().getItemId().equals((Object)childLoaded)) continue;
                    cfa.forget(this.connectionHandle, (IComponentHandle)this.component, share.getSharingDescriptor().getRootVersionable(), (IProgressMonitor)subProgress.newChild(3));
                }
            }
            subProgress.done();
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }

    private Map<UUID, Set<IShare>> organizeSharesByLoadRoot(Collection<IShare> allShares) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        HashMap<UUID, Set<IShare>> shares = new HashMap<UUID, Set<IShare>>();
        for (IShare share : allShares) {
            IVersionableHandle root = share.getSharingDescriptor().getReloadRoot();
            HashSet<IShare> children = (HashSet<IShare>)shares.get(root.getItemId());
            if (children == null) {
                children = new HashSet<IShare>();
                shares.put(root.getItemId(), children);
            }
            children.add(share);
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        return shares;
    }

    private IStatus[] getDownloadFailures(List<DeferredFileLoadInformation> pathsToUpdate, SubMonitor monitor) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        ArrayList<Object> errors = new ArrayList<Object>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)pathsToUpdate.size());
        boolean reportedSupportedCharSets = false;
        for (DeferredFileLoadInformation deferredUpdateInformation : pathsToUpdate) {
            IStatus status;
            if (deferredUpdateInformation.getFailure() == null) continue;
            Throwable rootCause = deferredUpdateInformation.getFailure().getCause();
            int paranoiaCount = 0;
            while (rootCause instanceof TeamRepositoryException && paranoiaCount < 50) {
                Throwable cause = ((TeamRepositoryException)rootCause).getCause();
                if (cause == null) break;
                rootCause = cause;
                ++paranoiaCount;
            }
            if (rootCause instanceof UnsupportedEncodingException || rootCause instanceof UnsupportedCharsetException) {
                if (!reportedSupportedCharSets) {
                    StringBuffer charSetsAvailable = new StringBuffer();
                    for (String charsetName : Charset.availableCharsets().keySet()) {
                        charSetsAvailable.append(charsetName).append(' ');
                    }
                    Status infoStatus = new Status(1, "com.ibm.teamz.fileagent", NLS.bind((String)Messages.MVSLoadMutator_15, (Object)charSetsAvailable.toString(), (Object[])new Object[0]));
                    errors.add(infoStatus);
                    reportedSupportedCharSets = true;
                }
                status = FileSystemStatusUtil.getStatusFor((int)4, (String)NLS.bind((String)Messages.MVSLoadMutator_16, (Object)deferredUpdateInformation.getShareable().getFullPath().toString(), (Object[])new Object[]{this.component.getName(), deferredUpdateInformation.getContent().getCharacterEncoding()}), (Throwable)deferredUpdateInformation.getFailure());
            } else if (rootCause instanceof CharacterCodingException) {
                status = FileSystemStatusUtil.getStatusFor((int)4, (String)NLS.bind((String)Messages.MVSLoadMutator_17, (Object)deferredUpdateInformation.getShareable().getFullPath().toString(), (Object[])new Object[]{this.component.getName(), deferredUpdateInformation.getContent().getCharacterEncoding()}), (Throwable)deferredUpdateInformation.getFailure());
            } else {
                if (rootCause instanceof OperationCanceledException) continue;
                status = FileSystemStatusUtil.getStatusFor((int)4, (String)NLS.bind((String)Messages.MVSLoadMutator_18, (Object)deferredUpdateInformation.getShareable().getFullPath().toString(), (Object[])new Object[]{this.component.getName()}), (Throwable)deferredUpdateInformation.getFailure());
            }
            errors.add(status);
            IShare share = null;
            try {
                share = deferredUpdateInformation.getShareable().getShare((IProgressMonitor)progress.newChild(1));
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
            if (share == null) continue;
            this.recordInconsistentShare(deferredUpdateInformation.getCopyFileArea(), deferredUpdateInformation.getFileAreaUpdate(), this.inconsistentShares, (IProgressMonitor)monitor);
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogString.value(errors)});
        }
        return errors.toArray(new IStatus[errors.size()]);
    }

    private IStatus[] getDatasetUpdateFailures(List<DataSetLoadUpdater> datasetUpdaters) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        for (DataSetLoadUpdater updater : datasetUpdaters) {
            for (IStatus s : updater.getErrors()) {
                errors.add(s);
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogString.value(errors)});
        }
        return errors.toArray(new IStatus[errors.size()]);
    }

    private void throwAppropriateException(String msg, IStatus[] statuses) throws FileSystemStatusException {
        MultiStatus multi = new MultiStatus("com.ibm.team.filesystem.client", 0, statuses, msg, null);
        if (multi.isOK()) {
            return;
        }
        if (multi.matches(4)) {
            throw new FileSystemStatusException((IStatus)multi);
        }
        if (multi.matches(8)) {
            throw new OperationCanceledException();
        }
        throw new FileSystemStatusException((IStatus)multi);
    }

    public InputStream prepareContentsToSet(IFileOptions fileOptions, InputStream in) throws FileSystemException {
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return in;
    }

    private static boolean isSimulatedModeOn() {
        return MVSStorageManager.SIMULATION_ENABLED;
    }

    private void traceTime(String text, long millisecs) {
        if (TIMING) {
            this.dbg.log(String.valueOf(text) + MVSLoadByDatasetMutator.formatIntoHHMMSSMMM(millisecs));
        }
    }

    private static String formatIntoHHMMSSMMM(long millisecs) {
        return String.format("%02d:%02d:%02d.%03d", TimeUnit.MILLISECONDS.toHours(millisecs), TimeUnit.MILLISECONDS.toMinutes(millisecs) % TimeUnit.HOURS.toMinutes(1L), TimeUnit.MILLISECONDS.toSeconds(millisecs) % TimeUnit.MINUTES.toSeconds(1L), TimeUnit.MILLISECONDS.toMillis(millisecs) % TimeUnit.SECONDS.toMillis(1L));
    }

    public final IThreadOwner getThreadOwner() {
        return this.threadOwner;
    }

    public final void setThreadOwner(IThreadOwner threadOwner) {
        this.threadOwner = threadOwner;
    }

    private void logLoadTrace(String s) {
        if (this.loadTracing != null) {
            this.loadTracing.printToLog(s);
        }
    }
}

