/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.extensions.mutators;

import com.ibm.team.enterprise.scmee.common.DeferredFileLoadInformation;
import com.ibm.team.enterprise.scmee.common.DownloadHandler;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IFileContentManager;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.IShareableInternal;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.teamz.fileagent.internal.extensions.impl.AbortLoadOperationException;
import com.ibm.teamz.fileagent.internal.extensions.impl.ZSharingData;
import com.ibm.teamz.fileagent.internal.extensions.mutators.IDataSetUpdater;
import com.ibm.teamz.fileagent.internal.extensions.mutators.MVSMutator;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class DataSetUpdateMutator
implements IDataSetUpdater {
    private final ISandbox sandbox;
    private final IRelativeLocation dataSet;
    private IDataSetDefinition dataSetDefinition;
    private final List<FileAreaUpdate> adds;
    private final List<FileAreaUpdate> mods;
    private final ICopyFileArea cfa;
    private final IConnection connection;
    private final IComponent component;
    private final Shed shed;
    private final IFileContentManager fileContentManager;
    private final IDownloadListener downloadMonitor;
    private final List<DeferredFileLoadInformation> deferredDownloadInfo;
    private final List<IStatus> errors;
    private boolean canceled;
    private FileAreaUpdate createDataSet;
    private boolean isAborted;

    public DataSetUpdateMutator(ICopyFileArea cfa, IConnection connection, IComponent component, ISandbox sandbox, IRelativeLocation dataSet, Shed shed, IDownloadListener downloadMonitor) {
        this.cfa = cfa;
        this.connection = connection;
        this.component = component;
        this.sandbox = sandbox;
        this.dataSet = dataSet;
        this.shed = shed;
        this.adds = new ArrayList<FileAreaUpdate>();
        this.mods = new ArrayList<FileAreaUpdate>();
        this.downloadMonitor = downloadMonitor;
        this.fileContentManager = FileSystemCore.getContentManager((ITeamRepository)connection.teamRepository());
        this.deferredDownloadInfo = new ArrayList<DeferredFileLoadInformation>(this.adds.size() + this.mods.size());
        this.errors = new ArrayList<IStatus>();
        this.canceled = false;
        this.isAborted = false;
    }

    public IDataSetDefinition getDataSetDefinition() {
        return this.dataSetDefinition;
    }

    public void setDataSetDefinition(IDataSetDefinition dataSetDefinition) {
        this.dataSetDefinition = dataSetDefinition;
    }

    public List<? extends DeferredFileLoadInformation> getDownloadInfo() {
        return this.deferredDownloadInfo;
    }

    public void createDataSet(FileAreaUpdate update) {
        this.createDataSet = update;
    }

    public void addMember(FileAreaUpdate update) {
        this.adds.add(update);
    }

    public void modifyMember(FileAreaUpdate update) {
        this.mods.add(update);
    }

    @Override
    public void updateDataSet(IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(1 + this.adds.size() + this.mods.size()));
        String errorName = "";
        if (this.createDataSet != null) {
            errorName = this.createDataSet.getName();
        } else if (!this.adds.isEmpty()) {
            errorName = this.adds.get(0).getName();
        } else if (!this.mods.isEmpty()) {
            errorName = this.mods.get(0).getName();
        }
        if (this.ensureDataSetExists(errorName, (IProgressMonitor)monitor.newChild(1))) {
            for (FileAreaUpdate update : this.adds) {
                this.checkIsCancelled((IProgressMonitor)monitor);
                this.processUpdate(update, false, (IProgressMonitor)monitor.newChild(1));
                if (!this.isAborted) continue;
                return;
            }
            for (FileAreaUpdate update : this.mods) {
                this.checkIsCancelled((IProgressMonitor)monitor);
                this.processUpdate(update, true, (IProgressMonitor)monitor.newChild(1));
                if (!this.isAborted) continue;
                return;
            }
        }
    }

    @Override
    public List<IStatus> getErrors() {
        return this.errors;
    }

    @Override
    public void updateCanceled() {
        this.canceled = true;
    }

    public void checkIsCancelled(IProgressMonitor monitor) {
        if (this.canceled || monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private boolean ensureDataSetExists(String name, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IShareableInternal datasetShareable = (IShareableInternal)this.sandbox.findShareable(this.dataSet, ResourceType.FOLDER);
        try {
            if (!datasetShareable.exists((IProgressMonitor)progress.newChild(1))) {
                datasetShareable.getFileStorage().create(true, (Object)this.dataSetDefinition, (IProgressMonitor)progress.newChild(1));
            }
            return true;
        }
        catch (FileSystemException e) {
            this.errors.add((IStatus)new Status(4, "com.ibm.teamz.fileagent", NLS.bind((String)Messages.MVSLoadMutator_8, (Object)this.sandbox.getRoot().append(this.dataSet).toOSString(), (Object[])new Object[]{name, this.component.getName()}), (Throwable)e));
            return false;
        }
    }

    private void processUpdate(FileAreaUpdate update, boolean shouldExist, IProgressMonitor monitor) {
        Map<String, byte[]> clientData;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IFileItemHandle fileItemState = (IFileItemHandle)update.afterState();
        IFolderHandle parent = update.getDestinationParent();
        IRelativeLocation path = MVSMutator.getLocation(update, this.dataSetDefinition);
        try {
            clientData = new ZSharingData((IDataSetDefinitionHandle)this.dataSetDefinition).getClientData();
        }
        catch (TeamRepositoryException e) {
            this.errors.add((IStatus)new Status(4, "com.ibm.teamz.fileagent", NLS.bind((String)Messages.DataSetUpdateMutator_0, (Object)this.sandbox.getRoot().append(path).toOSString(), (Object[])new Object[]{this.component.getName()}), (Throwable)e));
            return;
        }
        Shareable fileToCreate = new Shareable(this.sandbox.getRoot(), path, ResourceType.FILE);
        SharingDescriptor descriptor = SharingDescriptor.create((IConnection)this.connection, (IComponent)this.component, (IVersionableHandle)fileItemState, (IFolderHandle)parent, clientData);
        DeferredFileLoadInformation dataSetMemberUpdateInfo = new DeferredFileLoadInformation(this.cfa, (IShareableInternal)fileToCreate, update, (ISharingDescriptor)descriptor);
        this.deferredDownloadInfo.add(dataSetMemberUpdateInfo);
        boolean skipWrite = this.skipUpdate(this.sandbox.getRoot(), (IComponentHandle)this.component, (IVersionableHandle)fileItemState);
        this.storeFileContent(dataSetMemberUpdateInfo, (IShareableInternal)fileToCreate, shouldExist, skipWrite, (IProgressMonitor)progress);
    }

    private void storeFileContent(DeferredFileLoadInformation downloadInfo, IShareableInternal shareable, boolean shouldExist, boolean skipWrite, IProgressMonitor progress) {
        block5: {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            IFileItemHandle fileState = null;
            DownloadHandler downloadHandler = null;
            try {
                if (skipWrite && shareable.getRemote((IProgressMonitor)monitor.newChild(1)) != null && !this.fileContentManager.convertDelimitersDuringRetrieval(downloadInfo.getContent())) {
                    IFileContent content = downloadInfo.getContent();
                    downloadInfo.setContentUpdated(content.getHash(), content.getRawLength());
                    return;
                }
                Date existingShareableTimestamp = shouldExist ? new Date(downloadInfo.getShareable().getFileStorage().getModificationStamp()) : null;
                downloadInfo.setExistingShareableTimestamp(existingShareableTimestamp);
                fileState = (IFileItemHandle)downloadInfo.getFileItemState();
                downloadHandler = new DownloadHandler(shareable, downloadInfo, this.downloadMonitor, false, this.shed);
                InputStream inputStream = this.fileContentManager.retrieveContentStream(fileState, downloadInfo.getContent(), (IProgressMonitor)monitor.newChild(98));
                downloadHandler.downloadStreamAcquired(fileState, downloadInfo.getContent(), inputStream);
            }
            catch (TeamRepositoryException e) {
                if (downloadHandler != null && fileState != null) {
                    downloadHandler.downloadFailed(fileState, downloadInfo.getContent(), (Exception)((Object)e));
                } else {
                    downloadInfo.setFailure((Exception)((Object)e));
                }
                if (this.checkIsAborted(downloadInfo)) break block5;
                monitor.setWorkRemaining(100);
                this.doDilemmaHandling(downloadInfo, (IProgressMonitor)monitor);
            }
        }
    }

    private void doDilemmaHandling(DeferredFileLoadInformation downloadInfo, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.setWorkRemaining(100);
        if (downloadInfo.getFailure() != null) {
            Exception failure = downloadInfo.getFailure();
            Throwable rootCause = downloadInfo.getFailure().getCause();
            int digParanoiaCount = 0;
            while (rootCause instanceof TeamRepositoryException && digParanoiaCount < 50) {
                Throwable cause = ((TeamRepositoryException)rootCause).getCause();
                if (cause == null) break;
                rootCause = cause;
                ++digParanoiaCount;
            }
            if (rootCause instanceof UnsupportedEncodingException || rootCause instanceof UnsupportedCharsetException) {
                if (Charset.isSupported("ISO-8859-1")) {
                    downloadInfo.setAlternateEncoding("ISO-8859-1");
                    IFileItemHandle fileItemState = (IFileItemHandle)downloadInfo.getFileItemState();
                    DownloadHandler downloadHandler = new DownloadHandler(downloadInfo.getShareable(), downloadInfo, this.downloadMonitor, false, this.shed);
                    try {
                        InputStream inputStream = this.fileContentManager.retrieveContentStream(fileItemState, downloadInfo.getContent(), downloadInfo.getEncoding(), downloadInfo.getLineDelimiter(), (IProgressMonitor)progress);
                        downloadHandler.downloadStreamAcquired(fileItemState, downloadInfo.getContent(), inputStream);
                    }
                    catch (TeamRepositoryException e) {
                        if (!this.checkIsAborted(downloadInfo)) {
                            downloadInfo.setFailure(failure);
                        }
                    }
                }
            } else if (rootCause instanceof OperationCanceledException) {
                throw new OperationCanceledException();
            }
        }
    }

    private boolean checkIsAborted(DeferredFileLoadInformation deferredFileLoadInformation) {
        if (this.isAborted) {
            return true;
        }
        if (AbortLoadOperationException.isRootCause(deferredFileLoadInformation.getFailure())) {
            this.isAborted = true;
            return true;
        }
        return false;
    }

    protected final boolean skipUpdate(ILocation cfa, IComponentHandle comp, IVersionableHandle remote) {
        return false;
    }
}

