/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.extensions.mutators;

import com.ibm.team.enterprise.common.common.LocalPropertyTable;
import com.ibm.team.enterprise.scmee.common.IThreadOwner;
import com.ibm.team.repository.client.util.ThreadPool;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.teamz.fileagent.internal.extensions.mutators.CombinedCancellationMonitor;
import com.ibm.teamz.fileagent.internal.extensions.mutators.IDataSetUpdater;
import com.ibm.teamz.fileagent.internal.extensions.mutators.ProgressHandlingDataSetUpdateSession;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import com.ibm.teamz.impersonation.CoreJNI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class ASyncDataSetUpdateSession
extends ProgressHandlingDataSetUpdateSession {
    protected final ThreadPool threadPool;
    private final IThreadOwner threadOwner;

    public ASyncDataSetUpdateSession(String name, int numThreads, boolean allowFailures, long totalWork, IProgressMonitor mon) {
        this(name, numThreads, allowFailures, totalWork, null, mon);
    }

    public ASyncDataSetUpdateSession(String name, int numThreads, boolean allowFailures, long totalWork, IThreadOwner threadOwner, IProgressMonitor mon) {
        super(name, totalWork, false, mon);
        this.threadPool = new ThreadPool(numThreads, allowFailures);
        this.threadOwner = threadOwner;
    }

    protected void join() throws TeamRepositoryException {
        try {
            this.threadPool.join();
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw new TeamRepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    protected IStatus internalDoUpdateDataSet(IDataSetUpdater updater, IProgressMonitor mon) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)new CombinedCancellationMonitor(mon, this), (int)100);
        IStatus returnStatus = Status.OK_STATUS;
        try {
            this.switchAuth(this.threadOwner);
            this.handleCancel(updater);
            updater.updateDataSet((IProgressMonitor)progress);
            this.handleCancel(updater);
            IStatus iStatus = returnStatus;
            return iStatus;
        }
        catch (Exception e) {
            if (e instanceof OperationCanceledException) {
                returnStatus = Status.CANCEL_STATUS;
            } else if (e.getCause() instanceof CoreException) {
                returnStatus = new MultiStatus("com.ibm.teamz.fileagent", 0, Messages.ASyncDataSetUpdateSession_0, (Throwable)e);
                ((MultiStatus)returnStatus).add(((CoreException)e.getCause()).getStatus());
            } else {
                returnStatus = new Status(4, "com.ibm.teamz.fileagent", 0, Messages.ASyncDataSetUpdateSession_1, (Throwable)e);
            }
            IStatus iStatus = returnStatus;
            return iStatus;
        }
        finally {
            try {
                this.unSwitchAuth(this.threadOwner);
            }
            catch (Exception e) {
                returnStatus = new Status(4, "com.ibm.teamz.fileagent", 0, e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    @Override
    protected void internalUpdateDataSet(final IDataSetUpdater updater) throws TeamRepositoryException {
        ThreadPool.Task task = new ThreadPool.Task(){

            public IStatus run(IProgressMonitor mon) {
                return ASyncDataSetUpdateSession.this.internalDoUpdateDataSet(updater, mon);
            }
        };
        try {
            this.threadPool.addTask(task);
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    protected void handleCoreException(CoreException e) throws TeamRepositoryException {
        IStatus status = e.getStatus();
        assert (status.isOK()) : "Unexpected status value. An OK status should not be thrown.";
        if (status.matches(8)) {
            throw new OperationCanceledException();
        }
        try {
            throw new TeamRepositoryException(e.getStatus().getException().getMessage(), (Throwable)e);
        }
        catch (NullPointerException z) {
            throw new TeamRepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    protected void handleCancel(IDataSetUpdater updater) throws TeamRepositoryException {
        if (this.isCanceled()) {
            updater.updateCanceled();
            throw new OperationCanceledException();
        }
    }

    @Override
    public boolean isCanceled() {
        boolean canceled = super.isCanceled();
        if (canceled) {
            this.threadPool.setCancellation(Status.CANCEL_STATUS);
        }
        return canceled || this.threadPool.isCanceled();
    }

    public IStatus[] getErrorStatus() {
        return this.threadPool.getErrorStatus();
    }

    private final void switchAuth(IThreadOwner threadOwner) throws Exception {
        if (threadOwner != null) {
            int secrc = CoreJNI.pThreadSecurity((String)threadOwner.getUserID(), (String)threadOwner.getPassTicket(), (String)threadOwner.getApplId(), (boolean)true);
            if (secrc != 0) {
                throw new Exception("ThreadSecurity error: rc=" + secrc);
            }
            if (threadOwner.getProperties() != null) {
                LocalPropertyTable.get().set(threadOwner.getProperties());
            }
        }
    }

    private final void unSwitchAuth(IThreadOwner threadOwner) throws Exception {
        if (threadOwner != null) {
            int secrc;
            if (threadOwner.getProperties() != null) {
                LocalPropertyTable.get().remove();
            }
            if ((secrc = CoreJNI.pThreadSecurity((String)threadOwner.getUserID(), (String)threadOwner.getPassTicket(), (String)threadOwner.getApplId(), (boolean)false)) != 0) {
                throw new Exception("ThreadSecurity error: rc=" + secrc);
            }
        }
    }
}

