/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.extensions.impl;

import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.ItemHandleHelper;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.teamz.fileagent.internal.extensions.IZSharingData;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ZSharingData
implements IZSharingData,
Serializable {
    private static final long serialVersionUID = -6538442121923786622L;
    private static final short METADATA_VERSION1 = 1;
    private static final String RTCZ_NAMESPACE = "com.ibm.teamz.dataset";
    private final IDataSetDefinitionHandle dataSetDefinitionHandle;

    public static ZSharingData createFrom(ISharingDescriptor sharingDescriptor) throws FileSystemException {
        byte[] bytes = sharingDescriptor.getClientData(RTCZ_NAMESPACE);
        if (bytes != null) {
            try {
                ByteArrayInputStream data = new ByteArrayInputStream(bytes);
                ObjectInputStream in = new ObjectInputStream(data);
                short version = in.readShort();
                if (version != 1) {
                    throw new FileSystemException(NLS.bind((String)Messages.ZSharingData_0, (Object)version, (Object[])new Object[]{(short)1}));
                }
                IDataSetDefinitionHandle dataSetDefinitionHandle = (IDataSetDefinitionHandle)ItemHandleHelper.fromString((IItemType)IDataSetDefinition.ITEM_TYPE, (String)in.readUTF());
                return new ZSharingData(dataSetDefinitionHandle);
            }
            catch (IOException e) {
                throw new FileSystemException(Messages.ZSharingData_1, (Throwable)e);
            }
        }
        return null;
    }

    public ZSharingData(IDataSetDefinitionHandle dataSetDefinitionStateHandle) {
        if (!dataSetDefinitionStateHandle.hasStateId()) {
            throw new IllegalArgumentException(Messages.ZSharingData_2);
        }
        this.dataSetDefinitionHandle = dataSetDefinitionStateHandle;
    }

    @Override
    public IDataSetDefinitionHandle getDataSetDefinitionStateHandle() {
        return this.dataSetDefinitionHandle;
    }

    public Map<String, byte[]> getClientData() throws FileSystemException {
        try {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(data);
            out.writeShort(1);
            out.writeUTF(ItemHandleHelper.toString((IItemHandle)this.dataSetDefinitionHandle));
            out.flush();
            out.close();
            HashMap<String, byte[]> result = new HashMap<String, byte[]>(1);
            result.put(RTCZ_NAMESPACE, data.toByteArray());
            return result;
        }
        catch (IOException e) {
            throw new FileSystemException(Messages.ZSharingData_3, (Throwable)e);
        }
    }
}

