/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.extensions.impl;

import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogField;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.teamz.fileagent.internal.extensions.impl.IZFile;

public class ZFileWrapper
implements IZFile {
    private static final String cls = ZFileWrapper.class.getSimpleName();
    private static final int zFileMax = 5;
    private static final int zFileSleep = 100;
    private final IDebugger dbg;
    private final ZFile zfile;
    private final String dsn;

    public ZFileWrapper(String name, String options, IDebugger dbg) throws ZFileException {
        this.dbg = dbg != null ? dbg : new Debugger(ZFileWrapper.class);
        ZFile zF = null;
        int i = 1;
        while (zF == null && i <= 5) {
            try {
                zF = new ZFile(name, options);
            }
            catch (ZFileException e) {
                if (i == 5) {
                    throw e;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    throw e;
                }
            }
            ++i;
        }
        this.zfile = zF;
        this.dsn = zF.getActualFilename();
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{cls, LogField.valueOf((String)this.dsn)});
        }
    }

    @Override
    public void close() throws ZFileException {
        this.zfile.close();
    }

    @Override
    public boolean exists(String quotedName) throws ZFileException {
        boolean result = ZFile.exists((String)quotedName);
        if (this.dbg.isTrace()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), LogField.valueOf((String)this.dsn), LogField.valueOf((boolean)result)});
        }
        return result;
    }

    @Override
    public void flush() throws ZFileException {
        this.zfile.flush();
    }

    @Override
    public int getLrecl() throws ZFileException {
        return this.zfile.getLrecl();
    }

    @Override
    public String getRecfm() throws ZFileException {
        return this.zfile.getRecfm();
    }

    public ZFile getUnderlyingZFile() {
        return this.zfile;
    }

    @Override
    public void write(byte[] buffer, int offset, int len) throws ZFileException {
        this.zfile.write(buffer, offset, len);
    }
}

