/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.extensions.impl;

import com.ibm.jzos.PdsDirectory;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.DebugMessage;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogField;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.enterprise.common.common.IEnterpriseConfiguration;
import com.ibm.team.enterprise.common.common.utils.LoadTracing;
import com.ibm.team.enterprise.internal.common.client.EnterpriseConfigurationCache;
import com.ibm.team.enterprise.internal.common.common.model.CodePage;
import com.ibm.team.enterprise.scmee.common.EEZFileException;
import com.ibm.team.enterprise.scmee.common.SCMEEStorageManager;
import com.ibm.team.enterprise.scmee.zos.DataSetLocation;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.agent.AgentMapping;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.agent.MappingException;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.api.MappingValidation;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IShareableInternal;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.ContentLineDelimiterError;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.teamz.build.ant.jni.ISPFStatistics;
import com.ibm.teamz.build.ant.jni.SystemServices;
import com.ibm.teamz.build.ant.zos.exceptions.JzosException;
import com.ibm.teamz.build.ant.zos.exceptions.UndefinedRecordFormatException;
import com.ibm.teamz.build.ant.zos.utils.JzosUtility;
import com.ibm.teamz.build.ant.zos.utils.LogUtility;
import com.ibm.teamz.fileagent.IScmeeProperties;
import com.ibm.teamz.fileagent.PDSUtility;
import com.ibm.teamz.fileagent.UniqueDD;
import com.ibm.teamz.fileagent.importz.PDSInfo;
import com.ibm.teamz.fileagent.importz.PDSManager;
import com.ibm.teamz.fileagent.importz.PDSManagerException;
import com.ibm.teamz.fileagent.internal.binary.BinaryConverterException;
import com.ibm.teamz.fileagent.internal.binary.zos.ZosBinaryConverter;
import com.ibm.teamz.fileagent.internal.extensions.impl.ConvertFromPseudoSOSIInputStream;
import com.ibm.teamz.fileagent.internal.extensions.impl.ConvertToPseudoSOSIInputStream;
import com.ibm.teamz.fileagent.internal.extensions.impl.DataSetInformationCache;
import com.ibm.teamz.fileagent.internal.extensions.impl.IDataSetInformation;
import com.ibm.teamz.fileagent.internal.extensions.impl.IISPFStatistics;
import com.ibm.teamz.fileagent.internal.extensions.impl.ISPFStatisticsWrapper;
import com.ibm.teamz.fileagent.internal.extensions.impl.IZFile;
import com.ibm.teamz.fileagent.internal.extensions.impl.MVSStorageManager;
import com.ibm.teamz.fileagent.internal.extensions.impl.MemberInfo;
import com.ibm.teamz.fileagent.internal.extensions.impl.PDSMemberInfo;
import com.ibm.teamz.fileagent.internal.extensions.impl.SimulatedZFileInterface;
import com.ibm.teamz.fileagent.internal.extensions.impl.ZFileWrapper;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import com.ibm.teamz.fileagent.internal.utility.ReaderToInputStreamEE;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZFileInterface {
    private static final String cls = ZFileInterface.class.getSimpleName();
    private static final Log LOG = LogFactory.getLog(ZFileInterface.class);
    private static final String BPXWDYN_DD_COLON = "//DD:";
    private static final String CMD_ALLOC_SHR = "alloc fi(%1$s) da('%2$s') shr";
    private static final String CMD_ALLOC_SHR_REUSE = "alloc fi(%1$s) da('%2$s') shr reuse";
    private static final String CMD_FREE = "free fi(%s)";
    private static final String CMD_REMOVE = "//DD:%1$s";
    private static final String CMD_REMOVE_MBR = "//DD:%1$s(%2$s)";
    private static final String FMT_SCM_PATH = "//'%1$s'";
    private static final String READ_BINARY = "rb";
    private static final String READ_BINARY_NOSEEK = "rb,type=record,noseek";
    private static final String READ_TEXT_FILE_OPTIONS = "rt";
    private static final String WRITE_BINARY_FILE_OPTIONS = "wb,type=record,noseek";
    private static final String WRITE_TEXT_FILE_OPTIONS = "wt";
    private static final String WRITE_XMIT_FILE_OPTIONS = "wb,type=record,recfm=fb,lrecl=80,blksize=3120,noseek";
    private static final String DBG_MSG_CODEPAGE = "Codepage is illegal: {0} - ";
    private static final String DBG_MSG_CHARSET_NS = "Charset not supported by VM: {0} - ";
    private static final String DBG_MSG_CreateXmit = "Creating XMIT file failed: {0} - ";
    private static final String DBG_MSG_ReceiveCmd = "RECEIVE command failed: {0} - ";
    private static final String DBG_MSG_ScmMember = "Transmitting member to SCM: {0}";
    private static final String DBG_MSG_SOSI_Needed = "SOSI Conversion needed for {0}: {1}";
    private static final String DBG_MSG_UnableToCheckNL = "Unable to check NL character due to PDSInfo failed: {0} ({1}) - ";
    private static final String DBG_MSG_UnableToGetPdsCh = "Unable to obtain PDSInfo due to: ({0}) {1} - ";
    private static final String DBG_MSG_UnableToGetStats = "Unable to get ISPF statistics for: ({0}) {1} - ";
    private static final String DBG_MSG_UnableToUpdStats = "Unable to update ISPF statistics for: ({0}) {1} - ";
    private static final String RGX_ERRNO2 = ".* errno2=0xc00b0445 .*";
    private static final int BUFFER_SIZE_UNDEFINED = 0;
    private static final char LINE_SEPARATOR = '\n';
    private static final boolean SCMEE_SKIP_SSI_CHECK = System.getProperty("scmee.skipSSICheck") != null;
    public static final boolean SCMEE_SOSI_CONVERSION_DISABLED = System.getProperty("scmee.sosi.conversion.disabled") != null;
    public static final boolean SCMEE_ENCODING_REPORT_DISABLED = System.getProperty("scmee.coding.error.report.disabled") != null;
    private static final boolean SCMEE_REMOVE_LAST_NL_DISABLED = System.getProperty("scmee.remove.last.nl.disabled") != null;
    private static final Integer SCMEE_RETRY_CREATE_LIMIT = Integer.getInteger("scmee.retry.create.limit", IScmeeProperties.SCMEE_RETRY_CREATE_DEFAULT);
    private static final List<String> predefinedDBCScodepages = new ArrayList<String>(Arrays.asList("x-IBM930", "x-IBM933", "x-IBM935", "x-IBM937", "x-IBM939", "x-IBM1364", "x-IBM1371", "x-IBM1388", "x-IBM1390", "x-IBM1399"));
    private static Set<String> codePage4ExtraSOSIProcessing = null;
    private static byte[] AllBytes;
    private static Map<Charset, Set<Byte>> charsetMap;
    private final DataSetLocation location;
    private final IFileStorage storage;
    private final LoadTracing loadTracing;
    private final SystemServices services;
    private final IDebugger dbg;
    private final boolean debug;
    private final boolean items;
    private final boolean trace;
    private final boolean traceLoad;
    private final String dbgName;
    private IDataSetInformation datasetInformation;
    IEnterpriseConfiguration configuration;
    private Integer memberLines = null;
    private IISPFStatistics memberStatistics;

    static {
        byte[] byArray = new byte[256];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        byArray[9] = 9;
        byArray[10] = 10;
        byArray[11] = 11;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        byArray[16] = 16;
        byArray[17] = 17;
        byArray[18] = 18;
        byArray[19] = 19;
        byArray[20] = 20;
        byArray[21] = 21;
        byArray[22] = 22;
        byArray[23] = 23;
        byArray[24] = 24;
        byArray[25] = 25;
        byArray[26] = 26;
        byArray[27] = 27;
        byArray[28] = 28;
        byArray[29] = 29;
        byArray[30] = 30;
        byArray[31] = 31;
        byArray[32] = 32;
        byArray[33] = 33;
        byArray[34] = 34;
        byArray[35] = 35;
        byArray[36] = 36;
        byArray[37] = 37;
        byArray[38] = 38;
        byArray[39] = 39;
        byArray[40] = 40;
        byArray[41] = 41;
        byArray[42] = 42;
        byArray[43] = 43;
        byArray[44] = 44;
        byArray[45] = 45;
        byArray[46] = 46;
        byArray[47] = 47;
        byArray[48] = 48;
        byArray[49] = 49;
        byArray[50] = 50;
        byArray[51] = 51;
        byArray[52] = 52;
        byArray[53] = 53;
        byArray[54] = 54;
        byArray[55] = 55;
        byArray[56] = 56;
        byArray[57] = 57;
        byArray[58] = 58;
        byArray[59] = 59;
        byArray[60] = 60;
        byArray[61] = 61;
        byArray[62] = 62;
        byArray[63] = 63;
        byArray[64] = 64;
        byArray[65] = 65;
        byArray[66] = 66;
        byArray[67] = 67;
        byArray[68] = 68;
        byArray[69] = 69;
        byArray[70] = 70;
        byArray[71] = 71;
        byArray[72] = 72;
        byArray[73] = 73;
        byArray[74] = 74;
        byArray[75] = 75;
        byArray[76] = 76;
        byArray[77] = 77;
        byArray[78] = 78;
        byArray[79] = 79;
        byArray[80] = 80;
        byArray[81] = 81;
        byArray[82] = 82;
        byArray[83] = 83;
        byArray[84] = 84;
        byArray[85] = 85;
        byArray[86] = 86;
        byArray[87] = 87;
        byArray[88] = 88;
        byArray[89] = 89;
        byArray[90] = 90;
        byArray[91] = 91;
        byArray[92] = 92;
        byArray[93] = 93;
        byArray[94] = 94;
        byArray[95] = 95;
        byArray[96] = 96;
        byArray[97] = 97;
        byArray[98] = 98;
        byArray[99] = 99;
        byArray[100] = 100;
        byArray[101] = 101;
        byArray[102] = 102;
        byArray[103] = 103;
        byArray[104] = 104;
        byArray[105] = 105;
        byArray[106] = 106;
        byArray[107] = 107;
        byArray[108] = 108;
        byArray[109] = 109;
        byArray[110] = 110;
        byArray[111] = 111;
        byArray[112] = 112;
        byArray[113] = 113;
        byArray[114] = 114;
        byArray[115] = 115;
        byArray[116] = 116;
        byArray[117] = 117;
        byArray[118] = 118;
        byArray[119] = 119;
        byArray[120] = 120;
        byArray[121] = 121;
        byArray[122] = 122;
        byArray[123] = 123;
        byArray[124] = 124;
        byArray[125] = 125;
        byArray[126] = 126;
        byArray[127] = 127;
        byArray[128] = -128;
        byArray[129] = -127;
        byArray[130] = -126;
        byArray[131] = -125;
        byArray[132] = -124;
        byArray[133] = -123;
        byArray[134] = -122;
        byArray[135] = -121;
        byArray[136] = -120;
        byArray[137] = -119;
        byArray[138] = -118;
        byArray[139] = -117;
        byArray[140] = -116;
        byArray[141] = -115;
        byArray[142] = -114;
        byArray[143] = -113;
        byArray[144] = -112;
        byArray[145] = -111;
        byArray[146] = -110;
        byArray[147] = -109;
        byArray[148] = -108;
        byArray[149] = -107;
        byArray[150] = -106;
        byArray[151] = -105;
        byArray[152] = -104;
        byArray[153] = -103;
        byArray[154] = -102;
        byArray[155] = -101;
        byArray[156] = -100;
        byArray[157] = -99;
        byArray[158] = -98;
        byArray[159] = -97;
        byArray[160] = -96;
        byArray[161] = -95;
        byArray[162] = -94;
        byArray[163] = -93;
        byArray[164] = -92;
        byArray[165] = -91;
        byArray[166] = -90;
        byArray[167] = -89;
        byArray[168] = -88;
        byArray[169] = -87;
        byArray[170] = -86;
        byArray[171] = -85;
        byArray[172] = -84;
        byArray[173] = -83;
        byArray[174] = -82;
        byArray[175] = -81;
        byArray[176] = -80;
        byArray[177] = -79;
        byArray[178] = -78;
        byArray[179] = -77;
        byArray[180] = -76;
        byArray[181] = -75;
        byArray[182] = -74;
        byArray[183] = -73;
        byArray[184] = -72;
        byArray[185] = -71;
        byArray[186] = -70;
        byArray[187] = -69;
        byArray[188] = -68;
        byArray[189] = -67;
        byArray[190] = -66;
        byArray[191] = -65;
        byArray[192] = -64;
        byArray[193] = -63;
        byArray[194] = -62;
        byArray[195] = -61;
        byArray[196] = -60;
        byArray[197] = -59;
        byArray[198] = -58;
        byArray[199] = -57;
        byArray[200] = -56;
        byArray[201] = -55;
        byArray[202] = -54;
        byArray[203] = -53;
        byArray[204] = -52;
        byArray[205] = -51;
        byArray[206] = -50;
        byArray[207] = -49;
        byArray[208] = -48;
        byArray[209] = -47;
        byArray[210] = -46;
        byArray[211] = -45;
        byArray[212] = -44;
        byArray[213] = -43;
        byArray[214] = -42;
        byArray[215] = -41;
        byArray[216] = -40;
        byArray[217] = -39;
        byArray[218] = -38;
        byArray[219] = -37;
        byArray[220] = -36;
        byArray[221] = -35;
        byArray[222] = -34;
        byArray[223] = -33;
        byArray[224] = -32;
        byArray[225] = -31;
        byArray[226] = -30;
        byArray[227] = -29;
        byArray[228] = -28;
        byArray[229] = -27;
        byArray[230] = -26;
        byArray[231] = -25;
        byArray[232] = -24;
        byArray[233] = -23;
        byArray[234] = -22;
        byArray[235] = -21;
        byArray[236] = -20;
        byArray[237] = -19;
        byArray[238] = -18;
        byArray[239] = -17;
        byArray[240] = -16;
        byArray[241] = -15;
        byArray[242] = -14;
        byArray[243] = -13;
        byArray[244] = -12;
        byArray[245] = -11;
        byArray[246] = -10;
        byArray[247] = -9;
        byArray[248] = -8;
        byArray[249] = -7;
        byArray[250] = -6;
        byArray[251] = -5;
        byArray[252] = -4;
        byArray[253] = -3;
        byArray[254] = -2;
        byArray[255] = -1;
        AllBytes = byArray;
        charsetMap = new HashMap<Charset, Set<Byte>>(10);
    }

    public ZFileInterface(DataSetLocation location, IFileStorage storage, LoadTracing loadTracing) throws FileSystemException {
        this.location = location;
        this.storage = storage;
        this.loadTracing = loadTracing;
        this.services = new SystemServices();
        this.dbg = SCMEEStorageManager.getCommonDbg();
        this.debug = this.dbg.isDebug();
        this.trace = this.dbg.isTrace();
        this.items = this.dbg.isItems();
        this.traceLoad = loadTracing != null;
        String string = this.dbgName = this.location.getDatasetName() != null ? this.location.getDatasetName().toString() : this.location.getName();
        if (this.isMember()) {
            try {
                this.datasetInformation = DataSetInformationCache.getInstance().get((DataSetLocation)location.getParent());
            }
            catch (Exception exception) {}
        } else {
            this.datasetInformation = DataSetInformationCache.getInstance().get(location);
        }
        this.configuration = this.datasetInformation != null ? this.datasetInformation.getConfiguration() : EnterpriseConfigurationCache.getInstance().createDefault(null);
        if (this.debug) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, this.dbgName});
        }
        if (this.items) {
            String loc = this.dbgName;
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, Debug.data((String[])new String[]{loc, "SCMEE_SKIP_SSI_CHECK", LogField.valueOf((boolean)SCMEE_SKIP_SSI_CHECK)})});
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, Debug.data((String[])new String[]{loc, "SCMEE_SOSI_CONVERSION_DISABLED", LogField.valueOf((boolean)SCMEE_SOSI_CONVERSION_DISABLED)})});
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, Debug.data((String[])new String[]{loc, "SCMEE_ENCODING_REPORT_DISABLED", LogField.valueOf((boolean)SCMEE_ENCODING_REPORT_DISABLED)})});
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, Debug.data((String[])new String[]{loc, "SCMEE_REMOVE_LAST_NL_DISABLED", LogField.valueOf((boolean)SCMEE_REMOVE_LAST_NL_DISABLED)})});
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, Debug.data((String[])new String[]{loc, "SCMEE_RETRY_CREATE_LIMIT", LogField.valueOf((Integer)SCMEE_RETRY_CREATE_LIMIT)})});
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, Debug.data((String[])new String[]{loc, "IDataSetInformation", Boolean.toString(this.datasetInformation != null)})});
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, Debug.data((String[])new String[]{loc, "IEnterpriseConfiguration", Boolean.toString(this.configuration != null)})});
        }
        this.validate(location);
        String zLang = System.getenv("ZLANG");
        if (zLang != null && zLang.length() > 0 && (zLang.contains("1142") || zLang.contains("277")) && !this.configuration.getCodePage().equals(CodePage.IBM1142_LITERAL) && !this.configuration.getCodePage().equals(CodePage.IBM277_LITERAL)) {
            this.configuration.setCodePage(CodePage.IBM277_LITERAL);
        }
        this.convertHighLevelQualifier();
        this.convertDataSetName();
        this.convertMemberName();
    }

    private int validate(DataSetLocation location) throws FileSystemException {
        int result;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        MappingValidation valider = new MappingValidation(this.configuration);
        if (location.getMember() != null) {
            String[] messages = new String[2];
            int i = 0;
            result = valider.isValidMemberName(location.getMember());
            if (result > 0) {
                messages[i++] = valider.getMemberErrorMessage(result);
            }
            if ((result = valider.isValidDSName(location.getDatasetName(), null)) > 0) {
                messages[i++] = valider.getDSNameErrorMessage(result);
            }
            if (i == 1) {
                throw new FileSystemException(NLS.bind((String)Messages.ZFileInterface_2, (Object)location.toOSString(), (Object[])new Object[]{messages[0]}));
            }
            if (i == 2) {
                throw new FileSystemException(NLS.bind((String)Messages.ZFileInterface_2, (Object)location.toOSString(), (Object[])new Object[]{String.valueOf(messages[0]) + " & " + messages[1]}));
            }
        } else {
            result = valider.isValidDSName(location.getDatasetName(), null);
            if (result > 0) {
                throw new FileSystemException(NLS.bind((String)Messages.ZFileInterface_2, (Object)location.toOSString(), (Object[])new Object[]{valider.getDSNameErrorMessage(result)}));
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, LogField.valueOf((int)result)});
        }
        return result;
    }

    private void convertHighLevelQualifier() {
        String result = "";
        String hlq = this.location.getHighLevelQualifier();
        if (hlq != null && hlq.length() > 0 && !(result = this.configuration.toCommonCodePage(hlq)).equals(hlq)) {
            this.location.setHighLevelQualifier(result);
        }
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, result});
        }
    }

    private void convertDataSetName() {
        String result = "";
        String dsName = this.location.getDataSetName();
        if (dsName != null && dsName.length() > 0 && !(result = this.configuration.toCommonCodePage(dsName)).equals(dsName)) {
            this.location.setDataSetName(result);
        }
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, result});
        }
    }

    private void convertMemberName() {
        String result = "";
        String mbrName = this.location.getMember();
        if (mbrName != null && mbrName.length() > 0 && !(result = this.configuration.toCommonCodePage(mbrName)).equals(mbrName)) {
            this.location.setMember(result);
        }
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, result});
        }
    }

    public boolean exists() throws ZFileException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        boolean result = false;
        if (!this.hasDatasetInformation() && this.hasDatasetInformationCached()) {
            this.datasetInformation = DataSetInformationCache.getInstance().getMap().get(this.location);
            if (this.trace) {
                Debug.debug((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, "Cached"});
            }
        }
        if (this.location.hasMember()) {
            if (this.hasDatasetInformation() && this.datasetInformation.isMemberMapped(this.location.getMember())) {
                if (this.datasetInformation.isDatasetExists()) {
                    result = this.datasetInformation.memberExists(this.location.getMember());
                }
                if (this.trace) {
                    Debug.debug((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, "DsInfo"});
                }
            } else {
                result = ZFile.dsExists((String)JzosUtility.getSlashSlashQuotedDSN((String)this.getFullName()));
                if (this.trace) {
                    Debug.debug((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, "ZFile"});
                }
            }
        } else if (this.hasDatasetInformation()) {
            if (this.datasetInformation.isDatasetExists()) {
                result = true;
            }
            if (this.trace) {
                Debug.debug((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, "DsInfo"});
            }
        } else {
            result = this.services.locateDataset(this.location.getDatasetName());
            if (this.trace) {
                Debug.debug((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, "Locate"});
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, LogField.valueOf((boolean)result)});
        }
        return result;
    }

    public boolean isFolder() {
        boolean result;
        boolean bl = result = !this.location.hasMember();
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.valueOf((boolean)result)});
        }
        return result;
    }

    public boolean isMember() {
        boolean result = this.location.hasMember();
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.valueOf((boolean)result)});
        }
        return result;
    }

    public final boolean memberExists() throws ZFileException {
        boolean result = this.hasDatasetInformation() ? this.datasetInformation.memberExists(this.location.getMember()) : this.exists();
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.valueOf((boolean)result)});
        }
        return result;
    }

    public long getModificationStamp() throws IOException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        long result = 0L;
        Date date = null;
        if (this.hasDatasetInformation() && this.datasetInformation.getDatasetMemberMap().containsKey(this.location.getMember())) {
            MemberInfo info = this.datasetInformation.getDatasetMemberMap().get(this.location.getMember());
            date = info.getModificationDate();
        } else {
            IISPFStatistics stats = this.getMemberStatistics();
            if (stats != null) {
                date = stats.getModificationDate();
            }
        }
        if (date != null) {
            result = date.getTime();
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, LogField.valueOf((long)result)});
        }
        return result;
    }

    public void setModificationStamp(long timestamp) throws UnsupportedEncodingException, IOException {
        IISPFStatistics stats;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        if ((stats = this.getMemberStatistics()) != null) {
            stats.setModificationDate(new Date(timestamp));
            if (stats.getCreationDate().after(stats.getModificationDate())) {
                stats.setCreationDate(stats.getModificationDate());
            }
            stats.save();
            this.memberStatistics = stats;
            if (this.hasDatasetInformation() && this.datasetInformation.getDatasetMemberMap().containsKey(this.location.getMember())) {
                MemberInfo info = this.datasetInformation.getDatasetMemberMap().get(this.location.getMember());
                info.setModificationDate(stats.getModificationDate());
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, LogField.nonNull((Object)stats)});
        }
    }

    public int getCurrentNumberOfLines() throws IOException {
        IISPFStatistics stats = this.getMemberStatistics();
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.nonNull((Object)stats)});
        }
        return stats == null ? -1 : stats.getCurrentLines();
    }

    public int getInitialNumberOfLines() throws IOException {
        IISPFStatistics stats = this.getMemberStatistics();
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.nonNull((Object)stats)});
        }
        return stats == null ? -1 : stats.getInitialLines();
    }

    public String getName() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return this.location.getName();
    }

    public InputStream getEncodedContents(String localEncoding, String serverEncoding) throws ZFileException, UnsupportedEncodingException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        Reader readerToConvert = null;
        InputStreamReader reader = null;
        String member = JzosUtility.getSlashSlashQuotedDSN((String)this.location.toOSString());
        CharsetDecoder decoder = Charset.forName(localEncoding).newDecoder().onMalformedInput(SCMEE_ENCODING_REPORT_DISABLED ? CodingErrorAction.REPLACE : CodingErrorAction.REPORT).onUnmappableCharacter(SCMEE_ENCODING_REPORT_DISABLED ? CodingErrorAction.REPLACE : CodingErrorAction.REPORT);
        DebugMessage debugMsg = null;
        if (LOG.isDebugEnabled()) {
            debugMsg = new DebugMessage(cls, mnm, true);
            debugMsg.append(" For member: ");
            debugMsg.append(member);
            debugMsg.append(" locally encoded in: ");
            debugMsg.append(localEncoding);
            debugMsg.append(" to server encoding: ");
            debugMsg.append(serverEncoding);
        }
        try {
            if (!ZFileInterface.SOSIConversionNeeded(localEncoding, this.location, this.dbg)) {
                reader = new InputStreamReader(this.getInputStream(member, READ_TEXT_FILE_OPTIONS), decoder);
            } else {
                if (LOG.isDebugEnabled()) {
                    debugMsg.append(" with SO/SI conversion");
                }
                reader = new InputStreamReader((InputStream)new ConvertToPseudoSOSIInputStream(this.getInputStream(member, READ_TEXT_FILE_OPTIONS)), decoder);
            }
            if (this.isNewLineCheckingWanted()) {
                String recfm;
                block21: {
                    recfm = null;
                    try {
                        PDSInfo info = this.getPDSInfo();
                        recfm = info.getRecfm();
                    }
                    catch (PDSManagerException e) {
                        if (!LOG.isWarnEnabled()) break block21;
                        DebugMessage msg = new DebugMessage(cls, mnm, true, DBG_MSG_UnableToCheckNL, new Object[]{this.location, e.getMessage()});
                        LogUtility.logWarn((Log)LOG, (Exception)e, (String[])new String[]{msg.bind()});
                    }
                }
                if (recfm != null) {
                    if (recfm.toLowerCase().startsWith("f")) {
                        if (LOG.isDebugEnabled()) {
                            debugMsg.append(" with RECFM=F");
                        }
                        readerToConvert = this.getWrapperInputStream((Reader)reader, this.getNumberOfLine(member), '\n', this.getFullName());
                    } else if (recfm.toLowerCase().startsWith("v")) {
                        if (LOG.isDebugEnabled()) {
                            debugMsg.append(" with RECFM=V");
                        }
                        Set<Byte> NLbytes = this.checkNLbytesFor(localEncoding);
                        readerToConvert = this.getWrapperInputStream((Reader)reader, this.getBinaryContents(), NLbytes, this.getFullName());
                    }
                }
            }
            if (readerToConvert == null) {
                readerToConvert = reader;
            }
        }
        catch (Throwable throwable) {
            if (LOG.isDebugEnabled()) {
                LogUtility.logDebug((Log)LOG, null, (String[])new String[]{debugMsg.toString()});
            }
            throw throwable;
        }
        if (LOG.isDebugEnabled()) {
            LogUtility.logDebug((Log)LOG, null, (String[])new String[]{debugMsg.toString()});
        }
        if (!SCMEE_REMOVE_LAST_NL_DISABLED) {
            readerToConvert = this.getRemoveLastNLInputStreamReader(readerToConvert, '\n');
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        return new ReaderToInputStream(readerToConvert, serverEncoding);
    }

    protected Reader getRemoveLastNLInputStreamReader(Reader wrapped, char lineSeparator) {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return new RemoveLastNLInputStreamReader(wrapped, lineSeparator);
    }

    private Reader getWrapperInputStream(Reader wrapped, long numberOfLines, char lineSeparator, String name) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        Reader result = numberOfLines == -1L ? wrapped : new NLVerifyFixedRecfmInputStreamReader(wrapped, numberOfLines, lineSeparator, name);
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        return result;
    }

    private Reader getWrapperInputStream(Reader wrapped, InputStream inputStream, Set<Byte> aNLbytes, String name) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        NLVerifyVariableRecfmInputStreamReader result = new NLVerifyVariableRecfmInputStreamReader(wrapped, inputStream, aNLbytes, name);
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        return result;
    }

    private Set<Byte> checkNLbytesFor(String encoding) {
        Charset cs = Charset.forName(encoding);
        if (charsetMap.get(cs) == null) {
            CharBuffer cb = cs.decode(ByteBuffer.wrap(AllBytes));
            HashSet<Byte> bytes = new HashSet<Byte>();
            charsetMap.put(cs, bytes);
            int i = 0;
            while (cb.hasRemaining()) {
                if (cb.get() == '\n') {
                    bytes.add(AllBytes[i]);
                }
                ++i;
            }
        }
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return charsetMap.get(cs);
    }

    public boolean isNewLineCheckingWanted() {
        boolean result;
        boolean bl = result = PDSManager.isNLCheckingAllowed() && PDSManager.isNLCheckingWanted();
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.valueOf((boolean)result)});
        }
        return result;
    }

    public InputStream getBinaryContents() throws ZFileException {
        String member = JzosUtility.getSlashSlashQuotedDSN((String)this.location.toOSString());
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return new ZBinaryInputStream(this.getUnderlyingZFile(member, READ_BINARY_NOSEEK));
    }

    /*
     * Unable to fully structure code
     */
    public boolean updateMemberContents(InputStream inputStream, boolean isBinaryType, String ddName, long timestamp, boolean bConvertSOSI) throws IOException, FileSystemException {
        v0 = mnm = this.dbg.isOn() != false ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{ZFileInterface.cls, mnm, this.dbgName});
        }
        intialSize = -1;
        creationDate = new Date(0L);
        alreadyExist = false;
        if (this.hasDatasetInformation()) {
            info = this.datasetInformation.getDatasetMemberMap().get(this.location.getMember());
            if (info != null) {
                intialSize = info.getCurrentLines();
                creationDate = info.getCreationDate();
                alreadyExist = true;
            }
        } else {
            alreadyExist = this.exists();
            stats = null;
            if (alreadyExist && (stats = this.getMemberStatistics()) != null) {
                intialSize = stats.getInitialLines();
                creationDate = stats.getCreationDate();
            }
        }
        success = false;
        formattedMemberBuffer = null;
        formattedMember = null;
        if (ddName != null && ddName.length() > 0) {
            dd = UniqueDD.getInstance().get();
            cmd = String.format("alloc fi(%1$s) da('%2$s') shr", new Object[]{dd, this.location.toString()});
            formattedMemberBuffer = new StringBuffer();
            formattedMemberBuffer.append("//DD:");
            formattedMemberBuffer.append(dd);
            formattedMember = formattedMemberBuffer.toString();
            this.allocate(cmd);
            try {
                success = isBinaryType != false ? this.updateMemberBinaryContents(inputStream, formattedMember) : this.updateMemberTextContents(inputStream, formattedMember, bConvertSOSI);
                if (!success) ** GOTO lbl66
                this.updateStatistics(formattedMember, alreadyExist, intialSize, creationDate, timestamp);
            }
            finally {
                this.freePF(dd);
            }
        } else {
            tempDDName = this.instantAllocateByDDName();
            try {
                formattedMemberBuffer = new StringBuffer();
                formattedMemberBuffer.append("//DD:");
                formattedMemberBuffer.append(tempDDName);
                formattedMemberBuffer.append("(");
                formattedMemberBuffer.append(this.location.getMember());
                formattedMemberBuffer.append(")");
                formattedMember = formattedMemberBuffer.toString();
                success = isBinaryType != false ? this.updateMemberBinaryContents(inputStream, formattedMember) : this.updateMemberTextContents(inputStream, formattedMember, bConvertSOSI);
                if (success) {
                    this.updateStatistics(formattedMemberBuffer.toString(), alreadyExist, intialSize, creationDate, timestamp);
                }
            }
            finally {
                try {
                    this.freeByDDname(tempDDName);
                }
                catch (JzosException e) {
                    throw new FileSystemException((Throwable)e);
                }
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{ZFileInterface.cls, mnm, this.dbgName, LogField.valueOf((boolean)success)});
        }
        return success;
    }

    protected boolean allocate(String cmd) throws IOException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        try {
            JzosUtility.executeCommand((String)cmd, (LoadTracing)this.loadTracing);
        }
        catch (JzosException e) {
            if (this.traceLoad) {
                DebugMessage msg = new DebugMessage(cls, mnm, true, e.getMessage(), new Object[0]);
                this.loadTracing.printToLog(msg.bind());
            }
            throw new IOException(e);
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        return true;
    }

    protected String instantAllocateByDDName() throws FileSystemException, ZFileException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        String result = this.getUniqueDD();
        String allocCmd = String.format(CMD_ALLOC_SHR_REUSE, result, this.location.getDatasetName());
        if (!MVSStorageManager.SIMULATION_ENABLED) {
            try {
                JzosUtility.executeCommand((String)allocCmd, (LoadTracing)this.loadTracing);
            }
            catch (JzosException e) {
                throw new FileSystemException((Throwable)e);
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        return result;
    }

    protected boolean ddExists(String ddName) {
        boolean result = this.services.locateDD(ddName);
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.valueOf((boolean)result)});
        }
        return result;
    }

    private void updateStatistics(String formattedMember, boolean alreadyExist, int intialSize, Date creationDate, long timestampToProcess) {
        String mnm;
        block20: {
            String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
            if (this.debug) {
                Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
            }
            IISPFStatistics stats = null;
            stats = this.getMemberStatistics();
            if (stats != null) {
                DebugMessage msg;
                int lines;
                block19: {
                    long timestamp;
                    if (alreadyExist) {
                        stats.setInitialLines(intialSize);
                        stats.setCreationDate(creationDate);
                    }
                    if ((timestamp = timestampToProcess) == -1L) {
                        timestamp = System.currentTimeMillis();
                    }
                    timestamp = timestamp / 1000L * 1000L;
                    stats.setModificationDate(new Date(timestamp));
                    if (stats.getCreationDate().after(stats.getModificationDate())) {
                        stats.setCreationDate(stats.getModificationDate());
                    }
                    lines = -1;
                    try {
                        lines = (int)this.getNumberOfLine(formattedMember);
                    }
                    catch (ZFileException e) {
                        if (!LOG.isErrorEnabled()) break block19;
                        msg = new DebugMessage(cls, mnm, true, DBG_MSG_UnableToUpdStats, new Object[]{1, this.getFullName()});
                        LogUtility.logError((Log)LOG, (Exception)((Object)e), (String[])new String[]{msg.bind()});
                    }
                }
                if (lines != -1) {
                    stats.setCurrentLines(lines);
                    if (!alreadyExist) {
                        stats.setInitialLines(lines);
                    }
                }
                try {
                    if (this.traceLoad) {
                        DebugMessage msg2 = new DebugMessage(cls, mnm, true, Messages.ZFileInterface_logging_3, new Object[]{this.getFullName()});
                        this.loadTracing.printToLog(msg2.bind());
                    }
                    stats.save();
                    this.memberStatistics = stats;
                    if (this.hasDatasetInformation()) {
                        MemberInfo info;
                        if (this.datasetInformation.getDatasetMemberMap().containsKey(this.location.getMember())) {
                            info = this.datasetInformation.getDatasetMemberMap().get(this.location.getMember());
                            info.setCreationDate(stats.getCreationDate());
                            info.setCurrentLines(stats.getCurrentLines());
                            info.setInitialLines(stats.getInitialLines());
                            info.setModificationDate(stats.getModificationDate());
                        } else if (!MVSStorageManager.SIMULATION_ENABLED) {
                            info = new PDSMemberInfo(new PdsDirectory.MemberInfo(stats.getMemberInfoBldlEntry(), 0), this.dbg);
                            this.datasetInformation.getDatasetMemberMap().put(this.location.getMember(), info);
                        }
                    } else {
                        ISandbox sandbox = this.storage.getShareable().getSandbox();
                        DataSetLocation loc = (DataSetLocation)this.location.getParent();
                        IShareableInternal shr = (IShareableInternal)sandbox.findShareable((IRelativeLocation)new RelativeLocation(new String[]{loc.getDatasetName()}), ResourceType.FOLDER);
                        PDSMemberInfo info = new PDSMemberInfo(new PdsDirectory.MemberInfo(stats.getMemberInfoBldlEntry(), 0), this.dbg);
                        IDataSetInformation datasetInformation = DataSetInformationCache.getInstance().put(null, loc, shr, info, this.dbg);
                        if (datasetInformation != null) {
                            this.datasetInformation = datasetInformation;
                        }
                    }
                }
                catch (UnsupportedEncodingException e) {
                    if (!LOG.isErrorEnabled()) break block20;
                    msg = new DebugMessage(cls, mnm, true, DBG_MSG_UnableToUpdStats, new Object[]{2, this.getFullName()});
                    LogUtility.logError((Log)LOG, (Exception)e, (String[])new String[]{msg.bind()});
                }
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
    }

    protected long getNumberOfLine(String formattedMember) throws ZFileException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        ZFile zFileOut = null;
        long lines = -1L;
        boolean ended = false;
        if (this.memberLines != null) {
            lines = this.memberLines.longValue();
        } else {
            try {
                int lineLength;
                zFileOut = this.getUnderlyingZFile(formattedMember, READ_BINARY);
                zFileOut.seek(0L, 2);
                long length = zFileOut.tell();
                if (length != -1L && (lineLength = zFileOut.getLrecl()) > 0) {
                    lines = length / (long)lineLength;
                    if (length % (long)lineLength > 0L) {
                        ++lines;
                    }
                }
                ended = true;
            }
            finally {
                block15: {
                    try {
                        if (zFileOut != null) {
                            zFileOut.close();
                        }
                    }
                    catch (ZFileException e) {
                        if (!ended) break block15;
                        throw e;
                    }
                }
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, LogField.valueOf((long)lines)});
        }
        return lines;
    }

    private boolean updateMemberTextContents(InputStream inputStream, String formattedMember, boolean bConvertSOSI) throws IOException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        boolean success = false;
        OutputStream outputStream = null;
        int buf_size = 0;
        try {
            outputStream = this.getOutputStream(formattedMember, WRITE_TEXT_FILE_OPTIONS);
            if (this.traceLoad) {
                DebugMessage msg = new DebugMessage(cls, mnm, true, Messages.ZFileInterface_logging_1, new Object[]{this.getFullName()});
                this.loadTracing.printToLog(msg.bind());
            }
            if (!bConvertSOSI) {
                this.copyByte(inputStream, outputStream, buf_size);
            } else {
                this.copyByte(new ConvertFromPseudoSOSIInputStream(inputStream), outputStream, buf_size);
            }
            outputStream.flush();
            success = true;
        }
        finally {
            block14: {
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException e) {
                    if (!success) break block14;
                    success = false;
                    throw e;
                }
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, LogField.valueOf((boolean)success)});
        }
        return success;
    }

    private boolean updateMemberBinaryContents(InputStream inputStream, String formattedMember) throws FileSystemException, IOException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        boolean success = false;
        IZFile zFileOut = null;
        try {
            zFileOut = this.createZFile(formattedMember, WRITE_BINARY_FILE_OPTIONS);
            String recfm = zFileOut.getRecfm();
            if (!recfm.toLowerCase().startsWith("f") && !recfm.toLowerCase().startsWith("v")) {
                DebugMessage msg = new DebugMessage(cls, mnm, true, Messages.ZFileInterface_1, new Object[]{recfm});
                if (LOG.isDebugEnabled()) {
                    LogUtility.logDebug((Log)LOG, null, (String[])new String[]{msg.bind()});
                }
                throw new FileSystemException(msg.bind());
            }
            int bufferSize = recfm.toLowerCase().startsWith("v") ? zFileOut.getLrecl() - 4 : zFileOut.getLrecl();
            byte[] buffer = new byte[bufferSize == 0 ? 8192 : bufferSize];
            if (this.traceLoad) {
                DebugMessage msg = new DebugMessage(cls, mnm, true, Messages.ZFileInterface_logging_2, new Object[]{this.getFullName()});
                this.loadTracing.printToLog(msg.bind());
            }
            int n = 0;
            while (-1 != (n = this.readFully(inputStream, buffer, 0, bufferSize))) {
                zFileOut.write(buffer, 0, n);
            }
            zFileOut.flush();
            success = true;
        }
        finally {
            block15: {
                try {
                    if (zFileOut != null) {
                        zFileOut.close();
                    }
                }
                catch (IOException e) {
                    if (!success) break block15;
                    success = false;
                    throw e;
                }
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, LogField.valueOf((boolean)success)});
        }
        return success;
    }

    protected int readFully(InputStream inputStream, byte[] buffer, int offset, int len) throws IOException {
        int len_copied = 0;
        while (len > 0) {
            int n = inputStream.read(buffer, offset, len);
            if (n < 0) {
                if (len_copied == 0) {
                    return -1;
                }
                return len_copied;
            }
            offset += n;
            len -= n;
            len_copied += n;
        }
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.valueOf((int)len_copied)});
        }
        return len_copied;
    }

    public void remove() throws ZFileException, JzosException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        String ddName = this.getUniqueDD();
        String cmd = String.format(CMD_ALLOC_SHR_REUSE, ddName, this.location.getDatasetName());
        JzosUtility.executeCommand((String)cmd, (LoadTracing)this.loadTracing);
        try {
            if (this.isMember()) {
                if (this.traceLoad) {
                    DebugMessage msg = new DebugMessage(cls, mnm, true, Messages.ZFileInterface_logging_4, new Object[]{this.getFullName()});
                    this.loadTracing.printToLog(msg.bind());
                }
                ZFile.remove((String)String.format(CMD_REMOVE_MBR, ddName, this.location.getMember()));
            } else {
                if (this.traceLoad) {
                    DebugMessage msg = new DebugMessage(cls, mnm, true, Messages.ZFileInterface_logging_4, new Object[]{this.getFullName()});
                    this.loadTracing.printToLog(msg.bind());
                }
                ZFile.remove((String)String.format(CMD_REMOVE, ddName));
            }
        }
        finally {
            this.freeByDDname(ddName);
            this.reinitialize();
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
    }

    public String getUniqueDD() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return UniqueDD.getInstance().get();
    }

    public void rename(ZFileInterface target) throws ZFileException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        ZFile.rename((String)JzosUtility.getSlashSlashQuotedDSN((String)this.getFullName()), (String)JzosUtility.getSlashSlashQuotedDSN((String)target.getFullName()));
        this.reinitialize();
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
    }

    public void allocateDataset(IDataSetDefinition dsdef) throws ZFileException, MappingException, JzosException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        if (!this.services.locateDataset(this.getFullName())) {
            AgentMapping mapping = new AgentMapping();
            String cmd = null;
            cmd = mapping.pdsMapping(dsdef, this.location.getDataSetPrefix());
            JzosUtility.executeCommand((String)cmd, (LoadTracing)this.loadTracing);
            cmd = mapping.pdsFree();
            JzosUtility.executeCommand((String)cmd, (LoadTracing)this.loadTracing);
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
    }

    public void allocateDatasetByDDname(IDataSetDefinition dsdef, String ddName) throws ZFileException, MappingException, JzosException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        boolean pds = dsdef.getDsType() != 1;
        AgentMapping mapping = new AgentMapping(this.dbg);
        String cmd = null;
        if (!this.services.locateDataset(this.getFullName())) {
            if (this.hasDatasetInformation()) {
                this.datasetInformation.setDatasetIsNew(true);
                this.datasetInformation.setDatasetExists(true);
            }
            cmd = mapping.pdsMappingDDName(ddName, dsdef, this.location.getDataSetPrefix(), true);
            JzosUtility.executeCommand((String)cmd, (LoadTracing)this.loadTracing);
            this.freeByDDname(ddName);
        }
        if (pds) {
            try {
                if (this.hasDatasetInformation()) {
                    this.datasetInformation.setDatasetPDSInfo();
                    this.datasetInformation.setDatasetMemberMap();
                }
            }
            catch (Exception e) {
                throw new JzosException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        cmd = mapping.pdsMappingDDName(ddName, dsdef, this.location.getDataSetPrefix(), false);
        cmd = String.valueOf(cmd) + " REUSE";
        JzosUtility.executeCommand((String)cmd, (LoadTracing)this.loadTracing);
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
    }

    public void free(IDataSetDefinition dsdef) throws ZFileException, JzosException, MappingException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        AgentMapping mapping = new AgentMapping();
        mapping.pdsMapping(dsdef, this.location.getDataSetPrefix());
        JzosUtility.executeCommand((String)mapping.pdsFree(), (LoadTracing)this.loadTracing);
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
    }

    public void freeByDDname(String ddName) throws JzosException, ZFileException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        if (ZFile.ddExists((String)ddName)) {
            JzosUtility.executeCommand((String)String.format(CMD_FREE, ddName), (LoadTracing)this.loadTracing);
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
    }

    protected void freePF(String ddName) throws IOException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        try {
            JzosUtility.executeCommand((String)String.format(CMD_FREE, ddName), (LoadTracing)this.loadTracing);
        }
        catch (JzosException e) {
            if (this.traceLoad) {
                DebugMessage msg = new DebugMessage(cls, mnm, true, e.getMessage(), new Object[0]);
                this.loadTracing.printToLog(msg.bind());
            }
            throw new IOException(e);
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
    }

    public boolean receiveBinaryContents_PC(InputStream in) throws IOException, BinaryConverterException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        boolean success = false;
        ZosBinaryConverter zosBinaryConverter = new ZosBinaryConverter();
        OutputStream out = null;
        String member = this.getFullName();
        String xmitFile = ZosBinaryConverter.getGeneratedFile(member);
        try {
            ZFile zFileOut = this.getUnderlyingZFile(xmitFile, WRITE_BINARY_FILE_OPTIONS);
            int buf_size = zFileOut.getLrecl();
            out = zFileOut.getOutputStream();
            this.copyByte(in, out, buf_size);
            out.flush();
            out.close();
            success = true;
        }
        finally {
            block11: {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    if (!success) break block11;
                    success = false;
                    throw e;
                }
            }
        }
        zosBinaryConverter.scmToHost(xmitFile);
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, LogField.valueOf((boolean)success)});
        }
        return true;
    }

    public boolean updateSpecialMemberContents(InputStream in) throws IOException, BinaryConverterException, FileSystemException {
        boolean success;
        String mnm;
        block14: {
            String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
            if (this.debug) {
                Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
            }
            success = false;
            String xmitFile = ZosBinaryConverter.getGeneratedFile(this.getFullName());
            String formatted = JzosUtility.getSlashSlashQuotedDSN((String)xmitFile);
            try {
                try {
                    success = this.createTemporaryXMITtedFile(in, formatted);
                }
                catch (FileSystemException e) {
                    if (LOG.isTraceEnabled()) {
                        DebugMessage msg = new DebugMessage(cls, mnm, true, DBG_MSG_CreateXmit, new Object[]{formatted});
                        LogUtility.logTrace((Log)LOG, (Exception)((Object)e), (String[])new String[]{msg.bind()});
                    }
                    throw e;
                }
                catch (IOException e) {
                    if (LOG.isTraceEnabled()) {
                        DebugMessage msg = new DebugMessage(cls, mnm, true, DBG_MSG_CreateXmit, new Object[]{formatted});
                        LogUtility.logTrace((Log)LOG, (Exception)e, (String[])new String[]{msg.bind()});
                    }
                    throw e;
                }
                if (!success) break block14;
                try {
                    this.convertXMITFile(xmitFile);
                }
                catch (BinaryConverterException e) {
                    if (LOG.isTraceEnabled()) {
                        DebugMessage msg = new DebugMessage(cls, mnm, true, DBG_MSG_ReceiveCmd, new Object[]{xmitFile});
                        LogUtility.logTrace((Log)LOG, (Exception)e, (String[])new String[]{msg.bind()});
                    }
                    throw e;
                }
            }
            finally {
                if (success) {
                    this.removeZFile(formatted);
                }
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, LogField.valueOf((boolean)success)});
        }
        return success;
    }

    private boolean createTemporaryXMITtedFile(InputStream inputStream, String formattedMember) throws FileSystemException, IOException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        boolean success = false;
        IZFile zFileOut = null;
        try {
            zFileOut = this.createZFile(formattedMember, WRITE_XMIT_FILE_OPTIONS);
            int bufferSize = zFileOut.getLrecl();
            byte[] buffer = new byte[bufferSize == 0 ? 8192 : bufferSize];
            int n = 0;
            while (-1 != (n = this.readFully(inputStream, buffer, 0, bufferSize))) {
                zFileOut.write(buffer, 0, n);
            }
            zFileOut.flush();
            success = true;
        }
        finally {
            block12: {
                try {
                    if (zFileOut != null) {
                        zFileOut.close();
                    }
                }
                catch (IOException e) {
                    if (!success) break block12;
                    success = false;
                    throw e;
                }
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, LogField.valueOf((boolean)success)});
        }
        return success;
    }

    public InputStream transmitBinaryContents() throws BinaryConverterException, ZFileException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        String path = this.getFullName();
        ZosBinaryConverter zosBinaryConverter = new ZosBinaryConverter();
        String scmPath = String.format(FMT_SCM_PATH, zosBinaryConverter.hostToScm(path));
        if (LOG.isTraceEnabled()) {
            DebugMessage msg = new DebugMessage(cls, mnm, true, DBG_MSG_ScmMember, new Object[]{scmPath});
            LogUtility.logTrace((Log)LOG, null, (String[])new String[]{msg.bind()});
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        return new ZBinaryInputStream(this.getUnderlyingZFile(scmPath, READ_BINARY_NOSEEK), true);
    }

    /*
     * Unable to fully structure code
     */
    private int copyByte(InputStream input, OutputStream output, int buffer_size) throws IOException {
        block31: {
            v0 = mnm = this.dbg.isOn() != false ? new Mnm(){}.get() : null;
            if (this.debug) {
                Debug.enter((IDebugger)this.dbg, (String[])new String[]{ZFileInterface.cls, mnm, this.dbgName});
            }
            gotline = false;
            buffer = new byte[buffer_size == 0 ? 8192 : buffer_size];
            newline = System.lineSeparator().getBytes()[0];
            count = 0;
            lines = 0;
            eeReader = null;
            if (input instanceof ReaderToInputStreamEE) {
                eeReader = (ReaderToInputStreamEE)input;
            }
            n = 0;
            partial = 0;
            endsWithNewline = false;
            if (eeReader == null) ** GOTO lbl100
            while (n != -1) {
                block29: {
                    block30: {
                        try {
                            n = eeReader.read(buffer);
                            break block29;
                        }
                        catch (IOException e) {
                            errorPosition = eeReader.getErrorPosition();
                            if (errorPosition <= 0) break block30;
                            errorMessage = null;
                            errorLine = lines + 1;
                            errorCol = partial;
                            i = 0;
                            ** while (i < errorPosition - 1)
                        }
lbl-1000:
                        // 1 sources

                        {
                            if (buffer[i] == newline) {
                                ++errorLine;
                                errorCol = 0;
                            } else {
                                ++errorCol;
                            }
                            ++i;
                            continue;
                        }
lbl35:
                        // 1 sources

                        ++errorCol;
                        if (e instanceof UnmappableCharacterException) {
                            errorMessage = NLS.bind((String)Messages.ZFileInterface_IO_1, (Object)this.dbgName, (Object[])new Object[]{LogField.valueOf((int)errorLine), LogField.valueOf((int)errorCol)});
                            LogUtility.logWarn((Log)ZFileInterface.LOG, null, (String[])new String[]{errorMessage});
                        } else if (e instanceof MalformedInputException) {
                            errorMessage = NLS.bind((String)Messages.ZFileInterface_IO_2, (Object)this.dbgName, (Object[])new Object[]{LogField.valueOf((int)errorLine), LogField.valueOf((int)errorCol)});
                            LogUtility.logWarn((Log)ZFileInterface.LOG, null, (String[])new String[]{errorMessage});
                        } else {
                            errorMessage = e.getMessage();
                        }
                        throw new EEZFileException(errorMessage, (Throwable)e, errorLine, errorCol, count + errorPosition);
                    }
                    throw e;
                }
                if (n == -1) {
                    if (gotline && !endsWithNewline) {
                        ++lines;
                    }
                    break block31;
                }
                gotline = true;
                gotlines = 0;
                i = 0;
                while (i < n) {
                    if (buffer[i] == newline) {
                        ++gotlines;
                        partial = 0;
                    }
                    ++partial;
                    ++i;
                }
                endsWithNewline = n > 0 && buffer[n - 1] == newline;
                try {
                    output.write(buffer, 0, n);
                    output.flush();
                }
                catch (ZFileException e) {
                    if (e.getMessage().contains("EDC5003I")) {
                        this.catch_EDC5003I(e, count, lines, buffer, n);
                    }
                    throw e;
                }
                count += n;
                lines += gotlines;
            }
            break block31;
lbl-1000:
            // 1 sources

            {
                n = input.read(buffer);
                if (n == -1) {
                    if (gotline && !endsWithNewline) {
                        ++lines;
                    }
                    break;
                }
                gotline = true;
                gotlines = 0;
                i = 0;
                while (i < n) {
                    if (buffer[i] == newline) {
                        ++gotlines;
                    }
                    ++i;
                }
                endsWithNewline = n > 0 && buffer[n - 1] == newline;
                try {
                    output.write(buffer, 0, n);
                    output.flush();
                }
                catch (ZFileException e) {
                    if (e.getMessage().contains("EDC5003I")) {
                        this.catch_EDC5003I(e, count, lines, buffer, n);
                    }
                    throw e;
                }
                count += n;
                lines += gotlines;
lbl100:
                // 2 sources

                ** while (n != -1)
            }
        }
        if (gotline) {
            this.memberLines = lines;
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{ZFileInterface.cls, mnm, this.dbgName, LogField.valueOf((int)lines)});
        }
        return count;
    }

    private void catch_EDC5003I(ZFileException original, int alreadyRead, int lines, byte[] buffer, int read) throws ZFileException, EEZFileException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.trace) {
            Debug.error((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        int lrecl = 0;
        try {
            PDSInfo info = this.getPDSInfo();
            lrecl = info.getLrecl();
        }
        catch (PDSManagerException e) {
            if (LOG.isDebugEnabled()) {
                DebugMessage msg = new DebugMessage(cls, mnm, true, DBG_MSG_UnableToCheckNL, new Object[]{this.location});
                LogUtility.logDebug((Log)LOG, (Exception)e, (String[])new String[]{msg.bind(), original.getMessage()});
            }
            throw original;
        }
        if (lrecl != 0) {
            int start = 0;
            int errorLine = lines;
            int errorColumn = 0;
            int errorPosition = 0;
            int i = 0;
            while (i < read) {
                if (buffer[i] == 21) {
                    if (i - start > lrecl) {
                        errorColumn = i;
                        errorPosition = alreadyRead + i - 1;
                        String errorMessage = NLS.bind((String)Messages.ZFileInterface_IO_3, (Object)this.dbgName, (Object[])new Object[]{LogField.valueOf((int)errorLine), LogField.valueOf((int)errorColumn)});
                        throw new EEZFileException(errorMessage, (Throwable)original, errorLine, errorColumn, errorPosition);
                    }
                    start = i;
                }
                ++i;
            }
        }
        throw original;
    }

    public String getFullName() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return this.location.toString();
    }

    private String getQuotedName(String name) {
        String fName = name;
        StringBuffer sb = new StringBuffer();
        sb.append("//'");
        sb.append(fName);
        sb.append("'");
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return sb.toString();
    }

    protected IISPFStatistics getMemberStatistics() {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        IISPFStatistics result = null;
        ISPFStatistics stats = null;
        if (this.memberStatistics != null) {
            result = this.memberStatistics;
        } else if (this.isMember()) {
            block12: {
                try {
                    try {
                        stats = new ISPFStatistics(this.location.getDatasetName(), this.location.getMember());
                    }
                    catch (UndefinedRecordFormatException ure) {
                        if (!SCMEE_SKIP_SSI_CHECK) {
                            stats = new ISPFStatistics(this.location.getDatasetName(), this.location.getMember(), true);
                        }
                    }
                }
                catch (Exception e) {
                    if (!LOG.isInfoEnabled()) break block12;
                    DebugMessage msg = new DebugMessage(cls, mnm, true, DBG_MSG_UnableToGetStats, new Object[]{this.getFullName()});
                    LogUtility.logInfo((Log)LOG, (Exception)e, (String[])new String[]{msg.bind()});
                }
            }
            if (stats != null) {
                this.memberStatistics = result = new ISPFStatisticsWrapper(stats);
                if (this.trace) {
                    Debug.debug((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, "New"});
                }
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, LogField.nonNull((Object)result)});
        }
        return result;
    }

    public List<String> getMemberNames() throws IOException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        ArrayList<String> result = new ArrayList<String>();
        try (PdsDirectory dir = null;){
            dir = new PdsDirectory(this.getQuotedName(this.getFullName()));
            for (PdsDirectory.MemberInfo info : dir) {
                result.add(info.getName());
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, LogField.valueOf(result)});
        }
        return result;
    }

    public boolean isSpecialBinary() throws PDSManagerException, FileSystemException, ZFileException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        boolean result = false;
        if (this.isMember()) {
            if (this.hasDatasetInformation() && this.datasetInformation.hasDatasetPDSInfo()) {
                if ("U".equals(this.datasetInformation.getDatasetPDSInfo().getRecfm())) {
                    result = true;
                }
            } else {
                try {
                    PDSInfo info = this.getPDSInfo();
                    if ("U".equals(info.getRecfm())) {
                        result = true;
                    }
                }
                catch (PDSManagerException e) {
                    if (LOG.isTraceEnabled()) {
                        DebugMessage msg = new DebugMessage(cls, mnm, true, DBG_MSG_UnableToGetPdsCh, new Object[]{this.location, e.getMessage()});
                        LogUtility.logTrace((Log)LOG, (Exception)e, (String[])new String[]{msg.bind()});
                    }
                    throw e;
                }
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, LogField.valueOf((boolean)result)});
        }
        return result;
    }

    public static ZFileInterface createZFileInterface(DataSetLocation location, IFileStorage storage, LoadTracing lt) throws FileSystemException {
        IDebugger dbg = MVSStorageManager.getCommonDbg();
        if (dbg.isTrace()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{cls, new Mnm(){}.get(), LogField.valueOf((Object)location)});
        }
        if (MVSStorageManager.SIMULATION_ENABLED) {
            return new SimulatedZFileInterface(location, storage, lt);
        }
        return new ZFileInterface(location, storage, lt);
    }

    protected void convertXMITFile(String xmitFile) throws BinaryConverterException {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        new ZosBinaryConverter().scmToHost(xmitFile);
    }

    protected void removeZFile(String formatted) throws ZFileException {
        ZFile.remove((String)formatted);
        this.reinitialize();
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
    }

    private void reinitialize() {
        this.memberLines = null;
        this.memberStatistics = null;
        if (this.datasetInformation != null) {
            this.datasetInformation.getDatasetMemberMap().remove(this.location.getMember());
            this.datasetInformation.getDatasetMembers().remove(this.location.getMember());
            this.datasetInformation = null;
        }
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
    }

    protected IZFile createZFile(String formattedMember, String options) throws ZFileException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        ZFileWrapper zFile = null;
        boolean done = false;
        int retry = 0;
        int limit = SCMEE_RETRY_CREATE_LIMIT;
        long sleep = 100L;
        while (!done) {
            try {
                zFile = new ZFileWrapper(formattedMember, options, this.dbg);
                done = true;
            }
            catch (ZFileException e) {
                DebugMessage msg;
                if (++retry > limit || !e.getMessage().matches(RGX_ERRNO2)) {
                    if (this.traceLoad) {
                        msg = new DebugMessage(cls, mnm, true, e.getMessage(), new Object[0]);
                        this.loadTracing.printToLog(msg.bind());
                    }
                    throw e;
                }
                if (this.traceLoad) {
                    msg = new DebugMessage(cls, mnm, true, e.getMessage(), new Object[]{"; Retry: ", retry});
                    this.loadTracing.printToLog(msg.bind());
                }
                try {
                    Thread.sleep(sleep);
                    sleep += 100L;
                }
                catch (InterruptedException ie) {
                    if (!this.traceLoad) continue;
                    DebugMessage msg2 = new DebugMessage(cls, mnm, true, ie.getMessage(), new Object[]{"; Retry: ", retry});
                    this.loadTracing.printToLog(msg2.bind());
                }
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        return zFile;
    }

    private ZFile getUnderlyingZFile(String formattedMember, String options) throws ZFileException {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return ((ZFileWrapper)this.createZFile(formattedMember, options)).getUnderlyingZFile();
    }

    protected InputStream getInputStream(String member, String options) throws ZFileException {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return this.getUnderlyingZFile(member, options).getInputStream();
    }

    protected OutputStream getOutputStream(String formattedMember, String options) throws ZFileException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        OutputStream out = this.getUnderlyingZFile(formattedMember, options).getOutputStream();
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, LogField.nonNull((Object)out)});
        }
        return out;
    }

    protected PDSInfo getPDSInfo() throws PDSManagerException {
        PDSInfo result;
        if (this.hasDatasetInformation() && this.datasetInformation.hasDatasetPDSInfo()) {
            result = this.datasetInformation.getDatasetPDSInfo();
        } else {
            DataSetLocation pdsLocation = this.isMember() ? this.location.getParent() : this.location;
            result = PDSUtility.getPDSCharacteristics(pdsLocation.toOSString());
            if (this.hasDatasetInformation()) {
                this.datasetInformation.setDatasetPDSInfo(result);
            }
        }
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return result;
    }

    public static boolean SOSIConversionNeeded(String localEncoding) {
        return ZFileInterface.SOSIConversionNeeded(localEncoding, null, (IDebugger)new Debugger(ZFileInterface.class));
    }

    public static synchronized boolean SOSIConversionNeeded(String localEncoding, DataSetLocation location, IDebugger dbg) {
        String mnm;
        String string = mnm = dbg.isOn() ? new Mnm(){}.get() : null;
        if (dbg.isTrace()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{cls, mnm, LogField.valueOf((Object)location)});
        }
        if (SCMEE_SOSI_CONVERSION_DISABLED) {
            return false;
        }
        if (codePage4ExtraSOSIProcessing == null) {
            ArrayList<String> checkedCharsets = new ArrayList<String>(predefinedDBCScodepages.size());
            for (String charsetName : predefinedDBCScodepages) {
                try {
                    checkedCharsets.add(Charset.forName(charsetName).name());
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                }
                catch (UnsupportedCharsetException e2) {
                    if (!LOG.isDebugEnabled()) continue;
                    DebugMessage msg = new DebugMessage(cls, mnm, true, DBG_MSG_CHARSET_NS, new Object[]{charsetName});
                    LogUtility.logDebug((Log)LOG, (Exception)e2, (String[])new String[]{msg.bind()});
                }
            }
            codePage4ExtraSOSIProcessing = new HashSet<String>(checkedCharsets);
            String value = System.getenv("SOSICP");
            if (value != null) {
                StringTokenizer st = new StringTokenizer(value, ":");
                String charsetName = null;
                while (st.hasMoreElements()) {
                    DebugMessage msg;
                    try {
                        charsetName = ((String)st.nextElement()).trim().toUpperCase();
                        codePage4ExtraSOSIProcessing.add(Charset.forName(charsetName).name());
                    }
                    catch (IllegalCharsetNameException e1) {
                        if (!LOG.isDebugEnabled()) continue;
                        msg = new DebugMessage(cls, mnm, true, DBG_MSG_CODEPAGE, new Object[]{charsetName});
                        LogUtility.logDebug((Log)LOG, (Exception)e1, (String[])new String[]{msg.bind()});
                    }
                    catch (UnsupportedCharsetException e2) {
                        if (!LOG.isDebugEnabled()) continue;
                        msg = new DebugMessage(cls, mnm, true, DBG_MSG_CHARSET_NS, new Object[]{charsetName});
                        LogUtility.logDebug((Log)LOG, (Exception)e2, (String[])new String[]{msg.bind()});
                    }
                }
            }
        }
        boolean needed = codePage4ExtraSOSIProcessing.contains(Charset.forName(localEncoding.trim().toUpperCase()).name());
        if (LOG.isDebugEnabled()) {
            DebugMessage msg = new DebugMessage(cls, mnm, true, DBG_MSG_SOSI_Needed, new Object[]{localEncoding, needed});
            LogUtility.logDebug((Log)LOG, null, (String[])new String[]{msg.bind()});
        }
        if (dbg.isTrace()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{cls, mnm, LogField.valueOf((Object)location), LogField.valueOf((boolean)needed)});
        }
        return needed;
    }

    public final IDataSetInformation getDatasetInformation() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return this.datasetInformation;
    }

    public final boolean hasDatasetInformation() {
        boolean result;
        boolean bl = result = this.datasetInformation != null;
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.valueOf((boolean)result)});
        }
        return result;
    }

    public final boolean hasDatasetInformationCached() {
        boolean result = DataSetInformationCache.getInstance().getMap().containsKey(this.location);
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.valueOf((boolean)result)});
        }
        return result;
    }

    public final boolean datasetExists() throws ZFileException {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return this.datasetInformation != null ? this.datasetInformation.isDatasetExists() : this.exists();
    }

    protected void logLoadTrace(String s) {
        if (this.traceLoad) {
            this.loadTracing.printToLog(s);
        }
    }

    private class NLVerifyFixedRecfmInputStreamReader
    extends Reader {
        private final String icls;
        private Reader wrapped;
        private final long numberOfLines;
        private final char lineSeparator;
        private long separatorCount;
        private final String name;

        private NLVerifyFixedRecfmInputStreamReader(Reader wrapped, long numberOfLines, char lineSeparator, String name) {
            super((Object)wrapped);
            this.wrapped = wrapped;
            this.numberOfLines = numberOfLines;
            this.lineSeparator = lineSeparator;
            this.separatorCount = 0L;
            this.name = name;
            this.icls = this.getClass().getSimpleName();
            if (ZFileInterface.this.debug) {
                Debug.setup((IDebugger)ZFileInterface.this.dbg, (String[])new String[]{this.icls, ZFileInterface.this.dbgName});
            }
        }

        @Override
        public void close() throws IOException {
            if (this.wrapped != null) {
                Reader in = this.wrapped;
                this.wrapped = null;
                in.close();
            }
        }

        @Override
        public void mark(int readAheadLimit) throws IOException {
            this.wrapped.mark(readAheadLimit);
        }

        @Override
        public boolean markSupported() {
            return this.wrapped.markSupported();
        }

        @Override
        public int read() throws IOException {
            int ret = this.wrapped.read();
            if (ret == -1) {
                this.verify();
                return -1;
            }
            if ((char)ret == this.lineSeparator) {
                ++this.separatorCount;
            }
            return ret;
        }

        @Override
        public int read(char[] cbuf) throws IOException {
            int ret = this.wrapped.read(cbuf);
            if (ret == -1) {
                this.verify();
                return -1;
            }
            int m = 0;
            while (m < ret) {
                if (cbuf[m] == this.lineSeparator) {
                    ++this.separatorCount;
                }
                ++m;
            }
            return ret;
        }

        @Override
        public int read(char[] cbuf, int offset, int length) throws IOException {
            int ret = this.wrapped.read(cbuf, offset, length);
            if (ret == -1) {
                this.verify();
                return -1;
            }
            int m = offset;
            while (m < offset + ret) {
                if (cbuf[m] == this.lineSeparator) {
                    ++this.separatorCount;
                }
                ++m;
            }
            return ret;
        }

        @Override
        public int read(CharBuffer target) throws IOException {
            int ret = this.wrapped.read(target);
            if (ret == -1) {
                this.verify();
                return -1;
            }
            this.checkCharBuffer(target, ret);
            return ret;
        }

        void checkCharBuffer(CharBuffer buf, int count) {
            int currentPos = buf.position();
            buf.rewind();
            int i = 0;
            while (i < count) {
                char read = buf.get();
                if (read == this.lineSeparator) {
                    ++this.separatorCount;
                }
                ++i;
            }
            buf.position(currentPos);
        }

        @Override
        public boolean ready() throws IOException {
            return this.wrapped.ready();
        }

        @Override
        public void reset() throws IOException {
            this.wrapped.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.wrapped.skip(n);
        }

        private void verify() throws IOException {
            if (this.separatorCount > this.numberOfLines) {
                DebugMessage msg = new DebugMessage();
                msg.setClassName(cls);
                msg.setInnerClassName(this.icls);
                msg.setMethodName(new Mnm(){}.get());
                msg.append(NLS.bind((String)Messages.ZFileInterface_3, (Object)this.name, (Object[])new Object[0]));
                msg.append(" [separatorCount:");
                msg.append(this.separatorCount);
                msg.append("][numberOfLines:");
                msg.append(this.numberOfLines);
                msg.add("]");
                String errorMsg = msg.get();
                if (LOG.isErrorEnabled()) {
                    LogUtility.logError((Log)LOG, null, (String[])new String[]{errorMsg});
                }
                throw new ContentLineDelimiterError(errorMsg);
            }
            if (ZFileInterface.this.debug) {
                Debug.inout((IDebugger)ZFileInterface.this.dbg, (String[])new String[]{this.icls, new Mnm(){}.get(), ZFileInterface.this.dbgName, LogField.valueOf((long)this.separatorCount)});
            }
        }
    }

    private class NLVerifyVariableRecfmInputStreamReader
    extends Reader {
        private final String icls;
        private final Reader wrapped;
        private InputStream binaryStream;
        private final Set<Byte> checkForNLbytes;
        private boolean alreadyChecked;
        private final String name;

        private NLVerifyVariableRecfmInputStreamReader(Reader wrapped, InputStream inputStream, Set<Byte> aNLbytes, String name) {
            this.wrapped = wrapped;
            this.binaryStream = inputStream;
            this.checkForNLbytes = aNLbytes;
            this.alreadyChecked = false;
            this.name = name;
            this.icls = this.getClass().getSimpleName();
            if (ZFileInterface.this.debug) {
                Debug.setup((IDebugger)ZFileInterface.this.dbg, (String[])new String[]{this.icls, ZFileInterface.this.dbgName});
            }
        }

        @Override
        public void close() throws IOException {
            this.wrapped.close();
        }

        @Override
        public void mark(int readAheadLimit) throws IOException {
            this.wrapped.mark(readAheadLimit);
        }

        @Override
        public boolean markSupported() {
            return this.wrapped.markSupported();
        }

        @Override
        public int read() throws IOException {
            if (!this.alreadyChecked) {
                this.checks();
            }
            return this.wrapped.read();
        }

        @Override
        public int read(char[] cbuf) throws IOException {
            if (!this.alreadyChecked) {
                this.checks();
            }
            return this.wrapped.read(cbuf);
        }

        @Override
        public int read(char[] cbuf, int offset, int length) throws IOException {
            if (!this.alreadyChecked) {
                this.checks();
            }
            return this.wrapped.read(cbuf, offset, length);
        }

        @Override
        public int read(CharBuffer target) throws IOException {
            if (!this.alreadyChecked) {
                this.checks();
            }
            return this.wrapped.read(target);
        }

        @Override
        public boolean ready() throws IOException {
            return this.wrapped.ready();
        }

        @Override
        public void reset() throws IOException {
            this.wrapped.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.wrapped.skip(n);
        }

        private void checks() throws IOException {
            this.alreadyChecked = true;
            byte[] buffer = new byte[8192];
            boolean ended = false;
            try {
                int n = 0;
                while (-1 != (n = this.binaryStream.read(buffer))) {
                    int m = 0;
                    while (m < n) {
                        for (byte b : this.checkForNLbytes) {
                            if (buffer[m] != b) continue;
                            this.throwAppropriateException();
                        }
                        ++m;
                    }
                }
                ended = true;
            }
            finally {
                block12: {
                    try {
                        InputStream in = this.binaryStream;
                        this.binaryStream = null;
                        in.close();
                    }
                    catch (IOException e) {
                        if (!ended) break block12;
                        ended = false;
                        throw e;
                    }
                }
            }
            if (ZFileInterface.this.debug) {
                Debug.inout((IDebugger)ZFileInterface.this.dbg, (String[])new String[]{this.icls, new Mnm(){}.get(), ZFileInterface.this.dbgName});
            }
        }

        private void throwAppropriateException() throws ContentLineDelimiterError {
            throw new ContentLineDelimiterError(NLS.bind((String)Messages.ZFileInterface_4, (Object)this.name, (Object[])new Object[0]));
        }
    }

    private class RemoveLastNLInputStreamReader
    extends Reader {
        private final String icls;
        private Reader wrapped;
        private final char lineSeparator;
        private int pendingInt;
        private boolean isPendingInt;

        private RemoveLastNLInputStreamReader(Reader wrapped, char lineSeparator) {
            super((Object)wrapped);
            this.isPendingInt = false;
            this.wrapped = wrapped;
            this.lineSeparator = lineSeparator;
            this.icls = this.getClass().getSimpleName();
            if (ZFileInterface.this.debug) {
                Debug.setup((IDebugger)ZFileInterface.this.dbg, (String[])new String[]{this.icls, ZFileInterface.this.dbgName});
            }
        }

        @Override
        public void close() throws IOException {
            if (this.wrapped != null) {
                Reader in = this.wrapped;
                this.wrapped = null;
                in.close();
            }
        }

        @Override
        public void mark(int readAheadLimit) throws IOException {
            this.wrapped.mark(readAheadLimit);
        }

        @Override
        public boolean markSupported() {
            return this.wrapped.markSupported();
        }

        @Override
        public int read() throws IOException {
            int ret;
            if (this.isPendingInt) {
                this.isPendingInt = false;
                ret = this.pendingInt;
            } else {
                ret = this.wrapped.read();
            }
            if (ret == -1) {
                return -1;
            }
            if (ret == this.lineSeparator) {
                this.pendingInt = this.wrapped.read();
                if (this.pendingInt == -1) {
                    return -1;
                }
                this.isPendingInt = true;
            }
            return ret;
        }

        @Override
        public int read(char[] cbuf) throws IOException {
            return this.read(cbuf, 0, cbuf.length);
        }

        @Override
        public int read(char[] cbuf, int offset, int length) throws IOException {
            int offset2 = offset;
            int length2 = length;
            int ret = 0;
            int ret2 = 0;
            if (this.isPendingInt) {
                this.isPendingInt = false;
                if (this.pendingInt == -1) {
                    return -1;
                }
                cbuf[offset] = (char)this.pendingInt;
                ++offset2;
                --length2;
                ret = 1;
            }
            if (length2 > 0) {
                ret2 = this.wrapped.read(cbuf, offset2, length2);
                if (ret2 == -1) {
                    if (ret == 1) {
                        this.isPendingInt = true;
                        this.pendingInt = -1;
                        return ret;
                    }
                    return -1;
                }
                if (cbuf[offset2 + ret2 - 1] == this.lineSeparator) {
                    this.isPendingInt = true;
                    this.pendingInt = this.wrapped.read();
                    if (this.pendingInt == -1) {
                        --ret2;
                    }
                }
                ret += ret2;
            }
            return ret;
        }

        @Override
        public int read(CharBuffer target) throws IOException {
            int len = target.remaining();
            char[] cbuf = new char[len];
            int n = this.read(cbuf, 0, len);
            if (n > 0) {
                target.put(cbuf, 0, n);
            }
            return n;
        }

        @Override
        public boolean ready() throws IOException {
            return this.wrapped.ready();
        }

        @Override
        public void reset() throws IOException {
            this.wrapped.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.wrapped.skip(n);
        }
    }

    private class ZBinaryInputStream
    extends InputStream {
        private ZFile zFile;
        private final byte[] buffer;
        private int offset;
        private int size;
        private final boolean isTemporary;

        public ZBinaryInputStream(ZFile fileToRead) throws ZFileException {
            this(fileToRead, false);
        }

        public ZBinaryInputStream(ZFile fileToRead, boolean isTemporaryFile) throws ZFileException {
            this.zFile = fileToRead;
            this.buffer = new byte[this.zFile.getLrecl()];
            this.offset = -1;
            this.size = 0;
            this.isTemporary = isTemporaryFile;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.offset == -1 && this.size != -1) {
                this.size = this.zFile.read(this.buffer, 0, this.buffer.length);
                if (this.size != -1) {
                    this.offset = 0;
                }
            }
            if (this.size == -1) {
                return this.size;
            }
            int toCopy = Math.min(len, this.size - this.offset);
            int i = 0;
            while (i < toCopy) {
                b[off + i] = this.buffer[this.offset];
                ++this.offset;
                ++i;
            }
            if (this.offset == this.size) {
                this.offset = -1;
            }
            return toCopy;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read() throws IOException {
            if (this.offset == -1 && this.size != -1) {
                this.size = this.zFile.read(this.buffer, 0, this.buffer.length);
                if (this.size != -1) {
                    this.offset = 0;
                }
            }
            if (this.offset == -1) {
                return -1;
            }
            byte toReturn = this.buffer[this.offset];
            ++this.offset;
            if (this.offset == this.size) {
                this.offset = -1;
            }
            return toReturn & 0xFF;
        }

        @Override
        public void close() throws IOException {
            if (this.zFile != null) {
                this.zFile.close();
                this.offset = -1;
                this.size = 0;
                String name = this.zFile.getFilename();
                this.zFile = null;
                if (this.isTemporary) {
                    ZFile.remove((String)name);
                }
            }
        }
    }
}

