/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.extensions.impl;

import com.ibm.jzos.ZFileException;
import com.ibm.team.enterprise.common.common.utils.LoadTracing;
import com.ibm.team.enterprise.scmee.common.SCMEEFileStorage;
import com.ibm.team.enterprise.scmee.zos.DataSetLocation;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.teamz.fileagent.importz.PDSInfo;
import com.ibm.teamz.fileagent.importz.PDSManagerException;
import com.ibm.teamz.fileagent.internal.binary.BinaryConverterException;
import com.ibm.teamz.fileagent.internal.extensions.impl.HFSMemberInfo;
import com.ibm.teamz.fileagent.internal.extensions.impl.IISPFStatistics;
import com.ibm.teamz.fileagent.internal.extensions.impl.IZFile;
import com.ibm.teamz.fileagent.internal.extensions.impl.MemberInfo;
import com.ibm.teamz.fileagent.internal.extensions.impl.SimulatedISPFStatistics;
import com.ibm.teamz.fileagent.internal.extensions.impl.SimulatedZFile;
import com.ibm.teamz.fileagent.internal.extensions.impl.ZFileInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimulatedZFileInterface
extends ZFileInterface {
    private static Map<String, String> ddNameToCanonicalPathMap = new HashMap<String, String>();
    private File file;

    public static File getSimulerFile(String formattedMember) throws ZFileException {
        int indexOfParen = formattedMember.indexOf("(");
        if (formattedMember.startsWith("//'") && formattedMember.endsWith("'")) {
            if (indexOfParen < 0) {
                return new File(SCMEEFileStorage.SIMULER_AREA, formattedMember.substring(3, formattedMember.length() - 1));
            }
            return new File(new File(SCMEEFileStorage.SIMULER_AREA, formattedMember.substring(3, indexOfParen)), formattedMember.substring(indexOfParen + 1, formattedMember.indexOf(")")));
        }
        if (formattedMember.startsWith("//DD:") && indexOfParen > 0) {
            String ddname = formattedMember.substring(5, indexOfParen);
            String memberName = formattedMember.substring(indexOfParen + 1, formattedMember.indexOf(")"));
            String canonicalPath = ddNameToCanonicalPathMap.get(ddname);
            return new File(canonicalPath, memberName);
        }
        if (formattedMember.startsWith("//DD:") && indexOfParen == -1) {
            String ddname = formattedMember.substring(5, formattedMember.length());
            String canonicalPath = ddNameToCanonicalPathMap.get(ddname);
            String memberName = canonicalPath.substring(canonicalPath.lastIndexOf("\\") + 1, canonicalPath.length());
            String parent = canonicalPath.substring(0, canonicalPath.lastIndexOf("\\") + 1);
            return new File(parent, memberName);
        }
        throw new ZFileException(formattedMember, "Unexpected formattedMember " + formattedMember, 0);
    }

    public SimulatedZFileInterface(DataSetLocation fullPath, IFileStorage storage, LoadTracing lt) throws FileSystemException {
        super(fullPath, storage, lt);
        this.file = new File(SCMEEFileStorage.SIMULER_AREA, fullPath.getDatasetName());
        String member = fullPath.getMember();
        if (member != null) {
            this.file = new File(this.file, member);
        }
    }

    @Override
    public void allocateDatasetByDDname(IDataSetDefinition dsdef, String ddName) throws ZFileException {
        if (this.file.isFile()) {
            throw new ZFileException(this.file.getAbsolutePath(), "Tried to allocated dataset on a file", 0);
        }
        if (!this.file.exists()) {
            if (this.file.mkdirs()) {
                if (ddName != null) {
                    try {
                        ddNameToCanonicalPathMap.put(ddName, this.file.getCanonicalPath());
                    }
                    catch (IOException e) {
                        throw new ZFileException(this.file.getAbsolutePath(), e.getMessage(), 0);
                    }
                }
            } else {
                throw new ZFileException(this.file.getAbsolutePath(), "Failed to mkdirs", 0);
            }
        }
    }

    @Override
    public void allocateDataset(IDataSetDefinition dsdef) throws ZFileException {
        this.allocateDatasetByDDname(dsdef, null);
    }

    @Override
    protected String instantAllocateByDDName() throws FileSystemException, ZFileException {
        String tempDDName = this.getUniqueDD();
        try {
            ddNameToCanonicalPathMap.put(tempDDName, this.file.getParentFile().getCanonicalPath());
        }
        catch (IOException e) {
            throw new ZFileException(this.file.getParentFile().getAbsolutePath(), e.getMessage(), 0);
        }
        return tempDDName;
    }

    @Override
    protected PDSInfo getPDSInfo() throws PDSManagerException {
        return new PDSInfo();
    }

    @Override
    protected OutputStream getOutputStream(String formattedMember, String options) throws ZFileException {
        try {
            return new FileOutputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new ZFileException(this.file.getAbsolutePath(), e.getMessage(), 0);
        }
    }

    @Override
    protected Reader getRemoveLastNLInputStreamReader(Reader wrapped, char lineSeparator) {
        return wrapped;
    }

    @Override
    public void remove() throws ZFileException {
        if (!this.file.delete()) {
            throw new ZFileException(this.file.getAbsolutePath(), "Delete failed", 0);
        }
    }

    @Override
    protected IZFile createZFile(String formattedMember, String options) throws ZFileException {
        return new SimulatedZFile(formattedMember, options);
    }

    @Override
    public void freeByDDname(String ddName) {
        ddNameToCanonicalPathMap.remove(ddName);
    }

    @Override
    protected void convertXMITFile(String xmitFile) throws BinaryConverterException {
        FileOutputStream outFos = null;
        FileInputStream inFos = null;
        AbstractInterruptibleChannel out = null;
        AbstractInterruptibleChannel in = null;
        try {
            try {
                File parent = this.file.getParentFile();
                if (!parent.exists() && !parent.mkdirs()) {
                    throw new BinaryConverterException("Failed to mkdirs for " + parent.getAbsolutePath());
                }
                outFos = new FileOutputStream(this.file);
                out = outFos.getChannel();
                inFos = new FileInputStream(new File(SCMEEFileStorage.SIMULER_AREA, xmitFile));
                in = inFos.getChannel();
                ((FileChannel)out).transferFrom((ReadableByteChannel)((Object)in), 0L, ((FileChannel)in).size());
            }
            catch (IOException e) {
                throw new BinaryConverterException(e);
            }
        }
        finally {
            try {
                if (outFos != null) {
                    outFos.close();
                }
                if (inFos != null) {
                    inFos.close();
                }
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new BinaryConverterException(e);
            }
        }
    }

    @Override
    protected void removeZFile(String formatted) throws ZFileException {
        SimulatedZFileInterface.getSimulerFile(formatted).delete();
    }

    @Override
    protected InputStream getInputStream(String member, String options) throws ZFileException {
        try {
            return new FileInputStream(this.file);
        }
        catch (IOException e) {
            throw new ZFileException(this.file.getAbsolutePath(), e.getMessage(), 0);
        }
    }

    @Override
    public InputStream getBinaryContents() throws ZFileException {
        try {
            return new FileInputStream(this.file);
        }
        catch (IOException e) {
            throw new ZFileException(this.file.getAbsolutePath(), e.getMessage(), 0);
        }
    }

    @Override
    public InputStream transmitBinaryContents() throws BinaryConverterException, ZFileException {
        try {
            return new FileInputStream(this.file);
        }
        catch (IOException e) {
            throw new ZFileException(this.file.getAbsolutePath(), e.getMessage(), 0);
        }
    }

    public ArrayList<String> getMemberNames() throws IOException {
        return new ArrayList<String>(Arrays.asList(this.file.list()));
    }

    public HashSet<MemberInfo> getMemberInfos() {
        File[] l = this.file.listFiles();
        HashSet<MemberInfo> set = new HashSet<MemberInfo>();
        File[] fileArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            set.add(new HFSMemberInfo(child.getName(), new SimulatedISPFStatistics(child)));
            ++n2;
        }
        return set;
    }

    @Override
    public void rename(ZFileInterface target) throws ZFileException {
        this.file.renameTo(((SimulatedZFileInterface)target).file);
    }

    @Override
    protected IISPFStatistics getMemberStatistics() {
        return new SimulatedISPFStatistics(this.file);
    }

    @Override
    protected long getNumberOfLine(String formattedMember) throws ZFileException {
        return -1L;
    }

    @Override
    protected boolean ddExists(String ddName) {
        return false;
    }

    @Override
    protected boolean allocate(String cmd) {
        String ddName;
        Pattern p = Pattern.compile(".*fi\\((.*)\\).*");
        Matcher m = p.matcher(cmd);
        if (m.find() & m.groupCount() > 0 && (ddName = m.group(1)) != null) {
            try {
                ddNameToCanonicalPathMap.put(ddName, this.file.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
                this.logLoadTrace(e.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    protected void freePF(String ddName) {
        ddNameToCanonicalPathMap.remove(ddName);
    }
}

