/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.extensions.impl;

import com.ibm.jzos.ZFileException;
import com.ibm.teamz.fileagent.internal.extensions.impl.IZFile;
import com.ibm.teamz.fileagent.internal.extensions.impl.SimulatedZFileInterface;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class SimulatedZFile
implements IZFile {
    private final String formattedMember;
    private FileOutputStream out;

    public SimulatedZFile() throws ZFileException {
        this.formattedMember = null;
        this.out = null;
    }

    @Override
    public boolean exists(String quotedName) throws ZFileException {
        File file = SimulatedZFileInterface.getSimulerFile(quotedName);
        return file.exists();
    }

    public SimulatedZFile(String formattedMember, String options) throws ZFileException {
        this.formattedMember = formattedMember;
        try {
            this.out = new FileOutputStream(SimulatedZFileInterface.getSimulerFile(formattedMember));
        }
        catch (IOException e) {
            throw new ZFileException(formattedMember, e.getMessage(), 0);
        }
    }

    @Override
    public int getLrecl() throws ZFileException {
        return 80;
    }

    @Override
    public String getRecfm() throws ZFileException {
        return "fb";
    }

    @Override
    public void write(byte[] buffer, int offset, int len) throws ZFileException {
        try {
            this.out.write(buffer, offset, len);
        }
        catch (IOException e) {
            throw new ZFileException(this.formattedMember, e.getMessage(), 0);
        }
    }

    @Override
    public void flush() throws ZFileException {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new ZFileException(this.formattedMember, e.getMessage(), 0);
        }
    }

    @Override
    public void close() throws ZFileException {
        try {
            this.out.close();
        }
        catch (IOException e) {
            throw new ZFileException(this.formattedMember, e.getMessage(), 0);
        }
    }
}

