/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.extensions.impl;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogField;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.enterprise.scmee.common.SCMEEStorageManager;
import com.ibm.team.enterprise.scmee.zos.DataSetLocation;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileStorage;
import com.ibm.team.filesystem.client.internal.FileStorageWrapper;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.operations.ILoadMutator;
import com.ibm.team.filesystem.client.internal.operations.IUpdateMutator;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport2;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import com.ibm.teamz.build.ant.jni.ISPFStatistics;
import com.ibm.teamz.fileagent.internal.extensions.impl.MVSFileStorage;
import com.ibm.teamz.fileagent.internal.extensions.mutators.MVSLoadByDatasetMutator;
import com.ibm.teamz.fileagent.internal.extensions.mutators.MVSLoadMutator;
import com.ibm.teamz.fileagent.internal.extensions.mutators.MVSMutator;
import com.ibm.teamz.fileagent.internal.extensions.mutators.MVSReloadingUpdateMutator;
import com.ibm.teamz.fileagent.internal.extensions.mutators.MVSThreadedUpdateMutator;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import java.util.Collection;
import org.eclipse.osgi.util.NLS;

public class MVSStorageManager
extends SCMEEStorageManager {
    private static final String cls = MVSStorageManager.class.getSimpleName();
    private final boolean noOptimizationEnabled = Boolean.getBoolean("rtcz.no.optimize");
    private final IDebugger dbg = MVSStorageManager.getCommonDbg();
    private final boolean debug = this.dbg.isDebug();
    private final boolean trace = this.dbg.isTrace();

    public MVSStorageManager() {
        if (this.debug) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls});
        }
    }

    public void resolveFileStorage(FileStorageWrapper storage, ResourceType resourceTypeHint) {
        if (!storage.getShareable().getFullPath().getStorageId().equals("com.ibm.teamz.filesystem.mvs")) {
            throw new IllegalStateException(NLS.bind((String)Messages.MVSStorageManager_0, (Object)storage.getShareable().getFullPath().getStorageId()));
        }
        storage.setUnderlyingStorage((FileStorage)new MVSFileStorage((IFileStorage)storage));
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), LogField.valueOf((String)storage.getName())});
        }
    }

    public ILoadMutator getLoadMutator(ISandbox sandbox, LoadDilemmaHandler loadProblemHandler) {
        MVSMutator result;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        if (sandbox.getRoot().getStorageId().equals("com.ibm.teamz.filesystem.mvs")) {
            this.isLibraryAvailable();
            result = this.noOptimizationEnabled ? new MVSLoadMutator(sandbox, loadProblemHandler, loadTracing) : new MVSLoadByDatasetMutator(sandbox, loadProblemHandler, loadTracing);
        } else {
            throw new IllegalStateException(NLS.bind((String)Messages.MVSStorageManager_0, (Object)sandbox.getRoot().getStorageId()));
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogString.value((Object)((Object)((Object)result)).getClass().getSimpleName())});
        }
        return result;
    }

    public IUpdateMutator getUpdateMutator(IConnection connection, Collection<IComponentStateSummary> componentStatesBefore, Collection<IComponentStateSummary> componentStatesAfter, FileAreaUpdateReport2 updates, Collection<IItemUpdateReport> rawUpdates, Collection<ICopyFileArea> copyFileAreasToUpdate, UpdateDilemmaHandler dilemmaHandler, IDownloadListener downloadMonitor) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        this.isLibraryAvailable();
        MVSMutator result = this.noOptimizationEnabled ? new MVSReloadingUpdateMutator(connection, componentStatesBefore, componentStatesAfter, updates, rawUpdates, copyFileAreasToUpdate, dilemmaHandler, loadTracing, downloadMonitor) : new MVSThreadedUpdateMutator(connection, componentStatesBefore, componentStatesAfter, updates, rawUpdates, copyFileAreasToUpdate, dilemmaHandler, loadTracing, downloadMonitor);
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogString.value((Object)((Object)((Object)result)).getClass().getSimpleName())});
        }
        return result;
    }

    public ILocation createLocation(String location) {
        return new DataSetLocation(location);
    }

    private void isLibraryAvailable() {
        if (!SIMULATION_ENABLED) {
            new ISPFStatistics();
        }
    }
}

