/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.extensions.impl;

import com.ibm.jzos.ZFileException;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogField;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.enterprise.scmee.common.EEZFileException;
import com.ibm.team.enterprise.scmee.common.SCMEEFileStorage;
import com.ibm.team.enterprise.scmee.common.SCMEEStorageManager;
import com.ibm.team.enterprise.scmee.zos.DataSetLocation;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.agent.MappingException;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileStorage;
import com.ibm.team.filesystem.client.internal.FileStorageWrapper;
import com.ibm.team.filesystem.client.internal.IFileOptions;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.INonEFS;
import com.ibm.team.filesystem.client.internal.IShareableInternal;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.exceptions.ContentRetrievalFailure;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.teamz.build.ant.zos.exceptions.JzosException;
import com.ibm.teamz.fileagent.Zutility;
import com.ibm.teamz.fileagent.importz.PDSManagerException;
import com.ibm.teamz.fileagent.internal.binary.BinaryConverterException;
import com.ibm.teamz.fileagent.internal.extensions.impl.AbortLoadOperationException;
import com.ibm.teamz.fileagent.internal.extensions.impl.MVSStorageManager;
import com.ibm.teamz.fileagent.internal.extensions.impl.ZFileInterface;
import com.ibm.teamz.fileagent.internal.extensions.mutators.DataSetInfo;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import com.ibm.teamz.fileagent.internal.utility.CaseInsensitiveProperties;
import com.ibm.teamz.fileagent.internal.utility.ReaderToInputStreamEE;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class MVSFileStorage
extends SCMEEFileStorage
implements INonEFS {
    private static final String cls = MVSFileStorage.class.getSimpleName();
    private static final boolean doNotManageLoadModule = System.getProperty("rtcz.no.load.module") != null;
    private static final boolean doNotAbortLoad_37 = System.getProperty("rtcz.do.not.abort.load.37") != null;
    private static CaseInsensitiveProperties cpMappingProperties;
    private final DataSetLocation location;
    private final IFileStorage storage;
    private final IDebugger dbg;
    private final boolean debug;
    private final boolean trace;
    private final String dbgName;
    private ZFileInterface file = null;

    static {
        String value = System.getenv("SCMEE_CODEPAGE_MAPPING");
        if (value != null && value.length() > 0) {
            try {
                MVSFileStorage.initCodePagesMapping(value);
            }
            catch (IOException e) {
                MVSStorageManager.getCommonDbg().log(NLS.bind((String)Messages.MVSFileStorage_28, (Object)e.getMessage(), (Object[])new Object[0]), (Throwable)e, 300);
            }
        }
    }

    private static synchronized void initCodePagesMapping(String cpMappingFile) throws IOException {
        FileInputStream inputStream = null;
        try {
            CaseInsensitiveProperties prop = new CaseInsensitiveProperties();
            inputStream = new FileInputStream(new File(cpMappingFile));
            prop.load(inputStream);
            cpMappingProperties = prop;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                    inputStream = null;
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static boolean isSimulatedModeOn() {
        return MVSStorageManager.SIMULATION_ENABLED;
    }

    protected MVSFileStorage(IFileStorage storage) {
        super(storage);
        DataSetLocation location = (DataSetLocation)storage.getShareable().getFullPath().getAdapter(DataSetLocation.class);
        if (location == null) {
            throw new IllegalArgumentException();
        }
        this.location = location;
        this.storage = storage;
        this.dbg = SCMEEStorageManager.getCommonDbg();
        this.debug = this.dbg.isDebug();
        this.trace = this.dbg.isTrace();
        this.dbgName = location.toString();
        if (this.debug) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, this.dbgName});
        }
        if (this.trace) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, LogField.valueOf((Object)this.location)});
        }
        if (this.trace) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, LogField.valueOf((Object)this.storage)});
        }
    }

    public void create(boolean createParents, Object additionalInfo, IProgressMonitor progress) throws FileSystemException {
        String mnm;
        block21: {
            String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
            if (this.debug) {
                Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
            }
            IDataSetDefinition dsdef = null;
            if (!(additionalInfo instanceof IDataSetDefinition)) {
                if (additionalInfo instanceof DataSetInfo) {
                    this.allocate(createParents, additionalInfo, progress);
                    if (this.debug) {
                        Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
                    }
                    return;
                }
                throw new IllegalStateException();
            }
            dsdef = (IDataSetDefinition)additionalInfo;
            if (dsdef.getRecordFormat().equals("U")) {
                if (this.debug) {
                    Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, LogField.valueOf((String)dsdef.getRecordFormat())});
                }
                return;
            }
            if (dsdef.getUsageType() == 0 || dsdef.getUsageType() == 1) {
                if (this.getFile().isMember()) {
                    throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_0, (Object)this.location.toOSString(), (Object[])new Object[0]));
                }
                try {
                    if (this.getFile().exists()) break block21;
                    try {
                        this.getFile().allocateDataset(dsdef);
                    }
                    catch (ZFileException e) {
                        this.throwAppropriateException(e, NLS.bind((String)Messages.MVSFileStorage_5, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}));
                    }
                    catch (MappingException e) {
                        throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_6, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                    }
                    catch (JzosException e) {
                        throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_5, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                    }
                }
                catch (ZFileException e) {
                    this.throwAppropriateException(e, NLS.bind((String)Messages.MVSFileStorage_12, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}));
                }
            } else if (dsdef.getUsageType() == 3) {
                try {
                    if (!this.getFile().exists()) {
                        throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_13, (Object)dsdef.getName(), (Object[])new Object[]{this.location.toOSString()}));
                    }
                }
                catch (ZFileException e) {
                    this.throwAppropriateException(e, NLS.bind((String)Messages.MVSFileStorage_14, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}));
                }
            } else {
                throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_15, (Object)dsdef.getName(), (Object[])new Object[]{dsdef.getItemId(), this.location.toOSString()}));
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
    }

    private void allocate(boolean createParents, Object additionalInfo, IProgressMonitor progress) throws FileSystemException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        if (!(additionalInfo instanceof DataSetInfo)) {
            throw new IllegalStateException();
        }
        DataSetInfo dsInfo = (DataSetInfo)additionalInfo;
        IDataSetDefinition dsdef = dsInfo.getDatasetDefinition();
        if (dsdef.getRecordFormat().equals("U")) {
            if (this.debug) {
                Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, LogField.valueOf((String)dsdef.getRecordFormat())});
            }
            return;
        }
        if (dsdef.getUsageType() == 0 || dsdef.getUsageType() == 1) {
            if (this.getFile().isMember()) {
                throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_0, (Object)this.location.toOSString(), (Object[])new Object[0]));
            }
            try {
                this.getFile().allocateDatasetByDDname(dsdef, dsInfo.getDdName());
            }
            catch (ZFileException e) {
                this.throwAppropriateException(e, NLS.bind((String)Messages.MVSFileStorage_5, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}));
            }
            catch (MappingException e) {
                throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_6, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            }
            catch (JzosException e) {
                throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_5, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            }
        } else if (dsdef.getUsageType() == 3) {
            try {
                if (!this.getFile().exists()) {
                    throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_13, (Object)dsdef.getName(), (Object[])new Object[]{this.location.toOSString()}));
                }
            }
            catch (ZFileException e) {
                this.throwAppropriateException(e, NLS.bind((String)Messages.MVSFileStorage_14, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}));
            }
        } else {
            throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_15, (Object)dsdef.getName(), (Object[])new Object[]{dsdef.getItemId(), this.location.toOSString()}));
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
    }

    /*
     * Unable to fully structure code
     */
    public void delete(IProgressMonitor monitor) throws FileSystemException {
        v0 = mnm = this.dbg.isOn() != false ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{MVSFileStorage.cls, mnm, this.dbgName});
        }
        if (this.isFile((IProgressMonitor)(subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100)).newChild(10))) {
            try {
                this.getFile().remove();
                subMonitor.worked(90);
            }
            catch (ZFileException e) {
                try {
                    if (!this.getFile().exists()) ** GOTO lbl59
                    this.throwAppropriateException(e, NLS.bind((String)Messages.MVSFileStorage_16, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}));
                }
                catch (ZFileException e1) {
                    this.throwAppropriateException(e, NLS.bind((String)Messages.MVSFileStorage_16, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}));
                }
            }
            catch (JzosException e) {
                try {
                    if (!this.file.exists()) ** GOTO lbl59
                    throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_16, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                }
                catch (ZFileException e1) {
                    throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_16, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                }
            }
        } else {
            children = this.getChildren(false, (IProgressMonitor)subMonitor.newChild(30));
            subMonitor.setWorkRemaining(children.size() * 10 + 30);
            for (IFileStorage child : children) {
                child.delete((IProgressMonitor)subMonitor.newChild(10));
            }
            members = null;
            try {
                members = this.getFile().getMemberNames();
                subMonitor.worked(30);
            }
            catch (IOException e) {
                throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_12, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            }
            if (members.size() == 0) {
                subMonitor.setWorkRemaining(10);
                try {
                    this.getFile().remove();
                    subMonitor.worked(10);
                }
                catch (ZFileException e) {
                    try {
                        if (this.getFile().exists()) {
                            this.throwAppropriateException(e, NLS.bind((String)Messages.MVSFileStorage_16, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}));
                        }
                    }
                    catch (ZFileException e1) {
                        this.throwAppropriateException(e, NLS.bind((String)Messages.MVSFileStorage_16, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}));
                    }
                }
                catch (JzosException e) {
                    try {
                        if (this.getFile().exists()) {
                            throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_16, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                        }
                    }
                    catch (ZFileException e1) {
                        throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_16, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                    }
                }
            }
        }
lbl59:
        // 12 sources

        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{MVSFileStorage.cls, mnm, this.dbgName});
        }
    }

    public String getActualName() {
        String result;
        try {
            result = this.getFile().getName().toUpperCase();
        }
        catch (FileSystemException e) {
            result = "";
        }
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), LogField.valueOf((String)result)});
        }
        return result;
    }

    public Object getAdapter(Class adaptTo) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        ZFileInterface result = null;
        if (adaptTo.isAssignableFrom(ZFileInterface.class)) {
            try {
                result = this.getFile();
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        return result;
    }

    public long getModificationStamp() throws FileSystemException {
        long timeStamp;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        try {
            timeStamp = this.getFile().getModificationStamp();
        }
        catch (IllegalStateException e) {
            timeStamp = 0L;
        }
        catch (IOException e) {
            throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_17, (Object)this.location.toOSString().toString(), (Object[])new Object[]{e.getMessage()}), (Throwable)e);
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        return timeStamp == 0L ? -1L : timeStamp;
    }

    public void setLocalTimeStamp(long timeStamp, IProgressMonitor progress) throws FileSystemException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        try {
            this.getFile().setModificationStamp(timeStamp);
        }
        catch (IOException e) {
            throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_21, (Object)this.location.toOSString().toString(), (Object[])new Object[]{e.getMessage()}), (Throwable)e);
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
    }

    public void move(FileStorage target, IProgressMonitor monitor) throws FileSystemException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        MVSFileStorage mvsTarget = (MVSFileStorage)target;
        try {
            this.getFile().rename(mvsTarget.getFile());
        }
        catch (ZFileException e) {
            this.throwAppropriateException(e, NLS.bind((String)Messages.MVSFileStorage_18, (Object)this.location.toOSString(), (Object[])new Object[]{mvsTarget.getLocalPath(), e.getMessage()}));
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
    }

    public void resolveChildStorage(FileStorageWrapper childStorage, String name, ResourceType type) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        childStorage.setUnderlyingStorage((FileStorage)new MVSFileStorage((IFileStorage)childStorage));
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
    }

    public boolean storageExists(IProgressMonitor progress) throws FileSystemException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        boolean result = false;
        try {
            result = this.getFile().hasDatasetInformation() ? (this.getFile().isMember() ? this.getFile().memberExists() : this.getFile().datasetExists()) : this.getFile().exists();
        }
        catch (ZFileException e) {
            this.throwAppropriateException(e, NLS.bind((String)Messages.MVSFileStorage_19, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}));
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, LogField.valueOf((boolean)result)});
        }
        return result;
    }

    public IFileStorage getChild(String name, IProgressMonitor newChild) throws FileSystemException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)newChild, (int)100);
        FileStorageWrapper result = null;
        if (!this.isFile((IProgressMonitor)monitor.newChild(10)) && this.storageExists((IProgressMonitor)monitor.newChild(10))) {
            List<String> members = null;
            try {
                members = this.getFile().getMemberNames();
                monitor.worked(50);
            }
            catch (IOException e) {
                throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_12, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            }
            monitor.setWorkRemaining(members.size() * 10);
            for (String child : members) {
                if (child.equalsIgnoreCase(name)) {
                    Shareable childShareable = new Shareable(this.getSandbox(), this.getLocalPath().append(child), ResourceType.FILE);
                    FileStorageWrapper storage = new FileStorageWrapper((IShareableInternal)childShareable, this.getStorage(), ResourceType.FILE);
                    if (!storage.getShareable().isShare((IProgressMonitor)monitor.newChild(10))) break;
                    result = storage;
                    break;
                }
                monitor.worked(10);
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, LogField.nonNull(result)});
        }
        return result;
    }

    public Collection<IFileStorage> getChildren(boolean refreshAllowed, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        if (this.isFile((IProgressMonitor)(monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100)).newChild(10)) || !this.storageExists((IProgressMonitor)monitor.newChild(10))) {
            return Collections.EMPTY_LIST;
        }
        List<String> members = null;
        try {
            members = this.getFile().getMemberNames();
            monitor.worked(50);
        }
        catch (IOException e) {
            throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_12, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), (Throwable)e);
        }
        if (members.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        monitor.setWorkRemaining(members.size() * 10);
        ArrayList<IFileStorage> children = new ArrayList<IFileStorage>(members.size());
        ISandbox sandbox = this.getSandbox();
        IRelativeLocation path = this.getLocalPath();
        for (String child : members) {
            Shareable childShareable = new Shareable(sandbox, path.append(child), ResourceType.FILE);
            FileStorageWrapper storage = new FileStorageWrapper((IShareableInternal)childShareable, this.getStorage(), ResourceType.FILE);
            if (!storage.getShareable().isShare((IProgressMonitor)monitor.newChild(10))) continue;
            children.add((IFileStorage)storage);
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        return children;
    }

    public ResourceType getResourceType(IProgressMonitor progress) throws FileSystemException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        ResourceType result = null;
        try {
            if (this.getFile().exists()) {
                result = this.getFile().isMember() ? ResourceType.FILE : ResourceType.FOLDER;
            }
        }
        catch (ZFileException e) {
            this.throwAppropriateException(e, NLS.bind((String)Messages.MVSFileStorage_20, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}));
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, LogField.valueOf((Enum)result)});
        }
        return result;
    }

    public long getSize(IProgressMonitor progress) throws FileSystemException {
        long result = -1L;
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.valueOf((long)result)});
        }
        return result;
    }

    public boolean isFile(IProgressMonitor progress) throws FileSystemException {
        boolean result = this.getFile().isMember();
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.valueOf((boolean)result)});
        }
        return result;
    }

    public boolean isFolder(IProgressMonitor progress) throws FileSystemException {
        boolean result = this.getFile().isFolder();
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.valueOf((boolean)result)});
        }
        return result;
    }

    protected String getPlatformDefaultEncoding() {
        String result = MVSFileStorage.isSimulatedModeOn() ? "IBM-1047" : Zutility.getDefaultPlatformEncoding();
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.valueOf((String)result)});
        }
        return result;
    }

    protected final String retrieveLocalEncoding(IFileOptions options) {
        String codePage = (String)options.getProperties().get("mvsCodePage");
        if (codePage == null || codePage.trim().length() < 1) {
            codePage = System.getenv("ZLANG");
        }
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.valueOf((String)codePage)});
        }
        return codePage == null ? this.getPlatformDefaultEncoding() : codePage;
    }

    protected boolean updateSpecialContents(InputStream in) throws FileSystemException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        boolean result = false;
        if (doNotManageLoadModule) {
            this.dbg.log("Load module management is not yet implemented for this tool", 400);
            result = true;
        } else {
            try {
                result = this.getFile().updateSpecialMemberContents(in);
            }
            catch (ZFileException e) {
                this.throwAppropriateException(e, NLS.bind((String)Messages.MVSFileStorage_10, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}));
            }
            catch (IOException e) {
                throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_10, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            }
            catch (BinaryConverterException e) {
                throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_11, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, LogField.valueOf((boolean)result)});
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean updateContents(InputStream in, IFileOptions fileOptions, String localCodePage) throws FileSystemException {
        boolean success;
        String mnm;
        block20: {
            String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
            if (this.debug) {
                Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
            }
            success = false;
            InputStream contentStream = null;
            FileLineDelimiter lineDelimiter = fileOptions.getLineDelimiter();
            String serverEncoding = this.checkIfReplacedEncodingNeeded(fileOptions.getCharacterEncoding());
            boolean bConvertSOSI = false;
            if (!lineDelimiter.equals((Object)FileLineDelimiter.LINE_DELIMITER_NONE)) {
                String localEncoding = localCodePage == null || localCodePage.trim().length() < 1 ? this.retrieveLocalEncoding(fileOptions) : localCodePage;
                bConvertSOSI = ZFileInterface.SOSIConversionNeeded(localEncoding, this.location, this.dbg);
                contentStream = new ReaderToInputStreamEE(new InputStreamReader(in, serverEncoding), localEncoding);
            } else {
                contentStream = in;
            }
            String ddName = null;
            long timeStamp = -1L;
            Map properties = fileOptions.getProperties();
            if (properties != null && !properties.isEmpty()) {
                if (properties.containsKey("PrivateZOSProp_DDName")) {
                    ddName = (String)properties.get("PrivateZOSProp_DDName");
                }
                if (properties.containsKey("PrivateZOSProp_Timestamp")) {
                    timeStamp = Long.parseLong((String)properties.get("PrivateZOSProp_Timestamp"), 10);
                }
            }
            boolean bl = success = this.getFile().updateMemberContents(contentStream, lineDelimiter.equals((Object)FileLineDelimiter.LINE_DELIMITER_NONE), ddName, timeStamp, bConvertSOSI);
            if (contentStream == null) return bl;
            try {
                contentStream.close();
                return bl;
            }
            catch (IOException e) {
                if (!success) return bl;
                throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_3, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            }
            catch (ZFileException e) {
                this.throwAppropriateException(e, NLS.bind((String)Messages.MVSFileStorage_3, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}));
                if (contentStream == null) break block20;
                {
                    catch (Throwable throwable) {
                        if (contentStream == null) throw throwable;
                        try {
                            contentStream.close();
                            throw throwable;
                        }
                        catch (IOException e2) {
                            if (!success) throw throwable;
                            throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_3, (Object)this.location.toOSString(), (Object[])new Object[]{e2.getMessage()}), (Throwable)e2);
                        }
                    }
                }
                try {
                    contentStream.close();
                }
                catch (IOException e3) {
                    if (success) {
                        throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_3, (Object)this.location.toOSString(), (Object[])new Object[]{e3.getMessage()}), (Throwable)e3);
                    }
                    break block20;
                }
                catch (EEZFileException e4) {
                    throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_30, (Object)e4.getMessage(), (Object[])new Object[]{this.location.toOSString()}), (Throwable)e4);
                    catch (IOException e5) {
                        throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_3, (Object)this.location.toOSString(), (Object[])new Object[]{e5.getMessage()}), (Throwable)e5);
                    }
                }
            }
        }
        if (!this.debug) return success;
        Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, LogField.valueOf((boolean)success)});
        return success;
    }

    private void throwAppropriateException(final ZFileException zfe, String message) throws FileSystemException {
        if (!doNotAbortLoad_37) {
            int abendCode = 0;
            try {
                abendCode = zfe.getAbendCode();
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            if (abendCode == 2871 || abendCode == 3383 || abendCode == 3639) {
                throw new AbortLoadOperationException(message, zfe){
                    private static final long serialVersionUID = 1L;

                    public String getMessage() {
                        StringBuffer messages = new StringBuffer(super.getMessage());
                        messages.append(MVSFileStorage.this.getAddMessages(zfe));
                        return messages.toString();
                    }
                };
            }
        }
        throw new FileSystemException(message, zfe){
            private static final long serialVersionUID = 1L;

            public String getMessage() {
                StringBuffer messages = new StringBuffer(super.getMessage());
                messages.append(MVSFileStorage.this.getAddMessages(zfe));
                return messages.toString();
            }
        };
    }

    public void create(IFileOptions fileOptions, InputStream in, IProgressMonitor monitor) throws FileSystemException {
        String mnm;
        block13: {
            String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
            if (this.debug) {
                Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
            }
            if (fileOptions == null) {
                throw new IllegalStateException();
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            boolean success = false;
            try {
                if (this.isFolder((IProgressMonitor)progress.newChild(2))) {
                    throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_2, (Object)this.location.toOSString(), (Object[])new Object[0]));
                }
                success = this.isSpecialBinaryContent(fileOptions) ? this.updateSpecialContents(in) : this.updateContents(in, fileOptions, (String)fileOptions.getProperties().get("mvsCodePage"));
            }
            catch (Throwable throwable) {
                block12: {
                    progress.done();
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            if (!success) break block12;
                            throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_1, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                        }
                    }
                }
                throw throwable;
            }
            progress.done();
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    if (!success) break block13;
                    throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_1, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                }
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
    }

    public void free(Object additionalInfo, CancellationMonitor cMon) throws FileSystemException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        IDataSetDefinition dsdef = null;
        DataSetInfo dsInfo = null;
        if (additionalInfo instanceof IDataSetDefinition) {
            dsdef = (IDataSetDefinition)additionalInfo;
        } else if (additionalInfo instanceof DataSetInfo) {
            dsInfo = (DataSetInfo)additionalInfo;
            dsdef = dsInfo.getDatasetDefinition();
        } else {
            throw new IllegalStateException();
        }
        if (dsdef.getRecordFormat().equals("U")) {
            return;
        }
        try {
            if (dsInfo == null) {
                this.getFile().free(dsdef);
            } else {
                this.getFile().freeByDDname(dsInfo.getDdName());
            }
        }
        catch (ZFileException e) {
            this.throwAppropriateException(e, NLS.bind((String)Messages.MVSFileStorage_22, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}));
        }
        catch (MappingException e) {
            throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_23, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (JzosException e) {
            throw new FileSystemException(NLS.bind((String)Messages.MVSFileStorage_22, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), (Throwable)e);
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
    }

    private ZFileInterface getFile() throws FileSystemException {
        String name;
        if (this.file == null) {
            if (this.trace) {
                Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, "New"});
            }
            this.file = ZFileInterface.createZFileInterface(this.location, this.storage, SCMEEStorageManager.getLoadTracing());
        }
        String string = name = this.file == null ? null : this.file.getName();
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.valueOf((String)name)});
        }
        return this.file;
    }

    protected InputStream getBinaryContents() throws ContentRetrievalFailure {
        InputStream result;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        try {
            result = this.getFile().getBinaryContents();
        }
        catch (FileSystemException e) {
            throw new ContentRetrievalFailure(NLS.bind((String)Messages.MVSFileStorage_9, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), null, (Throwable)e);
        }
        catch (ZFileException e) {
            throw new ContentRetrievalFailure(NLS.bind((String)Messages.MVSFileStorage_9, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), null, e){
                private static final long serialVersionUID = 1L;

                public String getMessage() {
                    StringBuffer messages = new StringBuffer(super.getMessage());
                    messages.append(MVSFileStorage.this.getAddMessages(e));
                    return messages.toString();
                }
            };
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        return result;
    }

    protected InputStream getEncodedContents(String localEncoding, String serverEncoding) throws UnsupportedEncodingException, ContentRetrievalFailure {
        InputStream result;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        try {
            result = this.getFile().getEncodedContents(localEncoding, this.checkIfReplacedEncodingNeeded(serverEncoding));
        }
        catch (FileSystemException e) {
            throw new ContentRetrievalFailure(NLS.bind((String)Messages.MVSFileStorage_25, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), null, (Throwable)e);
        }
        catch (ZFileException e) {
            throw new ContentRetrievalFailure(NLS.bind((String)Messages.MVSFileStorage_25, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), null, e){
                private static final long serialVersionUID = 1L;

                public String getMessage() {
                    StringBuffer messages = new StringBuffer(super.getMessage());
                    messages.append(MVSFileStorage.this.getAddMessages(e));
                    return messages.toString();
                }
            };
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        return result;
    }

    protected InputStream transmitBinaryContents() throws ContentRetrievalFailure {
        InputStream result;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        if (doNotManageLoadModule) {
            throw new ContentRetrievalFailure(NLS.bind((String)"Getting contents of load module {0} is not yet implemented for this tool", (Object)this.location.toOSString(), (Object[])new Object[0]), this.getLocalPath());
        }
        try {
            result = this.getFile().transmitBinaryContents();
        }
        catch (BinaryConverterException e) {
            throw new ContentRetrievalFailure(NLS.bind((String)Messages.MVSFileStorage_7, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), this.getLocalPath(), (Throwable)e);
        }
        catch (ZFileException e) {
            throw new ContentRetrievalFailure(NLS.bind((String)Messages.MVSFileStorage_7, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), null, e){
                private static final long serialVersionUID = 1L;

                public String getMessage() {
                    StringBuffer messages = new StringBuffer(super.getMessage());
                    messages.append(MVSFileStorage.this.getAddMessages(e));
                    return messages.toString();
                }
            };
        }
        catch (FileSystemException e) {
            throw new ContentRetrievalFailure(NLS.bind((String)Messages.MVSFileStorage_7, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), null, (Throwable)e);
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        return result;
    }

    protected boolean isSpecialBinaryContent(IFileOptions fileOptions) throws FileSystemException {
        String recfm;
        Map properties;
        boolean isSpecial;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        if (!(isSpecial = Boolean.valueOf((String)fileOptions.getProperties().get("isBinary")).booleanValue()) && (properties = fileOptions.getProperties()) != null && !properties.isEmpty() && properties.containsKey("PrivateZOSProp_RECFM") && "U".equals(recfm = (String)properties.get("PrivateZOSProp_RECFM"))) {
            isSpecial = true;
        }
        if (!isSpecial) {
            try {
                isSpecial = this.getFile().isSpecialBinary();
            }
            catch (PDSManagerException e) {
                throw new FileSystemException((Object)NLS.bind((String)Messages.MVSFileStorage_24, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}), null, (Throwable)e);
            }
            catch (ZFileException e) {
                this.throwAppropriateException(e, NLS.bind((String)Messages.MVSFileStorage_24, (Object)this.location.toOSString(), (Object[])new Object[]{e.getMessage()}));
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, LogField.valueOf((boolean)isSpecial)});
        }
        return isSpecial;
    }

    protected StringBuffer getAddMessages(ZFileException zfe) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.trace) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        StringBuffer addMess = new StringBuffer();
        try {
            switch (zfe.getAbendCode()) {
                case 2871: {
                    addMess.append(" ");
                    addMess.append(Messages.MVSFileStorage_26);
                    addMess.append(" ");
                    addMess.append(NLS.bind((String)Messages.MVSFileStorage_27, (Object)"B37", (Object[])new Object[]{Integer.toHexString(zfe.getAbendRc()), "IEC030I"}));
                    break;
                }
                case 3383: {
                    addMess.append(" ");
                    addMess.append(Messages.MVSFileStorage_26);
                    addMess.append(" ");
                    addMess.append(NLS.bind((String)Messages.MVSFileStorage_27, (Object)"D37", (Object[])new Object[]{Integer.toHexString(zfe.getAbendRc()), "IEC031I"}));
                    break;
                }
                case 3639: {
                    addMess.append(" ");
                    addMess.append(Messages.MVSFileStorage_26);
                    addMess.append(" ");
                    addMess.append(NLS.bind((String)Messages.MVSFileStorage_27, (Object)"E37", (Object[])new Object[]{Integer.toHexString(zfe.getAbendRc()), "IEC032I"}));
                    break;
                }
            }
            if (zfe.getErrno2() == -1072562058) {
                addMess.append(". ");
                addMess.append(Messages.MVSFileStorage_29);
            }
            addMess.append(" (");
            addMess.append("errorCode=0x");
            addMess.append(Integer.toHexString(zfe.getErrorCode()));
            addMess.append(" AbendCode=0x");
            addMess.append(Integer.toHexString(zfe.getAbendCode()));
            addMess.append(" AbendRc=0x");
            addMess.append(Integer.toHexString(zfe.getAbendRc()));
            addMess.append(" AllocSvc99Info=0x");
            addMess.append(Integer.toHexString(zfe.getAllocSvc99Info()));
            addMess.append(" AllocSvc99Error=0x");
            addMess.append(Integer.toHexString(zfe.getAllocSvc99Error()));
            addMess.append(" FeedbackFdbk=0x");
            addMess.append(Integer.toHexString(zfe.getFeedbackFdbk()));
            addMess.append(" FeedbackFtncd=0x");
            addMess.append(Integer.toHexString(zfe.getFeedbackFtncd()));
            addMess.append(" FeedbackRc=0x");
            addMess.append(Integer.toHexString(zfe.getFeedbackRc()));
            addMess.append(")");
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        if (this.trace) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        return addMess;
    }

    private String checkIfReplacedEncodingNeeded(String charsetName) {
        String retCharsetName = charsetName;
        if (cpMappingProperties != null) {
            retCharsetName = cpMappingProperties.getPropertyIgnoreCase(charsetName, charsetName);
        }
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.valueOf((String)retCharsetName)});
        }
        return retCharsetName;
    }
}

