/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.fileagent.internal.extensions.impl;

import com.ibm.jzos.ZFileException;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogField;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.enterprise.common.common.BuildPropertyTable;
import com.ibm.team.enterprise.scmee.common.DeferredFileLoadInformation;
import com.ibm.team.enterprise.scmee.common.DownloadHandler;
import com.ibm.team.enterprise.scmee.common.IThreadOwner;
import com.ibm.team.enterprise.scmee.common.SCMEEStorageManager;
import com.ibm.team.enterprise.scmee.zos.DataSetLocation;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.filesystem.client.FileDownloadHandler;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IFileContentManagerSession;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.IShareableInternal;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.teamz.build.ant.zos.exceptions.JzosException;
import com.ibm.teamz.fileagent.internal.extensions.impl.AbortLoadOperationException;
import com.ibm.teamz.fileagent.internal.extensions.impl.IDataSetInformation;
import com.ibm.teamz.fileagent.internal.extensions.impl.ZFileInterface;
import com.ibm.teamz.fileagent.internal.extensions.mutators.DataSetInfo;
import com.ibm.teamz.fileagent.internal.extensions.mutators.IDataSetUpdater;
import com.ibm.teamz.fileagent.internal.messages.Messages;
import com.ibm.teamz.fileagent.internal.utility.Numerics;
import java.io.UnsupportedEncodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class DataSetLoadUpdater
implements IDataSetUpdater {
    private static final String cls = DataSetLoadUpdater.class.getSimpleName();
    private static int numThread = SCMPlatform.getMaxContentThreads();
    private boolean bSpecialBinary = false;
    private final ITeamRepository repo;
    private final IDataSetDefinition dsdef;
    private final IDataSetInformation dsinfo;
    private final IComponent component;
    private final ISandbox sandbox;
    private final IDownloadListener downloadMonitor;
    private final IThreadOwner threadOwner;
    private final Shed shed;
    private boolean canceled;
    private IFileContentManagerSession threadedContentSession = null;
    private ArrayList<DeferredFileLoadInformation> adds = null;
    private ArrayList<DeferredFileLoadInformation> updates = null;
    private final String ddName;
    private final List<IStatus> errors = new ArrayList<IStatus>();
    private final String recfm;
    private boolean isAborted;
    private DataSetLocation location;
    private final IDebugger dbg;
    private final boolean debug;
    private final boolean trace;
    private final String dbgName;

    public DataSetLoadUpdater(IConnection connection, ITeamRepository repository, ISandbox sandbox, IComponent component, IDownloadListener downloadMonitor, Shed shed, IDataSetDefinition datasetDefinition, IDataSetInformation datasetInformation, IThreadOwner threadOwner, String ddName) {
        this.repo = repository;
        this.sandbox = sandbox;
        this.component = component;
        this.downloadMonitor = downloadMonitor;
        this.shed = shed;
        this.dsdef = datasetDefinition;
        this.dsinfo = datasetInformation;
        this.threadOwner = threadOwner;
        this.recfm = datasetDefinition.getRecordFormat();
        this.canceled = false;
        this.isAborted = false;
        this.ddName = ddName;
        this.dbg = SCMEEStorageManager.getCommonDbg();
        this.debug = this.dbg.isDebug();
        this.trace = this.dbg.isTrace();
        this.dbgName = this.dsinfo != null && this.dsinfo.hasDatasetLocation() ? this.dsinfo.getDatasetLocation().toString() : this.dsdef.getDsName();
        this.adds = new ArrayList();
        this.updates = new ArrayList();
        String maxThreads = (String)BuildPropertyTable.getInstance().get().get("team.scm.maxContentThreads");
        String maxThreadsEE = (String)BuildPropertyTable.getInstance().get().get("team.enterprise.scm.maxContentThreads");
        if (maxThreadsEE != null && Numerics.isInteger(maxThreadsEE)) {
            numThread = Integer.valueOf(maxThreadsEE);
        } else if (maxThreads != null && Numerics.isInteger(maxThreads)) {
            numThread = Integer.valueOf(maxThreads);
        }
        if (this.debug) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, this.dbgName});
        }
        if (this.trace) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, Debug.data((String[])new String[]{"numThread", LogField.valueOf((int)numThread)})});
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, Debug.data((String[])new String[]{"maxThreads", LogField.valueOf((String)maxThreads)})});
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, Debug.data((String[])new String[]{"maxThreadsEE", LogField.valueOf((String)maxThreadsEE)})});
        }
    }

    @Override
    public List<IStatus> getErrors() {
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.valueOf(this.errors)});
        }
        return this.errors;
    }

    @Override
    public void updateCanceled() {
        this.canceled = true;
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.valueOf((boolean)this.canceled)});
        }
    }

    public void checkIsCancelled(IProgressMonitor monitor) {
        if (this.canceled || monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
    }

    public void addFile(DeferredFileLoadInformation deferredFileLoadInformation) {
        this.adds.add(deferredFileLoadInformation);
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.valueOf(this.adds)});
        }
    }

    public void modifyFile(DeferredFileLoadInformation deferredFileLoadInformation) {
        this.updates.add(deferredFileLoadInformation);
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.valueOf(this.updates)});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateDataSet(IProgressMonitor progress) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        CancellationMonitor cMon = new CancellationMonitor((IProgressMonitor)monitor);
        IShareableInternal datasetShareable = null;
        try {
            datasetShareable = this.handleDatasetBegin(cMon);
        }
        catch (FileSystemException e) {
            this.dbg.log(e.getMessage());
            this.collectStatus((IStatus)new Status(4, "com.ibm.teamz.fileagent", NLS.bind((String)Messages.MVSLoadMutator_8, (Object)this.sandbox.getRoot().append(this.getLocation(null, this.dsdef)).toOSString(), (Object[])new Object[]{this.dsdef.getName(), this.component.getName()}), (Throwable)e));
            return;
        }
        try {
            this.checkIsCancelled((IProgressMonitor)monitor);
            this.threadedContentSession = FileSystemCore.getContentManager((ITeamRepository)this.repo).createSession(this.bSpecialBinary ? 0 : numThread, true, "", (long)(this.adds.size() + this.updates.size()), (IProgressMonitor)monitor.newChild(100));
            try {
                for (DeferredFileLoadInformation deferredFileLoadInformation : this.adds) {
                    if (this.isAborted) {
                        return;
                    }
                    this.checkIsCancelled((IProgressMonitor)monitor);
                    this.threadedContentSession.decrementTransferCount(1L);
                    this.handleMember(deferredFileLoadInformation, progress);
                }
                for (DeferredFileLoadInformation deferredFileLoadInformation : this.updates) {
                    if (this.isAborted) {
                        return;
                    }
                    this.checkIsCancelled((IProgressMonitor)monitor);
                    this.threadedContentSession.decrementTransferCount(1L);
                    this.handleMember(deferredFileLoadInformation, progress);
                }
                if (this.isAborted) {
                    return;
                }
            }
            finally {
                try {
                    this.threadedContentSession.join();
                }
                catch (TeamRepositoryException e) {
                    this.dbg.log(e.getMessage());
                }
                if (!progress.isCanceled() && !this.isAborted) {
                    this.doDilemmaHandling(this.adds, progress);
                }
                if (!progress.isCanceled() && !this.isAborted) {
                    this.doDilemmaHandling(this.updates, progress);
                }
            }
        }
        finally {
            this.handleDatasetEnd(datasetShareable, cMon);
        }
    }

    private void handleMember(DeferredFileLoadInformation deferredFileLoadInformation, IProgressMonitor progress) {
        String mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        String shr = LogField.valueOf((String)deferredFileLoadInformation.getShareable().getFullPath().toString());
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, shr});
        }
        String fullPath = deferredFileLoadInformation.getShareable().getFullPath().toString();
        try {
            this.threadedContentSession.retrieveContent((IFileItemHandle)deferredFileLoadInformation.getFileItemState(), deferredFileLoadInformation.getContent(), (FileDownloadHandler)new DownloadHandler(deferredFileLoadInformation.getShareable(), deferredFileLoadInformation, this.downloadMonitor, false, this.shed, this.threadOwner, this.getAdditionalProperties()));
            this.checkIsAborted(deferredFileLoadInformation);
        }
        catch (TeamRepositoryException e) {
            this.checkIsAborted(deferredFileLoadInformation);
            this.collectStatus((IStatus)new Status(4, "com.ibm.teamz.fileagent", NLS.bind((String)Messages.MVSLoadMutator_14, (Object)fullPath, (Object[])new Object[]{this.component.getName()}), (Throwable)e));
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, shr});
        }
    }

    private boolean checkIsAborted(DeferredFileLoadInformation deferredFileLoadInformation) {
        if (!this.isAborted && AbortLoadOperationException.isRootCause(deferredFileLoadInformation.getFailure())) {
            this.isAborted = true;
        }
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.valueOf((boolean)this.isAborted)});
        }
        return this.isAborted;
    }

    private IShareableInternal handleDatasetBegin(CancellationMonitor cMon) throws FileSystemException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        IRelativeLocation path = this.getLocation(null, this.dsdef);
        IShareableInternal shareable = (IShareableInternal)this.sandbox.findShareable(path, ResourceType.FOLDER);
        shareable.getFileStorage().create(true, (Object)new DataSetInfo(this.dsdef, this.ddName, this.dbg), (IProgressMonitor)cMon);
        this.location = (DataSetLocation)shareable.getFullPath().getAdapter(DataSetLocation.class);
        if (!this.dsinfo.hasDatasetLocation()) {
            this.dsinfo.setDatasetLocation(this.location);
        }
        this.isItUndefinedFormatDS_Workaround();
        this.dbg.log(NLS.bind((String)Messages.DataSetLoadUpdater_Logging_0, (Object)this.ddName, (Object[])new Object[]{shareable.getFileStorage().getActualName(), this.component.getName()}));
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        return shareable;
    }

    private void isItUndefinedFormatDS_Workaround() {
        this.bSpecialBinary = "U".equals(this.recfm);
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.valueOf((boolean)this.bSpecialBinary)});
        }
    }

    private void handleDatasetEnd(IShareableInternal shareable, CancellationMonitor cMon) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        try {
            this.dbg.log(NLS.bind((String)Messages.DataSetLoadUpdater_Logging_1, (Object)this.ddName, (Object[])new Object[]{shareable.getFileStorage().getActualName(), this.component.getName()}));
            ZFileInterface datasetZFile = (ZFileInterface)shareable.getFileStorage().getAdapter(ZFileInterface.class);
            datasetZFile.freeByDDname(this.ddName);
        }
        catch (ZFileException | JzosException e) {
            IRelativeLocation path = this.getLocation(null, this.dsdef);
            this.collectStatus((IStatus)new Status(4, "com.ibm.teamz.fileagent", NLS.bind((String)Messages.DataSetLoadUpdater_0, (Object)this.sandbox.getRoot().append(path).toOSString(), (Object[])new Object[]{this.dsdef.getName(), this.component.getName()}), e));
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
    }

    private final IRelativeLocation getLocation(FileAreaUpdate update, IDataSetDefinition dataSetDefinition) {
        Object[] dsName;
        if (update == null || update.getItem() instanceof IFolderHandle) {
            dsName = new String[]{dataSetDefinition.getDsName()};
        } else {
            dsName = new String[]{dataSetDefinition.getDsName(), update.getName().toUpperCase()};
            if (dsName[1].lastIndexOf(".") > 0) {
                dsName[1] = dsName[1].substring(0, dsName[1].lastIndexOf("."));
            }
        }
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.valueOf((Object[])dsName)});
        }
        return new RelativeLocation((String[])dsName);
    }

    private void collectStatus(IStatus status) {
        if (status.isOK()) {
            return;
        }
        if (this.isLastError(status)) {
            return;
        }
        this.errors.add(status);
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.valueOf(this.errors)});
        }
    }

    private boolean isLastError(IStatus status) {
        boolean result;
        boolean bl = result = this.errors.size() > 0 && this.getLastError() == status;
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, LogField.valueOf((boolean)result)});
        }
        return result;
    }

    private IStatus getLastError() {
        Assert.isTrue((this.errors.size() > 0 ? 1 : 0) != 0);
        IStatus status = this.errors.get(this.errors.size() - 1);
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName, status.getMessage()});
        }
        return status;
    }

    private void doDilemmaHandling(ArrayList<DeferredFileLoadInformation> pathsToUpdate, IProgressMonitor monitor) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.setWorkRemaining(100);
        ArrayList<DeferredFileLoadInformation> encodingFailures = new ArrayList<DeferredFileLoadInformation>();
        for (DeferredFileLoadInformation deferredUpdateInformation : pathsToUpdate) {
            if (deferredUpdateInformation == null || deferredUpdateInformation.getFailure() == null) continue;
            Throwable rootCause = deferredUpdateInformation.getFailure().getCause();
            int digParanoiaCount = 0;
            while (rootCause instanceof TeamRepositoryException && digParanoiaCount < 50) {
                Throwable cause = ((TeamRepositoryException)rootCause).getCause();
                if (cause == null) break;
                rootCause = cause;
                ++digParanoiaCount;
            }
            if (rootCause instanceof UnsupportedEncodingException || rootCause instanceof UnsupportedCharsetException) {
                deferredUpdateInformation.setAlternateEncoding("ISO-8859-1");
                encodingFailures.add(deferredUpdateInformation);
                continue;
            }
            if (!(rootCause instanceof OperationCanceledException)) continue;
            throw new OperationCanceledException();
        }
        if (encodingFailures.size() > 0) {
            boolean moreContentUploaded = false;
            this.threadedContentSession = FileSystemCore.getContentManager((ITeamRepository)this.repo).createSession(0, true, "", (long)encodingFailures.size(), (IProgressMonitor)progress.newChild(75));
            try {
                for (DeferredFileLoadInformation failed : encodingFailures) {
                    IVersionableHandle fileItemState = failed.getFileItemState();
                    try {
                        this.threadedContentSession.retrieveContent((IFileItemHandle)fileItemState, failed.getContent(), failed.getEncoding(), failed.getLineDelimiter(), (FileDownloadHandler)new DownloadHandler(failed.getShareable(), failed, this.downloadMonitor, false, this.shed, this.threadOwner, this.getAdditionalProperties()));
                        if (this.checkIsAborted(failed)) {
                            break;
                        }
                        moreContentUploaded = true;
                    }
                    catch (TeamRepositoryException e) {
                        if (this.checkIsAborted(failed)) {
                            break;
                        }
                        failed.setFailure(failed.getFailure());
                    }
                }
            }
            finally {
                if (moreContentUploaded) {
                    try {
                        this.threadedContentSession.join();
                    }
                    catch (TeamRepositoryException e) {
                        this.dbg.log(e.getMessage());
                    }
                }
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
    }

    private Map<String, String> getAdditionalProperties() {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        HashMap<String, String> addProperties = new HashMap<String, String>(2);
        addProperties.put("PrivateZOSProp_DDName", this.ddName);
        addProperties.put("PrivateZOSProp_RECFM", this.recfm);
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        return addProperties;
    }
}

